/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.resolver;

import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.ow2.easybeans.resolver.CommonJNDIResolver;
import org.ow2.easybeans.resolver.api.EZBContainerJNDIResolver;
import org.ow2.easybeans.resolver.api.EZBJNDIData;
import org.ow2.easybeans.resolver.api.EZBServerJNDIResolver;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerJNDIResolver
extends CommonJNDIResolver
implements EZBServerJNDIResolver {
    private Log logger = LogFactory.getLog(ServerJNDIResolver.class);
    private static Map<URL, WeakReference<EZBContainerJNDIResolver>> containerResolvers = new WeakHashMap<URL, WeakReference<EZBContainerJNDIResolver>>();

    public synchronized void removeContainerResolver(EZBContainerJNDIResolver resolver) {
        URL containerURL = resolver.getURL();
        WeakReference<EZBContainerJNDIResolver> weakRef = containerResolvers.get(containerURL);
        if (weakRef != null) {
            containerResolvers.remove(containerURL);
        } else {
            this.logger.warn((Object)"Cannot remove the given container resolver as it is not present.", new Object[0]);
        }
    }

    public synchronized void addContainerResolver(EZBContainerJNDIResolver resolver) {
        WeakReference<EZBContainerJNDIResolver> weakRef = new WeakReference<EZBContainerJNDIResolver>(resolver);
        containerResolvers.put(resolver.getURL(), weakRef);
    }

    public synchronized List<EZBJNDIData> getNames(String interfaceName) {
        return this.getNames(interfaceName, null);
    }

    public synchronized List<EZBJNDIData> getNames(String interfaceName, String beanName) {
        Iterator<URL> itContainerURL = containerResolvers.keySet().iterator();
        ArrayList<EZBJNDIData> foundJNDINames = new ArrayList<EZBJNDIData>();
        while (itContainerURL.hasNext()) {
            URL url = itContainerURL.next();
            WeakReference<EZBContainerJNDIResolver> weakRef = containerResolvers.get(url);
            if (weakRef == null) continue;
            EZBContainerJNDIResolver containerResolver = (EZBContainerJNDIResolver)weakRef.get();
            List containerJNDINames = containerResolver.getNames(interfaceName, beanName, false);
            foundJNDINames.addAll(containerJNDINames);
        }
        return foundJNDINames;
    }
}

