/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.statistic;

import java.util.LinkedList;
import java.util.List;
import org.ow2.easybeans.api.event.EZBEventListener;
import org.ow2.easybeans.api.jmx.EZBMBeanAttribute;
import org.ow2.easybeans.api.jmx.EZBMBeanOperation;
import org.ow2.easybeans.api.statistic.EZBStatistic;
import org.ow2.easybeans.component.itf.EZBEventComponent;
import org.ow2.easybeans.component.itf.EZBJmxComponent;

public abstract class AbstractStatistic
implements EZBStatistic {
    private String name;
    private String description;
    private String unit;
    private long startTime;
    private long lastTime;
    private boolean available;
    private String statisticFactoryId;
    private String statisticProviderId;
    private EZBEventComponent eventComponent;
    private EZBJmxComponent jmxComponent;
    private List<EZBEventListener> eventListeners;
    private List<EZBMBeanAttribute> mbeanAttributes;
    private List<EZBMBeanOperation> mbeanOperations;

    public AbstractStatistic(String name, String description, String unit, String statisticFactoryId, String statisticProviderId, EZBEventComponent eventComponent, EZBJmxComponent jmxComponent) {
        this.name = name;
        this.description = description;
        this.unit = unit;
        this.startTime = System.currentTimeMillis();
        this.lastTime = System.currentTimeMillis();
        this.available = false;
        this.statisticFactoryId = statisticFactoryId;
        this.statisticProviderId = statisticProviderId;
        this.eventComponent = eventComponent;
        this.jmxComponent = jmxComponent;
        this.eventListeners = new LinkedList<EZBEventListener>();
        this.mbeanAttributes = new LinkedList<EZBMBeanAttribute>();
        this.mbeanOperations = new LinkedList<EZBMBeanOperation>();
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getUnit() {
        return this.unit;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getLastSampleTime() {
        return this.lastTime;
    }

    public void setLastSampleTime(long lastTime) {
        this.lastTime = lastTime;
    }

    public String getStatisticId() {
        return this.getStatisticProviderId().replaceAll(":", "\\:") + "::" + this.getStatisticFactoryId().replaceAll(":", "\\:");
    }

    public String getStatisticFactoryId() {
        return this.statisticFactoryId;
    }

    public String getStatisticProviderId() {
        return this.statisticProviderId;
    }

    public synchronized void reset() {
        this.startTime = System.currentTimeMillis();
        this.lastTime = System.currentTimeMillis();
    }

    public synchronized void activate() {
        if (!this.available) {
            this.available = true;
            for (EZBEventListener eventListener : this.eventListeners) {
                this.eventComponent.registerEventListener(eventListener);
            }
            for (EZBMBeanAttribute mbeanAttribute : this.mbeanAttributes) {
                this.jmxComponent.registerMBeanAttribute(mbeanAttribute);
            }
            for (EZBMBeanOperation mbeanOperation : this.mbeanOperations) {
                this.jmxComponent.registerMBeanOperation(mbeanOperation);
            }
        }
    }

    public synchronized void deactivate() {
        if (this.available) {
            this.available = false;
            for (EZBEventListener eventListener : this.eventListeners) {
                this.eventComponent.unregisterEventListener(eventListener);
            }
            for (EZBMBeanAttribute mbeanAttribute : this.mbeanAttributes) {
                this.jmxComponent.unregisterMBeanAttribute(mbeanAttribute);
            }
            for (EZBMBeanOperation mbeanOperation : this.mbeanOperations) {
                this.jmxComponent.unregisterMBeanOperation(mbeanOperation);
            }
        }
    }

    public synchronized boolean isAvailable() {
        return this.available;
    }

    protected EZBEventComponent getEventComponent() {
        return this.eventComponent;
    }

    protected EZBJmxComponent getJmxComponent() {
        return this.jmxComponent;
    }

    protected synchronized void addEventListener(EZBEventListener eventListener) {
        this.eventListeners.add(eventListener);
        if (this.available) {
            this.eventComponent.registerEventListener(eventListener);
        }
    }

    protected synchronized void removeEventListener(EZBEventListener eventListener) {
        this.eventListeners.remove(eventListener);
        if (this.available) {
            this.eventComponent.unregisterEventListener(eventListener);
        }
    }

    protected synchronized void addMBeanAttribute(EZBMBeanAttribute mbeanAttribute) {
        this.mbeanAttributes.add(mbeanAttribute);
        if (this.available) {
            this.jmxComponent.registerMBeanAttribute(mbeanAttribute);
        }
    }

    protected synchronized void removeMBeanAttribute(EZBMBeanAttribute mbeanAttribute) {
        this.mbeanAttributes.remove(mbeanAttribute);
        if (this.available) {
            this.jmxComponent.unregisterMBeanAttribute(mbeanAttribute);
        }
    }

    protected synchronized void addMBeanOperation(EZBMBeanOperation mbeanOperation) {
        this.mbeanOperations.add(mbeanOperation);
        if (this.available) {
            this.jmxComponent.registerMBeanOperation(mbeanOperation);
        }
    }

    protected synchronized void removeMBeanOperation(EZBMBeanOperation mbeanOperation) {
        this.mbeanOperations.remove(mbeanOperation);
        if (this.available) {
            this.jmxComponent.unregisterMBeanOperation(mbeanOperation);
        }
    }
}

