/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.plan.fetcher.impl.url;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import org.ow2.util.file.FileUtils;
import org.ow2.util.file.FileUtilsException;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.plan.bindings.deploymentplan.url.UrlDeployment;
import org.ow2.util.plan.bindings.exceptions.InvalidDeploymentException;
import org.ow2.util.plan.bindings.exceptions.InvalidRepositoryException;
import org.ow2.util.plan.bindings.repository.Repository;
import org.ow2.util.plan.bindings.repository.RepositoryKind;
import org.ow2.util.plan.fetcher.api.IResourceFetcher;
import org.ow2.util.plan.fetcher.api.exceptions.FetcherException;
import org.ow2.util.plan.fetcher.api.exceptions.ResourceFetcherNotResolvedException;
import org.ow2.util.plan.fetcher.api.exceptions.ResourceNotFoundException;
import org.ow2.util.plan.fetcher.impl.AbsResourceFetcherImpl;

public class UrlResourceFetcher
extends AbsResourceFetcherImpl
implements IResourceFetcher {
    private Log logger = LogFactory.getLog(UrlResourceFetcher.class);
    private Repository foundRepository = null;
    private URL foundURL = null;
    private Long lastModifiedCheck = null;
    private File localFile = null;

    public void resolve() throws FetcherException {
        if (!(this.deployment instanceof UrlDeployment)) {
            throw new FetcherException((Throwable)new InvalidDeploymentException("Incompatible class " + this.deployment.getClass()));
        }
        UrlDeployment urlDeployment = (UrlDeployment)this.deployment;
        this.logger.info((Object)"trying to resolve resource {0}", new Object[]{urlDeployment.getResource()});
        this.localFile = null;
        for (Repository repository : this.getRepositoryManager()) {
            try {
                this.localFile = this.searchRepository(repository);
            }
            catch (FetcherException e) {
                this.logger.debug((Object)"resource {0} was not found on repository {1}", new Object[]{this.deployment, repository});
            }
            if (this.localFile == null) continue;
            return;
        }
        if (this.localFile == null) {
            throw new FetcherException((Throwable)new ResourceNotFoundException(urlDeployment.toString()));
        }
    }

    private File searchRepository(Repository repository) throws FetcherException {
        URL repositoryURL = null;
        try {
            repositoryURL = new URL(repository.getUrl());
        }
        catch (MalformedURLException e) {
            throw new FetcherException((Throwable)new InvalidRepositoryException("invalid URL", (Throwable)e));
        }
        URI baseURI = null;
        try {
            baseURI = repositoryURL.toURI();
        }
        catch (URISyntaxException e) {
            this.logger.error((Object)"Bad URI syntax in {0}", new Object[]{repositoryURL});
            throw new FetcherException((Throwable)new InvalidRepositoryException("invalid URL", (Throwable)e));
        }
        URI resultURI = baseURI.resolve(((UrlDeployment)this.deployment).getResource());
        URL resultURL = null;
        try {
            resultURL = resultURI.toURL();
        }
        catch (MalformedURLException e) {
            this.logger.error((Object)"Bad URI syntax in {0}", new Object[]{resultURL});
            throw new FetcherException((Throwable)new InvalidDeploymentException("invalid path to resource", (Throwable)e));
        }
        this.lastModifiedCheck = System.currentTimeMillis();
        InputStream input = null;
        try {
            input = resultURL.openStream();
        }
        catch (IOException e) {
            this.logger.error((Object)"Exception while opening connection to resource {0}", new Object[]{resultURL});
            throw new FetcherException("Exception while opening connection", (Throwable)e);
        }
        this.foundRepository = repository;
        this.foundURL = resultURL;
        this.localFile = UrlResourceFetcher.makeLocalFilePath((File)this.localRepositoriesBaseDir, (String)this.foundRepository.getId(), (String)((UrlDeployment)this.deployment).getResource());
        if (this.localFile != null && !this.localFile.getParentFile().exists()) {
            this.localFile.getParentFile().mkdirs();
        }
        try {
            FileUtils.dump((InputStream)input, (File)this.localFile);
        }
        catch (FileUtilsException e) {
            this.logger.error((Object)"Exception while copying data from resource {0};exception: {1}", new Object[]{resultURL, e});
            throw new FetcherException("Exception while copying resource data", (Throwable)e);
        }
        return this.localFile;
    }

    public RepositoryKind getSupportedRepositoryType() {
        return RepositoryKind.URL;
    }

    public File getResource() throws ResourceFetcherNotResolvedException {
        if (this.localFile == null) {
            throw new ResourceFetcherNotResolvedException();
        }
        return this.localFile;
    }

    public boolean hasChanged() throws FetcherException {
        URLConnection connection = null;
        try {
            connection = this.foundURL.openConnection();
        }
        catch (IOException e) {
            throw new FetcherException((Throwable)e);
        }
        long time = System.currentTimeMillis() - 1L;
        long changed = connection.getLastModified();
        if (this.lastModifiedCheck < changed) {
            return true;
        }
        this.lastModifiedCheck = time;
        return false;
    }

    public void update() throws FetcherException {
        this.searchRepository(this.foundRepository);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append(":useRepository=");
        if (this.foundRepository != null) {
            sb.append(this.foundRepository);
        } else {
            sb.append("null");
        }
        sb.append(":resolved=");
        sb.append(this.localFile != null);
        sb.append(":lastCheck=");
        sb.append(this.lastModifiedCheck);
        return sb.toString();
    }
}

