/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.cmi.config;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import net.jcip.annotations.ThreadSafe;
import org.ow2.cmi.config.CMIConfigException;
import org.ow2.cmi.config.CMIProperty;
import org.ow2.cmi.config.ProviderURLsParser;
import org.ow2.cmi.config.UtilConfig;
import org.ow2.cmi.controller.server.ServerClusterViewManager;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public final class CMIConfig {
    private static final Log LOGGER = LogFactory.getLog(CMIConfig.class);
    public static final String CMI_PROPERTIES = "cmi.properties";
    private static final String DEFAULT_SERVER_CONF_FILENAME = "cmi-server-config.xml";
    private static final String DEFAULT_MANAGER = "org.ow2.cmi.controller.server.impl.jgroups.JGroupsClusterViewManager";
    private static final String DEFAULT_PROVIDER_BIND_NAME = "client_provider";
    private static final String DEFAULT_DUMMY_REGISTRY_BIND_NAME = "dummy_registry";
    public static final String DEFAULT_DEPLOY_DIRECTORY = "deploy";
    private static boolean configured = false;
    private static boolean autostart = true;
    private static boolean replicationEnabled = true;
    private static String serverClusterViewManagerClassname = "org.ow2.cmi.controller.server.impl.jgroups.JGroupsClusterViewManager";
    private static String bindNameForProvider = "client_provider";
    private static String confDir;
    private static String bindNameForDummyRegistry;
    private static Map<String, List<String>> clusterViewProviderUrls;
    private static String deployDirectory;
    private static boolean embedded;
    private static String serverConfFilename;

    private CMIConfig() {
    }

    public static synchronized void init() throws CMIConfigException {
        CMIConfig.setProperties(Thread.currentThread().getContextClassLoader().getResource(CMI_PROPERTIES));
    }

    public static synchronized void setProperties(Properties props) throws CMIConfigException {
        if (configured) {
            return;
        }
        LOGGER.debug((Object)"Starting the configuration of CMI...", new Object[0]);
        LOGGER.debug((Object)"CMI props: {0}", new Object[]{props.toString()});
        String repEnabled = props.getProperty(CMIProperty.REPLICATION_ENABLED.getPropertyName());
        if (repEnabled != null) {
            replicationEnabled = Boolean.parseBoolean(repEnabled);
        }
        Enumeration<?> e = props.propertyNames();
        while (e.hasMoreElements()) {
            String k = (String)e.nextElement();
            String s = props.getProperty(k);
            if (k.equals(CMIProperty.REPLICATION_MANAGER_CLASS.getPropertyName())) {
                if (!replicationEnabled) continue;
                serverClusterViewManagerClassname = s;
                continue;
            }
            if (k.equals(CMIProperty.PROVIDER_BIND_NAME.getPropertyName())) {
                bindNameForProvider = s;
                continue;
            }
            if (k.equals(CMIProperty.CLUSTER_VIEW_PROVIDER_URLS.getPropertyName())) {
                if (replicationEnabled) continue;
                try {
                    clusterViewProviderUrls = ProviderURLsParser.parseMultiprotocol(s);
                    continue;
                }
                catch (MalformedURLException e1) {
                    LOGGER.error((Object)"Cannot parse the following urls: {0}.", new Object[]{s, e1});
                    throw new CMIConfigException("Cannot parse the following urls: " + s, e1);
                }
            }
            if (k.equals(CMIProperty.DEPLOY_DIRECTORY.getPropertyName())) {
                deployDirectory = s;
                continue;
            }
            if (k.equals(CMIProperty.AUTOSTART.getPropertyName())) {
                if (!replicationEnabled) continue;
                autostart = Boolean.parseBoolean(s);
                continue;
            }
            if (!k.equals(CMIProperty.SERVER_CONF_FILENAME.getPropertyName()) || !replicationEnabled) continue;
            serverConfFilename = s;
        }
        configured = true;
        LOGGER.debug((Object)"Configuration of CMI is done.", new Object[0]);
    }

    public static synchronized void setProperties(URL url) throws CMIConfigException {
        if (url == null) {
            LOGGER.error((Object)"The given URL is null", new Object[0]);
            throw new CMIConfigException("The given URL is null");
        }
        Properties props = UtilConfig.getPropertiesFromURL(url);
        CMIConfig.setProperties(props);
    }

    public static Class<? extends ServerClusterViewManager> getServerClusterViewManagerClass() throws ClassNotFoundException {
        return CMIConfig.class.getClassLoader().loadClass(serverClusterViewManagerClassname);
    }

    public static String getBindNameForProvider() {
        return bindNameForProvider;
    }

    public static String getBindNameForDummyRegistry() {
        return bindNameForDummyRegistry;
    }

    public static boolean isConfigured() {
        return configured;
    }

    public static boolean isEmbedded() {
        return embedded;
    }

    public static void setEmbedded() {
        embedded = true;
    }

    public static List<String> getClusterViewProviderUrls(String protocol) {
        List<String> res = clusterViewProviderUrls.get(protocol);
        if (res == null) {
            return new ArrayList<String>();
        }
        return res;
    }

    public static boolean isReplicationEnabled() {
        return replicationEnabled;
    }

    public static String getConfDir() {
        return confDir;
    }

    public static void setConfDir(String confDir) {
        CMIConfig.confDir = confDir;
    }

    public static String getDeployDirectory() {
        return deployDirectory;
    }

    public static boolean isAutoStarted() {
        return autostart;
    }

    public static String getServerConfFilename() {
        return serverConfFilename;
    }

    static {
        bindNameForDummyRegistry = DEFAULT_DUMMY_REGISTRY_BIND_NAME;
        deployDirectory = DEFAULT_DEPLOY_DIRECTORY;
        embedded = false;
        serverConfFilename = DEFAULT_SERVER_CONF_FILENAME;
    }
}

