/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.cmi.controller.common;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import net.jcip.annotations.ThreadSafe;
import org.ow2.cmi.controller.client.ClientClusterViewManager;
import org.ow2.cmi.controller.common.CMIThreadFactory;
import org.ow2.cmi.controller.common.ClusterViewManager;
import org.ow2.cmi.controller.common.LocalObjectData;
import org.ow2.cmi.ha.SessionId;
import org.ow2.cmi.lb.policy.IPolicy;
import org.ow2.cmi.lb.util.PolicyFactory;
import org.ow2.cmi.lb.util.PolicyFactoryException;
import org.ow2.cmi.reference.CMIReference;
import org.ow2.cmi.reference.CMIReferenceable;
import org.ow2.cmi.reference.ObjectNotFoundException;
import org.ow2.util.component.ComponentManager;
import org.ow2.util.component.Components;
import org.ow2.util.component.api.Component;
import org.ow2.util.component.api.IComponentManager;
import org.ow2.util.event.api.IEventDispatcher;
import org.ow2.util.event.impl.EventDispatcher;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.pool.api.Pool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public abstract class AbsClusterViewManager
implements ClusterViewManager {
    private static final Log LOGGER = LogFactory.getLog(AbsClusterViewManager.class);
    private static volatile ClusterViewManager clusterViewManager;
    private ClusterViewManager.State state = ClusterViewManager.State.STOPPED;
    private final ConcurrentHashMap<String, LocalObjectData> localObjectData = new ConcurrentHashMap();
    private final Set<String> watchedObjects = Collections.synchronizedSet(new HashSet());
    private final CMIThreadFactory cmiThreadFactory;
    private final UUID uuid;
    private final AtomicLong sessionNb = new AtomicLong(0L);
    private final IEventDispatcher dispatcher;
    private Components components;
    private final IComponentManager componentManager;
    private final String cmiManagedObjectId;

    protected AbsClusterViewManager() {
        String managerName = this instanceof ClientClusterViewManager ? "ClientClusterViewManager" : "ServerClusterViewManager";
        this.cmiThreadFactory = new CMIThreadFactory(managerName);
        this.uuid = UUID.randomUUID();
        this.components = new Components();
        this.componentManager = new ComponentManager(this.components);
        this.dispatcher = new EventDispatcher();
        this.cmiManagedObjectId = "/cmi";
    }

    public IEventDispatcher getEventDispatcher() {
        return this.dispatcher;
    }

    public final Components getComponents() {
        return this.components;
    }

    public final void setComponents(Components components) {
        this.components = components;
    }

    public final Component getComponent(String componentName) {
        if (this.componentManager != null) {
            return this.componentManager.getComponentRegistry().getComponent(componentName);
        }
        return null;
    }

    @Override
    public <T extends Component> T getComponent(Class<T> itf) {
        try {
            return (T)((Component)this.componentManager.getComponentRegistry().getComponents(itf).get(0));
        }
        catch (IndexOutOfBoundsException e) {
            LOGGER.debug((Object)"No component", new Object[]{e});
            return null;
        }
    }

    public final IComponentManager getComponentManager() {
        return this.componentManager;
    }

    @Override
    public String getCMIManagedObjectId() {
        return this.cmiManagedObjectId;
    }

    protected static final void setClusterViewManager(ClusterViewManager clusterViewManager) {
        if (clusterViewManager == null || AbsClusterViewManager.clusterViewManager == null) {
            AbsClusterViewManager.clusterViewManager = clusterViewManager;
        } else {
            LOGGER.warn((Object)"The cluster view manager is already initialized", new Object[0]);
        }
    }

    @Override
    public final ClusterViewManager.State getState() {
        return this.state;
    }

    protected final void setState(ClusterViewManager.State state) {
        this.state = state;
    }

    @Override
    public final IPolicy<CMIReference> getPolicy(String objectName) {
        this.localObjectData.putIfAbsent(objectName, new LocalObjectData(objectName));
        return this.localObjectData.get(objectName).getPolicy();
    }

    private void setPolicy(String objectName, IPolicy<CMIReference> lbPolicy) {
        this.localObjectData.putIfAbsent(objectName, new LocalObjectData(objectName));
        this.localObjectData.get(objectName).setPolicy(lbPolicy);
    }

    protected final boolean hasPool(String objectName) throws ObjectNotFoundException {
        this.localObjectData.putIfAbsent(objectName, new LocalObjectData(objectName));
        return this.localObjectData.get(objectName).getPool() != null;
    }

    @Override
    public final Pool<CMIReferenceable<?>, CMIReference> getPool(String objectName) {
        this.localObjectData.putIfAbsent(objectName, new LocalObjectData(objectName));
        return this.localObjectData.get(objectName).getPool();
    }

    @Override
    public final void setPool(String objectName, Pool<CMIReferenceable<?>, CMIReference> pool) {
        this.localObjectData.putIfAbsent(objectName, new LocalObjectData(objectName));
        this.localObjectData.get(objectName).setPool(pool);
    }

    protected final void updatePolicy(String objectName) throws ObjectNotFoundException, PolicyFactoryException {
        LOGGER.debug((Object)"Updating policy for {0}", new Object[]{objectName});
        PolicyFactory policyFactory = new PolicyFactory(this);
        IPolicy<CMIReference> policy = policyFactory.getPolicy(objectName);
        this.setPolicy(objectName, policy);
    }

    protected final boolean isWatched(String objectName) {
        return this.watchedObjects.contains(objectName);
    }

    protected final void watch(String objectName) {
        this.watchedObjects.add(objectName);
    }

    protected final Set<String> getNamesOfWatchedObject() {
        return new HashSet<String>(this.watchedObjects);
    }

    public static final ClusterViewManager getClusterViewManager() {
        return clusterViewManager;
    }

    protected final CMIThreadFactory getCmiThreadFactory() {
        return this.cmiThreadFactory;
    }

    @Override
    public final UUID getUUID() {
        return this.uuid;
    }

    @Override
    public final SessionId getSessionId() {
        return new SessionId(AbsClusterViewManager.getClusterViewManager().getUUID(), this.sessionNb.incrementAndGet());
    }

    public static void destroy() {
        if (clusterViewManager != null) {
            clusterViewManager.stop();
            AbsClusterViewManager.setClusterViewManager(null);
        }
    }

    public static boolean isDestroyed() {
        return AbsClusterViewManager.getClusterViewManager() == null;
    }
}

