/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.cmi.controller.server.component;

import java.io.File;
import java.net.URL;
import org.ow2.cmi.config.CMIConfig;
import org.ow2.cmi.controller.server.ServerClusterViewManager;
import org.ow2.cmi.controller.server.ServerClusterViewManagerException;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.url.URLUtils;
import org.ow2.util.url.URLUtilsException;
import org.ow2.util.xmlconfig.XMLConfiguration;
import org.ow2.util.xmlconfig.XMLConfigurationException;
import org.ow2.util.xmlconfig.properties.IPropertyResolver;
import org.ow2.util.xmlconfig.properties.SystemPropertyResolver;

public final class CMIServerConfigurator {
    private static Log logger = LogFactory.getLog(CMIServerConfigurator.class);

    private CMIServerConfigurator() {
    }

    public static void configure(ServerClusterViewManager serverClusterViewManager) throws ServerClusterViewManagerException {
        String confDir = CMIConfig.getConfDir();
        String confFilename = CMIConfig.getServerConfFilename();
        URL url = null;
        if (confDir != null) {
            File file = new File(confDir, confFilename);
            if (file.exists()) {
                try {
                    url = URLUtils.fileToURL2((File)file);
                }
                catch (URLUtilsException e) {
                    logger.warn((Object)"Cannot get the url for the file: {0}", new Object[]{file, e});
                }
            } else {
                logger.warn((Object)"File not found: {0}", new Object[]{file});
            }
        }
        if (url == null && (url = ClassLoader.getSystemClassLoader().getResource(confFilename)) == null) {
            url = Thread.currentThread().getContextClassLoader().getResource(confFilename);
            if (url == null) {
                url = serverClusterViewManager.getClass().getResource(confFilename);
            }
            if (url == null) {
                logger.info((Object)"Unable to find cmi-server-config.xml: using the default configuration.", new Object[0]);
            }
        }
        long tStart = System.currentTimeMillis();
        logger.debug((Object)"Starting configuration of CMI server", new Object[0]);
        XMLConfiguration xmlConfiguration = new XMLConfiguration(url, "cmi-server-mapping.xml");
        xmlConfiguration.setPropertyResolver((IPropertyResolver)new SystemPropertyResolver());
        try {
            xmlConfiguration.configure((Object)serverClusterViewManager);
        }
        catch (XMLConfigurationException e) {
            logger.error((Object)"Cannot configure the CMI server", new Object[]{e});
            throw new ServerClusterViewManagerException("Cannot configure the CMI server", e);
        }
        if (logger.isInfoEnabled()) {
            logger.debug((Object)("Configuration done in : " + (System.currentTimeMillis() - tStart) + " ms"), new Object[0]);
        }
    }
}

