/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.cmi.controller.server.impl.jms;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.jms.BytesMessage;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.management.MBeanServerNotification;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import net.jcip.annotations.ThreadSafe;
import org.ow2.cmi.admin.MBeanUtils;
import org.ow2.cmi.controller.common.ClusterViewManager;
import org.ow2.cmi.controller.provider.ServerClusterViewProvider;
import org.ow2.cmi.controller.server.AbsServerClusterViewManager;
import org.ow2.cmi.controller.server.ClusterView;
import org.ow2.cmi.controller.server.DistributedObjectInfo;
import org.ow2.cmi.controller.server.ServerClusterViewManagerException;
import org.ow2.cmi.controller.server.ServerView;
import org.ow2.cmi.controller.server.filter.IFilter;
import org.ow2.cmi.controller.server.impl.jms.Config;
import org.ow2.cmi.controller.server.impl.jms.JORAMHelper;
import org.ow2.cmi.controller.server.impl.jms.JmsProvider;
import org.ow2.cmi.lb.data.PolicyData;
import org.ow2.cmi.reference.CMIReference;
import org.ow2.cmi.reference.ObjectNotFoundException;
import org.ow2.cmi.reference.ServerId;
import org.ow2.cmi.reference.ServerNotFoundException;
import org.ow2.cmi.reference.ServerRef;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public final class JMSClusterViewManager
extends AbsServerClusterViewManager
implements MessageListener,
NotificationListener {
    private static final Log logger = LogFactory.getLog(JMSClusterViewManager.class);
    private Topic superTopic;
    private Connection superTopicConnection;
    private Session superSession;
    private MessageProducer superPublisher;
    private Topic ourTopic;
    private MessageConsumer ourSubscriber;
    private MessageProducer ourPublisher;
    private Connection ourTopicConnection;
    private Session ourSessionSubscriber;
    private Session ourSessionPublisher;
    private ClusterView clusterView = new ClusterView();
    private ObjectName delegate;
    private ObjectName objectNameToListen;
    private boolean initialized = false;
    private ClusterViewCleaner clusterViewCleaner;
    private Heartbeat heartbeat;
    private boolean registrationOpened;

    @Override
    public void doStart() {
        if (this.getObjectNameToListen() != null) {
            try {
                this.objectNameToListen = new ObjectName(this.getObjectNameToListen());
            }
            catch (Exception e) {
                logger.error((Object)"Unable to check if JMS is available", new Object[]{e});
                throw new ServerClusterViewManagerException("Unable to check if JMS is available", e);
            }
        }
        if (this.getObjectNameToListen() == null || MBeanUtils.getMBeanServer().isRegistered(this.objectNameToListen)) {
            this.registrationOpened = true;
        } else {
            try {
                this.delegate = new ObjectName("JMImplementation:type=MBeanServerDelegate");
                MBeanUtils.getMBeanServer().addNotificationListener(this.delegate, this, null, null);
            }
            catch (Exception e) {
                logger.error((Object)"Unable to add the listener for JMS", new Object[]{e});
                throw new ServerClusterViewManagerException("Unable to add the listener for JMS", e);
            }
            logger.info((Object)"CMI server waiting for a JMS implementation...", new Object[0]);
        }
    }

    @Override
    public void doStop() {
        this.registrationOpened = false;
        this.setImplementationAvailable(false);
        if (this.delegate != null && MBeanUtils.getMBeanServer().isRegistered(this.delegate)) {
            try {
                MBeanUtils.getMBeanServer().removeNotificationListener(this.delegate, this);
            }
            catch (Exception e) {
                logger.warn((Object)"Unable to remove the listener for JMS", new Object[]{e});
            }
        }
        try {
            if (this.superTopic != null) {
                this.superPublisher.close();
                this.superSession.close();
                this.superTopicConnection.close();
            }
            if (this.ourPublisher != null) {
                this.ourPublisher.close();
                this.ourSessionPublisher.close();
            }
            if (this.ourSubscriber != null) {
                this.ourSubscriber.close();
                this.ourSessionSubscriber.close();
            }
            if (this.ourTopicConnection != null) {
                this.ourTopicConnection.close();
            }
        }
        catch (JMSException e) {
            logger.warn((Object)"Error while closing the JMS objects", new Object[]{e});
        }
        this.clusterView.clear();
    }

    @Override
    public boolean isRegistrationOpened() {
        return this.registrationOpened;
    }

    @Override
    public void handleNotification(Notification notification, Object handback) {
        if (notification.getType().equals("JMX.mbean.registered")) {
            if (this.objectNameToListen.equals(((MBeanServerNotification)notification).getMBeanName())) {
                this.registrationOpened = true;
                if (this.getState().equals((Object)ClusterViewManager.State.STARTED)) {
                    try {
                        new InitialContext();
                    }
                    catch (NamingException e) {
                        logger.warn((Object)"Unable to create a cmi context", new Object[]{e});
                    }
                }
            }
        } else if (notification.getType().equals("JMX.mbean.unregistered") && this.objectNameToListen.equals(((MBeanServerNotification)notification).getMBeanName())) {
            logger.warn((Object)"JMS no more available: auto-stopping the CMI server.", new Object[0]);
            this.ourSessionPublisher = null;
            this.ourSessionSubscriber = null;
            this.ourPublisher = null;
            this.ourSubscriber = null;
            this.ourTopic = null;
            this.ourTopicConnection = null;
            this.superSession = null;
            this.superPublisher = null;
            this.superTopic = null;
            this.superTopicConnection = null;
            this.stop();
        }
    }

    @Override
    protected void initServerConfig(String contextFactory, ServerId serverId, Context cmiContext) {
        if (!this.initialized) {
            if (this.getSuperTopicName() != null) {
                this.initSuperTopic(contextFactory);
            }
            if (this.getOurTopicName() != null) {
                this.initOurTopic(contextFactory, serverId);
            }
            super.initServerConfig(contextFactory, serverId, cmiContext);
            if (this.ourTopic == null && this.superTopic == null) {
                logger.error((Object)"No topic available!", new Object[0]);
                throw new ServerClusterViewManagerException("No topic available!");
            }
            this.setImplementationAvailable(true);
            logger.info((Object)"CMI server available.", new Object[0]);
            this.initHeartBeat();
            if (this.ourTopic != null || this.superTopic == null) {
                this.initClusterViewCleaner();
            }
            this.initialized = true;
        }
    }

    private void initClusterViewCleaner() {
        this.clusterViewCleaner = new ClusterViewCleaner();
        this.getCmiThreadFactory().newThread(this.clusterViewCleaner, "Cluster View Cleaner").start();
    }

    private void initHeartBeat() {
        this.heartbeat = new Heartbeat();
        this.getCmiThreadFactory().newThread(this.heartbeat, "Heart Beat").start();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void initSuperTopic(String contextFactory) throws ServerClusterViewManagerException {
        InitialContext context;
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", contextFactory);
        env.put("java.naming.provider.url", this.getSuperProviderURL());
        try {
            context = new InitialContext(env);
        }
        catch (NamingException e) {
            logger.error((Object)"Unable to create a context", new Object[]{e});
            throw new ServerClusterViewManagerException("Unable to create a context", e);
        }
        try {
            this.superTopic = (Topic)context.lookup(this.getSuperTopicName());
            ConnectionFactory tcf = (ConnectionFactory)context.lookup(this.getConnectionFactoryName());
            this.superTopicConnection = tcf.createConnection();
            this.superSession = this.superTopicConnection.createSession(false, 1);
            this.superPublisher = this.superSession.createProducer((Destination)this.superTopic);
            this.superTopicConnection.start();
        }
        catch (Exception e) {
            try {
                logger.error((Object)"Unable to initialize the super topic", new Object[]{e});
                throw new ServerClusterViewManagerException("Unable to initialize the super topic", e);
            }
            catch (Throwable throwable) {
                try {
                    context.close();
                    throw throwable;
                }
                catch (NamingException e2) {
                    logger.error((Object)"Unable to close the context", new Object[]{e2});
                }
                throw throwable;
            }
        }
        try {
            context.close();
            return;
        }
        catch (NamingException e) {
            logger.error((Object)"Unable to close the context", new Object[]{e});
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void initOurTopic(String contextFactory, ServerId serverId) {
        block34: {
            env = new Hashtable<String, String>();
            env.put("java.naming.factory.initial", contextFactory);
            providerURL = this.getOurProviderURL();
            if (providerURL == null) {
                providerURL = serverId.getProviderURL();
            }
            env.put("java.naming.provider.url", providerURL);
            try {
                context = new InitialContext(env);
            }
            catch (NamingException e) {
                JMSClusterViewManager.logger.error((Object)"Unable to create a context", new Object[]{e});
                throw new ServerClusterViewManagerException("Unable to create a context", e);
            }
            try {
                this.ourTopic = (Topic)context.lookup(this.getOurTopicName());
            }
            catch (NamingException e) {
                if (this.getOurProviderURL() != null) {
                    JMSClusterViewManager.logger.error((Object)"No topic found with name {0} for the provider URL {1}", new Object[]{this.getOurTopicName(), this.getOurProviderURL(), e});
                    throw new ServerClusterViewManagerException("No topic found with name " + this.getOurTopicName() + " for the provider URL " + this.getOurProviderURL());
                }
                JMSClusterViewManager.logger.debug((Object)"No topic found with name {0} in the local registry.", new Object[]{this.getOurTopicName(), e});
                this.ourTopic = null;
            }
            if (this.ourTopic == null) {
                this.createOurTopic();
                context.rebind(this.getOurTopicName(), (Object)this.ourTopic);
            }
            if (this.getClusterViewProviderURL() == null) {
                JMSClusterViewManager.logger.warn((Object)"Cannot retrieve the cluster view: missing infos about its provider.", new Object[0]);
            } else {
                contextForProvider = null;
                try {
                    envForProvider = new Hashtable<String, String>();
                    envForProvider.put("java.naming.factory.initial", contextFactory);
                    envForProvider.put("java.naming.provider.url", this.getClusterViewProviderURL());
                    contextForProvider = new InitialContext(envForProvider);
                    this.clusterView = ((ServerClusterViewProvider)contextForProvider.lookup(this.getJmsProviderName())).getClusterView();
                    ** if (contextForProvider == null) goto lbl-1000
                }
                catch (NamingException e) {
                    try {
                        JMSClusterViewManager.logger.warn((Object)"Cannot retrieve the cluster view: no provider found for the jndi name {0}", new Object[]{this.getJmsProviderName(), e});
                        ** if (contextForProvider == null) goto lbl-1000
                    }
                    catch (Throwable var8_16) {
                        if (contextForProvider != null) {
                            try {
                                contextForProvider.close();
                            }
                            catch (NamingException e) {
                                JMSClusterViewManager.logger.error((Object)"Unable to close the context", new Object[]{e});
                            }
                        }
                        throw var8_16;
                    }
lbl-1000:
                    // 1 sources

                    {
                        try {
                            contextForProvider.close();
                        }
                        catch (NamingException e) {
                            JMSClusterViewManager.logger.error((Object)"Unable to close the context", new Object[]{e});
                        }
                    }
lbl-1000:
                    // 2 sources

                    {
                    }
                }
lbl-1000:
                // 1 sources

                {
                    try {
                        contextForProvider.close();
                    }
                    catch (NamingException e) {
                        JMSClusterViewManager.logger.error((Object)"Unable to close the context", new Object[]{e});
                    }
                }
lbl-1000:
                // 2 sources

                {
                }
            }
            if (this.isClusterViewShared()) {
                try {
                    jmsProvider = new JmsProvider(this);
                    context.rebind(this.getJmsProviderName(), (Object)jmsProvider);
                }
                catch (Exception e) {
                    JMSClusterViewManager.logger.warn((Object)("Cannot share the cluster view provider with name " + this.getJmsProviderName()), new Object[]{e});
                }
            }
            tcf = (ConnectionFactory)context.lookup(this.getConnectionFactoryName());
            this.ourTopicConnection = tcf.createConnection();
            this.ourSessionSubscriber = this.ourTopicConnection.createSession(false, 1);
            this.ourSubscriber = this.ourSessionSubscriber.createConsumer((Destination)this.ourTopic);
            this.ourSubscriber.setMessageListener((MessageListener)this);
            if (this.isPublisher()) {
                this.ourSessionPublisher = this.ourTopicConnection.createSession(false, 1);
                this.ourPublisher = this.ourSessionPublisher.createProducer((Destination)this.ourTopic);
            }
            this.ourTopicConnection.start();
            try {
                context.close();
            }
            catch (NamingException e) {
                JMSClusterViewManager.logger.error((Object)"Unable to close the context", new Object[]{e});
            }
            break block34;
            catch (Exception e) {
                try {
                    JMSClusterViewManager.logger.error((Object)"Unable to initialize our topic", new Object[]{e});
                    throw new ServerClusterViewManagerException("Unable to initialize our topic", e);
                }
                catch (Throwable var10_18) {
                    try {
                        context.close();
                    }
                    catch (NamingException e) {
                        JMSClusterViewManager.logger.error((Object)"Unable to close the context", new Object[]{e});
                    }
                    throw var10_18;
                }
            }
        }
    }

    private void createOurTopic() {
        if (this.getOurTopicName() != null && this.ourTopic == null) {
            try {
                this.ourTopic = JORAMHelper.createTopic(this.getOurTopicName(), this.superTopic);
            }
            catch (Exception e) {
                logger.error((Object)"Cannot create the topic {0}", new Object[]{this.getOurTopicName(), e});
                throw new ServerClusterViewManagerException("Cannot create the topic " + this.getOurTopicName(), e);
            }
        }
    }

    @Override
    protected boolean containObject(String objectName) {
        return this.clusterView.containsObject(objectName);
    }

    @Override
    protected DistributedObjectInfo getDistributedObjectInfo(String objectName) throws ObjectNotFoundException {
        return this.clusterView.getObjectInfo(objectName);
    }

    @Override
    public void broadCastArchive(Object archiveId, byte[] bytesOfFile) {
        throw new UnsupportedOperationException("TODO");
    }

    @Override
    protected void initStats() {
    }

    @Override
    public boolean isAlreadyDistributed(Object archiveId) {
        throw new UnsupportedOperationException("TODO");
    }

    @Override
    public void removeDistributedArchive(Object archiveId) {
        throw new UnsupportedOperationException("TODO");
    }

    private void sendMessage(Object data, Map<String, Serializable> properties) {
        if (!(data instanceof Serializable)) {
            throw new IllegalArgumentException("The provided object is not serializable.");
        }
        Session session = null;
        MessageProducer publisher = null;
        if (this.ourSessionPublisher != null) {
            session = this.ourSessionPublisher;
            publisher = this.ourPublisher;
        } else if (this.superSession != null) {
            session = this.superSession;
            publisher = this.superPublisher;
        }
        if (session != null) {
            try {
                BytesMessage msg = session.createBytesMessage();
                msg.writeBytes(this.serialize(data));
                for (String key : properties.keySet()) {
                    msg.setObjectProperty(key, (Object)properties.get(key));
                }
                publisher.send((Message)msg);
            }
            catch (Exception e) {
                logger.error((Object)"Unable to send a message to add data", new Object[]{e});
            }
        }
    }

    @Override
    protected void addDistributedObjectInfo(String objectName, DistributedObjectInfo distributedObjectInfo) {
        this.addLocalDistributedObjectInfo(objectName, distributedObjectInfo);
        HashMap<String, Serializable> properties = new HashMap<String, Serializable>();
        properties.put("action", (Serializable)((Object)"add"));
        this.sendMessage(distributedObjectInfo, properties);
    }

    @Override
    protected void setDistributedObjectInfo(String objectName, DistributedObjectInfo distributedObjectInfo) {
        this.setLocalDistributedObjectInfo(objectName, distributedObjectInfo);
        HashMap<String, Serializable> properties = new HashMap<String, Serializable>();
        properties.put("action", (Serializable)((Object)"set"));
        this.sendMessage(distributedObjectInfo, properties);
    }

    @Override
    public void addCMIReference(CMIReference cmiReference) {
        this.addLocalCMIReference(cmiReference);
        HashMap<String, Serializable> properties = new HashMap<String, Serializable>();
        properties.put("action", (Serializable)((Object)"add"));
        this.sendMessage(cmiReference, properties);
    }

    public List<CMIReference> getCMIReferences(String objectName) throws ObjectNotFoundException {
        return this.clusterView.getCMIReferences(objectName);
    }

    @Override
    public Collection<CMIReference> getCMIReferences(String objectName, String protocolName) throws ObjectNotFoundException {
        return this.clusterView.getCMIReferences(objectName, protocolName);
    }

    @Override
    public Set<String> getObjectNames() {
        return this.clusterView.getObjectNames();
    }

    private void setLocalDistributedObjectInfo(String objectName, DistributedObjectInfo distributedObjectInfo) {
        DistributedObjectInfo oldDistributedObjectInfo = this.clusterView.addObjectInfo(distributedObjectInfo, true);
        if (!oldDistributedObjectInfo.equals(distributedObjectInfo)) {
            PolicyData policyData = oldDistributedObjectInfo.getPolicyData();
            if (!policyData.equals(distributedObjectInfo.getPolicyData())) {
                try {
                    this.updatePolicy(objectName);
                }
                catch (Exception e) {
                    logger.error((Object)("Cannot update the policy for the object with name " + objectName), new Object[]{e});
                }
            }
            try {
                this.updatePool(oldDistributedObjectInfo, distributedObjectInfo);
            }
            catch (ObjectNotFoundException e) {
                logger.error((Object)("Cannot update the pool configuration for the object with name " + objectName), new Object[]{e});
            }
        }
    }

    private void addLocalDistributedObjectInfo(String objectName, DistributedObjectInfo distributedObjectInfo) {
        this.clusterView.addObjectInfo(distributedObjectInfo, false);
        try {
            this.updatePolicy(objectName);
        }
        catch (Exception e) {
            logger.error((Object)("Cannot update the policy for the object with name " + objectName), new Object[]{e});
        }
        try {
            this.updatePool(null, distributedObjectInfo);
        }
        catch (ObjectNotFoundException e) {
            logger.error((Object)("Cannot update the pool configuration for the object with name " + objectName), new Object[]{e});
        }
    }

    private void addLocalCMIReference(CMIReference cmiReference) {
        this.clusterView.addCMIReference(cmiReference);
    }

    @Override
    protected boolean doRemoveCMIReference(CMIReference cmiReference) {
        try {
            this.removeLocalCMIReference(cmiReference);
            HashMap<String, Serializable> properties = new HashMap<String, Serializable>();
            properties.put("action", (Serializable)((Object)"rem"));
            this.sendMessage(cmiReference, properties);
            if (this.clusterView.getCMIReferences(cmiReference.getObjectName()).isEmpty()) {
                this.clusterView.removeCMIReference(cmiReference);
                return true;
            }
        }
        catch (ObjectNotFoundException e) {
            logger.debug((Object)"Cannot remove the CMIReference {0}", new Object[]{cmiReference, e});
        }
        return false;
    }

    private void removeLocalCMIReference(CMIReference cmiReference) throws ObjectNotFoundException {
        this.clusterView.removeCMIReference(cmiReference);
    }

    @Override
    public void setDelayToRefresh(int delay) {
        this.setLocalDelay(delay);
        HashMap<String, Serializable> properties = new HashMap<String, Serializable>();
        properties.put("delay", (Serializable)((Object)"set"));
        this.sendMessage(delay, properties);
    }

    @Override
    protected void initDelayToRefresh(int delayToRefresh) {
    }

    private void setLocalDelay(int delay) {
        this.clusterView.setDelay(delay);
    }

    @Override
    public int getDelayToRefresh() {
        return this.clusterView.getDelay();
    }

    @Override
    public List<IFilter> getGlobalFilters() {
        return this.clusterView.getFilters();
    }

    @Override
    public void addGlobalFilter(IFilter filter) throws IllegalArgumentException {
        this.addFilter(filter);
        HashMap<String, Serializable> properties = new HashMap<String, Serializable>();
        properties.put("action", (Serializable)((Object)"add"));
        this.sendMessage(filter, properties);
    }

    @Override
    public void removeGlobalFilter(IFilter filter) {
        if (this.removeFilter(filter)) {
            HashMap<String, Serializable> properties = new HashMap<String, Serializable>();
            properties.put("action", (Serializable)((Object)"rem"));
            this.sendMessage(filter, properties);
        }
    }

    private void addFilter(IFilter filter) {
        this.clusterView.addFilter(filter);
    }

    private boolean removeFilter(IFilter filter) {
        return this.clusterView.removeFilter(filter);
    }

    @Override
    public boolean isServerBlackListed(ServerRef serverRef) {
        return this.clusterView.isServerBlackListed(serverRef);
    }

    @Override
    public void addServerToBlackList(ServerRef serverRef) {
        if (!this.clusterView.addServerToBlackList(serverRef)) {
            HashMap<String, Serializable> properties = new HashMap<String, Serializable>();
            properties.put("black", Boolean.valueOf(true));
            this.sendMessage(serverRef, properties);
        }
    }

    @Override
    public void removeServerFromBlackList(ServerRef serverRef) {
        try {
            if (this.clusterView.removeServerFromBlackList(serverRef)) {
                HashMap<String, Serializable> properties = new HashMap<String, Serializable>();
                properties.put("black", Boolean.valueOf(false));
                this.sendMessage(serverRef, properties);
            }
        }
        catch (ServerNotFoundException e) {
            logger.debug((Object)"Unable to remove {0} from the blacklist", new Object[]{serverRef, e});
        }
    }

    @Override
    public Set<String> getClusterNames() {
        return this.clusterView.getClusterNames();
    }

    @Override
    public int getNbClientsConnectedToProvider() {
        return -1;
    }

    @Override
    public Set<String> getObjectNames(String clusterName) {
        return this.clusterView.getObjectNames(clusterName);
    }

    @Override
    public void registerClient(UUID uuid) {
    }

    @Override
    public boolean isPoolToEmpty(String objectName) throws ObjectNotFoundException {
        throw new UnsupportedOperationException("TODO");
    }

    @Override
    public void addPoolToEmpty(String objectName) {
        throw new UnsupportedOperationException("TODO");
    }

    @Override
    public void removePoolToEmpty(String objectName) {
        throw new UnsupportedOperationException("TODO");
    }

    @Override
    public int getLoadFactor(ServerRef serverRef) throws ServerNotFoundException {
        return this.clusterView.getLoadFactor(serverRef);
    }

    @Override
    public void setLoadFactor(ServerRef serverRef, int loadFactor) {
        if (this.clusterView.setLoadFactor(serverRef, loadFactor) != loadFactor) {
            HashMap<String, Serializable> properties = new HashMap<String, Serializable>();
            properties.put("load", Integer.valueOf(loadFactor));
            this.sendMessage(serverRef, properties);
        }
    }

    @Override
    public long getDateOfConfiguration() {
        return -1L;
    }

    public void onMessage(Message msg) {
        block25: {
            try {
                Object value;
                Object object;
                if (!(msg instanceof BytesMessage)) break block25;
                BytesMessage bytesMessage = (BytesMessage)msg;
                try {
                    object = this.unserialize(bytesMessage);
                }
                catch (Exception e) {
                    logger.error((Object)"Cannot unserialize the bytes message {0}", new Object[]{bytesMessage, e});
                    return;
                }
                if (object instanceof CMIReference) {
                    CMIReference cmiRef = (CMIReference)object;
                    if (bytesMessage.getObjectProperty("action").equals("add")) {
                        logger.debug((Object)"A new object is available at this location: {0}", new Object[]{cmiRef});
                        this.addLocalCMIReference(cmiRef);
                    } else {
                        logger.debug((Object)"A new object is to remove for this location: {0}", new Object[]{cmiRef});
                        try {
                            this.removeLocalCMIReference(cmiRef);
                        }
                        catch (ObjectNotFoundException e) {
                            logger.debug((Object)"Cannot remove the CMIReference {0}", new Object[]{cmiRef, e});
                        }
                    }
                } else if (object instanceof DistributedObjectInfo) {
                    DistributedObjectInfo distributedObjectInfo = (DistributedObjectInfo)object;
                    if (bytesMessage.getObjectProperty("action").equals("add")) {
                        this.addLocalDistributedObjectInfo(distributedObjectInfo.getObjectName(), distributedObjectInfo);
                    } else {
                        this.setLocalDistributedObjectInfo(distributedObjectInfo.getObjectName(), distributedObjectInfo);
                    }
                } else if (object instanceof IFilter) {
                    IFilter filter = (IFilter)object;
                    if (bytesMessage.getObjectProperty("action").equals("add")) {
                        this.addFilter(filter);
                    } else {
                        this.removeFilter(filter);
                    }
                } else if (object instanceof ServerRef) {
                    ServerRef serverRef = (ServerRef)object;
                    Object value2 = bytesMessage.getObjectProperty("black");
                    if (value2 != null && value2 instanceof Boolean) {
                        if (((Boolean)value2).booleanValue()) {
                            this.addServerToBlackList(serverRef);
                        } else {
                            this.removeServerFromBlackList(serverRef);
                        }
                    }
                    if ((value2 = bytesMessage.getObjectProperty("load")) != null && value2 instanceof Integer) {
                        this.setLoadFactor(serverRef, (Integer)value2);
                    }
                } else if (object instanceof Integer && (value = bytesMessage.getObjectProperty("delay")) != null && value.equals("set")) {
                    this.setLocalDelay((Integer)object);
                }
            }
            catch (JMSException e) {
                logger.error((Object)"Cannot read the message {0}", new Object[]{msg, e});
            }
        }
    }

    private byte[] serialize(Object object) throws IOException {
        ByteArrayOutputStream bOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(bOutputStream);
        objectOutputStream.writeObject(object);
        objectOutputStream.flush();
        return bOutputStream.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object unserialize(BytesMessage bytesMessage) throws IOException, JMSException, ClassNotFoundException {
        byte[] bytes = new byte[(int)bytesMessage.getBodyLength()];
        bytesMessage.readBytes(bytes);
        ObjectInputStream stream = new ObjectInputStream(new ByteArrayInputStream(bytes)){

            @Override
            protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
                String name = desc.getName();
                return Class.forName(name, false, this.getClass().getClassLoader());
            }
        };
        try {
            Object object = stream.readObject();
            return object;
        }
        finally {
            stream.close();
        }
    }

    private String getSuperTopicName() {
        return ((Config)this.getConfig()).getSuperTopicName();
    }

    private String getOurTopicName() {
        return ((Config)this.getConfig()).getOurTopicName();
    }

    private String getSuperProviderURL() {
        return ((Config)this.getConfig()).getSuperProviderURL();
    }

    private String getOurProviderURL() {
        return ((Config)this.getConfig()).getOurProviderURL();
    }

    private boolean isPublisher() {
        return ((Config)this.getConfig()).isPublisher();
    }

    private String getClusterViewProviderURL() {
        return ((Config)this.getConfig()).getClusterViewProviderURL();
    }

    private boolean isClusterViewShared() {
        return ((Config)this.getConfig()).isClusterViewShared();
    }

    private String getObjectNameToListen() {
        return ((Config)this.getConfig()).getObjectNameToListen();
    }

    private String getJmsProviderName() {
        return ((Config)this.getConfig()).getJmsProviderName();
    }

    private String getConnectionFactoryName() {
        return ((Config)this.getConfig()).getConnectionFactoryName();
    }

    public long getPeriodToBeat() {
        return ((Config)this.getConfig()).getPeriodToBeat();
    }

    private long getPeriodToCleanUp() {
        return ((Config)this.getConfig()).getPeriodToCleanUp();
    }

    private long getWaitingBeatNumber() {
        return ((Config)this.getConfig()).getWaitingBeatNumber();
    }

    public ClusterView getClusterView() {
        return this.clusterView;
    }

    private class ClusterViewCleaner
    implements Runnable,
    MessageListener {
        private Map<String, Long> timestamps;

        private ClusterViewCleaner() {
        }

        public void run() {
            Topic topic;
            this.timestamps = new ConcurrentHashMap<String, Long>();
            Connection connection = null;
            if (JMSClusterViewManager.this.ourTopic != null) {
                connection = JMSClusterViewManager.this.ourTopicConnection;
                topic = JMSClusterViewManager.this.ourTopic;
            } else if (JMSClusterViewManager.this.superTopic != null) {
                connection = JMSClusterViewManager.this.superTopicConnection;
                topic = JMSClusterViewManager.this.superTopic;
            } else {
                logger.error((Object)"No connection available!", new Object[0]);
                throw new ServerClusterViewManagerException("No connection available!");
            }
            try {
                Session session = connection.createSession(false, 1);
                MessageConsumer consumer = session.createConsumer((Destination)topic);
                consumer.setMessageListener((MessageListener)this);
            }
            catch (JMSException e) {
                logger.error((Object)"Cannot init the consumer for the cluster view cleaner!", new Object[]{e});
                throw new ServerClusterViewManagerException("Cannot init the consumer for the cluster view cleaner!", e);
            }
            while (JMSClusterViewManager.this.isImplementationAvailable()) {
                try {
                    Thread.sleep(JMSClusterViewManager.this.getPeriodToCleanUp());
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                logger.debug((Object)"Cleaning the cluster view...", new Object[0]);
                this.cleanClusterView();
            }
        }

        private boolean isLocalRegistry(String providerURL) {
            for (ServerId serverId : JMSClusterViewManager.this.getRefOnLocalRegistries()) {
                if (!serverId.getProviderURL().equals(providerURL)) continue;
                return true;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized void cleanClusterView() {
            Map<String, ? extends ServerView> serverViews;
            Map<String, ? extends ServerView> map = serverViews = JMSClusterViewManager.this.clusterView.getServerViews();
            synchronized (map) {
                Iterator<String> it = serverViews.keySet().iterator();
                while (it.hasNext()) {
                    String providerURL = it.next();
                    Long timestamp = this.timestamps.get(providerURL);
                    if (timestamp == null || timestamp + JMSClusterViewManager.this.getPeriodToBeat() * JMSClusterViewManager.this.getWaitingBeatNumber() >= System.currentTimeMillis()) continue;
                    if (this.isLocalRegistry(providerURL)) {
                        logger.warn((Object)"The local registry doesn't anymore send heartbeats!", new Object[]{providerURL});
                        continue;
                    }
                    logger.debug((Object)"Removing {0}", new Object[]{providerURL});
                    JMSClusterViewManager.this.clusterView.removeClusteredObjects(providerURL);
                    it.remove();
                }
            }
        }

        public void onMessage(Message msg) {
            if (msg instanceof TextMessage) {
                try {
                    this.timestamps.put(((TextMessage)msg).getText(), msg.getJMSTimestamp());
                }
                catch (JMSException e) {
                    logger.warn((Object)"Cannot extract the content of {0}", new Object[]{msg, e});
                }
            }
        }
    }

    private class Heartbeat
    implements Runnable {
        private Heartbeat() {
        }

        public void run() {
            MessageProducer producer;
            Topic topic;
            Connection connection = null;
            if (JMSClusterViewManager.this.ourTopic != null) {
                connection = JMSClusterViewManager.this.ourTopicConnection;
                topic = JMSClusterViewManager.this.ourTopic;
            } else if (JMSClusterViewManager.this.superTopic != null) {
                connection = JMSClusterViewManager.this.superTopicConnection;
                topic = JMSClusterViewManager.this.superTopic;
            } else {
                logger.error((Object)"No connection available!", new Object[0]);
                throw new ServerClusterViewManagerException("No connection available!");
            }
            Set<ServerId> registries = JMSClusterViewManager.this.getRefOnLocalRegistries();
            ArrayList<TextMessage> messages = new ArrayList<TextMessage>(registries.size());
            try {
                Session session = connection.createSession(false, 1);
                producer = session.createProducer((Destination)topic);
                for (ServerId serverId : registries) {
                    messages.add(session.createTextMessage(serverId.getProviderURL()));
                }
            }
            catch (JMSException e) {
                logger.error((Object)"Cannot init the producer for the heartbeat!", new Object[]{e});
                throw new ServerClusterViewManagerException("Cannot init the producer for the heartbeat!", e);
            }
            while (JMSClusterViewManager.this.isImplementationAvailable()) {
                try {
                    for (Message message : messages) {
                        producer.send(message);
                    }
                }
                catch (JMSException e) {
                    logger.warn((Object)"Cannot send a heartbeat!", new Object[]{e});
                }
                try {
                    Thread.sleep(JMSClusterViewManager.this.getPeriodToBeat());
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }
}

