/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.cmi.rpc;

import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import net.jcip.annotations.ThreadSafe;
import org.ow2.cmi.controller.client.ClientClusterViewManager;
import org.ow2.cmi.controller.common.AbsClusterViewManager;
import org.ow2.cmi.controller.common.ClusterViewManager;
import org.ow2.cmi.controller.provider.ClientClusterViewProvider;
import org.ow2.cmi.event.CMIEventComponent;
import org.ow2.cmi.event.CMIManagedObject;
import org.ow2.cmi.lb.NoLoadBalanceableException;
import org.ow2.cmi.lb.decision.DecisionManager;
import org.ow2.cmi.lb.policy.IPolicy;
import org.ow2.cmi.reference.CMIProxyHandle;
import org.ow2.cmi.reference.CMIReference;
import org.ow2.cmi.reference.CMIReferenceable;
import org.ow2.cmi.reference.ObjectNotFoundException;
import org.ow2.cmi.rpc.CMIInvocationHandlerException;
import org.ow2.cmi.rpc.CMIProxy;
import org.ow2.util.component.api.Component;
import org.ow2.util.event.api.IEventDispatcher;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public abstract class CMIInvocationHandler<T>
implements InvocationHandler,
Serializable,
CMIManagedObject {
    private static final long serialVersionUID = -2257434302509492634L;
    private static transient Log logger = LogFactory.getLog(CMIInvocationHandler.class);
    private transient ClassLoader classLoader;
    protected final String objectName;
    protected final String protocolName;
    protected transient ClusterViewManager clusterViewManager;
    private CMIReferenceable<T> currentRef;
    protected transient Class<? extends T> itf;
    private boolean keepCurrentRef;
    protected transient CMIProxyHandle cmiProxyHandle = null;
    private long lastInvocDuration;
    private transient IEventDispatcher dispatcher;
    private transient String cmiManagedObjectId;
    private static transient long id = 0L;

    protected CMIInvocationHandler(ClusterViewManager clusterViewManager, String objectName, String protocolName, boolean keepCurrentRef, Class<? extends T> itf) {
        this.clusterViewManager = clusterViewManager;
        this.protocolName = protocolName;
        this.objectName = objectName;
        this.keepCurrentRef = keepCurrentRef;
        this.itf = itf;
        this.registerCMIManagedObject();
    }

    protected void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public <Comp extends Component> Comp getComponent(Class<Comp> itf) {
        return this.clusterViewManager.getComponent(itf);
    }

    @Override
    public String getCMIManagedObjectId() {
        return this.cmiManagedObjectId;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (this.clusterViewManager == null) {
            this.clusterViewManager = AbsClusterViewManager.getClusterViewManager();
        }
        if (this.classLoader == null) {
            this.classLoader = Thread.currentThread().getContextClassLoader();
        }
        if (this.itf == null) {
            try {
                this.itf = this.clusterViewManager.getInterface(this.objectName);
            }
            catch (ObjectNotFoundException e) {
                logger.error((Object)("Cannot retrieve the interface for object with name " + this.objectName), new Object[]{e});
                throw new CMIInvocationHandlerException("Cannot retrieve the interface for object with name " + this.objectName, e);
            }
        }
        if (this.cmiManagedObjectId == null) {
            this.registerCMIManagedObject();
        }
        this.checkInitialized();
        if (method.getDeclaringClass() == Object.class) {
            return this.invokeObjectMethod(proxy, method, args);
        }
        String methodName = method.getName();
        if (methodName.endsWith("_CMI")) {
            return this.invokeCMIProxy(methodName.substring(0, methodName.length() - 4), proxy);
        }
        return this.invokeRemoteMethod(proxy, method, args);
    }

    private void registerCMIManagedObject() {
        this.dispatcher = ((AbsClusterViewManager)this.clusterViewManager).getEventDispatcher();
        if (this.dispatcher != null) {
            this.cmiManagedObjectId = "/cmi/" + this.objectName + "/" + this.protocolName + "/" + id++;
            CMIEventComponent eventComponent = this.getComponent((Class)CMIEventComponent.class);
            if (eventComponent != null) {
                eventComponent.registerCMIManagedObject(this, this.dispatcher);
            }
        }
    }

    private Object invokeCMIProxy(String methodName, Object proxy) throws CMIInvocationHandlerException {
        if (methodName.equals("getObjectName")) {
            return this.objectName;
        }
        if (methodName.equals("getInterface")) {
            return this.itf;
        }
        if (methodName.equals("getProtocolName")) {
            return this.protocolName;
        }
        if (methodName.equals(this.getHandleMethodName())) {
            return this.getHandle((CMIProxy)proxy);
        }
        if (methodName.equals("getCurrentCMIRef")) {
            return this.currentRef;
        }
        if (methodName.equals("isCMIRefKept")) {
            return this.keepCurrentRef;
        }
        throw new CMIInvocationHandlerException("CMIProxy doesn't define the method " + methodName);
    }

    protected abstract void checkInitialized() throws CMIInvocationHandlerException;

    private Object invokeObjectMethod(Object proxy, Method method, Object ... args) {
        String name = method.getName();
        if (name.equals("hashCode")) {
            return new Integer(this.hashCode());
        }
        if (name.equals("equals")) {
            Object obj = args[0];
            boolean b = proxy == obj || obj != null && Proxy.isProxyClass(obj.getClass()) && this.equals(Proxy.getInvocationHandler(obj));
            return b;
        }
        if (name.equals("toString")) {
            return this.proxyToString(proxy);
        }
        logger.error((Object)"unexpected Object method: {0}", new Object[]{method});
        throw new IllegalArgumentException("unexpected Object method: " + method);
    }

    protected String proxyToString(Object proxy) {
        return "object:" + this.objectName + ", protocol:" + this.protocolName + ", object:" + this.currentRef + ", keepCurrentRef:" + this.keepCurrentRef + ", itf:" + this.itf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object invokeRemoteMethod(Object proxy, Method method, Object ... args) throws Throwable {
        String methodName = method.getName();
        ArrayList<CMIReference> cmiReferences = null;
        IPolicy<CMIReference> policy = null;
        try {
            cmiReferences = new ArrayList<CMIReference>(this.clusterViewManager.getCMIReferences(this.objectName, this.protocolName));
            logger.debug((Object)"Object: {0} - Invoke:{1} > CMIReferences: {2}", new Object[]{this.objectName, methodName, cmiReferences});
            policy = this.clusterViewManager.getPolicy(this.objectName);
            logger.debug((Object)"Object: {0} - Invoke: {1} > Policy: {2}", new Object[]{this.objectName, methodName, policy});
        }
        catch (Exception e) {
            logger.error((Object)"Object: {0} - Invoke:{1} > Cannot retrieve data", new Object[]{this.objectName, method, e});
            throw new CMIInvocationHandlerException("Object: " + this.objectName + " - Invoke: " + methodName + " > Cannot retrieve data", e);
        }
        DecisionManager<Object> decisionManagerOnReturn = null;
        do {
            DecisionManager.Decision decision;
            DecisionManager<Void> decisionManager;
            CMIReference cmiReference = null;
            CMIReferenceable<T> cmiReferenceable = null;
            if (this.keepCurrentRef && this.currentRef != null) {
                cmiReference = this.currentRef.getReference();
                cmiReferenceable = this.currentRef;
            }
            if (cmiReferenceable == null) {
                DecisionManager<CMIReferenceable<T>> decisionManagerOnChoose;
                if (cmiReferences.isEmpty()) {
                    logger.error((Object)"Object:{0} - Invoke: {1} > No server available! Skipping the invocation...", new Object[]{this.objectName, methodName});
                    throw new CMIInvocationHandlerException("Object: " + this.objectName + " - Invoke: " + methodName + " > No server available! Skipping the invocation...");
                }
                logger.debug((Object)"Object:{0} - Invoke: {1} > Choosing a node...", new Object[]{this.objectName, methodName});
                try {
                    cmiReference = policy.choose(cmiReferences);
                }
                catch (NoLoadBalanceableException e) {
                    logger.error((Object)"Object: {0} - Invoke: {1} > Cannot get a CMIReference for protocol {2}", new Object[]{this.objectName, methodName, this.protocolName, e});
                    throw new CMIInvocationHandlerException("Object: " + this.objectName + " - Invoke: " + methodName + " > Cannot get a CMIReference for protocol " + this.protocolName, e);
                }
                logger.debug((Object)"Object: {0} - Invoke: {1} > Trying to get a CMIReferenceable for {2}...", new Object[]{this.objectName, methodName, cmiReference});
                try {
                    cmiReferenceable = this.getCMIReferenceable(cmiReference);
                    logger.debug((Object)"Object: {0} - Invoke: {1} > CMIReferenceable successfully retrieved: {2}", new Object[]{this.objectName, methodName, cmiReferenceable});
                    decisionManagerOnChoose = policy.onChoose(method, args, cmiReferenceable);
                }
                catch (Exception e) {
                    logger.debug((Object)"Object:{0} - Invoke: {1} > onLookupException.", new Object[]{this.objectName, methodName, e});
                    decisionManager = policy.onLookupException(cmiReference, e);
                    if (decisionManager.getDecision().equals((Object)DecisionManager.Decision.THROW)) {
                        logger.debug((Object)"Object: {0} - Invoke: {1} > onLookupException=THROW", new Object[]{this.objectName, methodName, decisionManager.getThrowable()});
                        throw decisionManager.getThrowable();
                    }
                    logger.debug((Object)"Object: {0} - Invoke: {1} > onLookupException=RETRY, Removing node {2}", new Object[]{this.objectName, methodName, cmiReference});
                    cmiReferences.remove(cmiReference);
                    this.currentRef = null;
                    continue;
                }
                decision = decisionManagerOnChoose.getDecision();
                if (decision.equals((Object)DecisionManager.Decision.RETRY)) {
                    logger.debug((Object)"Object:{0} - Invoke: {1} > onChoose=RETRY!", new Object[]{this.objectName, method});
                    cmiReferences.remove(cmiReference);
                    continue;
                }
                if (decision.equals((Object)DecisionManager.Decision.RETURN)) {
                    logger.debug((Object)"Object: {0} - Invoke: {1} > onChoose=RETURN!", new Object[]{this.objectName, method});
                    cmiReferenceable = decisionManagerOnChoose.getRetVal();
                } else if (decision.equals((Object)DecisionManager.Decision.THROW)) {
                    logger.error((Object)"Object: {0} - Invoke: {1} > onChoose=THROW!", new Object[]{this.objectName, method, decisionManagerOnChoose.getThrowable()});
                    throw decisionManagerOnChoose.getThrowable();
                }
                this.currentRef = cmiReferenceable;
            }
            if (cmiReferenceable == null) {
                logger.error((Object)"Object: {0} - Invoke: {1} > The current manadatory for reference {2} should not be null !", new Object[]{this.objectName, methodName, cmiReference});
                throw new CMIInvocationHandlerException("Object: " + this.objectName + " - Invoke: " + methodName + " > The current manadatory for reference " + cmiReference + "should not be null !");
            }
            this.preInvokeHook(cmiReferenceable);
            ClassLoader oldClassLoader = null;
            if (this.classLoader != null) {
                oldClassLoader = Thread.currentThread().getContextClassLoader();
                Thread.currentThread().setContextClassLoader(this.classLoader);
            }
            logger.debug((Object)"Object: {0} - Invoke: {1} > Invocation with args: {2}", new Object[]{this.objectName, methodName, args});
            try {
                Object result;
                long timeBefore = System.currentTimeMillis();
                try {
                    result = method.invoke(cmiReferenceable.getReferencedObject(), args);
                    long timeAfter = System.currentTimeMillis();
                    this.lastInvocDuration = timeAfter - timeBefore;
                    logger.debug((Object)"Object: {0} - Invoke: {1} > Invocation performed in {2} ms", new Object[]{this.objectName, methodName, this.lastInvocDuration});
                }
                finally {
                    if (this.classLoader != null) {
                        Thread.currentThread().setContextClassLoader(oldClassLoader);
                    }
                }
                this.postInvokeHook();
                decisionManagerOnReturn = policy.onReturn(method, args, cmiReference, result);
            }
            catch (InvocationTargetException e) {
                logger.debug((Object)"Object: {0} - Invoke: {1} > onInvokeException.", new Object[]{this.objectName, methodName, e.getCause()});
                decisionManager = policy.onInvokeException(method, args, cmiReference, e.getCause());
                if (decisionManager.getDecision().equals((Object)DecisionManager.Decision.THROW)) {
                    logger.debug((Object)"Object: {0} - Invoke: {1} > onInvokeException=THROW!", new Object[]{this.objectName, methodName, decisionManager.getThrowable()});
                    throw decisionManager.getThrowable();
                }
                if (this.clusterViewManager instanceof ClientClusterViewManager && !this.itf.equals(ClientClusterViewProvider.class)) {
                    CMIInvocationHandler cMIInvocationHandler = this;
                    synchronized (cMIInvocationHandler) {
                        logger.debug((Object)"Object: {0} - Invoke: {1} > onInvokeException=RETRY, Forcing an update...", new Object[]{this.objectName, methodName});
                        ((ClientClusterViewManager)this.clusterViewManager).pullAndUpdateObjectInfos(this.objectName);
                    }
                }
                cmiReferences = new ArrayList<CMIReference>(this.clusterViewManager.getCMIReferences(this.objectName, this.protocolName));
                logger.debug((Object)"Object: {0} - Invoke: {1} > onInvokeException=RETRY, CMIReferences is now: {2}", new Object[]{this.objectName, methodName, cmiReferences});
                logger.debug((Object)"Object: {0} - Invoke: {1} > onInvokeException=RETRY, Removing node {2}", new Object[]{this.objectName, methodName, cmiReference});
                cmiReferences.remove(cmiReference);
                this.currentRef = null;
                this.onExceptionHook(this.objectName, cmiReferenceable);
            }
            catch (Exception e) {
                logger.error((Object)"Object: {0} - Invoke: {1} > onInvokeException.", new Object[]{this.objectName, methodName, e});
                throw new CMIInvocationHandlerException("Object: " + this.objectName + " - Invoke: " + methodName + " > onInvokeException.", e);
            }
            finally {
                this.onFinallyHook(this.objectName, cmiReferenceable);
            }
            if (decisionManagerOnReturn == null) continue;
            decision = decisionManagerOnReturn.getDecision();
            if (decision.equals((Object)DecisionManager.Decision.RETRY)) {
                logger.debug((Object)"Object: {0} - Invoke: {1} > onReturn=RETRY!", new Object[]{this.objectName, method});
                cmiReferences.remove(cmiReference);
                this.currentRef = null;
                decisionManagerOnReturn = null;
                continue;
            }
            if (decision.equals((Object)DecisionManager.Decision.RETURN)) {
                logger.debug((Object)"Object: {0} - Invoke: {1} > onReturn=RETURN!", new Object[]{this.objectName, method});
                continue;
            }
            if (!decision.equals((Object)DecisionManager.Decision.THROW)) continue;
            logger.error((Object)"Object: {0} - Invoke: {1} > onReturn=THROW!", new Object[]{this.objectName, method, decisionManagerOnReturn.getThrowable()});
            throw decisionManagerOnReturn.getThrowable();
        } while (decisionManagerOnReturn == null);
        if (this.cmiProxyHandle != null) {
            this.cmiProxyHandle = this.cmiProxyHandle.updateHttpSession();
        }
        return decisionManagerOnReturn.getRetVal();
    }

    public CMIReferenceable<T> getCurrentRef() {
        return this.currentRef;
    }

    public void setCurrentRef(CMIReferenceable<T> currentRef) {
        this.currentRef = currentRef;
    }

    protected String getHandleMethodName() {
        return "getHandle";
    }

    protected abstract CMIProxyHandle getHandle(CMIProxy var1);

    public void setCmiProxyHandle(CMIProxyHandle cmiProxyHandle) {
        this.cmiProxyHandle = cmiProxyHandle;
    }

    protected abstract CMIReferenceable<T> getCMIReferenceable(CMIReference var1) throws Exception;

    public long getLastInvocDuration() {
        return this.lastInvocDuration;
    }

    protected void preInvokeHook(CMIReferenceable<T> cmiReferenceable) {
    }

    protected void postInvokeHook() {
    }

    protected abstract void onExceptionHook(String var1, CMIReferenceable<T> var2) throws Throwable;

    protected abstract void onFinallyHook(String var1, CMIReferenceable<T> var2);
}

