/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.cmi.rpc;

import java.lang.reflect.Method;
import java.util.Hashtable;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;
import org.ow2.cmi.controller.common.ClusterViewManager;
import org.ow2.cmi.ha.RequestId;
import org.ow2.cmi.ha.SessionId;
import org.ow2.cmi.ha.interceptor.HACurrent;
import org.ow2.cmi.reference.CMIProxyHandle;
import org.ow2.cmi.reference.CMIProxyHandleImpl;
import org.ow2.cmi.reference.CMIReference;
import org.ow2.cmi.reference.CMIReferenceable;
import org.ow2.cmi.reference.CMIReferenceableWrapper;
import org.ow2.cmi.reference.ServerRef;
import org.ow2.cmi.rpc.CMIInvocationHandler;
import org.ow2.cmi.rpc.CMIInvocationHandlerException;
import org.ow2.cmi.rpc.CMIProxy;
import org.ow2.cmi.rpc.POJOInvocationHandlerException;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatefulPOJOInvocationHandler
extends CMIInvocationHandler<Object> {
    private static final long serialVersionUID = -5482752408858461947L;
    private static transient Log logger = LogFactory.getLog(StatefulPOJOInvocationHandler.class);
    private transient ClassLoader classLoader;
    private boolean onFailover = false;
    private SessionId sessionId;
    private int requestNb = 0;

    protected StatefulPOJOInvocationHandler(ClassLoader classLoader, ClusterViewManager clusterViewManager, String objectName, String protocolName, Class<?> itf, SessionId sessionId) {
        super(clusterViewManager, objectName, protocolName, true, itf);
        this.classLoader = classLoader;
        this.sessionId = sessionId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Object invokeRemoteMethod(Object proxy, Method method, Object ... args) throws Throwable {
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.classLoader);
        this.setClassLoader(oldClassLoader);
        try {
            RequestId requestId = new RequestId(this.sessionId, this.requestNb);
            HACurrent.getHACurrent().putNextReq(requestId);
            Object result = super.invokeRemoteMethod(proxy, method, args);
            ++this.requestNb;
            if (this.onFailover) {
                this.onFailover = false;
                HACurrent.getHACurrent().setOnFailover(false);
            }
            Object object = result;
            return object;
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
    }

    @Override
    protected void checkInitialized() throws CMIInvocationHandlerException {
        if (this.classLoader == null) {
            try {
                this.classLoader = Thread.currentThread().getContextClassLoader();
            }
            catch (Exception e) {
                throw new POJOInvocationHandlerException("Cannot retrieve the classloader for object with name " + this.objectName, e);
            }
        }
    }

    @Override
    protected CMIProxyHandle getHandle(CMIProxy cmiProxy) {
        if (this.cmiProxyHandle == null) {
            this.cmiProxyHandle = new CMIProxyHandleImpl(this.objectName, this.itf.getName(), cmiProxy);
        }
        return this.cmiProxyHandle;
    }

    @Override
    protected CMIReferenceable<Object> getCMIReferenceable(CMIReference cmiReference) throws Exception {
        Class<?> interfaceClass;
        InitialContext chosenContext;
        ServerRef serverRef = cmiReference.getServerRef();
        String protocol = serverRef.getProtocol();
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", this.clusterViewManager.getInitialContextFactoryName(protocol));
        env.put("java.naming.provider.url", serverRef.getProviderURL());
        try {
            chosenContext = new InitialContext(env);
        }
        catch (NamingException e) {
            logger.error((Object)"Cannot get a real context", new Object[]{e});
            throw new POJOInvocationHandlerException("Cannot get a real context", e);
        }
        if (chosenContext == null) {
            logger.error((Object)"Cannot get a real context", new Object[0]);
            throw new POJOInvocationHandlerException("Cannot get a real context");
        }
        String bindName = cmiReference.getObjectName();
        try {
            interfaceClass = this.clusterViewManager.getInterface(bindName);
        }
        catch (Exception e) {
            logger.error((Object)"Cannot get interface for name {0}", new Object[]{bindName, e});
            throw new POJOInvocationHandlerException("Cannot get interface for name " + bindName, e);
        }
        Object object = null;
        try {
            logger.debug((Object)"Lookup {0} on {1}", new Object[]{bindName, serverRef.getProviderURL()});
            object = PortableRemoteObject.narrow((Object)chosenContext.lookup(bindName), interfaceClass);
        }
        catch (NamingException e) {
            logger.info((Object)"No ClientClusterViewProvider is bound with the name {0} at the url {1}", new Object[]{bindName, serverRef.getProviderURL(), e});
            throw new POJOInvocationHandlerException("No ClientClusterViewProvider is bound with the name " + bindName + " at the url " + serverRef.getProviderURL(), e);
        }
        return new CMIReferenceableWrapper<Object>(cmiReference, object);
    }

    @Override
    protected void onExceptionHook(String objectName, CMIReferenceable<Object> cmiReferenceable) throws Throwable {
        this.setCurrentRef(null);
        this.onFailover = true;
        HACurrent.getHACurrent().setOnFailover(true);
    }

    @Override
    protected void onFinallyHook(String objectName, CMIReferenceable<Object> cmiReferenceable) {
    }
}

