/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.ee.metadata.ejbjar.impl;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.ow2.util.archive.api.ArchiveException;
import org.ow2.util.archive.api.IArchive;
import org.ow2.util.ee.deploy.api.deployable.EJBDeployable;
import org.ow2.util.ee.deploy.api.deployable.metadata.DeployableMetadataException;
import org.ow2.util.ee.metadata.common.impl.AbsDeployableMetadataFactory;
import org.ow2.util.ee.metadata.common.impl.xml.parsing.ParsingException;
import org.ow2.util.ee.metadata.ejbjar.api.IEjbJarDeployableMetadata;
import org.ow2.util.ee.metadata.ejbjar.api.IEjbJarDeployableMetadataFactory;
import org.ow2.util.ee.metadata.ejbjar.impl.EjbJarDeployableMetadata;
import org.ow2.util.ee.metadata.ejbjar.impl.configurator.EjbJarDeployableMetadataConfigurator;
import org.ow2.util.ee.metadata.ejbjar.impl.specific.ISpecificEjbJarDeployableFactory;
import org.ow2.util.ee.metadata.ejbjar.impl.struct.JApplicationException;
import org.ow2.util.ee.metadata.ejbjar.impl.xml.helper.EjbJarMetadataMerge;
import org.ow2.util.ee.metadata.ejbjar.impl.xml.parsing.EJB3DeploymentDesc;
import org.ow2.util.ee.metadata.ejbjar.impl.xml.struct.AssemblyDescriptor;
import org.ow2.util.ee.metadata.ejbjar.impl.xml.struct.EJB3;
import org.ow2.util.ee.metadata.ejbjar.impl.xml.struct.EnterpriseBeans;
import org.ow2.util.ee.metadata.ejbjar.impl.xml.struct.Interceptor;
import org.ow2.util.ee.metadata.ejbjar.impl.xml.struct.Interceptors;
import org.ow2.util.ee.metadata.ejbjar.impl.xml.struct.MessageDriven;
import org.ow2.util.ee.metadata.ejbjar.impl.xml.struct.Session;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.scan.api.IClassesLocator;
import org.ow2.util.scan.api.IScanner;
import org.ow2.util.scan.api.classlocator.ArchiveClassesLocator;
import org.ow2.util.scan.api.classlocator.ClassLoaderClassesLocator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EjbJarDeployableMetadataFactory<E extends EJBDeployable<E>>
extends AbsDeployableMetadataFactory
implements IEjbJarDeployableMetadataFactory<E> {
    private static final Log LOGGER = LogFactory.getLog(EjbJarDeployableMetadataFactory.class);

    public EjbJarDeployableMetadataFactory() {
    }

    public EjbJarDeployableMetadataFactory(IScanner scanner) {
        super(scanner);
    }

    public IEjbJarDeployableMetadata<E> createDeployableMetadata(E ejb3Deployable) throws DeployableMetadataException {
        return this.createDeployableMetadata(ejb3Deployable, null, null);
    }

    public IEjbJarDeployableMetadata<E> createDeployableMetadata(E deployable, ClassLoader classLoader) throws DeployableMetadataException {
        List<ClassLoaderClassesLocator> classesLocatorList = null;
        classesLocatorList = classLoader != null ? Arrays.asList(new ClassLoaderClassesLocator(classLoader)) : Arrays.asList(new ClassLoaderClassesLocator(ClassLoader.getSystemClassLoader()));
        return this.createDeployableMetadata(deployable, classesLocatorList, null);
    }

    private void completeClassList(EJB3 ejb3, Set<String> classNameSet) {
        if (ejb3 != null) {
            List<JApplicationException> applicationExceptionList;
            AssemblyDescriptor assemblyDescriptor;
            List<Interceptor> interceptorList;
            Interceptors interceptors;
            EnterpriseBeans enterpriseBeans = ejb3.getEnterpriseBeans();
            if (enterpriseBeans != null) {
                List<Session> sessionList = enterpriseBeans.getSessionList();
                for (Session session : sessionList) {
                    this.addClassToSetIfNotNull(session.getEjbClass(), classNameSet);
                }
                List<MessageDriven> messageDrivenList = enterpriseBeans.getMessageDrivenList();
                for (MessageDriven messageDriven : messageDrivenList) {
                    this.addClassToSetIfNotNull(messageDriven.getEjbClass(), classNameSet);
                }
            }
            if ((interceptors = ejb3.getInterceptors()) != null && (interceptorList = interceptors.getInterceptorList()) != null) {
                for (Interceptor interceptor : interceptorList) {
                    this.addClassToSetIfNotNull(interceptor.getInterceptorClass(), classNameSet);
                }
            }
            if ((assemblyDescriptor = ejb3.getAssemblyDescriptor()) != null && (applicationExceptionList = assemblyDescriptor.getApplicationExceptionList()) != null) {
                for (JApplicationException applicationException : applicationExceptionList) {
                    this.addClassToSetIfNotNull(applicationException.getClassName(), classNameSet);
                }
            }
        }
    }

    public IEjbJarDeployableMetadata<E> createDeployableMetadata(E ejb3Deployable, List<? extends IClassesLocator> ejbJarExternLibraries, List<? extends ISpecificEjbJarDeployableFactory<E>> specificDeployableFactoryList) throws DeployableMetadataException {
        EJB3 ejb3;
        long tAnalyzeStart = System.currentTimeMillis();
        IArchive archive = ejb3Deployable.getArchive();
        try {
            ejb3 = EJB3DeploymentDesc.getEjb3(archive);
        }
        catch (ParsingException e) {
            throw new DeployableMetadataException((Throwable)e);
        }
        EjbJarDeployableMetadataConfigurator<E> ejbJarArchiveMetadataConfigurator = new EjbJarDeployableMetadataConfigurator<E>(ejb3Deployable);
        HashSet<String> classNameSet = new HashSet<String>();
        if (specificDeployableFactoryList != null) {
            for (ISpecificEjbJarDeployableFactory<E> specificEjbJarDeployableFactory : specificDeployableFactoryList) {
                ejbJarArchiveMetadataConfigurator.addSpecificMetadataConfigurator(specificEjbJarDeployableFactory.beforeScan(ejb3Deployable, classNameSet));
            }
        }
        if (ejb3 != null && ejb3.isMetadataComplete()) {
            ejbJarArchiveMetadataConfigurator.setAnnotationParsingDesactived(true);
        } else {
            Iterator entryIterator;
            ejbJarArchiveMetadataConfigurator.setAnnotationParsingDesactived(false);
            try {
                entryIterator = archive.getEntries();
            }
            catch (ArchiveException e) {
                throw new DeployableMetadataException((Throwable)e);
            }
            while (entryIterator.hasNext()) {
                String entry = (String)entryIterator.next();
                if (!entry.endsWith(".class")) continue;
                classNameSet.add(entry.substring(0, entry.length() - ".class".length()));
            }
        }
        this.completeClassList(ejb3, classNameSet);
        this.scan(classNameSet, (IClassesLocator)new ArchiveClassesLocator(archive), ejbJarExternLibraries, ejbJarArchiveMetadataConfigurator);
        EjbJarDeployableMetadata<E> ejbJarArchiveMetadata = ejbJarArchiveMetadataConfigurator.getEjbJarArchiveMetadata();
        ejbJarArchiveMetadata.setEjb3(ejb3);
        EjbJarMetadataMerge.merge(ejbJarArchiveMetadata);
        if (specificDeployableFactoryList != null) {
            for (ISpecificEjbJarDeployableFactory<E> specificEjbJarDeployableFactory : specificDeployableFactoryList) {
                specificEjbJarDeployableFactory.afterScan();
            }
        }
        if (LOGGER.isDebugEnabled()) {
            long tAnalyzeStartEnd = System.currentTimeMillis();
            LOGGER.debug((Object)"Analyze of file {0} took {1} ms.", new Object[]{archive.getName(), tAnalyzeStartEnd - tAnalyzeStart});
        }
        return ejbJarArchiveMetadata;
    }

    public Class<IEjbJarDeployableMetadata<E>> getDeployableMetadataClass() {
        return IEjbJarDeployableMetadata.class;
    }
}

