/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.services.bootstrap;

import java.io.File;
import java.io.FilenameFilter;
import java.util.List;
import java.util.Set;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.ow2.jonas.configuration.ConfigurationManager;
import org.ow2.jonas.configuration.ServiceDeployer;
import org.ow2.jonas.lib.bootstrap.JProp;
import org.ow2.jonas.properties.ServerProperties;
import org.ow2.util.archive.api.IArchive;
import org.ow2.util.archive.impl.ArchiveManager;
import org.ow2.util.ee.deploy.api.deployable.IDeployable;
import org.ow2.util.ee.deploy.api.deployer.IDeployerManager;
import org.ow2.util.ee.deploy.impl.helper.DeployableHelper;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public class JOnASServiceDeployer
extends Thread
implements ServiceDeployer,
Pojo {
    private InstanceManager _cm;
    private boolean _FconfigurationManager;
    private ConfigurationManager configurationManager;
    private boolean _FdeployerManager;
    private IDeployerManager deployerManager;
    private boolean _FserverProperties;
    private ServerProperties serverProperties;
    private boolean _Flogger;
    private Log logger;
    private static final String JONAS_BOOTSTRAP = "jonas.bootstrap";
    private static final String JONAS_SERVICE = "jonas.service";
    private static final String DEPLOYMENT_CONFIG_DIR = JProp.getConfDir() + File.separator + "deployment";
    private boolean _M$initorg_apache_felix_ipojo_InstanceManager;
    private boolean _Minit;
    private boolean _Mrun;
    private boolean _MdeployServicejava_lang_String;
    private boolean _MundeployServicejava_lang_String;
    private boolean _MdeployPlanjava_io_File;
    private boolean _MundeployPlanjava_io_File;
    private boolean _MsetConfigurationManagerorg_ow2_jonas_configuration_ConfigurationManager;
    private boolean _MsetDeployerManagerorg_ow2_util_ee_deploy_api_deployer_IDeployerManager;
    private boolean _MsetServerPropertiesorg_ow2_jonas_properties_ServerProperties;

    private ConfigurationManager _getconfigurationManager() {
        if (!this._FconfigurationManager) {
            return this.configurationManager;
        }
        return (ConfigurationManager)this._cm.getterCallback("configurationManager");
    }

    private void _setconfigurationManager(ConfigurationManager configurationManager) {
        if (!this._FconfigurationManager) {
            this.configurationManager = configurationManager;
            return;
        }
        this._cm.setterCallback("configurationManager", (Object)configurationManager);
    }

    private IDeployerManager _getdeployerManager() {
        if (!this._FdeployerManager) {
            return this.deployerManager;
        }
        return (IDeployerManager)this._cm.getterCallback("deployerManager");
    }

    private void _setdeployerManager(IDeployerManager iDeployerManager) {
        if (!this._FdeployerManager) {
            this.deployerManager = iDeployerManager;
            return;
        }
        this._cm.setterCallback("deployerManager", (Object)iDeployerManager);
    }

    private ServerProperties _getserverProperties() {
        if (!this._FserverProperties) {
            return this.serverProperties;
        }
        return (ServerProperties)this._cm.getterCallback("serverProperties");
    }

    private void _setserverProperties(ServerProperties serverProperties) {
        if (!this._FserverProperties) {
            this.serverProperties = serverProperties;
            return;
        }
        this._cm.setterCallback("serverProperties", (Object)serverProperties);
    }

    private Log _getlogger() {
        if (!this._Flogger) {
            return this.logger;
        }
        return (Log)this._cm.getterCallback("logger");
    }

    private void _setlogger(Log log) {
        if (!this._Flogger) {
            this.logger = log;
            return;
        }
        this._cm.setterCallback("logger", (Object)log);
    }

    public JOnASServiceDeployer(InstanceManager _manager) {
        this._setComponentManager(_manager);
        if (this._M$initorg_apache_felix_ipojo_InstanceManager) {
            this._cm.entryCallback("$initorg_apache_felix_ipojo_InstanceManager");
        }
        this._setconfigurationManager(null);
        this._setdeployerManager(null);
        this._setserverProperties(null);
        this._setlogger(LogFactory.getLog(JOnASServiceDeployer.class));
        Object var3_2 = null;
        if (this._M$initorg_apache_felix_ipojo_InstanceManager) {
            this._cm.exitCallback("$initorg_apache_felix_ipojo_InstanceManager", var3_2);
        }
    }

    public void init() {
        if (this._Minit) {
            this._cm.entryCallback("init");
        }
        new Thread(this).start();
        Object var1_1 = null;
        if (this._Minit) {
            this._cm.exitCallback("init", var1_1);
        }
    }

    public void run() {
        boolean boostrapMode;
        if (this._Mrun) {
            this._cm.entryCallback("run");
        }
        if (!(boostrapMode = Boolean.getBoolean(JONAS_BOOTSTRAP))) {
            List services = this._getconfigurationManager().getOptionalServices();
            for (String service : services) {
                this.deployService(service);
            }
        }
        Object var5_5 = null;
        if (this._Mrun) {
            this._cm.exitCallback("run", var5_5);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void deployService(String string) {
        void serviceName;
        if (this._MdeployServicejava_lang_String) {
            this._cm.entryCallback("deployServicejava_lang_String");
        }
        this._getlogger().debug((Object)"Deploying the service ''{0}''", new Object[]{serviceName});
        String service = serviceName;
        File configDir = new File(DEPLOYMENT_CONFIG_DIR);
        try {
            final String baseName = (String)serviceName + "-base";
            File[] base = configDir.listFiles(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    return name.equalsIgnoreCase(baseName.concat(".xml"));
                }
            });
            if (base.length == 1) {
                this.deployService(baseName);
                String serviceClass = this._getserverProperties().getValue("jonas.service." + service + ".class");
                String implementationName = serviceClass.split("\\.")[4];
                service = service + "-" + implementationName;
            }
        }
        catch (Exception e) {
            this._getlogger().error((Object)e.getMessage(), new Object[0]);
        }
        File file = new File(DEPLOYMENT_CONFIG_DIR, service + ".xml");
        if (file.exists()) {
            this.deployPlan(file);
        } else {
            this._getlogger().error((Object)"Cannot deploy the service ''{0}'', file ''{1}'' not found", new Object[]{service, file});
        }
        Object var8_9 = null;
        if (this._MdeployServicejava_lang_String) {
            this._cm.exitCallback("deployServicejava_lang_String", var8_9);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void undeployService(String string) {
        void serviceName;
        if (this._MundeployServicejava_lang_String) {
            this._cm.entryCallback("undeployServicejava_lang_String");
        }
        this._getlogger().debug((Object)"Undeploying the service ''{0}''", new Object[]{serviceName});
        File file = new File(DEPLOYMENT_CONFIG_DIR, (String)serviceName + ".xml");
        if (file.exists()) {
            this.undeployPlan(file);
        } else {
            this._getlogger().error((Object)"Cannot undeploy the service ''{0}'', file ''{1}'' not found", new Object[]{serviceName, file});
        }
        Object var3_3 = null;
        if (this._MundeployServicejava_lang_String) {
            this._cm.exitCallback("undeployServicejava_lang_String", var3_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void deployPlan(File file) {
        void file2;
        if (this._MdeployPlanjava_io_File) {
            this._cm.entryCallback("deployPlanjava_io_File");
        }
        this._getlogger().debug((Object)"Deploying the deployment plan for ''{0}''", new Object[]{file2});
        IArchive archive = ArchiveManager.getInstance().getArchive((Object)file2);
        if (archive == null) {
            this._getlogger().warn((Object)"Ignoring invalid file ''{0}''", new Object[]{file2});
            Object var3_3 = null;
            if (this._MdeployPlanjava_io_File) {
                this._cm.exitCallback("deployPlanjava_io_File", var3_3);
            }
            return;
        }
        IDeployable deployable = null;
        try {
            deployable = DeployableHelper.getDeployable((IArchive)archive);
            this._getdeployerManager().deploy(deployable);
        }
        catch (Exception e) {
            this._getlogger().error((Object)"Cannot get a deployable for the archive ''{0}''", new Object[]{archive, e});
        }
        Object var6_6 = null;
        if (this._MdeployPlanjava_io_File) {
            this._cm.exitCallback("deployPlanjava_io_File", var6_6);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void undeployPlan(File file) {
        void file2;
        if (this._MundeployPlanjava_io_File) {
            this._cm.entryCallback("undeployPlanjava_io_File");
        }
        this._getlogger().debug((Object)"Undeploying the deployment plan for ''{0}''", new Object[]{file2});
        IArchive archive = ArchiveManager.getInstance().getArchive((Object)file2);
        if (archive == null) {
            this._getlogger().warn((Object)"Ignoring invalid file ''{0}''", new Object[]{file2});
            Object var3_3 = null;
            if (this._MundeployPlanjava_io_File) {
                this._cm.exitCallback("undeployPlanjava_io_File", var3_3);
            }
            return;
        }
        IDeployable deployable = null;
        try {
            deployable = DeployableHelper.getDeployable((IArchive)archive);
            this._getdeployerManager().undeploy(deployable);
        }
        catch (Exception e) {
            this._getlogger().error((Object)"Cannot undeploy the deployment plan for ''{0}''", new Object[]{file2, e});
        }
        Object var6_6 = null;
        if (this._MundeployPlanjava_io_File) {
            this._cm.exitCallback("undeployPlanjava_io_File", var6_6);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setConfigurationManager(ConfigurationManager configurationManager) {
        void configurationManager2;
        if (this._MsetConfigurationManagerorg_ow2_jonas_configuration_ConfigurationManager) {
            this._cm.entryCallback("setConfigurationManagerorg_ow2_jonas_configuration_ConfigurationManager");
        }
        this._setconfigurationManager((ConfigurationManager)configurationManager2);
        Object var2_2 = null;
        if (this._MsetConfigurationManagerorg_ow2_jonas_configuration_ConfigurationManager) {
            this._cm.exitCallback("setConfigurationManagerorg_ow2_jonas_configuration_ConfigurationManager", var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setDeployerManager(IDeployerManager iDeployerManager) {
        void deployerManager;
        if (this._MsetDeployerManagerorg_ow2_util_ee_deploy_api_deployer_IDeployerManager) {
            this._cm.entryCallback("setDeployerManagerorg_ow2_util_ee_deploy_api_deployer_IDeployerManager");
        }
        this._setdeployerManager((IDeployerManager)deployerManager);
        Object var2_2 = null;
        if (this._MsetDeployerManagerorg_ow2_util_ee_deploy_api_deployer_IDeployerManager) {
            this._cm.exitCallback("setDeployerManagerorg_ow2_util_ee_deploy_api_deployer_IDeployerManager", var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setServerProperties(ServerProperties serverProperties) {
        void serverProperties2;
        if (this._MsetServerPropertiesorg_ow2_jonas_properties_ServerProperties) {
            this._cm.entryCallback("setServerPropertiesorg_ow2_jonas_properties_ServerProperties");
        }
        this._setserverProperties((ServerProperties)serverProperties2);
        Object var2_2 = null;
        if (this._MsetServerPropertiesorg_ow2_jonas_properties_ServerProperties) {
            this._cm.exitCallback("setServerPropertiesorg_ow2_jonas_properties_ServerProperties", var2_2);
        }
    }

    private void _setComponentManager(InstanceManager instanceManager) {
        this._cm = instanceManager;
        Set set = this._cm.getRegistredFields();
        if (set != null) {
            if (set.contains("serverProperties")) {
                this._FserverProperties = true;
            }
            if (set.contains("deployerManager")) {
                this._FdeployerManager = true;
            }
            if (set.contains("JONAS_SERVICE")) {
                this._FJONAS_SERVICE = true;
            }
            if (set.contains("JONAS_BOOTSTRAP")) {
                this._FJONAS_BOOTSTRAP = true;
            }
            if (set.contains("DEPLOYMENT_CONFIG_DIR")) {
                this._FDEPLOYMENT_CONFIG_DIR = true;
            }
            if (set.contains("logger")) {
                this._Flogger = true;
            }
            if (set.contains("configurationManager")) {
                this._FconfigurationManager = true;
            }
        }
        if ((set = this._cm.getRegistredMethods()) != null) {
            if (set.contains("$initorg_apache_felix_ipojo_InstanceManager")) {
                this._M$initorg_apache_felix_ipojo_InstanceManager = true;
            }
            if (set.contains("init")) {
                this._Minit = true;
            }
            if (set.contains("run")) {
                this._Mrun = true;
            }
            if (set.contains("deployServicejava_lang_String")) {
                this._MdeployServicejava_lang_String = true;
            }
            if (set.contains("undeployServicejava_lang_String")) {
                this._MundeployServicejava_lang_String = true;
            }
            if (set.contains("deployPlanjava_io_File")) {
                this._MdeployPlanjava_io_File = true;
            }
            if (set.contains("undeployPlanjava_io_File")) {
                this._MundeployPlanjava_io_File = true;
            }
            if (set.contains("setConfigurationManagerorg_ow2_jonas_configuration_ConfigurationManager")) {
                this._MsetConfigurationManagerorg_ow2_jonas_configuration_ConfigurationManager = true;
            }
            if (set.contains("setDeployerManagerorg_ow2_util_ee_deploy_api_deployer_IDeployerManager")) {
                this._MsetDeployerManagerorg_ow2_util_ee_deploy_api_deployer_IDeployerManager = true;
            }
            if (set.contains("setServerPropertiesorg_ow2_jonas_properties_ServerProperties")) {
                this._MsetServerPropertiesorg_ow2_jonas_properties_ServerProperties = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this._cm;
    }
}

