/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.services.bootstrap.repository;

import java.io.File;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.ow2.jonas.lib.bootstrap.JProp;
import org.ow2.jonas.lib.util.JonasObjectName;
import org.ow2.jonas.properties.ServerProperties;
import org.ow2.jonas.services.bootstrap.repository.JOnASRepositoriesMBean;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.plan.bindings.exceptions.InvalidRepositoryException;
import org.ow2.util.plan.bindings.repository.ExtendedRepository;
import org.ow2.util.plan.bindings.repository.Repositories;
import org.ow2.util.plan.bindings.repository.Repository;
import org.ow2.util.plan.bindings.repository.RepositoryKind;
import org.ow2.util.plan.deployer.api.IRepositoryDeployer;
import org.ow2.util.plan.reader.repository.IRepositoryDataReader;
import org.ow2.util.plan.repository.api.IRepositoryManager;
import org.ow2.util.plan.repository.api.RepositoryIdCollisionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JOnASRepositories
implements JOnASRepositoriesMBean,
Pojo {
    private InstanceManager _cm;
    private boolean _Flogger;
    private Log logger;
    private boolean _FserverProperties;
    private ServerProperties serverProperties;
    private boolean _FrepositoryManager;
    private IRepositoryManager repositoryManager;
    private boolean _FconfigurationAdmin;
    private ConfigurationAdmin configurationAdmin;
    private boolean _FmbeanServer;
    private MBeanServer mbeanServer;
    private boolean _FrepositoryDeployer;
    private IRepositoryDeployer repositoryDeployer;
    private boolean _FrepositoryReader;
    private IRepositoryDataReader repositoryReader;
    private static final String PROP_M2_LOCAL_REPOSITORY = "m2.repository";
    private static final String PATH_DEFAULT_REPOSITORY = ".m2/repository";
    private static final String CONFIG_FILE = "initial-repositories.xml";
    private boolean _M$initorg_apache_felix_ipojo_InstanceManager;
    private boolean _Mstart;
    private boolean _Mstop;
    private boolean _MgetRepositoryDeployablesCount;
    private boolean _MgetRepositoriesDescriptions;
    private boolean _MgetRepositoriesNumber;
    private boolean _MsetServerPropertiesorg_ow2_jonas_properties_ServerProperties;
    private boolean _MsetRepositoryManagerorg_ow2_util_plan_repository_api_IRepositoryManager;
    private boolean _MsetRepositoryDeployerorg_ow2_util_plan_deployer_api_IRepositoryDeployer;
    private boolean _MsetMBeanServerjavax_management_MBeanServer;
    private boolean _MsetRepositoryReaderorg_ow2_util_plan_reader_repository_IRepositoryDataReader;
    private boolean _MsetConfigurationAdminorg_osgi_service_cm_ConfigurationAdmin;
    private boolean _MaddLocalRepository;
    private boolean _MgetRepositoriesBundlesLocation;
    private boolean _MgetMaven2RepositoryLocation;

    private Log _getlogger() {
        if (!this._Flogger) {
            return this.logger;
        }
        return (Log)this._cm.getterCallback("logger");
    }

    private void _setlogger(Log log) {
        if (!this._Flogger) {
            this.logger = log;
            return;
        }
        this._cm.setterCallback("logger", (Object)log);
    }

    private ServerProperties _getserverProperties() {
        if (!this._FserverProperties) {
            return this.serverProperties;
        }
        return (ServerProperties)this._cm.getterCallback("serverProperties");
    }

    private void _setserverProperties(ServerProperties serverProperties) {
        if (!this._FserverProperties) {
            this.serverProperties = serverProperties;
            return;
        }
        this._cm.setterCallback("serverProperties", (Object)serverProperties);
    }

    private IRepositoryManager _getrepositoryManager() {
        if (!this._FrepositoryManager) {
            return this.repositoryManager;
        }
        return (IRepositoryManager)this._cm.getterCallback("repositoryManager");
    }

    private void _setrepositoryManager(IRepositoryManager iRepositoryManager) {
        if (!this._FrepositoryManager) {
            this.repositoryManager = iRepositoryManager;
            return;
        }
        this._cm.setterCallback("repositoryManager", (Object)iRepositoryManager);
    }

    private ConfigurationAdmin _getconfigurationAdmin() {
        if (!this._FconfigurationAdmin) {
            return this.configurationAdmin;
        }
        return (ConfigurationAdmin)this._cm.getterCallback("configurationAdmin");
    }

    private void _setconfigurationAdmin(ConfigurationAdmin configurationAdmin) {
        if (!this._FconfigurationAdmin) {
            this.configurationAdmin = configurationAdmin;
            return;
        }
        this._cm.setterCallback("configurationAdmin", (Object)configurationAdmin);
    }

    private MBeanServer _getmbeanServer() {
        if (!this._FmbeanServer) {
            return this.mbeanServer;
        }
        return (MBeanServer)this._cm.getterCallback("mbeanServer");
    }

    private void _setmbeanServer(MBeanServer mBeanServer) {
        if (!this._FmbeanServer) {
            this.mbeanServer = mBeanServer;
            return;
        }
        this._cm.setterCallback("mbeanServer", (Object)mBeanServer);
    }

    private IRepositoryDeployer _getrepositoryDeployer() {
        if (!this._FrepositoryDeployer) {
            return this.repositoryDeployer;
        }
        return (IRepositoryDeployer)this._cm.getterCallback("repositoryDeployer");
    }

    private void _setrepositoryDeployer(IRepositoryDeployer iRepositoryDeployer) {
        if (!this._FrepositoryDeployer) {
            this.repositoryDeployer = iRepositoryDeployer;
            return;
        }
        this._cm.setterCallback("repositoryDeployer", (Object)iRepositoryDeployer);
    }

    private IRepositoryDataReader _getrepositoryReader() {
        if (!this._FrepositoryReader) {
            return this.repositoryReader;
        }
        return (IRepositoryDataReader)this._cm.getterCallback("repositoryReader");
    }

    private void _setrepositoryReader(IRepositoryDataReader iRepositoryDataReader) {
        if (!this._FrepositoryReader) {
            this.repositoryReader = iRepositoryDataReader;
            return;
        }
        this._cm.setterCallback("repositoryReader", (Object)iRepositoryDataReader);
    }

    public JOnASRepositories(InstanceManager _manager) {
        this._setComponentManager(_manager);
        if (this._M$initorg_apache_felix_ipojo_InstanceManager) {
            this._cm.entryCallback("$initorg_apache_felix_ipojo_InstanceManager");
        }
        this._setlogger(LogFactory.getLog(JOnASRepositories.class));
        this._setserverProperties(null);
        this._setrepositoryManager(null);
        this._setconfigurationAdmin(null);
        this._setmbeanServer(null);
        this._setrepositoryReader(null);
        Object var3_2 = null;
        if (this._M$initorg_apache_felix_ipojo_InstanceManager) {
            this._cm.exitCallback("$initorg_apache_felix_ipojo_InstanceManager", var3_2);
        }
    }

    public void start() throws Exception {
        Configuration configuration;
        if (this._Mstart) {
            this._cm.entryCallback("start");
        }
        if ((configuration = this._getconfigurationAdmin().getConfiguration("org.ow2.util.plan.fetcher", null)) != null) {
            Hashtable<String, String> props = new Hashtable<String, String>();
            ((Dictionary)props).put("local.repositories.base.dir", "repositories");
            configuration.update(props);
        }
        this.addLocalRepository();
        Repositories initialRepositories = null;
        File configFile = new File(JProp.getConfDir(), CONFIG_FILE);
        if (configFile.exists()) {
            try {
                initialRepositories = this._getrepositoryReader().readRepositories(configFile);
            }
            catch (Exception e) {
                this._getlogger().error((Object)"Exception while parsing the initial repositories file : {0}", new Object[]{e});
            }
        }
        if (initialRepositories != null) {
            int repositoryCount = 0;
            for (Repository repository : initialRepositories.getRepositories()) {
                try {
                    this._getrepositoryManager().addRepository(repository);
                    ++repositoryCount;
                }
                catch (RepositoryIdCollisionException e) {
                    this._getlogger().warn((Object)"Multiple repository with same id; id={0}", new Object[]{repository.getId()});
                }
                catch (InvalidRepositoryException e) {
                    this._getlogger().warn((Object)"Invalid repository with id {0}", new Object[]{repository.getId()});
                }
            }
            this._getlogger().debug((Object)"JOnAS started with {0} repositories.", new Object[]{repositoryCount});
        } else {
            this._getlogger().debug((Object)"JOnAS started with no repositories", new Object[0]);
        }
        try {
            ObjectName objectName = JonasObjectName.repository((String)this._getserverProperties().getDomainName());
            this._getmbeanServer().registerMBean(this, objectName);
        }
        catch (Exception e) {
            this._getlogger().error((Object)"MBean registration error, {0}", new Object[]{e});
        }
        Object var8_13 = null;
        if (this._Mstart) {
            this._cm.exitCallback("start", var8_13);
        }
    }

    public void stop() throws Exception {
        if (this._Mstop) {
            this._cm.entryCallback("stop");
        }
        if (this._getmbeanServer() != null) {
            try {
                ObjectName objectName = JonasObjectName.repository((String)this._getserverProperties().getDomainName());
                this._getmbeanServer().unregisterMBean(objectName);
            }
            catch (Exception e) {
                this._getlogger().error((Object)"MBean unregistration error, {0}", new Object[]{e});
            }
        }
        Object var2_3 = null;
        if (this._Mstop) {
            this._cm.exitCallback("stop", var2_3);
        }
    }

    @Override
    public Integer getRepositoryDeployablesCount() {
        if (this._MgetRepositoryDeployablesCount) {
            this._cm.entryCallback("getRepositoryDeployablesCount");
        }
        Integer n = this._getrepositoryDeployer().getDeployablesCount();
        if (this._MgetRepositoryDeployablesCount) {
            this._cm.exitCallback("getRepositoryDeployablesCount", (Object)n);
        }
        return n;
    }

    @Override
    public List<String> getRepositoriesDescriptions() {
        if (this._MgetRepositoriesDescriptions) {
            this._cm.entryCallback("getRepositoriesDescriptions");
        }
        ArrayList<String> repositoriesDescriptions = new ArrayList<String>();
        for (Repository repository : this._getrepositoryManager()) {
            repositoriesDescriptions.add(repository.toString());
        }
        ArrayList<String> arrayList = repositoriesDescriptions;
        if (this._MgetRepositoriesDescriptions) {
            this._cm.exitCallback("getRepositoriesDescriptions", arrayList);
        }
        return arrayList;
    }

    @Override
    public Integer getRepositoriesNumber() {
        if (this._MgetRepositoriesNumber) {
            this._cm.entryCallback("getRepositoriesNumber");
        }
        Integer n = this._getrepositoryManager().getRepositoryCount();
        if (this._MgetRepositoriesNumber) {
            this._cm.exitCallback("getRepositoriesNumber", (Object)n);
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    public void setServerProperties(ServerProperties serverProperties) {
        void serverProperties2;
        if (this._MsetServerPropertiesorg_ow2_jonas_properties_ServerProperties) {
            this._cm.entryCallback("setServerPropertiesorg_ow2_jonas_properties_ServerProperties");
        }
        this._setserverProperties((ServerProperties)serverProperties2);
        Object var2_2 = null;
        if (this._MsetServerPropertiesorg_ow2_jonas_properties_ServerProperties) {
            this._cm.exitCallback("setServerPropertiesorg_ow2_jonas_properties_ServerProperties", var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setRepositoryManager(IRepositoryManager iRepositoryManager) {
        void repositoryManager;
        if (this._MsetRepositoryManagerorg_ow2_util_plan_repository_api_IRepositoryManager) {
            this._cm.entryCallback("setRepositoryManagerorg_ow2_util_plan_repository_api_IRepositoryManager");
        }
        this._setrepositoryManager((IRepositoryManager)repositoryManager);
        Object var2_2 = null;
        if (this._MsetRepositoryManagerorg_ow2_util_plan_repository_api_IRepositoryManager) {
            this._cm.exitCallback("setRepositoryManagerorg_ow2_util_plan_repository_api_IRepositoryManager", var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setRepositoryDeployer(IRepositoryDeployer iRepositoryDeployer) {
        void repositoryDeployer;
        if (this._MsetRepositoryDeployerorg_ow2_util_plan_deployer_api_IRepositoryDeployer) {
            this._cm.entryCallback("setRepositoryDeployerorg_ow2_util_plan_deployer_api_IRepositoryDeployer");
        }
        this._setrepositoryDeployer((IRepositoryDeployer)repositoryDeployer);
        Object var2_2 = null;
        if (this._MsetRepositoryDeployerorg_ow2_util_plan_deployer_api_IRepositoryDeployer) {
            this._cm.exitCallback("setRepositoryDeployerorg_ow2_util_plan_deployer_api_IRepositoryDeployer", var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setMBeanServer(MBeanServer mBeanServer) {
        void mbeanServer;
        if (this._MsetMBeanServerjavax_management_MBeanServer) {
            this._cm.entryCallback("setMBeanServerjavax_management_MBeanServer");
        }
        this._setmbeanServer((MBeanServer)mbeanServer);
        Object var2_2 = null;
        if (this._MsetMBeanServerjavax_management_MBeanServer) {
            this._cm.exitCallback("setMBeanServerjavax_management_MBeanServer", var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setRepositoryReader(IRepositoryDataReader iRepositoryDataReader) {
        void repositoryReader;
        if (this._MsetRepositoryReaderorg_ow2_util_plan_reader_repository_IRepositoryDataReader) {
            this._cm.entryCallback("setRepositoryReaderorg_ow2_util_plan_reader_repository_IRepositoryDataReader");
        }
        this._setrepositoryReader((IRepositoryDataReader)repositoryReader);
        Object var2_2 = null;
        if (this._MsetRepositoryReaderorg_ow2_util_plan_reader_repository_IRepositoryDataReader) {
            this._cm.exitCallback("setRepositoryReaderorg_ow2_util_plan_reader_repository_IRepositoryDataReader", var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setConfigurationAdmin(ConfigurationAdmin configurationAdmin) {
        void configurationAdmin2;
        if (this._MsetConfigurationAdminorg_osgi_service_cm_ConfigurationAdmin) {
            this._cm.entryCallback("setConfigurationAdminorg_osgi_service_cm_ConfigurationAdmin");
        }
        this._setconfigurationAdmin((ConfigurationAdmin)configurationAdmin2);
        Object var2_2 = null;
        if (this._MsetConfigurationAdminorg_osgi_service_cm_ConfigurationAdmin) {
            this._cm.exitCallback("setConfigurationAdminorg_osgi_service_cm_ConfigurationAdmin", var2_2);
        }
    }

    private void addLocalRepository() {
        if (this._MaddLocalRepository) {
            this._cm.entryCallback("addLocalRepository");
        }
        boolean developer = Boolean.getBoolean("jonas.developer");
        ExtendedRepository repository = new ExtendedRepository();
        repository.setType(RepositoryKind.MAVEN_2);
        String location = null;
        if (developer) {
            repository.setId("Maven2 local repository");
            location = this.getMaven2RepositoryLocation();
        } else {
            repository.setId("JOnAS bundles repository");
            location = this.getRepositoriesBundlesLocation();
        }
        repository.setUrl("file://" + location);
        try {
            this._getrepositoryManager().addRepository((Repository)repository);
        }
        catch (RepositoryIdCollisionException e) {
            this._getlogger().error((Object)"Cannot add repository {0}, it already exists", new Object[]{repository});
        }
        catch (InvalidRepositoryException e) {
            this._getlogger().error((Object)"Invalid repository {0}", new Object[]{repository});
        }
        Object var5_6 = null;
        if (this._MaddLocalRepository) {
            this._cm.exitCallback("addLocalRepository", var5_6);
        }
    }

    private String getRepositoriesBundlesLocation() {
        if (this._MgetRepositoriesBundlesLocation) {
            this._cm.entryCallback("getRepositoriesBundlesLocation");
        }
        String string = JProp.getJonasRoot() + File.separator + "repositories" + File.separator + "bundles";
        if (this._MgetRepositoriesBundlesLocation) {
            this._cm.exitCallback("getRepositoriesBundlesLocation", (Object)string);
        }
        return string;
    }

    private String getMaven2RepositoryLocation() {
        String m2Repository;
        if (this._MgetMaven2RepositoryLocation) {
            this._cm.entryCallback("getMaven2RepositoryLocation");
        }
        if ((m2Repository = System.getProperty(PROP_M2_LOCAL_REPOSITORY)) == null) {
            String userHome = System.getProperty("user.home");
            m2Repository = userHome + File.separator + PATH_DEFAULT_REPOSITORY;
        }
        String string = m2Repository;
        if (this._MgetMaven2RepositoryLocation) {
            this._cm.exitCallback("getMaven2RepositoryLocation", (Object)string);
        }
        return string;
    }

    private void _setComponentManager(InstanceManager instanceManager) {
        this._cm = instanceManager;
        Set set = this._cm.getRegistredFields();
        if (set != null) {
            if (set.contains("CONFIG_FILE")) {
                this._FCONFIG_FILE = true;
            }
            if (set.contains("repositoryReader")) {
                this._FrepositoryReader = true;
            }
            if (set.contains("serverProperties")) {
                this._FserverProperties = true;
            }
            if (set.contains("mbeanServer")) {
                this._FmbeanServer = true;
            }
            if (set.contains("configurationAdmin")) {
                this._FconfigurationAdmin = true;
            }
            if (set.contains("PATH_DEFAULT_REPOSITORY")) {
                this._FPATH_DEFAULT_REPOSITORY = true;
            }
            if (set.contains("PROP_M2_LOCAL_REPOSITORY")) {
                this._FPROP_M2_LOCAL_REPOSITORY = true;
            }
            if (set.contains("repositoryDeployer")) {
                this._FrepositoryDeployer = true;
            }
            if (set.contains("repositoryManager")) {
                this._FrepositoryManager = true;
            }
            if (set.contains("logger")) {
                this._Flogger = true;
            }
        }
        if ((set = this._cm.getRegistredMethods()) != null) {
            if (set.contains("$initorg_apache_felix_ipojo_InstanceManager")) {
                this._M$initorg_apache_felix_ipojo_InstanceManager = true;
            }
            if (set.contains("start")) {
                this._Mstart = true;
            }
            if (set.contains("stop")) {
                this._Mstop = true;
            }
            if (set.contains("getRepositoryDeployablesCount")) {
                this._MgetRepositoryDeployablesCount = true;
            }
            if (set.contains("getRepositoriesDescriptions")) {
                this._MgetRepositoriesDescriptions = true;
            }
            if (set.contains("getRepositoriesNumber")) {
                this._MgetRepositoriesNumber = true;
            }
            if (set.contains("setServerPropertiesorg_ow2_jonas_properties_ServerProperties")) {
                this._MsetServerPropertiesorg_ow2_jonas_properties_ServerProperties = true;
            }
            if (set.contains("setRepositoryManagerorg_ow2_util_plan_repository_api_IRepositoryManager")) {
                this._MsetRepositoryManagerorg_ow2_util_plan_repository_api_IRepositoryManager = true;
            }
            if (set.contains("setRepositoryDeployerorg_ow2_util_plan_deployer_api_IRepositoryDeployer")) {
                this._MsetRepositoryDeployerorg_ow2_util_plan_deployer_api_IRepositoryDeployer = true;
            }
            if (set.contains("setMBeanServerjavax_management_MBeanServer")) {
                this._MsetMBeanServerjavax_management_MBeanServer = true;
            }
            if (set.contains("setRepositoryReaderorg_ow2_util_plan_reader_repository_IRepositoryDataReader")) {
                this._MsetRepositoryReaderorg_ow2_util_plan_reader_repository_IRepositoryDataReader = true;
            }
            if (set.contains("setConfigurationAdminorg_osgi_service_cm_ConfigurationAdmin")) {
                this._MsetConfigurationAdminorg_osgi_service_cm_ConfigurationAdmin = true;
            }
            if (set.contains("addLocalRepository")) {
                this._MaddLocalRepository = true;
            }
            if (set.contains("getRepositoriesBundlesLocation")) {
                this._MgetRepositoriesBundlesLocation = true;
            }
            if (set.contains("getMaven2RepositoryLocation")) {
                this._MgetMaven2RepositoryLocation = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this._cm;
    }
}

