/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.carol.util.configuration;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ow2.carol.jndi.ns.NameServiceException;
import org.ow2.carol.jndi.ns.NameServiceManager;
import org.ow2.carol.util.configuration.ConfigurationException;
import org.ow2.carol.util.configuration.Protocol;
import org.ow2.carol.util.configuration.ProtocolConfiguration;
import org.ow2.carol.util.configuration.ProtocolConfigurationImpl;
import org.ow2.carol.util.configuration.ProtocolConfigurationImplMBean;
import org.ow2.carol.util.configuration.ServerConfiguration;
import org.ow2.carol.util.configuration.ServerConfigurationImpl;
import org.ow2.carol.util.configuration.ServerConfigurationImplMBean;
import org.ow2.carol.util.configuration.TraceCarol;
import org.ow2.carol.util.mbean.MBeanUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ConfigurationRepository {
    private static Log logger = LogFactory.getLog(ConfigurationRepository.class);
    private static Properties defaultProperties = null;
    private static ServerConfiguration serverConfiguration = null;
    private static Map<String, Protocol> managedProtocols = null;
    private static Map<String, ProtocolConfiguration> managedConfigurations = null;
    private static InheritableThreadLocal<ProtocolConfiguration> currentConfiguration = null;
    private static ProtocolConfiguration defaultConfiguration = null;
    private static Properties properties = null;
    private static boolean initDone = false;

    private ConfigurationRepository() {
    }

    protected static synchronized void checkInitialized() {
        if (!initDone) {
            try {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Do the configuration as the configuration was not yet done!");
                }
                ConfigurationRepository.init();
            }
            catch (ConfigurationException ce) {
                IllegalStateException ise = new IllegalStateException("Configuration of carol was not done and when trying to initialize it, it fails.");
                ise.initCause(ce);
                throw ise;
            }
        }
    }

    protected static void checkConfigured() {
        ConfigurationRepository.checkInitialized();
        if (managedConfigurations == null) {
            throw new IllegalStateException("Cannot find a configuration, carol was not configured");
        }
    }

    public static ProtocolConfiguration[] getConfigurations() {
        ConfigurationRepository.checkConfigured();
        ProtocolConfiguration[] configs = new ProtocolConfiguration[managedConfigurations.size()];
        return managedConfigurations.values().toArray(configs);
    }

    public static ProtocolConfiguration getConfiguration(String configName) {
        ConfigurationRepository.checkConfigured();
        return managedConfigurations.get(configName);
    }

    public static Protocol getProtocol(String protocolName) {
        ConfigurationRepository.checkConfigured();
        return managedProtocols.get(protocolName);
    }

    public static ProtocolConfiguration newConfiguration(String configurationName, String protocolName) throws ConfigurationException {
        ConfigurationRepository.checkConfigured();
        Protocol p = null;
        if (managedConfigurations.get(configurationName) != null) {
            throw new ConfigurationException("There is an existing configuration with the name '" + configurationName + "'. Use another name.");
        }
        if (managedProtocols != null) {
            p = managedProtocols.get(protocolName);
        }
        if (p == null) {
            throw new ConfigurationException("Protocol '" + protocolName + "' doesn't exists in carol. Cannot build");
        }
        return new ProtocolConfigurationImpl(configurationName, p, new Properties(), serverConfiguration);
    }

    public static ProtocolConfiguration setCurrentConfiguration(ProtocolConfiguration config) {
        ConfigurationRepository.checkConfigured();
        ProtocolConfiguration old = ConfigurationRepository.getCurrentConfiguration();
        currentConfiguration.set(config);
        return old;
    }

    public static ProtocolConfiguration getCurrentConfiguration() {
        ConfigurationRepository.checkConfigured();
        ProtocolConfiguration protocolConfiguration = (ProtocolConfiguration)currentConfiguration.get();
        if (protocolConfiguration != null) {
            return protocolConfiguration;
        }
        return defaultConfiguration;
    }

    public static void init(URL carolPropertiesFileURL) throws ConfigurationException {
        ConfigurationRepository.init(carolPropertiesFileURL, null, null);
    }

    public static void init(String domainName, String serverName) throws ConfigurationException {
        ConfigurationRepository.init(domainName, serverName, null);
    }

    public static void init(String domainName, String serverName, String agentId) throws ConfigurationException {
        ConfigurationRepository.init(Thread.currentThread().getContextClassLoader().getResource("carol.properties"), domainName, serverName, agentId);
    }

    public static void init(URL carolPropertiesFileURL, String domainName, String serverName) throws ConfigurationException {
        ConfigurationRepository.init(carolPropertiesFileURL, domainName, serverName, null);
    }

    public static void init(URL carolPropertiesFileURL, String domainName, String serverName, String agentId) throws ConfigurationException {
        if (initDone) {
            return;
        }
        TraceCarol.configure();
        Properties carolProperties = ConfigurationRepository.getPropertiesFromURL(carolPropertiesFileURL);
        ConfigurationRepository.init(carolProperties, domainName, serverName, agentId);
    }

    public static void init(Properties carolProperties, String domainName, String serverName) throws ConfigurationException {
        ConfigurationRepository.init(carolProperties, domainName, serverName, null);
    }

    public static void init(Properties carolProperties, String domainName, String serverName, String agentId) throws ConfigurationException {
        String[] protocolsArray;
        if (initDone) {
            return;
        }
        TraceCarol.configure();
        Properties carolDefaultProperties = ConfigurationRepository.getDefaultProperties();
        properties = ConfigurationRepository.mergeProperties(carolDefaultProperties, carolProperties);
        serverConfiguration = new ServerConfigurationImpl(properties, domainName, serverName, agentId);
        managedProtocols = new LinkedHashMap<String, Protocol>();
        managedConfigurations = new LinkedHashMap<String, ProtocolConfiguration>();
        currentConfiguration = new InheritableThreadLocal();
        int propertyBeginLength = "carol".length();
        int propertyEndLength = "context.factory".length();
        Enumeration<?> e = properties.propertyNames();
        while (e.hasMoreElements()) {
            Protocol protocol;
            String key = (String)e.nextElement();
            if (!key.startsWith("carol") || !key.endsWith("context.factory")) continue;
            String protocolName = key.substring(propertyBeginLength + 1, key.length() - propertyEndLength - 1);
            String prefixProtocol = "carol." + protocolName + ".";
            String protocolClassName = properties.getProperty(prefixProtocol + "protocol.class");
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Build protocol object for protocol name found '" + protocolName + "'."));
            }
            if (protocolClassName != null) {
                try {
                    Class<?> protocolClass = Class.forName(protocolClassName);
                    Constructor<?> constructor = protocolClass.getConstructor(String.class, Properties.class, Log.class, String.class, String.class);
                    protocol = (Protocol)constructor.newInstance(protocolName, properties, logger, domainName, serverName);
                }
                catch (Exception e1) {
                    TraceCarol.error("Cannot build the protocol " + protocolName + "for class " + protocolClassName, e1);
                    throw new ConfigurationException("Cannot build the protocol " + protocolName + "for class " + protocolClassName, e1);
                }
            } else {
                protocol = new Protocol(protocolName, properties, logger, domainName, serverName);
            }
            managedProtocols.put(protocolName, protocol);
        }
        String protocols = properties.getProperty("carol.protocols");
        String defaultProtocol = properties.getProperty("carol.protocols.default");
        if (defaultProtocol == null || defaultProtocol.equals("")) {
            throw new ConfigurationException("No default protocol defined with property 'carol.protocols.default', check your carol configuration.");
        }
        if (protocols == null || protocols.equals("")) {
            logger.info((Object)("No protocols were defined for property 'carol.protocols', trying with default protocol = '" + defaultProtocol + "'."));
            protocols = defaultProtocol;
        }
        for (String protocolName : protocolsArray = protocols.split(",")) {
            Protocol protocol = managedProtocols.get(protocolName);
            if (protocol == null) {
                throw new ConfigurationException("Cannot find a protocol with name '" + protocolName + "' in the list of available protocols.");
            }
            ProtocolConfigurationImpl protoConfig = new ProtocolConfigurationImpl(protocolName, protocol, properties, serverConfiguration);
            managedConfigurations.put(protocolName, protoConfig);
        }
        if (!Arrays.asList(protocolsArray).contains(defaultProtocol)) {
            if (protocolsArray.length != 1) {
                logger.info((Object)("The given defaut protocol is not enabled, so the first declared protocol, ie " + protocolsArray[0] + ", will be used as default."));
            }
            defaultProtocol = protocolsArray[0];
        }
        defaultConfiguration = managedConfigurations.get(defaultProtocol);
        if (domainName != null && serverName != null) {
            ConfigurationRepository.initMbeans(domainName, serverName, agentId);
        }
        initDone = true;
        if (serverConfiguration.isStartingNS()) {
            try {
                NameServiceManager.getNameServiceManager().startNS();
            }
            catch (NameServiceException e2) {
                TraceCarol.error("A name service was already started.", e2);
            }
        }
        ConfigurationRepository.initCMIOnStartUP();
    }

    private static void initCMIOnStartUP() throws ConfigurationException {
        String cmiConfig = System.getProperty("cmi.conf.url");
        try {
            if (cmiConfig != null) {
                logger.debug((Object)"Carol start CMI");
                URL cmiConfigUrl = new File(cmiConfig).toURL();
                Properties cmiProperties = new Properties();
                cmiProperties.load(cmiConfigUrl.openStream());
                ConfigurationRepository.configureProtocols(cmiProperties);
                serverConfiguration.enableCMI(cmiProperties);
            } else {
                logger.debug((Object)"Carol don't start CMI");
            }
        }
        catch (Exception e) {
            throw new ConfigurationException("Unable to enable CMI for Carol");
        }
    }

    public static void configureProtocols(Properties cmiProperties) throws ConfigurationException {
        ProtocolConfiguration[] protocols;
        int propertyBeginLength = "cmi".length();
        int propertyEndLength = "enable".length();
        ArrayList<String> toEnable = new ArrayList<String>();
        for (ProtocolConfiguration protocol : protocols = ConfigurationRepository.getConfigurations()) {
            toEnable.add(protocol.getName());
            String key1 = "cmi." + protocol.getName() + "." + "enable";
            properties.setProperty(key1, "true");
        }
        Enumeration<?> e = cmiProperties.propertyNames();
        while (e.hasMoreElements()) {
            boolean enableCmi;
            String key = (String)e.nextElement();
            String protocolName = key.substring(propertyBeginLength + 1, key.length() - propertyEndLength - 1);
            if (!key.startsWith("cmi") || !key.endsWith("enable") || (enableCmi = cmiProperties.get(key).toString().equalsIgnoreCase("true"))) continue;
            toEnable.remove(protocolName);
            String key2 = "cmi." + protocolName + "." + "enable";
            properties.setProperty(key2, "false");
        }
        for (String protocolName : toEnable) {
            ProtocolConfiguration protocolConfiguration = ConfigurationRepository.getConfiguration(protocolName);
            protocolConfiguration.enableCmi(cmiProperties);
        }
    }

    public static void addConfiguration(ProtocolConfiguration protocolConfiguration) throws ConfigurationException {
        String protocolConfigName = protocolConfiguration.getName();
        if (managedConfigurations.get(protocolConfigName) != null) {
            throw new ConfigurationException("The configuration named '" + protocolConfigName + "' already exist.");
        }
        managedConfigurations.put(protocolConfigName, protocolConfiguration);
    }

    public static ServerConfiguration getServerConfiguration() {
        ConfigurationRepository.checkConfigured();
        return serverConfiguration;
    }

    protected static Properties mergeProperties(Properties defaultValues, Properties values) {
        Properties p = new Properties();
        p.putAll((Map<?, ?>)defaultValues);
        p.putAll((Map<?, ?>)values);
        return p;
    }

    public static void init() throws ConfigurationException {
        ConfigurationRepository.init(Thread.currentThread().getContextClassLoader().getResource("carol.properties"));
    }

    protected static Properties getDefaultProperties() throws ConfigurationException {
        if (defaultProperties == null) {
            URL defaultConfigurationFile = Thread.currentThread().getContextClassLoader().getResource("carol-defaults.properties");
            defaultProperties = ConfigurationRepository.getPropertiesFromURL(defaultConfigurationFile);
        }
        return defaultProperties;
    }

    protected static Properties getPropertiesFromURL(URL url) throws ConfigurationException {
        if (url == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Return empty properties, URL is null");
            }
            return new Properties();
        }
        InputStream is = null;
        try {
            URLConnection urlConnect = null;
            urlConnect = url.openConnection();
            urlConnect.setDefaultUseCaches(false);
            is = urlConnect.getInputStream();
        }
        catch (IOException ioe) {
            throw new ConfigurationException("Invalid URL '" + url + "' : " + ioe.getMessage(), ioe);
        }
        if (is == null) {
            throw new ConfigurationException("No inputstream for URL '" + url + "'.");
        }
        Properties p = new Properties();
        try {
            p.load(is);
        }
        catch (IOException ioe) {
            throw new ConfigurationException("Could not load input stream of  URL '" + url + "' : " + ioe.getMessage());
        }
        try {
            is.close();
        }
        catch (IOException ioe) {
            throw new ConfigurationException("Cannot close inputStream", ioe);
        }
        return p;
    }

    public static ProtocolConfiguration getDefaultConfiguration() {
        ConfigurationRepository.checkConfigured();
        return defaultConfiguration;
    }

    public static Properties getProperties() {
        ConfigurationRepository.checkConfigured();
        return properties;
    }

    public static int getActiveConfigurationsNumber() {
        ConfigurationRepository.checkConfigured();
        if (managedConfigurations != null) {
            return managedConfigurations.size();
        }
        return 0;
    }

    @Deprecated
    public static void addInterceptors(String protocolName, String interceptorInitializer) throws ConfigurationException {
        ConfigurationRepository.checkConfigured();
        Protocol protocol = ConfigurationRepository.getProtocol(protocolName);
        if (protocol == null) {
            logger.error((Object)("Cannot add interceptor on an unknown protocol '" + protocolName + "'."));
            throw new ConfigurationException("Cannot add interceptor on an unknown protocol '" + protocolName + "'.");
        }
        protocol.addInterceptor(interceptorInitializer);
    }

    public static void addInterceptors(String protocolName, Class<?> interceptorInitializer) throws ConfigurationException {
        ConfigurationRepository.checkConfigured();
        Protocol protocol = ConfigurationRepository.getProtocol(protocolName);
        if (protocol == null) {
            logger.error((Object)("Cannot add interceptor on an unknown protocol '" + protocolName + "'."));
            throw new ConfigurationException("Cannot add interceptor on an unknown protocol '" + protocolName + "'.");
        }
        protocol.addInterceptor(interceptorInitializer);
    }

    public static void removeInterceptors(String protocolName, Class<?> interceptorInitializer) throws ConfigurationException {
        ConfigurationRepository.checkConfigured();
        Protocol protocol = ConfigurationRepository.getProtocol(protocolName);
        if (protocol == null) {
            logger.error((Object)("Cannot remove interceptor on an unknown protocol '" + protocolName + "'."));
            throw new ConfigurationException("Cannot remove interceptor on an unknown protocol '" + protocolName + "'.");
        }
        protocol.removeInterceptor(interceptorInitializer);
    }

    protected static void initMbeans(String domainName, String serverName, String agentId) throws ConfigurationException {
        MBeanUtils.registerServerConfigurationMBean((ServerConfigurationImplMBean)((Object)serverConfiguration), logger, domainName, serverName, agentId);
        for (String protocolName : managedConfigurations.keySet()) {
            ProtocolConfiguration protocolConfiguration = managedConfigurations.get(protocolName);
            if (!(protocolConfiguration instanceof ProtocolConfigurationImplMBean)) continue;
            MBeanUtils.registerProtocolConfigurationMBean((ProtocolConfigurationImplMBean)((Object)protocolConfiguration), logger, domainName, serverName, agentId);
        }
    }

    public static boolean isCMIEnabled() {
        return serverConfiguration.isStartCMI();
    }

    public static boolean isMultiEnvironment() {
        return serverConfiguration.isMultiEnvironment();
    }
}

