/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.cmi.ha;

import java.io.File;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import javax.management.MBeanServer;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.ChannelException;
import org.jgroups.ChannelListener;
import org.jgroups.JChannel;
import org.jgroups.MembershipListener;
import org.jgroups.Message;
import org.jgroups.blocks.MessageDispatcher;
import org.jgroups.blocks.RequestHandler;
import org.jgroups.jmx.JmxConfigurator;
import org.jgroups.util.RspList;
import org.ow2.cmi.admin.MBeanUtils;
import org.ow2.cmi.config.CMIConfig;
import org.ow2.cmi.ha.HaMessageData;
import org.ow2.cmi.ha.JGViewManager;
import org.ow2.cmi.ha.MessageManager;
import org.ow2.cmi.ha.ReplicationManager;
import org.ow2.util.cluster.jgroups.ConnectionManager;
import org.ow2.util.cluster.jgroups.IMessageDispatcher;
import org.ow2.util.cluster.jgroups.MessageDispatcherWrapper;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public class JGMessageManager
implements RequestHandler,
MessageManager {
    private static Log logger = LogFactory.getLog(JGMessageManager.class);
    private static final String JGROUPS_STACK = "UDP(mcast_addr=224.0.0.40;mcast_port=30001;ip_ttl=32;mcast_send_buf_size=150000;mcast_recv_buf_size=80000):PING(timeout=2000;num_initial_members=3):MERGE2(min_interval=5000;max_interval=10000):FD(timeout=2000;max_tries=3;shun=true):VERIFY_SUSPECT(timeout=1500):pbcast.NAKACK(gc_lag=50;retransmit_timeout=300,600,1200,2400,4800):UNICAST(timeout=1200,2400,3600):pbcast.STABLE(stability_delay=1000;desired_avg_gossip=2000):FRAG(frag_size=4096;down_thread=false;up_thread=false):pbcast.GMS(join_timeout=3000;join_retry_timeout=2000;shun=false;print_local_addr=true)";
    private static final String DEFAULT_GROUP_NAME = "jonas-rep";
    private final ReplicationManager replicationManager;
    private JChannel channel;
    private IMessageDispatcher dispatcher;
    private JGViewManager viewMgr;
    private Address address;
    private LinkedList<HaMessageData> messages;
    private ProcessThread processThread;
    private long messagesNumber;
    private long messagesSize;
    private final String jgroupsHAConfFilename;
    private final String jgroupsHAGroupName;

    public JGMessageManager(String jgroupsConf, String jgroupsGroupname, ReplicationManager replicationManager, long timeout) {
        this.replicationManager = replicationManager;
        this.jgroupsHAGroupName = jgroupsConf == null ? DEFAULT_GROUP_NAME : jgroupsGroupname;
        logger.info((Object)("jgroups HA group name is: " + this.jgroupsHAGroupName), new Object[0]);
        this.jgroupsHAConfFilename = jgroupsConf;
        logger.info((Object)("jgroups HA configuration file is: " + this.jgroupsHAConfFilename), new Object[0]);
        String confDir = CMIConfig.getConfDir();
        URL file = null;
        if (confDir != null) {
            URI uri = new File(confDir, this.jgroupsHAConfFilename).toURI();
            try {
                file = uri.toURL();
            }
            catch (MalformedURLException e) {
                logger.warn((Object)"Cannot get the url for the uri: {0}", new Object[]{uri, e});
            }
        }
        if (file == null && (file = ClassLoader.getSystemClassLoader().getResource(this.jgroupsHAConfFilename)) == null && (file = Thread.currentThread().getContextClassLoader().getResource(this.jgroupsHAConfFilename)) == null) {
            file = this.getClass().getResource(this.jgroupsHAConfFilename);
        }
        try {
            if (file != null) {
                this.channel = new JChannel(file);
            } else {
                logger.info((Object)"error accesing jgroups HA configuration file, using defaults", new Object[0]);
                this.channel = new JChannel(JGROUPS_STACK);
            }
            this.channel.setOpt(1, (Object)true);
            this.channel.setOpt(3, (Object)false);
            this.channel.setOpt(5, (Object)true);
            this.viewMgr = new JGViewManager();
            MessageDispatcher messageDispatcher = new MessageDispatcher((Channel)this.channel, null, (MembershipListener)this.viewMgr, (RequestHandler)this);
            ConnectionManager connectionManager = new ConnectionManager(timeout, (Object)new MessageDispatcherWrapper(messageDispatcher));
            this.channel.addChannelListener((ChannelListener)connectionManager);
            this.dispatcher = (IMessageDispatcher)Proxy.newProxyInstance(IMessageDispatcher.class.getClassLoader(), new Class[]{IMessageDispatcher.class}, (InvocationHandler)connectionManager);
            this.channel.connect(this.jgroupsHAGroupName);
            try {
                JmxConfigurator.registerChannel((JChannel)this.channel, (MBeanServer)MBeanUtils.getMBeanServer(), (String)MBeanUtils.getMBeanDomainName(), (String)(this.channel.getClusterName() + ",name=HA"), (boolean)true);
            }
            catch (Exception e) {
                logger.warn((Object)"Unable to register the channel to the MBean Server", new Object[]{e});
            }
            this.messages = new LinkedList();
            this.processThread = new ProcessThread(this.messages);
            this.processThread.setDaemon(true);
            this.processThread.start();
            this.address = this.channel.getLocalAddress();
            logger.debug((Object)(this.address + " joined group " + this.jgroupsHAGroupName), new Object[0]);
            this.messagesNumber = 0L;
            this.messagesSize = 0L;
        }
        catch (ChannelException e) {
            logger.error((Object)"Error creating JGroups channel", new Object[]{e});
        }
    }

    public void sendMessage(HaMessageData messageData) {
        Message message = new Message(null, null, (Serializable)messageData);
        ++this.messagesNumber;
        this.messagesSize += message.size();
        RspList rspList = this.dispatcher.castMessage(null, message, 1, 0L);
        if (logger.isDebugEnabled()) {
            Address localAddress = this.dispatcher.getChannel().getLocalAddress();
            logger.debug((Object)("Message sended. Length: " + message.getBuffer().length + " From: " + localAddress), new Object[0]);
            logger.debug((Object)("Response: " + rspList.toString()), new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object handle(Message message) {
        Object o;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"-----------------------------------------------", new Object[0]);
            logger.debug((Object)("Processing message: " + message + " in: " + this.dispatcher.getChannel().getLocalAddress()), new Object[0]);
        }
        if ((o = message.getObject()) instanceof HaMessageData) {
            LinkedList<HaMessageData> linkedList = this.messages;
            synchronized (linkedList) {
                this.messages.add((HaMessageData)o);
                if (this.messages.size() == 1) {
                    this.processThread.resumeExecution();
                }
            }
        } else {
            logger.debug((Object)"\tNo action performed, unknown message format!!!", new Object[0]);
        }
        logger.debug((Object)"-----------------------------------------------", new Object[0]);
        return null;
    }

    public void clear() {
        this.dispatcher.stop();
        String domain = MBeanUtils.getMBeanDomainName();
        String clusterName = this.channel.getClusterName();
        String name = domain + ":type=channel,cluster=" + clusterName + ",name=HA";
        String protos = domain + ":type=protocol,cluster=" + clusterName + ",name=HA" + ",*";
        try {
            JmxConfigurator.unregisterChannel((MBeanServer)MBeanUtils.getMBeanServer(), (String)name);
            JmxConfigurator.unregister((MBeanServer)MBeanUtils.getMBeanServer(), (String)protos);
        }
        catch (Exception e) {
            logger.warn((Object)"Error when unregistering the channel with name {0} from the MBean server", new Object[]{clusterName, e});
        }
        this.channel.disconnect();
        this.channel.close();
        this.processThread.stopExecution();
    }

    public long getNumberofReplicatedMessages() {
        return this.messagesNumber;
    }

    public double getAvgSizeofReplicatedMessages() {
        if (this.messagesNumber > 0L) {
            return this.messagesSize / this.messagesNumber;
        }
        return 0.0;
    }

    public double getTotSizeofReplicatedMessages() {
        return this.messagesSize;
    }

    public String jgroupsConfFileName() {
        return this.jgroupsHAConfFilename;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ProcessThread
    extends Thread {
        private volatile Thread test;
        private final LinkedList<HaMessageData> messages;
        private volatile boolean suspended;

        ProcessThread(LinkedList<HaMessageData> messages) {
            this.messages = messages;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            logger.debug((Object)"ProcessMessage thread started", new Object[0]);
            this.suspended = false;
            this.test = Thread.currentThread();
            while (this.test == Thread.currentThread()) {
                try {
                    HaMessageData o = null;
                    LinkedList<HaMessageData> linkedList = this.messages;
                    synchronized (linkedList) {
                        if (this.messages.size() > 0) {
                            o = this.messages.removeFirst();
                        } else {
                            this.suspendExecution();
                        }
                    }
                    if (o != null) {
                        JGMessageManager.this.replicationManager.processMessage(o);
                    }
                }
                catch (NoSuchElementException e) {
                    this.suspendExecution();
                }
                if (!this.suspended) continue;
                ProcessThread processThread = this;
                synchronized (processThread) {
                    try {
                        while (this.suspended && this.test == Thread.currentThread()) {
                            this.wait();
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void stopExecution() {
            logger.debug((Object)"ProcessMessage thread stoped", new Object[0]);
            ProcessThread processThread = this;
            synchronized (processThread) {
                this.test = null;
                this.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void suspendExecution() {
            logger.debug((Object)"ProcessMessage thread suspended", new Object[0]);
            ProcessThread processThread = this;
            synchronized (processThread) {
                this.suspended = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void resumeExecution() {
            logger.debug((Object)"ProcessMessage thread resumed", new Object[0]);
            ProcessThread processThread = this;
            synchronized (processThread) {
                this.suspended = false;
                this.notify();
            }
        }
    }
}

