/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.deployment.common;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.ow2.jonas.deployment.api.IEnvEntryDesc;
import org.ow2.jonas.deployment.api.IJNDIEnvRefsGroupDesc;
import org.ow2.jonas.deployment.api.IResourceEnvRefDesc;
import org.ow2.jonas.deployment.api.IResourceRefDesc;
import org.ow2.jonas.deployment.api.IServiceRefDesc;
import org.ow2.jonas.deployment.common.DeploymentDescException;
import org.ow2.jonas.deployment.common.DescriptionGroupDesc;
import org.ow2.jonas.deployment.common.EjbLocalRefDesc;
import org.ow2.jonas.deployment.common.EjbRefDesc;
import org.ow2.jonas.deployment.common.EnvEntryDesc;
import org.ow2.jonas.deployment.common.MessageDestinationRefDesc;
import org.ow2.jonas.deployment.common.ResourceEnvRefDesc;
import org.ow2.jonas.deployment.common.ResourceRefDesc;
import org.ow2.jonas.deployment.common.xml.EjbLocalRef;
import org.ow2.jonas.deployment.common.xml.EjbRef;
import org.ow2.jonas.deployment.common.xml.EnvEntry;
import org.ow2.jonas.deployment.common.xml.JLinkedList;
import org.ow2.jonas.deployment.common.xml.JndiEnvRefsGroupXml;
import org.ow2.jonas.deployment.common.xml.JonasEjbRef;
import org.ow2.jonas.deployment.common.xml.JonasJndiEnvRefsGroupXml;
import org.ow2.jonas.deployment.common.xml.JonasMessageDestinationRef;
import org.ow2.jonas.deployment.common.xml.JonasResource;
import org.ow2.jonas.deployment.common.xml.JonasResourceEnv;
import org.ow2.jonas.deployment.common.xml.JonasServiceRef;
import org.ow2.jonas.deployment.common.xml.MessageDestinationRef;
import org.ow2.jonas.deployment.common.xml.ResourceEnvRef;
import org.ow2.jonas.deployment.common.xml.ResourceRef;
import org.ow2.jonas.deployment.common.xml.ServiceRef;
import org.ow2.jonas.deployment.ws.ServiceRefDesc;
import org.ow2.jonas.deployment.ws.WSDeploymentDescException;
import org.ow2.jonas.lib.util.Log;
import org.ow2.util.ee.metadata.common.impl.enc.ENCBindingHolder;

public abstract class JndiEnvRefsGroupDesc
extends DescriptionGroupDesc
implements IJNDIEnvRefsGroupDesc {
    private Vector resourceEnvRefs = new Vector();
    private Vector resourceRefs = new Vector();
    private Vector envEntries = new Vector();
    private Vector serviceRefs = new Vector();
    private Vector ejbRefs = new Vector();
    private Vector ejbLocalRefs = new Vector();
    private Vector messageDestinationRefs = new Vector();
    private ENCBindingHolder encBindingHolder = null;
    protected static Logger logger = Log.getLogger((String)"org.ow2.jonas.deployment");

    protected JndiEnvRefsGroupDesc(ClassLoader classLoader, JndiEnvRefsGroupXml app, JonasJndiEnvRefsGroupXml jonasApp, String fileName) throws DeploymentDescException {
        if (classLoader == null) {
            throw new DeploymentDescException("Classloader is null");
        }
        this.displayName = null;
        if (app.getDisplayName() != null) {
            this.displayName = app.getDisplayName();
        }
        this.processResourceEnvRef(classLoader, app, jonasApp);
        this.processResourceRef(classLoader, app, jonasApp);
        this.processEnvEntry(app);
        this.processEjbRef(app, jonasApp);
        this.processEjbLocalRef(app);
        this.processServiceRef(classLoader, app, jonasApp, fileName);
        this.processMessageDestinationRef(app, jonasApp);
    }

    private void processEnvEntry(JndiEnvRefsGroupXml app) throws DeploymentDescException {
        Iterator i = app.getEnvEntryList().iterator();
        while (i.hasNext()) {
            EnvEntryDesc envEntryDesc = new EnvEntryDesc((EnvEntry)i.next());
            this.envEntries.addElement(envEntryDesc);
        }
    }

    private void processMessageDestinationRef(JndiEnvRefsGroupXml app, JonasJndiEnvRefsGroupXml jonasApp) throws DeploymentDescException {
        String mdrName;
        JLinkedList messageDestinationRefList = app.getMessageDestinationRefList();
        JLinkedList jonasMessageDestinationRefList = jonasApp.getJonasMessageDestinationRefList();
        HashMap<String, JonasMessageDestinationRef> messageDestinationRef = new HashMap<String, JonasMessageDestinationRef>();
        for (JonasMessageDestinationRef jonasMessageDestinationRef : jonasMessageDestinationRefList) {
            mdrName = jonasMessageDestinationRef.getMessageDestinationRefName();
            boolean findMDRef = false;
            Iterator j = messageDestinationRefList.iterator();
            while (j.hasNext() && !findMDRef) {
                MessageDestinationRef mdRef = (MessageDestinationRef)j.next();
                if (!mdrName.equals(mdRef.getMessageDestinationRefName())) continue;
                findMDRef = true;
            }
            if (!findMDRef) {
                throw new DeploymentDescException("message-destination-ref missing for jonas-message-destination-ref " + mdrName);
            }
            messageDestinationRef.put(mdrName, jonasMessageDestinationRef);
        }
        for (MessageDestinationRef mdRef : messageDestinationRefList) {
            mdrName = mdRef.getMessageDestinationRefName();
            JonasMessageDestinationRef jonasMessageDestinationRef = (JonasMessageDestinationRef)messageDestinationRef.get(mdrName);
            if (jonasMessageDestinationRef == null && mdRef.getMessageDestinationLink() == null) {
                throw new DeploymentDescException("message-destination-link missing for message-destination-ref-name " + mdrName);
            }
            this.messageDestinationRefs.addElement(new MessageDestinationRefDesc(mdRef, jonasMessageDestinationRef));
        }
    }

    private void processServiceRef(ClassLoader classLoader, JndiEnvRefsGroupXml app, JonasJndiEnvRefsGroupXml jonasApp, String fileName) throws WSDeploymentDescException {
        Map links = this.linksSR2JSR(app, jonasApp);
        JLinkedList serviceRefList = app.getServiceRefList();
        for (ServiceRef serviceRef : serviceRefList) {
            JonasServiceRef jsr = (JonasServiceRef)links.get(serviceRef.getServiceRefName());
            this.serviceRefs.addElement(new ServiceRefDesc(classLoader, serviceRef, jsr, fileName));
        }
    }

    private void processEjbLocalRef(JndiEnvRefsGroupXml app) throws DeploymentDescException {
        JLinkedList ejbLocalRefList = app.getEjbLocalRefList();
        for (EjbLocalRef ejbLocalRef : ejbLocalRefList) {
            if (ejbLocalRef.getEjbLink() == null) {
                throw new DeploymentDescException("ejb-link missing for ejb-ref-name " + ejbLocalRef.getEjbRefName());
            }
            this.ejbLocalRefs.addElement(new EjbLocalRefDesc(ejbLocalRef));
        }
    }

    private void processEjbRef(JndiEnvRefsGroupXml app, JonasJndiEnvRefsGroupXml jonasApp) throws DeploymentDescException {
        String brName;
        JLinkedList ejbRefList = app.getEjbRefList();
        JLinkedList jonasEjbRefList = jonasApp.getJonasEjbRefList();
        HashMap<String, JonasEjbRef> ejbRef = new HashMap<String, JonasEjbRef>();
        for (JonasEjbRef jonasEjbRef : jonasEjbRefList) {
            brName = jonasEjbRef.getEjbRefName();
            boolean findBRef = false;
            Iterator j = ejbRefList.iterator();
            while (j.hasNext() && !findBRef) {
                EjbRef eRef = (EjbRef)j.next();
                if (!brName.equals(eRef.getEjbRefName())) continue;
                findBRef = true;
            }
            if (!findBRef) {
                throw new DeploymentDescException("ejb-ref missing for jonas-ejb-ref " + brName);
            }
            ejbRef.put(brName, jonasEjbRef);
        }
        for (EjbRef eRef : ejbRefList) {
            brName = eRef.getEjbRefName();
            JonasEjbRef jonasEjbRef = (JonasEjbRef)ejbRef.get(brName);
            if (jonasEjbRef == null && eRef.getEjbLink() == null) {
                logger.log(BasicLevel.WARN, (Object)("ejb-link missing for ejb-ref-name " + brName));
                continue;
            }
            this.ejbRefs.addElement(new EjbRefDesc(eRef, jonasEjbRef));
        }
    }

    private void processResourceRef(ClassLoader classLoader, JndiEnvRefsGroupXml app, JonasJndiEnvRefsGroupXml jonasApp) throws DeploymentDescException {
        String rName;
        JLinkedList resourceRefList = app.getResourceRefList();
        JLinkedList jonasResourceList = jonasApp.getJonasResourceList();
        HashMap<String, JonasResource> resource = new HashMap<String, JonasResource>();
        for (JonasResource jonasResource : jonasResourceList) {
            rName = jonasResource.getResRefName();
            boolean findResRef = false;
            Iterator j = resourceRefList.iterator();
            while (j.hasNext() && !findResRef) {
                if (!rName.equals(((ResourceRef)j.next()).getResRefName())) continue;
                findResRef = true;
            }
            if (!findResRef) {
                throw new DeploymentDescException("resource-ref missing for jonas-resource " + rName);
            }
            resource.put(rName, jonasResource);
        }
        for (ResourceRef resourceRef : resourceRefList) {
            rName = resourceRef.getResRefName();
            if (!resource.containsKey(rName)) {
                throw new DeploymentDescException("jonas-resource missing for res-ref-name " + rName);
            }
            this.resourceRefs.addElement(new ResourceRefDesc(classLoader, resourceRef, (JonasResource)resource.get(rName)));
        }
    }

    private void processResourceEnvRef(ClassLoader classLoader, JndiEnvRefsGroupXml app, JonasJndiEnvRefsGroupXml jonasApp) throws DeploymentDescException {
        String rName;
        JLinkedList resourceEnvRefList = app.getResourceEnvRefList();
        JLinkedList jonasResourceEnvList = jonasApp.getJonasResourceEnvList();
        HashMap<String, JonasResourceEnv> resourceEnv = new HashMap<String, JonasResourceEnv>();
        for (JonasResourceEnv jonasResourceEnv : jonasResourceEnvList) {
            rName = jonasResourceEnv.getResourceEnvRefName();
            boolean findResRef = false;
            Iterator j = resourceEnvRefList.iterator();
            while (j.hasNext() && !findResRef) {
                ResourceEnvRef resourceEnvRef = (ResourceEnvRef)j.next();
                if (!rName.equals(resourceEnvRef.getResourceEnvRefName())) continue;
                findResRef = true;
            }
            if (!findResRef) {
                throw new DeploymentDescException("resource-env-ref missing for jonas-resource-env " + rName);
            }
            resourceEnv.put(rName, jonasResourceEnv);
        }
        for (ResourceEnvRef resourceEnvRef : resourceEnvRefList) {
            rName = resourceEnvRef.getResourceEnvRefName();
            if (!resourceEnv.containsKey(rName)) {
                throw new DeploymentDescException("jonas-resource-env missing for resource-env-ref-name " + rName);
            }
            this.resourceEnvRefs.addElement(new ResourceEnvRefDesc(classLoader, resourceEnvRef, (JonasResourceEnv)resourceEnv.get(rName)));
        }
    }

    private Map linksSR2JSR(JndiEnvRefsGroupXml app, JonasJndiEnvRefsGroupXml jonasApp) {
        HashMap<String, JonasServiceRef> res = new HashMap<String, JonasServiceRef>();
        for (ServiceRef sr : app.getServiceRefList()) {
            res.put(sr.getServiceRefName(), null);
        }
        if (jonasApp != null) {
            Set keys = res.keySet();
            for (JonasServiceRef jsr : jonasApp.getJonasServiceRefList()) {
                String srName = jsr.getServiceRefName();
                if (keys.contains(srName)) {
                    res.put(srName, jsr);
                    continue;
                }
                String err = "jonas-service-ref '" + srName + "' is not linked to any service-ref. It will be ignored.";
                logger.log(BasicLevel.WARN, (Object)err);
            }
        }
        return res;
    }

    public IResourceEnvRefDesc[] getResourceEnvRefDesc() {
        Object[] ret = new IResourceEnvRefDesc[this.resourceEnvRefs.size()];
        this.resourceEnvRefs.copyInto(ret);
        return ret;
    }

    public IResourceRefDesc[] getResourceRefDesc() {
        Object[] ret = new ResourceRefDesc[this.resourceRefs.size()];
        this.resourceRefs.copyInto(ret);
        return ret;
    }

    public IEnvEntryDesc[] getEnvEntryDesc() {
        Object[] ret = new EnvEntryDesc[this.envEntries.size()];
        this.envEntries.copyInto(ret);
        return ret;
    }

    public EjbRefDesc[] getEjbRefDesc() {
        Object[] ret = new EjbRefDesc[this.ejbRefs.size()];
        this.ejbRefs.copyInto(ret);
        return ret;
    }

    public EjbLocalRefDesc[] getEjbLocalRefDesc() {
        Object[] ret = new EjbLocalRefDesc[this.ejbLocalRefs.size()];
        this.ejbLocalRefs.copyInto(ret);
        return ret;
    }

    public IServiceRefDesc[] getServiceRefDesc() {
        Object[] ret = new ServiceRefDesc[this.serviceRefs.size()];
        this.serviceRefs.copyInto(ret);
        return ret;
    }

    public MessageDestinationRefDesc[] getMessageDestinationRefDesc() {
        Object[] ret = new MessageDestinationRefDesc[this.messageDestinationRefs.size()];
        this.messageDestinationRefs.copyInto(ret);
        return ret;
    }

    public ENCBindingHolder getENCBindingHolder() {
        return this.encBindingHolder;
    }

    public void setENCBindingHolder(ENCBindingHolder encBindingHolder) {
        this.encBindingHolder = encBindingHolder;
    }
}

