/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.deployment.web;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.ow2.jonas.deployment.api.IEnvEntryDesc;
import org.ow2.jonas.deployment.api.IResourceEnvRefDesc;
import org.ow2.jonas.deployment.api.IResourceRefDesc;
import org.ow2.jonas.deployment.api.IServiceRefDesc;
import org.ow2.jonas.deployment.common.DeploymentDescException;
import org.ow2.jonas.deployment.common.EjbLocalRefDesc;
import org.ow2.jonas.deployment.common.EjbRefDesc;
import org.ow2.jonas.deployment.common.JndiEnvRefsGroupDesc;
import org.ow2.jonas.deployment.common.MessageDestinationRefDesc;
import org.ow2.jonas.deployment.common.xml.JLinkedList;
import org.ow2.jonas.deployment.common.xml.SecurityRole;
import org.ow2.jonas.deployment.web.SecurityConstraintListDesc;
import org.ow2.jonas.deployment.web.SecurityRoleDesc;
import org.ow2.jonas.deployment.web.ServletDesc;
import org.ow2.jonas.deployment.web.WebContainerDeploymentDescException;
import org.ow2.jonas.deployment.web.xml.JonasWebApp;
import org.ow2.jonas.deployment.web.xml.Servlet;
import org.ow2.jonas.deployment.web.xml.ServletMapping;
import org.ow2.jonas.deployment.web.xml.WebApp;

public class WebContainerDeploymentDesc
extends JndiEnvRefsGroupDesc {
    private String host = null;
    private String contextRoot = null;
    private String port = null;
    private boolean java2DelegationModel = true;
    private Map servlets = new HashMap();
    private Hashtable servletsUrlMapping = new Hashtable();
    private String xmlContent = "";
    private String jonasXmlContent = "";
    private List securityRoleList;
    private SecurityConstraintListDesc securityConstraintListDesc;

    public WebContainerDeploymentDesc(String fileName, ClassLoader classLoader, WebApp webApp, JonasWebApp jonasWebApp) throws DeploymentDescException {
        super(classLoader, webApp, jonasWebApp, fileName);
        this.host = jonasWebApp.getHost() != null ? jonasWebApp.getHost() : null;
        this.contextRoot = jonasWebApp.getContextRoot() != null ? jonasWebApp.getContextRoot() : null;
        this.port = jonasWebApp.getPort() != null ? jonasWebApp.getPort() : null;
        String delegationModel = null;
        delegationModel = jonasWebApp.getJava2DelegationModel() != null ? jonasWebApp.getJava2DelegationModel() : "true";
        if (delegationModel.equalsIgnoreCase("false")) {
            this.java2DelegationModel = false;
        } else if (delegationModel.equalsIgnoreCase("true")) {
            this.java2DelegationModel = true;
        } else {
            throw new WebContainerDeploymentDescException("The java2 delegation model could be 'true' or 'false', not '" + delegationModel + "'.");
        }
        SecurityRole securityRole2 = null;
        this.securityRoleList = new ArrayList();
        for (SecurityRole securityRole2 : webApp.getSecurityRoleList()) {
            this.securityRoleList.add(new SecurityRoleDesc(securityRole2));
        }
        JLinkedList servletList = webApp.getServletList();
        for (Servlet servlet : servletList) {
            if (servlet.getServletName() == null) continue;
            ServletDesc servletDesc = new ServletDesc(servlet);
            this.servlets.put(servlet.getServletName(), servletDesc);
        }
        JLinkedList urlMappings = webApp.getServletMappingList();
        for (Servlet servlet : servletList) {
            String name = servlet.getServletName().trim();
            Vector<String> mappings = new Vector<String>();
            for (ServletMapping sm : urlMappings) {
                if (!sm.getServletName().trim().equals(name)) continue;
                String pattern = sm.getUrlPattern().trim();
                if (pattern.indexOf(10) != -1) {
                    throw new WebContainerDeploymentDescException("There is a '\\n' character inside the url pattern for servlet named '" + sm.getServletName() + "' in the file '" + fileName + "'.");
                }
                mappings.add(pattern);
            }
            this.servletsUrlMapping.put(name, mappings);
        }
        this.securityConstraintListDesc = new SecurityConstraintListDesc(webApp);
        if (webApp.getJspConfigNumber() > 1) {
            throw new WebContainerDeploymentDescException("The web-app element must contain only one element jsp-config in file '" + fileName + "'");
        }
        if (webApp.getLoginConfigNumber() > 1) {
            throw new WebContainerDeploymentDescException("The web-app element must contain only one element login-config in file '" + fileName + "'");
        }
        if (webApp.getSessionConfigNumber() > 1) {
            throw new WebContainerDeploymentDescException("The web-app element must contain only one element session-config in file '" + fileName + "'");
        }
    }

    public String getXmlContent() {
        return this.xmlContent;
    }

    public String getJOnASXmlContent() {
        return this.jonasXmlContent;
    }

    public void setXmlContent(String xml) {
        this.xmlContent = xml;
    }

    public void setJOnASXmlContent(String jXml) {
        this.jonasXmlContent = jXml;
    }

    public String getContextRoot() {
        return this.contextRoot;
    }

    public boolean getJava2DelegationModel() {
        return this.java2DelegationModel;
    }

    public String getHost() {
        return this.host;
    }

    public String getPort() {
        return this.port;
    }

    public String toString() {
        StringBuffer ret = new StringBuffer();
        ret.append("\ngetDisplayName()=" + this.getDisplayName());
        IResourceEnvRefDesc[] rer = this.getResourceEnvRefDesc();
        for (int i = 0; i < rer.length; ++i) {
            ret.append("\ngetResourceEnvRefDesc(" + i + ")=" + rer[i].getClass().getName());
            ret.append(rer[i].toString());
        }
        IResourceRefDesc[] resourceRefDesc = this.getResourceRefDesc();
        for (int i = 0; i < resourceRefDesc.length; ++i) {
            ret.append("\ngetResourceRefDesc(" + i + ")=" + resourceRefDesc[i].getClass().getName());
            ret.append(resourceRefDesc[i].toString());
        }
        IEnvEntryDesc[] envEntries = this.getEnvEntryDesc();
        for (int i = 0; i < envEntries.length; ++i) {
            ret.append("\ngetEnvEntryDesc(" + i + ")=" + envEntries[i].getClass().getName());
            ret.append(envEntries[i].toString());
        }
        EjbRefDesc[] ejbRefDesc = this.getEjbRefDesc();
        for (int i = 0; i < ejbRefDesc.length; ++i) {
            ret.append("\ngetEjbRefDesc(" + i + ")=" + ejbRefDesc[i].getClass().getName());
            ret.append(((Object)ejbRefDesc[i]).toString());
        }
        EjbLocalRefDesc[] ejbLocalRefDesc = this.getEjbLocalRefDesc();
        for (int i = 0; i < ejbLocalRefDesc.length; ++i) {
            ret.append("\ngetEjbLocalRefDesc(" + i + ")=" + ejbLocalRefDesc[i].getClass().getName());
            ret.append(((Object)ejbLocalRefDesc[i]).toString());
        }
        IServiceRefDesc[] svcRef = this.getServiceRefDesc();
        for (int i = 0; i < svcRef.length; ++i) {
            ret.append("\ngetServiceRefDesc(" + i + ")=" + svcRef[i].getClass().getName());
            ret.append(svcRef[i].toString());
        }
        MessageDestinationRefDesc[] mdRefDesc = this.getMessageDestinationRefDesc();
        for (int i = 0; i < mdRefDesc.length; ++i) {
            ret.append("\ngetMessageDestinationRefDesc(" + i + ")=" + mdRefDesc[i].getClass().getName());
            ret.append(((Object)mdRefDesc[i]).toString());
        }
        ret.append("\ngetHost()=" + this.getHost());
        ret.append("\ngetContextRoot()=" + this.getContextRoot());
        return ret.toString();
    }

    public Collection getServletDescList() {
        return this.servlets.values();
    }

    public String[] getServletsName() {
        String[] st = new String[this.servlets.size()];
        return this.servlets.keySet().toArray(st);
    }

    public String getServletClassname(String servName) {
        return ((ServletDesc)this.servlets.get(servName)).getServletClass();
    }

    public SecurityConstraintListDesc getSecurityConstraintListDesc() {
        return this.securityConstraintListDesc;
    }

    public List getSecurityRoleList() {
        return this.securityRoleList;
    }

    public List getServletMappings(String servName) {
        return (List)this.servletsUrlMapping.get(servName);
    }
}

