/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.handler;

import java.math.BigInteger;
import java.security.cert.X509Certificate;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.Vector;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.security.WSEncryptionPart;
import org.apache.ws.security.WSPasswordCallback;
import org.apache.ws.security.WSSecurityEngine;
import org.apache.ws.security.WSSecurityEngineResult;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.components.crypto.CryptoFactory;
import org.apache.ws.security.handler.RequestData;
import org.apache.ws.security.handler.WSHandlerConstants;
import org.apache.ws.security.handler.WSHandlerResult;
import org.apache.ws.security.message.WSAddTimestamp;
import org.apache.ws.security.message.WSEncryptBody;
import org.apache.ws.security.message.WSSAddSAMLToken;
import org.apache.ws.security.message.WSSAddUsernameToken;
import org.apache.ws.security.message.WSSignEnvelope;
import org.apache.ws.security.message.token.Timestamp;
import org.apache.ws.security.saml.SAMLIssuer;
import org.apache.ws.security.saml.SAMLIssuerFactory;
import org.apache.ws.security.util.Loader;
import org.apache.ws.security.util.StringUtil;
import org.apache.ws.security.util.WSSecurityUtil;
import org.apache.ws.security.util.XmlSchemaDateFormat;
import org.opensaml.SAMLAssertion;
import org.w3c.dom.Document;

public abstract class WSHandler {
    protected static Log log = LogFactory.getLog((String)(class$org$apache$ws$security$handler$WSHandler == null ? (class$org$apache$ws$security$handler$WSHandler = WSHandler.class$("org.apache.ws.security.handler.WSHandler")) : class$org$apache$ws$security$handler$WSHandler).getName());
    protected static final WSSecurityEngine secEngine = WSSecurityEngine.getInstance();
    protected static boolean doDebug = true;
    protected static Hashtable cryptos = new Hashtable(5);
    static /* synthetic */ Class class$org$apache$ws$security$handler$WSHandler;

    protected void doSenderAction(int doAction, Document doc, RequestData reqData, Vector actions) throws WSSecurityException {
        boolean mu = this.decodeMustUnderstand(reqData);
        secEngine.setPrecisionInMilliSeconds(this.decodeTimestampPrecision(reqData));
        String actor = null;
        actor = (String)this.getOption("actor");
        if (actor == null) {
            actor = (String)this.getProperty(reqData.getMsgContext(), "actor");
        }
        reqData.setActor(actor);
        reqData.setSoapConstants(WSSecurityUtil.getSOAPConstants(doc.getDocumentElement()));
        if ((doAction & 1) == 1) {
            this.decodeUTParameter(reqData);
        }
        if ((doAction & 0x40) == 64) {
            this.decodeUTParameter(reqData);
            this.decodeSignatureParameter(reqData);
        }
        if ((doAction & 2) == 2) {
            reqData.setSigCrypto(this.loadSignatureCrypto(reqData));
            this.decodeSignatureParameter(reqData);
        }
        if ((doAction & 0x10) == 16) {
            this.decodeSignatureParameter(reqData);
        }
        if ((doAction & 4) == 4) {
            reqData.setEncCrypto(this.loadEncryptionCrypto(reqData));
            this.decodeEncryptionParameter(reqData);
        }
        block10: for (int i = 0; i < actions.size(); ++i) {
            int actionToDo = (Integer)actions.get(i);
            if (doDebug) {
                log.debug((Object)("Performing Action: " + actionToDo));
            }
            switch (actionToDo) {
                case 1: {
                    this.performUTAction(actionToDo, mu, doc, reqData);
                    continue block10;
                }
                case 4: {
                    this.performENCRAction(actionToDo, mu, doc, reqData);
                    continue block10;
                }
                case 2: {
                    this.performSIGNAction(actionToDo, mu, doc, reqData);
                    continue block10;
                }
                case 16: {
                    this.performST_SIGNAction(actionToDo, mu, doc, reqData);
                    continue block10;
                }
                case 8: {
                    this.performSTAction(actionToDo, mu, doc, reqData);
                    continue block10;
                }
                case 32: {
                    this.performTSAction(actionToDo, mu, doc, reqData);
                    continue block10;
                }
                case 64: {
                    this.performUT_SIGNAction(actionToDo, mu, doc, reqData);
                    continue block10;
                }
                case 256: {
                    reqData.setNoSerialization(true);
                }
            }
        }
    }

    protected void performSIGNAction(int actionToDo, boolean mu, Document doc, RequestData reqData) throws WSSecurityException {
        String password = this.getPassword(reqData.getUsername(), actionToDo, "passwordCallbackClass", "passwordCallbackRef", reqData).getPassword();
        WSSignEnvelope wsSign = new WSSignEnvelope(reqData.getActor(), mu);
        if (reqData.getSigKeyId() != 0) {
            wsSign.setKeyIdentifierType(reqData.getSigKeyId());
        }
        if (reqData.getSigAlgorithm() != null) {
            wsSign.setSignatureAlgorithm(reqData.getSigAlgorithm());
        }
        wsSign.setUserInfo(reqData.getUsername(), password);
        if (reqData.getSignatureParts().size() > 0) {
            wsSign.setParts(reqData.getSignatureParts());
        }
        try {
            wsSign.build(doc, reqData.getSigCrypto());
        }
        catch (WSSecurityException e) {
            throw new WSSecurityException("WSHandler: Signature: error during message procesing" + e);
        }
    }

    protected void performENCRAction(int actionToDo, boolean mu, Document doc, RequestData reqData) throws WSSecurityException {
        WSEncryptBody wsEncrypt = new WSEncryptBody(reqData.getActor(), mu);
        if (reqData.getEncKeyId() != 0) {
            wsEncrypt.setKeyIdentifierType(reqData.getEncKeyId());
        }
        if (reqData.getEncKeyId() == 5) {
            String encKeyName = null;
            encKeyName = (String)this.getOption("EmbeddedKeyName");
            if (encKeyName == null) {
                encKeyName = (String)this.getProperty(reqData.getMsgContext(), "EmbeddedKeyName");
            }
            wsEncrypt.setEmbeddedKeyName(encKeyName);
            byte[] embeddedKey = this.getPassword(reqData.getEncUser(), actionToDo, "EmbeddedKeyCallbackClass", "EmbeddedKeyCallbackRef", reqData).getKey();
            wsEncrypt.setKey(embeddedKey);
        }
        if (reqData.getEncSymmAlgo() != null) {
            wsEncrypt.setSymmetricEncAlgorithm(reqData.getEncSymmAlgo());
        }
        if (reqData.getEncKeyTransport() != null) {
            wsEncrypt.setKeyEnc(reqData.getEncKeyTransport());
        }
        wsEncrypt.setUserInfo(reqData.getEncUser());
        wsEncrypt.setUseThisCert(reqData.getEncCert());
        if (reqData.getEncryptParts().size() > 0) {
            wsEncrypt.setParts(reqData.getEncryptParts());
        }
        try {
            wsEncrypt.build(doc, reqData.getEncCrypto());
        }
        catch (WSSecurityException e) {
            throw new WSSecurityException("WSHandler: Encryption: error during message processing" + e);
        }
    }

    protected void performUTAction(int actionToDo, boolean mu, Document doc, RequestData reqData) throws WSSecurityException {
        String password = this.getPassword(reqData.getUsername(), actionToDo, "passwordCallbackClass", "passwordCallbackRef", reqData).getPassword();
        WSSAddUsernameToken builder = new WSSAddUsernameToken(reqData.getActor(), mu);
        builder.setPasswordType(reqData.getPwType());
        builder.build(doc, reqData.getUsername(), password);
        if (reqData.getUtElements() != null && reqData.getUtElements().length > 0) {
            for (int j = 0; j < reqData.getUtElements().length; ++j) {
                reqData.getUtElements()[j].trim();
                if (reqData.getUtElements()[j].equals("Nonce")) {
                    builder.addNonce(doc);
                }
                if (reqData.getUtElements()[j].equals("Created")) {
                    builder.addCreated(doc);
                }
                reqData.getUtElements()[j] = null;
            }
        }
    }

    protected void performUT_SIGNAction(int actionToDo, boolean mu, Document doc, RequestData reqData) throws WSSecurityException {
        String password = this.getPassword(reqData.getUsername(), actionToDo, "passwordCallbackClass", "passwordCallbackRef", reqData).getPassword();
        WSSAddUsernameToken builder = new WSSAddUsernameToken(reqData.getActor(), mu);
        builder.setPasswordType("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordText");
        builder.preSetUsernameToken(doc, reqData.getUsername(), password);
        builder.addCreated(doc);
        builder.addNonce(doc);
        WSSignEnvelope sign = new WSSignEnvelope(reqData.getActor(), mu);
        if (reqData.getSignatureParts().size() > 0) {
            sign.setParts(reqData.getSignatureParts());
        }
        sign.setUsernameToken(builder);
        sign.setKeyIdentifierType(7);
        sign.setSignatureAlgorithm("http://www.w3.org/2000/09/xmldsig#hmac-sha1");
        try {
            sign.build(doc, null);
        }
        catch (WSSecurityException e) {
            throw new WSSecurityException("WSHandler: Error during Signatur with UsernameToken secret" + e);
        }
        builder.build(doc, null, null);
    }

    protected void performSTAction(int actionToDo, boolean mu, Document doc, RequestData reqData) throws WSSecurityException {
        WSSAddSAMLToken builder = new WSSAddSAMLToken(reqData.getActor(), mu);
        SAMLIssuer saml = this.loadSamlIssuer(reqData);
        saml.setUsername(reqData.getUsername());
        SAMLAssertion assertion = saml.newAssertion();
        builder.build(doc, assertion);
    }

    protected void performST_SIGNAction(int actionToDo, boolean mu, Document doc, RequestData reqData) throws WSSecurityException {
        Crypto crypto = null;
        try {
            crypto = this.loadSignatureCrypto(reqData);
        }
        catch (WSSecurityException ex) {
            // empty catch block
        }
        SAMLIssuer saml = this.loadSamlIssuer(reqData);
        saml.setUsername(reqData.getUsername());
        saml.setUserCrypto(crypto);
        saml.setInstanceDoc(doc);
        SAMLAssertion assertion = saml.newAssertion();
        if (assertion == null) {
            throw new WSSecurityException("WSHandler: Signed SAML: no SAML token received");
        }
        String issuerKeyName = null;
        String issuerKeyPW = null;
        Crypto issuerCrypto = null;
        WSSignEnvelope wsSign = new WSSignEnvelope(reqData.getActor(), mu);
        String password = null;
        if (saml.isSenderVouches()) {
            issuerKeyName = saml.getIssuerKeyName();
            issuerKeyPW = saml.getIssuerKeyPassword();
            issuerCrypto = saml.getIssuerCrypto();
        } else {
            password = this.getPassword(reqData.getUsername(), actionToDo, "passwordCallbackClass", "passwordCallbackRef", reqData).getPassword();
            wsSign.setUserInfo(reqData.getUsername(), password);
        }
        if (reqData.getSigKeyId() != 0) {
            wsSign.setKeyIdentifierType(reqData.getSigKeyId());
        }
        try {
            wsSign.build(doc, crypto, assertion, issuerCrypto, issuerKeyName, issuerKeyPW);
        }
        catch (WSSecurityException e) {
            throw new WSSecurityException("WSHandler: Signed SAML: error during message processing" + e);
        }
    }

    protected void performTSAction(int actionToDo, boolean mu, Document doc, RequestData reqData) throws WSSecurityException {
        WSAddTimestamp timeStampBuilder = new WSAddTimestamp(reqData.getActor(), mu);
        timeStampBuilder.build(doc, this.decodeTimeToLive(reqData));
    }

    protected Crypto loadSignatureCrypto(RequestData reqData) throws WSSecurityException {
        Crypto crypto = null;
        String sigPropFile = null;
        sigPropFile = (String)this.getOption("signaturePropFile");
        if (sigPropFile == null) {
            sigPropFile = (String)this.getProperty(reqData.getMsgContext(), "signaturePropFile");
        }
        if (sigPropFile != null) {
            crypto = (Crypto)cryptos.get(sigPropFile);
            if (crypto == null) {
                crypto = CryptoFactory.getInstance(sigPropFile);
                cryptos.put(sigPropFile, crypto);
            }
        } else {
            throw new WSSecurityException("WSHandler: Signature: no crypto property file");
        }
        return crypto;
    }

    protected Crypto loadEncryptionCrypto(RequestData reqData) throws WSSecurityException {
        Crypto crypto = null;
        String encPropFile = null;
        encPropFile = (String)this.getOption("encryptionPropFile");
        if (encPropFile == null) {
            encPropFile = (String)this.getProperty(reqData.getMsgContext(), "encryptionPropFile");
        }
        if (encPropFile != null) {
            crypto = (Crypto)cryptos.get(encPropFile);
            if (crypto == null) {
                crypto = CryptoFactory.getInstance(encPropFile);
                cryptos.put(encPropFile, crypto);
            }
        } else {
            crypto = reqData.getSigCrypto();
            if (crypto == null) {
                throw new WSSecurityException("WSHandler: Encryption: no crypto property file");
            }
        }
        return crypto;
    }

    protected SAMLIssuer loadSamlIssuer(RequestData reqData) {
        String samlPropFile = null;
        samlPropFile = (String)this.getOption("samlPropFile");
        if (samlPropFile == null) {
            samlPropFile = (String)this.getProperty(reqData.getMsgContext(), "samlPropFile");
        }
        return SAMLIssuerFactory.getInstance(samlPropFile);
    }

    protected void decodeUTParameter(RequestData reqData) throws WSSecurityException {
        reqData.setPwType((String)this.getOption("passwordType"));
        if (reqData.getPwType() == null) {
            reqData.setPwType((String)this.getProperty(reqData.getMsgContext(), "passwordType"));
        }
        if (reqData.getPwType() != null) {
            reqData.setPwType(reqData.getPwType().equals("PasswordText") ? "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordText" : "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordDigest");
        }
        String tmpS = null;
        tmpS = (String)this.getOption("addUTElements");
        if (tmpS == null) {
            tmpS = (String)this.getProperty(reqData.getMsgContext(), "addUTElements");
        }
        if (tmpS != null) {
            reqData.setUtElements(StringUtil.split(tmpS, ' '));
        }
    }

    protected void decodeSignatureParameter(RequestData reqData) throws WSSecurityException {
        String tmpS = null;
        tmpS = (String)this.getOption("signatureKeyIdentifier");
        if (tmpS == null) {
            tmpS = (String)this.getProperty(reqData.getMsgContext(), "signatureKeyIdentifier");
        }
        if (tmpS != null) {
            Integer I = (Integer)WSHandlerConstants.keyIdentifier.get(tmpS);
            if (I == null) {
                throw new WSSecurityException("WSHandler: Signature: unknown key identification");
            }
            reqData.setSigKeyId(I);
            if (reqData.getSigKeyId() != 2 && reqData.getSigKeyId() != 1 && reqData.getSigKeyId() != 3 && reqData.getSigKeyId() != 4) {
                throw new WSSecurityException("WSHandler: Signature: illegal key identification");
            }
        }
        reqData.setSigAlgorithm((String)this.getOption("signatureAlgorithm"));
        if (reqData.getSigAlgorithm() == null) {
            tmpS = (String)this.getProperty(reqData.getMsgContext(), "signatureAlgorithm");
        }
        if ((tmpS = (String)this.getOption("signatureParts")) == null) {
            tmpS = (String)this.getProperty(reqData.getMsgContext(), "signatureParts");
        }
        if (tmpS != null) {
            this.splitEncParts(tmpS, reqData.getSignatureParts(), reqData);
        }
    }

    protected void decodeEncryptionParameter(RequestData reqData) throws WSSecurityException {
        reqData.setEncUser((String)this.getOption("encryptionUser"));
        if (reqData.getEncUser() == null) {
            reqData.setEncUser((String)this.getProperty(reqData.getMsgContext(), "encryptionUser"));
        }
        if (reqData.getEncUser() == null) {
            reqData.setEncUser(reqData.getUsername());
        }
        if (reqData.getEncUser() == null) {
            throw new WSSecurityException("WSHandler: Encryption: no username");
        }
        this.handleSpecialUser(reqData);
        String tmpS = null;
        tmpS = (String)this.getOption("encryptionKeyIdentifier");
        if (tmpS == null) {
            tmpS = (String)this.getProperty(reqData.getMsgContext(), "encryptionKeyIdentifier");
        }
        if (tmpS != null) {
            Integer I = (Integer)WSHandlerConstants.keyIdentifier.get(tmpS);
            if (I == null) {
                throw new WSSecurityException("WSHandler: Encryption: unknown key identification");
            }
            reqData.setEncKeyId(I);
            if (reqData.getEncKeyId() != 2 && reqData.getEncKeyId() != 3 && reqData.getEncKeyId() != 4 && reqData.getEncKeyId() != 1 && reqData.getEncKeyId() != 5) {
                throw new WSSecurityException("WSHandler: Encryption: illegal key identification");
            }
        }
        reqData.setEncSymmAlgo((String)this.getOption("encryptionSymAlgorithm"));
        if (reqData.getEncSymmAlgo() == null) {
            reqData.setEncSymmAlgo((String)this.getProperty(reqData.getMsgContext(), "encryptionSymAlgorithm"));
        }
        reqData.setEncKeyTransport((String)this.getOption("encryptionKeyTransportAlgorithm"));
        if (reqData.getEncKeyTransport() == null) {
            reqData.setEncKeyTransport((String)this.getProperty(reqData.getMsgContext(), "encryptionKeyTransportAlgorithm"));
        }
        if ((tmpS = (String)this.getOption("encryptionParts")) == null) {
            tmpS = (String)this.getProperty(reqData.getMsgContext(), "encryptionParts");
        }
        if (tmpS != null) {
            this.splitEncParts(tmpS, reqData.getEncryptParts(), reqData);
        }
    }

    protected boolean decodeMustUnderstand(RequestData reqData) throws WSSecurityException {
        boolean mu = true;
        String mustUnderstand = null;
        mustUnderstand = (String)this.getOption("mustUnderstand");
        if (mustUnderstand == null) {
            mustUnderstand = (String)this.getProperty(reqData.getMsgContext(), "mustUnderstand");
        }
        if (mustUnderstand != null) {
            if (mustUnderstand.equals("0") || mustUnderstand.equals("false")) {
                mu = false;
            } else if (mustUnderstand.equals("1") || mustUnderstand.equals("true")) {
                mu = true;
            } else {
                throw new WSSecurityException("WSHandler: illegal mustUnderstand parameter");
            }
        }
        return mu;
    }

    protected int decodeTimeToLive(RequestData reqData) {
        String ttl = null;
        ttl = (String)this.getOption("timeToLive");
        if (ttl == null) {
            ttl = (String)this.getProperty(reqData.getMsgContext(), "timeToLive");
        }
        int ttl_i = 0;
        if (ttl != null) {
            try {
                ttl_i = Integer.parseInt(ttl);
            }
            catch (NumberFormatException e) {
                ttl_i = reqData.getTimeToLive();
            }
        }
        if (ttl_i <= 0) {
            ttl_i = reqData.getTimeToLive();
        }
        return ttl_i;
    }

    protected boolean decodeTimestampPrecision(RequestData reqData) throws WSSecurityException {
        boolean precisionInMilliSeconds = true;
        String value = null;
        value = (String)this.getOption("precisionInMilliseconds");
        if (value == null) {
            value = (String)this.getProperty(reqData.getMsgContext(), "precisionInMilliseconds");
        }
        if (value != null) {
            if (value.equals("0") || value.equals("false")) {
                precisionInMilliSeconds = false;
            } else if (value.equals("1") || value.equals("true")) {
                precisionInMilliSeconds = true;
            } else {
                throw new WSSecurityException("WSHandler: illegal precisionInMilliSeconds parameter");
            }
        }
        return precisionInMilliSeconds;
    }

    private WSPasswordCallback getPassword(String username, int doAction, String clsProp, String refProp, RequestData reqData) throws WSSecurityException {
        WSPasswordCallback pwCb = null;
        String password = null;
        String callback = null;
        CallbackHandler cbHandler = null;
        callback = (String)this.getOption(clsProp);
        if (callback == null) {
            callback = (String)this.getProperty(reqData.getMsgContext(), clsProp);
        }
        if (callback != null) {
            pwCb = this.readPwViaCallbackClass(callback, username, doAction);
            if (pwCb.getPassword() == null && pwCb.getKey() == null) {
                throw new WSSecurityException("WSHandler: password callback class provided null or empty password");
            }
        } else {
            cbHandler = (CallbackHandler)this.getProperty(reqData.getMsgContext(), refProp);
            if (cbHandler != null) {
                pwCb = this.performCallback(cbHandler, username, doAction);
                if (pwCb.getPassword() == null && pwCb.getKey() == null) {
                    throw new WSSecurityException("WSHandler: password callback provided null or empty password");
                }
            } else {
                password = this.getPassword(reqData.getMsgContext());
                if (password == null) {
                    throw new WSSecurityException("WSHandler: application provided null or empty password");
                }
                this.setPassword(reqData.getMsgContext(), null);
                pwCb = new WSPasswordCallback("", 0);
                pwCb.setPassword(password);
            }
        }
        return pwCb;
    }

    private WSPasswordCallback readPwViaCallbackClass(String callback, String username, int doAction) throws WSSecurityException {
        Class cbClass = null;
        CallbackHandler cbHandler = null;
        try {
            cbClass = Loader.loadClass(callback);
        }
        catch (ClassNotFoundException e) {
            throw new WSSecurityException("WSHandler: cannot load password callback class: " + callback, e);
        }
        try {
            cbHandler = (CallbackHandler)cbClass.newInstance();
        }
        catch (Exception e) {
            throw new WSSecurityException("WSHandler: cannot create instance of password callback: " + callback, e);
        }
        return this.performCallback(cbHandler, username, doAction);
    }

    private WSPasswordCallback performCallback(CallbackHandler cbHandler, String username, int doAction) throws WSSecurityException {
        WSPasswordCallback pwCb = null;
        int reason = 0;
        switch (doAction) {
            case 1: 
            case 64: {
                reason = 2;
                break;
            }
            case 2: {
                reason = 3;
                break;
            }
            case 4: {
                reason = 4;
            }
        }
        pwCb = new WSPasswordCallback(username, reason);
        Callback[] callbacks = new Callback[]{pwCb};
        try {
            cbHandler.handle(callbacks);
        }
        catch (Exception e) {
            throw new WSSecurityException("WSHandler: password callback failed", e);
        }
        return pwCb;
    }

    private void splitEncParts(String tmpS, Vector parts, RequestData reqData) throws WSSecurityException {
        WSEncryptionPart encPart = null;
        String[] rawParts = StringUtil.split(tmpS, ';');
        for (int i = 0; i < rawParts.length; ++i) {
            String[] partDef = StringUtil.split(rawParts[i], '}');
            if (partDef.length == 1) {
                if (doDebug) {
                    log.debug((Object)("single partDef: '" + partDef[0] + "'"));
                }
                encPart = new WSEncryptionPart(partDef[0].trim(), reqData.getSoapConstants().getEnvelopeURI(), "Content");
            } else if (partDef.length == 3) {
                String mode = partDef[0].trim();
                mode = mode.length() <= 1 ? "Content" : mode.substring(1);
                String nmSpace = partDef[1].trim();
                if (nmSpace.length() <= 1) {
                    nmSpace = reqData.getSoapConstants().getEnvelopeURI();
                } else if ((nmSpace = nmSpace.substring(1)).equals("Null")) {
                    nmSpace = null;
                }
                String element = partDef[2].trim();
                if (doDebug) {
                    log.debug((Object)("partDefs: '" + mode + "' ,'" + nmSpace + "' ,'" + element + "'"));
                }
                encPart = new WSEncryptionPart(element, nmSpace, mode);
            } else {
                throw new WSSecurityException("WSHandler: wrong part definition: " + tmpS);
            }
            parts.add(encPart);
        }
    }

    private void handleSpecialUser(RequestData reqData) {
        if (!"useReqSigCert".equals(reqData.getEncUser())) {
            return;
        }
        Vector results = null;
        results = (Vector)this.getProperty(reqData.getMsgContext(), "RECV_RESULTS");
        if (results == null) {
            return;
        }
        for (int i = 0; i < results.size(); ++i) {
            WSHandlerResult rResult = (WSHandlerResult)results.get(i);
            String hActor = rResult.getActor();
            if (!WSSecurityUtil.isActorEqual(reqData.getActor(), hActor)) continue;
            Vector wsSecEngineResults = rResult.getResults();
            for (int j = 0; j < wsSecEngineResults.size(); ++j) {
                WSSecurityEngineResult wser = (WSSecurityEngineResult)wsSecEngineResults.get(j);
                if (wser.getAction() != 2) continue;
                reqData.setEncCert(wser.getCertificate());
                return;
            }
        }
    }

    protected Crypto loadDecryptionCrypto(RequestData reqData) throws WSSecurityException {
        Crypto crypto = null;
        String decPropFile = null;
        decPropFile = (String)this.getOption("decryptionPropFile");
        if (decPropFile == null) {
            decPropFile = (String)this.getProperty(reqData.getMsgContext(), "decryptionPropFile");
        }
        if (decPropFile != null) {
            crypto = (Crypto)cryptos.get(decPropFile);
            if (crypto == null) {
                crypto = CryptoFactory.getInstance(decPropFile);
                cryptos.put(decPropFile, crypto);
            }
        } else {
            crypto = reqData.getSigCrypto();
            if (crypto == null) {
                throw new WSSecurityException("WSHandler: Encryption: no crypto property file");
            }
        }
        return crypto;
    }

    protected void decodeSignatureParameter2(RequestData reqData) throws WSSecurityException {
        reqData.setSigCrypto(this.loadSignatureCrypto(reqData));
    }

    protected void decodeDecryptionParameter(RequestData reqData) throws WSSecurityException {
        reqData.setDecCrypto(this.loadDecryptionCrypto(reqData));
    }

    protected CallbackHandler getPasswordCB(RequestData reqData) throws WSSecurityException {
        String callback = null;
        CallbackHandler cbHandler = null;
        callback = (String)this.getOption("passwordCallbackClass");
        if (callback == null) {
            callback = (String)this.getProperty(reqData.getMsgContext(), "passwordCallbackClass");
        }
        if (callback != null) {
            Class cbClass = null;
            try {
                cbClass = Loader.loadClass(callback);
            }
            catch (ClassNotFoundException e) {
                throw new WSSecurityException("WSHandler: cannot load password callback class: " + callback, e);
            }
            try {
                cbHandler = (CallbackHandler)cbClass.newInstance();
            }
            catch (Exception e) {
                throw new WSSecurityException("WSHandler: cannot create instance of password callback: " + callback, e);
            }
        }
        cbHandler = (CallbackHandler)this.getProperty(reqData.getMsgContext(), "passwordCallbackRef");
        if (cbHandler == null) {
            throw new WSSecurityException("WSHandler: no reference in callback property");
        }
        return cbHandler;
    }

    protected boolean verifyTrust(X509Certificate cert, RequestData reqData) throws WSSecurityException {
        X509Certificate[] certs;
        if (cert == null) {
            return false;
        }
        String[] aliases = null;
        String alias = null;
        String subjectString = cert.getSubjectDN().getName();
        String issuerString = cert.getIssuerDN().getName();
        BigInteger issuerSerial = cert.getSerialNumber();
        if (doDebug) {
            log.debug((Object)("WSHandler: Transmitted certificate has subject " + subjectString));
            log.debug((Object)("WSHandler: Transmitted certificate has issuer " + issuerString + " (serial " + issuerSerial + ")"));
        }
        try {
            alias = reqData.getSigCrypto().getAliasForX509Cert(issuerString, issuerSerial);
        }
        catch (WSSecurityException ex) {
            throw new WSSecurityException("WSHandler: Could not get alias for certificate with " + subjectString, ex);
        }
        if (alias != null) {
            try {
                certs = reqData.getSigCrypto().getCertificates(alias);
            }
            catch (WSSecurityException ex) {
                throw new WSSecurityException("WSHandler: Could not get certificates for alias " + alias, ex);
            }
            if (certs != null && certs.length > 0 && cert.equals(certs[0])) {
                if (doDebug) {
                    log.debug((Object)("Direct trust for certificate with " + subjectString));
                }
                return true;
            }
        } else if (doDebug) {
            log.debug((Object)("No alias found for subject from issuer with " + issuerString + " (serial " + issuerSerial + ")"));
        }
        try {
            aliases = reqData.getSigCrypto().getAliasesForDN(issuerString);
        }
        catch (WSSecurityException ex) {
            throw new WSSecurityException("WSHandler: Could not get alias for certificate with " + issuerString, ex);
        }
        if (aliases == null || aliases.length < 1) {
            if (doDebug) {
                log.debug((Object)("No aliases found in keystore for issuer " + issuerString + " of certificate for " + subjectString));
            }
            return false;
        }
        for (int i = 0; i < aliases.length; ++i) {
            alias = aliases[i];
            if (doDebug) {
                log.debug((Object)("Preparing to validate certificate path with alias " + alias + " for issuer " + issuerString));
            }
            try {
                certs = reqData.getSigCrypto().getCertificates(alias);
            }
            catch (WSSecurityException ex) {
                throw new WSSecurityException("WSHandler: Could not get certificates for alias " + alias, ex);
            }
            if (certs == null | certs.length < 1) {
                throw new WSSecurityException("WSHandler: Could not get certificates for alias " + alias);
            }
            X509Certificate[] x509certs = new X509Certificate[certs.length + 1];
            x509certs[0] = cert;
            for (int j = 0; j < certs.length; ++j) {
                x509certs[certs.length + j] = cert = certs[i];
            }
            certs = x509certs;
            try {
                if (!reqData.getSigCrypto().validateCertPath(certs)) continue;
                if (doDebug) {
                    log.debug((Object)("WSHandler: Certificate path has been verified for certificate with subject " + subjectString));
                }
                return true;
            }
            catch (WSSecurityException ex) {
                throw new WSSecurityException("WSHandler: Certificate path verification failed for certificate with subject " + subjectString, ex);
            }
        }
        log.debug((Object)("WSHandler: Certificate path could not be verified for certificate with subject " + subjectString));
        return false;
    }

    protected boolean verifyTimestamp(Timestamp timestamp, int timeToLive) throws WSSecurityException {
        Calendar validCreation = Calendar.getInstance();
        long currentTime = validCreation.getTimeInMillis();
        validCreation.setTimeInMillis(currentTime -= (long)(timeToLive * 1000));
        if (doDebug) {
            log.debug((Object)"Preparing to verify the timestamp");
            XmlSchemaDateFormat zulu = new XmlSchemaDateFormat();
            log.debug((Object)("Validation of Timestamp: Current time is " + zulu.format(Calendar.getInstance().getTime())));
            log.debug((Object)("Validation of Timestamp: Valid creation is " + zulu.format(validCreation.getTime())));
            log.debug((Object)("Validation of Timestamp: Timestamp created is " + zulu.format(timestamp.getCreated().getTime())));
        }
        if (!timestamp.getCreated().after(validCreation)) {
            if (doDebug) {
                log.debug((Object)"Validation of Timestamp: The message was created too long ago");
            }
            return false;
        }
        log.debug((Object)"Validation of Timestamp: Everything is ok");
        return true;
    }

    public abstract Object getOption(String var1);

    public abstract Object getProperty(Object var1, String var2);

    public abstract String getPassword(Object var1);

    public abstract void setPassword(Object var1, String var2);

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

