/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.message;

import java.security.cert.X509Certificate;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.security.SOAPConstants;
import org.apache.ws.security.WSDocInfo;
import org.apache.ws.security.WSDocInfoStore;
import org.apache.ws.security.WSEncryptionPart;
import org.apache.ws.security.WSSConfig;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.message.EnvelopeIdResolver;
import org.apache.ws.security.message.WSBaseMessage;
import org.apache.ws.security.message.WSSAddUsernameToken;
import org.apache.ws.security.message.token.BinarySecurity;
import org.apache.ws.security.message.token.PKIPathSecurity;
import org.apache.ws.security.message.token.Reference;
import org.apache.ws.security.message.token.SecurityTokenReference;
import org.apache.ws.security.message.token.X509Security;
import org.apache.ws.security.util.WSSecurityUtil;
import org.apache.xml.security.algorithms.SignatureAlgorithm;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.keys.KeyInfo;
import org.apache.xml.security.keys.content.X509Data;
import org.apache.xml.security.keys.content.x509.XMLX509Certificate;
import org.apache.xml.security.keys.content.x509.XMLX509IssuerSerial;
import org.apache.xml.security.signature.XMLSignature;
import org.apache.xml.security.signature.XMLSignatureException;
import org.apache.xml.security.transforms.Transform;
import org.apache.xml.security.transforms.TransformationException;
import org.apache.xml.security.transforms.Transforms;
import org.apache.xml.security.transforms.params.InclusiveNamespaces;
import org.apache.xml.security.utils.XMLUtils;
import org.opensaml.SAMLAssertion;
import org.opensaml.SAMLException;
import org.opensaml.SAMLObject;
import org.opensaml.SAMLSubject;
import org.opensaml.SAMLSubjectStatement;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class WSSignEnvelope
extends WSBaseMessage {
    private static Log log = LogFactory.getLog((String)(class$org$apache$ws$security$message$WSSignEnvelope == null ? (class$org$apache$ws$security$message$WSSignEnvelope = WSSignEnvelope.class$("org.apache.ws.security.message.WSSignEnvelope")) : class$org$apache$ws$security$message$WSSignEnvelope).getName());
    private static Log tlog = LogFactory.getLog((String)"org.apache.ws.security.TIME");
    protected boolean useSingleCert = true;
    protected String sigAlgo = null;
    protected String canonAlgo = "http://www.w3.org/2001/10/xml-exc-c14n#";
    protected WSSAddUsernameToken usernameToken = null;
    static /* synthetic */ Class class$org$apache$ws$security$message$WSSignEnvelope;

    public WSSignEnvelope() {
    }

    public WSSignEnvelope(String actor) {
        super(actor);
    }

    public WSSignEnvelope(String actor, boolean mu) {
        super(actor, mu);
    }

    public WSSignEnvelope(WSSConfig wssConfig, String actor, boolean mu) {
        super(wssConfig, actor, mu);
    }

    public void setUseSingleCertificate(boolean useSingleCert) {
        this.useSingleCert = useSingleCert;
    }

    public boolean isUseSingleCertificate() {
        return this.useSingleCert;
    }

    public void setSignatureAlgorithm(String algo) {
        this.sigAlgo = algo;
    }

    public String getSignatureAlgorithm() {
        return this.sigAlgo;
    }

    public void setSigCanonicalization(String algo) {
        this.canonAlgo = algo;
    }

    public String getSigCanonicalization() {
        return this.canonAlgo;
    }

    public void setUsernameToken(WSSAddUsernameToken usernameToken) {
        this.usernameToken = usernameToken;
    }

    public Document build(Document doc, Crypto crypto) throws WSSecurityException {
        this.doDebug = log.isDebugEnabled();
        long t0 = 0L;
        long t1 = 0L;
        long t2 = 0L;
        long t3 = 0L;
        long t4 = 0L;
        if (tlog.isDebugEnabled()) {
            t0 = System.currentTimeMillis();
        }
        if (this.doDebug) {
            log.debug((Object)"Beginning signing...");
        }
        WSDocInfo wsDocInfo = new WSDocInfo(doc.hashCode());
        wsDocInfo.setCrypto(crypto);
        Element envelope = doc.getDocumentElement();
        SOAPConstants soapConstants = WSSecurityUtil.getSOAPConstants(envelope);
        Element securityHeader = this.insertSecurityHeader(doc);
        String certUri = null;
        X509Certificate[] certs = null;
        if (this.keyIdentifierType != 7) {
            certs = crypto.getCertificates(this.user);
            if (certs == null || certs.length <= 0) {
                throw new WSSecurityException(0, "invalidX509Data", new Object[]{"for Signature"});
            }
            certUri = "CertId-" + certs[0].hashCode();
            if (this.sigAlgo == null) {
                String pubKeyAlgo = certs[0].getPublicKey().getAlgorithm();
                log.debug((Object)("automatic sig algo detection: " + pubKeyAlgo));
                if (pubKeyAlgo.equalsIgnoreCase("DSA")) {
                    this.sigAlgo = "http://www.w3.org/2000/09/xmldsig#dsa-sha1";
                } else if (pubKeyAlgo.equalsIgnoreCase("RSA")) {
                    this.sigAlgo = "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
                } else {
                    throw new WSSecurityException(0, "invalidX509Data", new Object[]{"for Signature - unkown public key Algo"});
                }
            }
        }
        XMLSignature sig = null;
        if (this.canonAlgo.equals("http://www.w3.org/2001/10/xml-exc-c14n#")) {
            Element canonElem = XMLUtils.createElementInSignatureSpace(doc, "CanonicalizationMethod");
            canonElem.setAttributeNS(null, "Algorithm", this.canonAlgo);
            if (this.wssConfig.isWsiBSPCompliant()) {
                Set prefixes = this.getInclusivePrefixes(securityHeader, false);
                InclusiveNamespaces inclusiveNamespaces = new InclusiveNamespaces(doc, prefixes);
                canonElem.appendChild(inclusiveNamespaces.getElement());
            }
            try {
                SignatureAlgorithm signatureAlgorithm = new SignatureAlgorithm(doc, this.sigAlgo);
                sig = new XMLSignature(doc, null, signatureAlgorithm.getElement(), canonElem);
            }
            catch (XMLSecurityException e) {
                log.error((Object)"", (Throwable)e);
                throw new WSSecurityException(9, "noXMLSig");
            }
        }
        try {
            sig = new XMLSignature(doc, null, this.sigAlgo, this.canonAlgo);
        }
        catch (XMLSecurityException e) {
            log.error((Object)"", (Throwable)e);
            throw new WSSecurityException(9, "noXMLSig");
        }
        KeyInfo info = sig.getKeyInfo();
        String keyInfoUri = "KeyId-" + info.hashCode();
        info.setId(keyInfoUri);
        SecurityTokenReference secRef = new SecurityTokenReference(this.wssConfig, doc);
        String strUri = "STRId-" + secRef.hashCode();
        secRef.setID(strUri);
        if (tlog.isDebugEnabled()) {
            t1 = System.currentTimeMillis();
        }
        if (this.parts == null) {
            this.parts = new Vector();
            WSEncryptionPart encP = new WSEncryptionPart(soapConstants.getBodyQName().getLocalPart(), soapConstants.getEnvelopeURI(), "Content");
            this.parts.add(encP);
        }
        Transforms transforms = null;
        for (int part = 0; part < this.parts.size(); ++part) {
            WSEncryptionPart encPart = (WSEncryptionPart)this.parts.get(part);
            String elemName = encPart.getName();
            String nmSpace = encPart.getNamespace();
            try {
                if (elemName.equals("Token")) {
                    transforms = new Transforms(doc);
                    transforms.addTransform("http://www.w3.org/2001/10/xml-exc-c14n#");
                    if (this.keyIdentifierType == 1) {
                        if (this.wssConfig.isWsiBSPCompliant()) {
                            transforms.item(0).getElement().appendChild(new InclusiveNamespaces(doc, this.getInclusivePrefixes(securityHeader)).getElement());
                        }
                        sig.addDocument("#" + certUri, transforms);
                        continue;
                    }
                    if (this.wssConfig.isWsiBSPCompliant()) {
                        transforms.item(0).getElement().appendChild(new InclusiveNamespaces(doc, this.getInclusivePrefixes(info.getElement())).getElement());
                    }
                    sig.addDocument("#" + keyInfoUri, transforms);
                    continue;
                }
                if (elemName.equals("STRTransform")) {
                    Element ctx = this.createSTRParameter(doc);
                    transforms = new Transforms(doc);
                    transforms.addTransform("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#STR-Transform", ctx);
                    sig.addDocument("#" + strUri, transforms);
                    continue;
                }
                if (elemName.equals("Assertion")) {
                    SAMLAssertion assertion;
                    Element assertionElement = (Element)WSSecurityUtil.findElement(envelope, elemName, nmSpace);
                    try {
                        assertion = new SAMLAssertion(assertionElement);
                    }
                    catch (Exception e1) {
                        log.error((Object)e1);
                        throw new WSSecurityException(9, "noXMLSig", null, e1);
                    }
                    Element body = (Element)WSSecurityUtil.findElement(envelope, elemName, nmSpace);
                    if (body == null) {
                        throw new WSSecurityException(0, "noEncElement", new Object[]{nmSpace + ", " + elemName});
                    }
                    transforms = new Transforms(doc);
                    transforms.addTransform("http://www.w3.org/2001/10/xml-exc-c14n#");
                    if (this.wssConfig.isWsiBSPCompliant()) {
                        transforms.item(0).getElement().appendChild(new InclusiveNamespaces(doc, this.getInclusivePrefixes(body)).getElement());
                    }
                    String prefix = WSSecurityUtil.setNamespace(body, this.wssConfig.getWsuNS(), "wsu");
                    body.setAttributeNS(this.wssConfig.getWsuNS(), prefix + ":Id", assertion.getId());
                    sig.addDocument("#" + assertion.getId(), transforms);
                    continue;
                }
                Element body = (Element)WSSecurityUtil.findElement(envelope, elemName, nmSpace);
                if (body == null) {
                    throw new WSSecurityException(0, "noEncElement", new Object[]{nmSpace + ", " + elemName});
                }
                transforms = new Transforms(doc);
                transforms.addTransform("http://www.w3.org/2001/10/xml-exc-c14n#");
                if (this.wssConfig.isWsiBSPCompliant()) {
                    transforms.item(0).getElement().appendChild(new InclusiveNamespaces(doc, this.getInclusivePrefixes(body)).getElement());
                }
                sig.addDocument("#" + this.setWsuId(body), transforms);
                continue;
            }
            catch (TransformationException e1) {
                throw new WSSecurityException(9, "noXMLSig", null, e1);
            }
            catch (XMLSignatureException e1) {
                throw new WSSecurityException(9, "noXMLSig", null, e1);
            }
        }
        sig.addResourceResolver(EnvelopeIdResolver.getInstance(this.wssConfig));
        WSSecurityUtil.prependChildElement(doc, securityHeader, sig.getElement(), false);
        if (tlog.isDebugEnabled()) {
            t2 = System.currentTimeMillis();
        }
        byte[] secretKey = null;
        switch (this.keyIdentifierType) {
            case 1: {
                Reference ref = new Reference(this.wssConfig, doc);
                ref.setURI("#" + certUri);
                BinarySecurity bstToken = null;
                if (!this.useSingleCert) {
                    bstToken = new PKIPathSecurity(this.wssConfig, doc);
                    ((PKIPathSecurity)bstToken).setX509Certificates(certs, false, crypto);
                } else {
                    bstToken = new X509Security(this.wssConfig, doc);
                    ((X509Security)bstToken).setX509Certificate(certs[0]);
                }
                ref.setValueType(bstToken.getValueType());
                secRef.setReference(ref);
                bstToken.setID(certUri);
                WSSecurityUtil.prependChildElement(doc, securityHeader, bstToken.getElement(), false);
                wsDocInfo.setBst(bstToken.getElement());
                break;
            }
            case 2: {
                XMLX509IssuerSerial data = new XMLX509IssuerSerial(doc, certs[0]);
                secRef.setX509IssuerSerial(data);
                break;
            }
            case 3: {
                secRef.setKeyIdentifier(certs[0]);
                break;
            }
            case 4: {
                secRef.setKeyIdentifierSKI(certs[0], crypto);
                break;
            }
            case 7: {
                Reference refUt = new Reference(this.wssConfig, doc);
                refUt.setValueType("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#UsernameToken");
                String utId = this.usernameToken.getId();
                if (utId == null) {
                    utId = "usernameTokenId-" + this.usernameToken.hashCode();
                    this.usernameToken.setId(utId);
                }
                refUt.setURI("#" + utId);
                secRef.setReference(refUt);
                secretKey = this.usernameToken.getSecretKey();
                break;
            }
            default: {
                throw new WSSecurityException(0, "unsupportedKeyId");
            }
        }
        if (tlog.isDebugEnabled()) {
            t3 = System.currentTimeMillis();
        }
        info.addUnknownElement(secRef.getElement());
        WSDocInfoStore.store(wsDocInfo);
        try {
            if (this.keyIdentifierType == 7) {
                sig.sign(sig.createSecretKey(secretKey));
            } else {
                sig.sign(crypto.getPrivateKey(this.user, this.password));
            }
        }
        catch (XMLSignatureException e1) {
            throw new WSSecurityException(9, null, null, e1);
        }
        catch (Exception e1) {
            throw new WSSecurityException(9, null, null, e1);
        }
        finally {
            WSDocInfoStore.delete(wsDocInfo);
        }
        if (tlog.isDebugEnabled()) {
            t4 = System.currentTimeMillis();
            tlog.debug((Object)("SignEnvelope: cre-Sig= " + (t1 - t0) + " set transform= " + (t2 - t1) + " sec-ref= " + (t3 - t2) + " signature= " + (t4 - t3)));
        }
        if (this.doDebug) {
            log.debug((Object)"Signing complete.");
        }
        return doc;
    }

    public Document build(Document doc, Crypto userCrypto, SAMLAssertion assertion, Crypto issuerCrypto, String issuerKeyName, String issuerKeyPW) throws WSSecurityException {
        this.doDebug = log.isDebugEnabled();
        long t0 = 0L;
        long t1 = 0L;
        long t2 = 0L;
        long t3 = 0L;
        long t4 = 0L;
        if (tlog.isDebugEnabled()) {
            t0 = System.currentTimeMillis();
        }
        if (this.doDebug) {
            log.debug((Object)"Beginning ST signing...");
        }
        SAMLSubjectStatement samlSubjS = null;
        Iterator it = assertion.getStatements();
        while (it.hasNext()) {
            SAMLObject so = (SAMLObject)it.next();
            if (!(so instanceof SAMLSubjectStatement)) continue;
            samlSubjS = (SAMLSubjectStatement)so;
            break;
        }
        SAMLSubject samlSubj = null;
        if (samlSubjS != null) {
            samlSubj = samlSubjS.getSubject();
        }
        if (samlSubj == null) {
            throw new WSSecurityException(0, "invalidSAMLToken", new Object[]{"for Signature"});
        }
        String confirmMethod = null;
        it = samlSubj.getConfirmationMethods();
        if (it.hasNext()) {
            confirmMethod = (String)it.next();
        }
        boolean senderVouches = false;
        if ("urn:oasis:names:tc:SAML:1.0:cm:sender-vouches".equals(confirmMethod)) {
            senderVouches = true;
        }
        WSDocInfo wsDocInfo = new WSDocInfo(doc.hashCode());
        Element envelope = doc.getDocumentElement();
        SOAPConstants soapConstants = WSSecurityUtil.getSOAPConstants(envelope);
        Element securityHeader = this.insertSecurityHeader(doc);
        X509Certificate[] certs = null;
        if (senderVouches) {
            certs = issuerCrypto.getCertificates(issuerKeyName);
            wsDocInfo.setCrypto(issuerCrypto);
        } else {
            if (userCrypto == null || !assertion.isSigned()) {
                throw new WSSecurityException(0, "invalidSAMLsecurity", new Object[]{"for SAML Signature (Key Holder)"});
            }
            Element e = samlSubj.getKeyInfo();
            try {
                KeyInfo ki = new KeyInfo(e, null);
                if (ki.containsX509Data()) {
                    X509Data data = ki.itemX509Data(0);
                    XMLX509Certificate certElem = null;
                    if (data != null && data.containsCertificate()) {
                        certElem = data.itemCertificate(0);
                    }
                    if (certElem != null) {
                        X509Certificate cert = certElem.getX509Certificate();
                        certs = new X509Certificate[]{cert};
                    }
                }
            }
            catch (XMLSecurityException e3) {
                throw new WSSecurityException(0, "invalidSAMLsecurity", new Object[]{"cannot get certificate (key holder)"}, e3);
            }
            wsDocInfo.setCrypto(userCrypto);
        }
        if (certs == null || certs.length <= 0) {
            throw new WSSecurityException(0, "invalidX509Data", new Object[]{"for Signature"});
        }
        if (this.sigAlgo == null) {
            String pubKeyAlgo = certs[0].getPublicKey().getAlgorithm();
            log.debug((Object)("automatic sig algo detection: " + pubKeyAlgo));
            if (pubKeyAlgo.equalsIgnoreCase("DSA")) {
                this.sigAlgo = "http://www.w3.org/2000/09/xmldsig#dsa-sha1";
            } else if (pubKeyAlgo.equalsIgnoreCase("RSA")) {
                this.sigAlgo = "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
            } else {
                throw new WSSecurityException(0, "invalidX509Data", new Object[]{"for Signature - unkown public key Algo"});
            }
        }
        XMLSignature sig = null;
        try {
            sig = new XMLSignature(doc, null, this.sigAlgo, this.canonAlgo);
        }
        catch (XMLSecurityException e) {
            throw new WSSecurityException(9, "noXMLSig");
        }
        KeyInfo info = sig.getKeyInfo();
        String keyInfoUri = "KeyId-" + info.hashCode();
        info.setId(keyInfoUri);
        SecurityTokenReference secRef = new SecurityTokenReference(this.wssConfig, doc);
        String strUri = "STRId-" + secRef.hashCode();
        secRef.setID(strUri);
        String certUri = "CertId-" + certs[0].hashCode();
        if (tlog.isDebugEnabled()) {
            t1 = System.currentTimeMillis();
        }
        if (this.parts == null) {
            this.parts = new Vector();
            WSEncryptionPart encP = new WSEncryptionPart(soapConstants.getBodyQName().getLocalPart(), soapConstants.getEnvelopeURI(), "Content");
            this.parts.add(encP);
        }
        Transforms transforms = null;
        SecurityTokenReference secRefSaml = null;
        try {
            if (senderVouches) {
                secRefSaml = new SecurityTokenReference(this.wssConfig, doc);
                String strSamlUri = "STRSAMLId-" + secRefSaml.hashCode();
                secRefSaml.setID(strSamlUri);
                Reference ref = new Reference(this.wssConfig, doc);
                ref.setURI("#" + assertion.getId());
                ref.setValueType("http://docs.oasis-open.org/wss/2004/XX/oasis-2004XX-wss-saml-token-profile-1.0#SAMLAssertion-1.1");
                secRefSaml.setReference(ref);
                Element ctx = this.createSTRParameter(doc);
                transforms = new Transforms(doc);
                transforms.addTransform("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#STR-Transform", ctx);
                sig.addDocument("#" + strSamlUri, transforms);
            }
            for (int part = 0; part < this.parts.size(); ++part) {
                WSEncryptionPart encPart = (WSEncryptionPart)this.parts.get(part);
                String elemName = encPart.getName();
                String nmSpace = encPart.getNamespace();
                if (elemName.equals("Token")) {
                    transforms = new Transforms(doc);
                    transforms.addTransform("http://www.w3.org/2001/10/xml-exc-c14n#");
                    if (this.keyIdentifierType == 1) {
                        sig.addDocument("#" + certUri, transforms);
                        continue;
                    }
                    sig.addDocument("#" + keyInfoUri, transforms);
                    continue;
                }
                if (elemName.equals("STRTransform")) {
                    Element ctx = this.createSTRParameter(doc);
                    transforms = new Transforms(doc);
                    transforms.addTransform("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#STR-Transform", ctx);
                    sig.addDocument("#" + strUri, transforms);
                    continue;
                }
                Element body = (Element)WSSecurityUtil.findElement(envelope, elemName, nmSpace);
                if (body == null) {
                    throw new WSSecurityException(0, "noEncElement", new Object[]{nmSpace + ", " + elemName});
                }
                transforms = new Transforms(doc);
                transforms.addTransform("http://www.w3.org/2001/10/xml-exc-c14n#");
                sig.addDocument("#" + this.setWsuId(body), transforms);
            }
        }
        catch (TransformationException e1) {
            throw new WSSecurityException(9, "noXMLSig", null, e1);
        }
        catch (XMLSignatureException e1) {
            throw new WSSecurityException(9, "noXMLSig", null, e1);
        }
        sig.addResourceResolver(EnvelopeIdResolver.getInstance(this.wssConfig));
        WSSecurityUtil.prependChildElement(doc, securityHeader, sig.getElement(), false);
        if (tlog.isDebugEnabled()) {
            t2 = System.currentTimeMillis();
        }
        switch (this.keyIdentifierType) {
            case 1: {
                Reference ref = new Reference(this.wssConfig, doc);
                if (senderVouches) {
                    ref.setURI("#" + certUri);
                    X509Security bstToken = null;
                    bstToken = new X509Security(this.wssConfig, doc);
                    bstToken.setX509Certificate(certs[0]);
                    bstToken.setID(certUri);
                    WSSecurityUtil.prependChildElement(doc, securityHeader, bstToken.getElement(), false);
                    wsDocInfo.setBst(bstToken.getElement());
                    ref.setValueType(bstToken.getValueType());
                } else {
                    ref.setURI("#" + assertion.getId());
                    ref.setValueType("http://docs.oasis-open.org/wss/2004/XX/oasis-2004XX-wss-saml-token-profile-1.0#SAMLAssertion-1.1");
                }
                secRef.setReference(ref);
                break;
            }
            default: {
                throw new WSSecurityException(0, "unsupportedKeyId");
            }
        }
        if (tlog.isDebugEnabled()) {
            t3 = System.currentTimeMillis();
        }
        info.addUnknownElement(secRef.getElement());
        Element samlToken = null;
        try {
            samlToken = (Element)assertion.toDOM(doc);
        }
        catch (SAMLException e2) {
            throw new WSSecurityException(9, "noSAMLdoc", null, e2);
        }
        if (senderVouches) {
            WSSecurityUtil.prependChildElement(doc, securityHeader, secRefSaml.getElement(), true);
        }
        wsDocInfo.setAssertion(samlToken);
        WSSecurityUtil.prependChildElement(doc, securityHeader, samlToken, true);
        WSDocInfoStore.store(wsDocInfo);
        try {
            if (senderVouches) {
                sig.sign(issuerCrypto.getPrivateKey(issuerKeyName, issuerKeyPW));
            } else {
                sig.sign(userCrypto.getPrivateKey(this.user, this.password));
            }
        }
        catch (XMLSignatureException e1) {
            throw new WSSecurityException(9, null, null, e1);
        }
        catch (Exception e1) {
            throw new WSSecurityException(9, null, null, e1);
        }
        finally {
            WSDocInfoStore.delete(wsDocInfo);
        }
        if (tlog.isDebugEnabled()) {
            t4 = System.currentTimeMillis();
            tlog.debug((Object)("SignEnvelope: cre-Sig= " + (t1 - t0) + " set transform= " + (t2 - t1) + " sec-ref= " + (t3 - t2) + " signature= " + (t4 - t3)));
        }
        if (this.doDebug) {
            log.debug((Object)"Signing complete.");
        }
        return doc;
    }

    private Element createSTRParameter(Document doc) {
        Element transformParam = doc.createElementNS(this.wssConfig.getWsseNS(), "wsse:TransformationParameters");
        WSSecurityUtil.setNamespace(transformParam, this.wssConfig.getWsseNS(), "wsse");
        Element canonElem = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "ds:CanonicalizationMethod");
        WSSecurityUtil.setNamespace(canonElem, "http://www.w3.org/2000/09/xmldsig#", "ds");
        canonElem.setAttributeNS(null, "Algorithm", "http://www.w3.org/2001/10/xml-exc-c14n#");
        transformParam.appendChild(canonElem);
        return transformParam;
    }

    protected Set getInclusivePrefixes(Element target) {
        return this.getInclusivePrefixes(target, true);
    }

    protected Set getInclusivePrefixes(Element target, boolean excludeVisible) {
        Node attribute;
        int i;
        NamedNodeMap attributes;
        HashSet<String> result = new HashSet<String>();
        Node parent = target;
        while (!(parent.getParentNode() instanceof Document)) {
            parent = parent.getParentNode();
            attributes = parent.getAttributes();
            for (i = 0; i < attributes.getLength(); ++i) {
                attribute = attributes.item(i);
                if (attribute.getNamespaceURI() == null || !attribute.getNamespaceURI().equals("http://www.w3.org/2000/xmlns/")) continue;
                if (attribute.getNodeName().equals("xmlns")) {
                    result.add("#default");
                    continue;
                }
                result.add(attribute.getLocalName());
            }
        }
        if (excludeVisible) {
            attributes = target.getAttributes();
            for (i = 0; i < attributes.getLength(); ++i) {
                attribute = attributes.item(i);
                if (attribute.getNamespaceURI() != null && attribute.getNamespaceURI().equals("http://www.w3.org/2000/xmlns/")) {
                    if (attribute.getNodeName().equals("xmlns")) {
                        result.remove("#default");
                    } else {
                        result.remove(attribute.getLocalName());
                    }
                }
                if (attribute.getPrefix() == null) continue;
                result.remove(attribute.getPrefix());
            }
            if (target.getPrefix() == null) {
                result.remove("#default");
            } else {
                result.remove(target.getPrefix());
            }
        }
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        Transform.init();
        try {
            Transform.register("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#STR-Transform", "org.apache.ws.security.transform.STRTransform");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

