/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.ws.base.handler;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.util.Properties;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.ow2.jonas.lib.bootstrap.JProp;
import org.ow2.jonas.lib.util.I18n;
import org.ow2.jonas.lib.util.Log;
import org.ow2.jonas.ws.WSServiceException;
import org.ow2.jonas.ws.base.handler.WSDLHandler;

public class WSDLHandlerFactory {
    public static final String CLASSNAME = "jonas.service.wsdl.class";
    private static Logger logger = Log.getLogger((String)"org.ow2.jonas.ws");
    private static I18n i18n = I18n.getInstance(WSDLHandlerFactory.class);

    private WSDLHandlerFactory() {
    }

    public static WSDLHandlerFactory newInstance() {
        return new WSDLHandlerFactory();
    }

    public WSDLHandler newHandler(String filename) throws WSServiceException {
        Properties props = this.loadProperties(filename + ".properties");
        String classname = props.getProperty(CLASSNAME);
        if (classname == null) {
            String err = i18n.getMessage("WSDLHandlerFactory.newHandler.noClassname", (Object)(filename + ".properties"));
            logger.log(BasicLevel.ERROR, (Object)err);
            throw new WSServiceException(err);
        }
        Object[] pvalues = new Object[]{props};
        Class[] types = new Class[]{Properties.class};
        WSDLHandler handler = null;
        try {
            Class<?> handlerClazz = Class.forName(classname);
            Constructor<?> handlerConstr = handlerClazz.getConstructor(types);
            handler = (WSDLHandler)handlerConstr.newInstance(pvalues);
        }
        catch (Exception e) {
            String err = i18n.getMessage("WSDLHandlerFactory.newHandler.instantiationFailure", (Object)filename, (Object)classname);
            logger.log(BasicLevel.ERROR, (Object)err);
            throw new WSServiceException(err, (Throwable)e);
        }
        return handler;
    }

    private Properties loadProperties(String filename) throws WSServiceException {
        Properties props = new Properties();
        InputStream is = this.getFromClassLoader(filename);
        if (is == null) {
            is = this.getFromFile(JProp.getJonasBase() + File.separator + "conf" + File.separator + filename);
        }
        if (is != null) {
            try {
                props.load(is);
            }
            catch (IOException ioe) {
                String err = i18n.getMessage("WSDLHandlerFactory.loadProperties.ioe", (Object)filename);
                logger.log(BasicLevel.ERROR, (Object)err);
                throw new WSServiceException(err);
            }
        } else {
            String err = i18n.getMessage("WSDLHandlerFactory.loadProperties.notFound", (Object)filename);
            logger.log(BasicLevel.ERROR, (Object)err);
            throw new WSServiceException(err);
        }
        return props;
    }

    private InputStream getFromClassLoader(String filename) {
        String clProps = filename;
        if (!clProps.startsWith("/")) {
            clProps = "/" + clProps;
        }
        return this.getClass().getResourceAsStream(clProps);
    }

    private InputStream getFromFile(String filename) {
        FileInputStream is = null;
        File file = new File(filename);
        try {
            is = new FileInputStream(file);
        }
        catch (IOException ioe) {
            logger.log(BasicLevel.WARN, (Object)("Cannot load " + filename + " from file system."));
            is = null;
        }
        return is;
    }
}

