/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.ws.cxf.jaxws;

import java.io.IOException;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.jaxws.EndpointImpl;
import org.ow2.jonas.ws.cxf.http.JOnASDestination;
import org.ow2.jonas.ws.jaxws.IWSRequest;
import org.ow2.jonas.ws.jaxws.IWSResponse;
import org.ow2.jonas.ws.jaxws.IWebServiceEndpoint;
import org.ow2.jonas.ws.jaxws.PortMetaData;
import org.ow2.jonas.ws.jaxws.WSException;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public class CXFWSEndpoint
implements IWebServiceEndpoint {
    private static Log logger = LogFactory.getLog(CXFWSEndpoint.class);
    private EndpointImpl endpoint = null;
    private JOnASDestination destination = null;
    private PortMetaData portMetaData;
    private IWebServiceEndpoint.EndpointType type;

    public CXFWSEndpoint(EndpointImpl endpoint, IWebServiceEndpoint.EndpointType type, PortMetaData pmd) {
        this.endpoint = endpoint;
        this.type = type;
        this.portMetaData = pmd;
        this.destination = (JOnASDestination)endpoint.getServer().getDestination();
    }

    public IWebServiceEndpoint.EndpointType getType() {
        return this.type;
    }

    public void invoke(IWSRequest request, IWSResponse response) throws WSException {
        logger.debug((Object)"Receiving request on the thread ''{0}''", new Object[]{Thread.currentThread()});
        Bus old = BusFactory.getThreadDefaultBus();
        try {
            BusFactory.setThreadDefaultBus((Bus)this.destination.getBus());
            HttpServletRequest httpRequest = (HttpServletRequest)request.getAttribute(HttpServletRequest.class);
            HttpServletResponse httpResponse = (HttpServletResponse)request.getAttribute(HttpServletResponse.class);
            ServletContext servletContext = (ServletContext)request.getAttribute(ServletContext.class);
            this.destination.invoke(servletContext, httpRequest, httpResponse);
        }
        catch (IOException e) {
            throw new WSException((Throwable)e);
        }
        finally {
            BusFactory.setThreadDefaultBus((Bus)old);
        }
    }

    public void start() {
        this.endpoint.publish();
    }

    public void stop() {
        this.endpoint.stop();
    }

    public PortMetaData getPortMetaData() {
        return this.portMetaData;
    }
}

