/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.util.monolog.wrapper.remote.lib;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.objectweb.util.monolog.Monolog;
import org.objectweb.util.monolog.api.Handler;
import org.objectweb.util.monolog.api.Level;
import org.objectweb.util.monolog.api.Logger;
import org.objectweb.util.monolog.api.MonologFactory;
import org.objectweb.util.monolog.api.TopicalLogger;
import org.objectweb.util.monolog.file.monolog.PropertiesConfAccess;
import org.objectweb.util.monolog.wrapper.remote.api.LoggerInfo;
import org.objectweb.util.monolog.wrapper.remote.api.MonologFactoryMBean;

public class MonologFactoryMBeanImpl
implements MonologFactoryMBean {
    private MonologFactory mf;

    public MonologFactoryMBeanImpl() {
        this(Monolog.getMonologFactory());
    }

    public MonologFactoryMBeanImpl(MonologFactory mf) {
        this.mf = mf;
    }

    public boolean defineLevel(String name, int value) {
        return this.mf.defineLevel(name, value) != null;
    }

    public boolean defineLevel(String name, String value) {
        return this.mf.defineLevel(name, value) != null;
    }

    public void removeLevel(String name) {
        this.mf.removeLevel(name);
    }

    public Level getLevel(String name) {
        return this.mf.getLevel(name);
    }

    public Level getLevel(int value) {
        return this.mf.getLevel(value);
    }

    public Level[] getLevels() {
        return this.mf.getLevels();
    }

    public int compareTo(String levelname1, String levelname2) {
        Level l1 = this.mf.getLevel(levelname1);
        if (l1 == null) {
            return Integer.MAX_VALUE;
        }
        Level l2 = this.mf.getLevel(levelname2);
        if (l2 == null) {
            return Integer.MIN_VALUE;
        }
        return l1.compareTo(l2);
    }

    public boolean createHandler(String hn, String handlertype) {
        return this.mf.createHandler(hn, handlertype) != null;
    }

    public boolean removeHandler(String handlername) {
        return this.mf.removeHandler(handlername) == null;
    }

    public String[] getHandlerNames() {
        Handler[] hs = this.mf.getHandlers();
        String[] hns = new String[hs.length];
        for (int i = 0; i < hs.length; ++i) {
            hns[i] = hs[i].getName();
        }
        return hns;
    }

    public Map getHandlerAttributes(String handlername) {
        Handler h = this.mf.getHandler(handlername);
        String[] ans = h.getAttributeNames();
        HashMap<String, Object> m = new HashMap<String, Object>(ans.length);
        for (int i = 0; i < ans.length; ++i) {
            m.put(ans[i], h.getAttribute(ans[i]));
        }
        m.put("name", handlername);
        return m;
    }

    public Map getAllHandlerAttributes() {
        Handler[] hs = this.mf.getHandlers();
        HashMap<Handler, Map> m = new HashMap<Handler, Map>(hs.length);
        for (int i = 0; i < hs.length; ++i) {
            m.put(hs[i], this.getHandlerAttributes(hs[i].getName()));
        }
        return m;
    }

    public void setHandlerAttribute(String handlername, String attributeName, String value) {
        Handler h = this.mf.getHandler(handlername);
        if (h == null) {
            return;
        }
        h.setAttribute(attributeName, value);
    }

    public LoggerInfo getLogger(String loggername) {
        return new LoggerInfo((TopicalLogger)this.mf.getLogger(loggername));
    }

    public LoggerInfo getLogger(String loggername, String resourceBundleName) {
        return new LoggerInfo((TopicalLogger)this.mf.getLogger(loggername, resourceBundleName));
    }

    public String getResourceBundleName() {
        return this.mf.getResourceBundleName();
    }

    public void setResourceBundleName(String resourceBundleName) {
        this.mf.setResourceBundleName(resourceBundleName);
    }

    public LoggerInfo[] getLoggers() {
        Logger[] ls = this.mf.getLoggers();
        LoggerInfo[] lis = new LoggerInfo[ls.length];
        for (int i = 0; i < ls.length; ++i) {
            lis[i] = new LoggerInfo((TopicalLogger)ls[i]);
        }
        Arrays.sort(lis, new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((LoggerInfo)o1).topics[0].compareTo(((LoggerInfo)o2).topics[0]);
            }
        });
        return lis;
    }

    public void addHandlerToLogger(String handlername, String loggerName) {
        Handler h = this.mf.getHandler(handlername);
        if (h == null) {
            return;
        }
        TopicalLogger l = (TopicalLogger)this.mf.getLogger(loggerName);
        try {
            l.addHandler(h);
        }
        catch (Exception e) {
            return;
        }
    }

    public void removeHandlerFromLogger(String handlerName, String loggerName) {
        Handler h = this.mf.getHandler(handlerName);
        if (h == null) {
            return;
        }
        TopicalLogger l = (TopicalLogger)this.mf.getLogger(loggerName);
        try {
            l.removeHandler(h);
        }
        catch (Exception e) {
            return;
        }
    }

    public void removeAllHandlersFromLogger(String loggerName) {
        TopicalLogger l = (TopicalLogger)this.mf.getLogger(loggerName);
        try {
            l.removeAllHandlers();
        }
        catch (Exception e) {
            return;
        }
    }

    public void setAdditivity(boolean a, String loggerName) {
        TopicalLogger l = (TopicalLogger)this.mf.getLogger(loggerName);
        l.setAdditivity(a);
    }

    public void setLoggerLevel(int level, String loggerName) {
        TopicalLogger l = (TopicalLogger)this.mf.getLogger(loggerName);
        l.setIntLevel(level);
    }

    public void setLoggerLevel(String levelName, String loggerName) {
        TopicalLogger l = (TopicalLogger)this.mf.getLogger(loggerName);
        Level level = this.mf.getLevel(levelName);
        if (level != null) {
            l.setLevel(level);
        }
    }

    public void addTopicToLogger(String topic, String loggerName) {
        TopicalLogger l = (TopicalLogger)this.mf.getLogger(loggerName);
        try {
            l.addTopic(topic);
        }
        catch (Exception e) {
            return;
        }
    }

    public void removeTopicFromLogger(String topic, String loggerName) {
        TopicalLogger l = (TopicalLogger)this.mf.getLogger(loggerName);
        try {
            l.removeTopic(topic);
        }
        catch (Exception e) {
            return;
        }
    }

    public Properties getMonologProperties() {
        Properties p = new Properties();
        try {
            PropertiesConfAccess.store(p, this.mf);
        }
        catch (Exception e) {
            return null;
        }
        return p;
    }

    public void setMonologProperties(Properties p) {
        try {
            PropertiesConfAccess.load(p, this.mf);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

