/*
 * Decompiled with CFR 0.152.
 */
package fr.dyade.aaa.agent;

import fr.dyade.aaa.agent.AgentId;
import fr.dyade.aaa.agent.Debug;
import fr.dyade.aaa.agent.Driver;
import fr.dyade.aaa.agent.DriverDone;
import fr.dyade.aaa.agent.FlowControlNot;
import fr.dyade.aaa.agent.Notification;
import fr.dyade.aaa.agent.NotificationInputStream;
import fr.dyade.aaa.agent.ProxyAgent;
import java.io.EOFException;
import java.io.IOException;
import org.objectweb.util.monolog.api.BasicLevel;

class DriverIn
extends Driver {
    private ProxyAgent proxy;
    protected AgentId proxyId;
    protected NotificationInputStream in;
    int nbNotSent = 0;
    int maxNotSent = 0;
    int nbFlowControl = 0;
    private int key = 0;

    DriverIn(int id, ProxyAgent proxy, NotificationInputStream in, int maxNotSent) {
        super(id);
        this.maxNotSent = maxNotSent;
        this.proxy = proxy;
        this.proxyId = proxy.getId();
        this.in = in;
        this.name = proxy.getName() + ".DriverIn#" + id;
        String classname = this.getClass().getName();
        this.logmon = Debug.getLogger(proxy.getLogTopic() + '.' + classname.substring(classname.lastIndexOf(46) + 1));
    }

    DriverIn(int id, ProxyAgent proxy, NotificationInputStream in, int maxNotSent, int key) {
        this(id, proxy, in, maxNotSent);
        this.key = key;
    }

    public String toString() {
        return "(" + super.toString() + ",key=" + this.key + ",nbNotSent=" + this.nbNotSent + ",maxNotSent=" + this.maxNotSent + ",nbFlowControl=" + this.nbFlowControl + ")";
    }

    synchronized void sendFlowControl() throws IOException {
        ++this.nbFlowControl;
        if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
            this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", sendFlowControl#" + this.nbFlowControl));
        }
        if (this.key == 0) {
            this.sendTo(this.proxyId, new FlowControlNot(this.id));
        } else {
            this.sendTo(this.proxyId, new FlowControlNot(this.id, this.key));
        }
        while (this.nbFlowControl > 1) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    synchronized void recvFlowControl(FlowControlNot not) {
        --this.nbFlowControl;
        if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
            this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", recvFlowControl#" + this.nbFlowControl));
        }
        this.notify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (this.isRunning) {
            Notification m = null;
            this.canStop = true;
            try {
                if (this.nbNotSent > this.maxNotSent) {
                    try {
                        this.sendFlowControl();
                    }
                    catch (IOException exc) {
                        if (!this.proxy.finalizing) {
                            this.logmon.log(BasicLevel.ERROR, (Object)(this.getName() + ", error during sendFlowControl"), (Throwable)exc);
                        }
                        Thread.interrupted();
                        this.canStop = false;
                        break;
                    }
                    this.nbNotSent = 0;
                }
                m = this.in.readNotification();
            }
            catch (EOFException exc) {
                break;
            }
            catch (Exception exc) {
                if (this.proxy.finalizing) break;
                this.logmon.log(BasicLevel.WARN, (Object)(this.getName() + ", error in readNotification"), (Throwable)exc);
                break;
            }
            finally {
                Thread.interrupted();
                this.canStop = false;
            }
            if (m == null) continue;
            if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
                this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", read " + m));
            }
            this.proxy.driverReact(this.key, m);
            ++this.nbNotSent;
        }
    }

    protected void end() {
        try {
            if (this.key == 0) {
                this.sendTo(this.proxyId, new DriverDone(this.id));
            } else {
                this.sendTo(this.proxyId, new DriverDone(this.id, this.key));
            }
        }
        catch (IOException exc) {
            this.logmon.log(BasicLevel.ERROR, (Object)(this.getName() + ", error in reporting end"), (Throwable)exc);
        }
    }

    public void close() {
        try {
            this.in.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.in = null;
    }
}

