/*
 * Decompiled with CFR 0.152.
 */
package fr.dyade.aaa.jndi2.server;

import fr.dyade.aaa.agent.AgentId;
import fr.dyade.aaa.agent.AgentServer;
import fr.dyade.aaa.jndi2.server.AgentEntryPoint;
import fr.dyade.aaa.jndi2.server.Container;
import fr.dyade.aaa.jndi2.server.RequestManager;
import fr.dyade.aaa.jndi2.server.TcpEntryPoint;
import fr.dyade.aaa.jndi2.server.TcpServer;
import fr.dyade.aaa.jndi2.server.Trace;
import java.net.ServerSocket;
import org.objectweb.util.monolog.api.BasicLevel;

public class JndiServer {
    public static final String SO_TIMEOUT_PROP = "fr.dyade.aaa.jndi2.server.soTimeout";
    public static final int DEFAULT_SO_TIMEOUT = 10000;
    public static final String POOL_SIZE_PROP = "fr.dyade.aaa.jndi2.server.poolSize";
    public static final int DEFAULT_POOL_SIZE = 3;
    private static TcpServer tcpServer;

    public static void init(String args, boolean firstTime) throws Exception {
        if (Trace.logger.isLoggable(BasicLevel.DEBUG)) {
            Trace.logger.log(BasicLevel.DEBUG, (Object)("JndiServer.init(" + args + ',' + firstTime + ')'));
        }
        int port = Integer.parseInt(args);
        ServerSocket serverSocket = new ServerSocket(port);
        int poolSize = Integer.getInteger(POOL_SIZE_PROP, 3);
        int timeout = Integer.getInteger(SO_TIMEOUT_PROP, 10000);
        tcpServer = new TcpServer(serverSocket, poolSize, timeout, JndiServer.getDefault());
        if (firstTime) {
            RequestManager manager = new RequestManager();
            AgentEntryPoint agentEP = new AgentEntryPoint();
            agentEP.setRequestManager(manager);
            TcpEntryPoint tcpEP = new TcpEntryPoint();
            tcpEP.setRequestManager(manager);
            Container container = new Container();
            container.addEntryPoint(agentEP);
            container.addEntryPoint(tcpEP);
            container.setLifeCycleListener(manager);
            manager.setContainer(container);
            container.deploy();
        }
        tcpServer.start();
    }

    public static void stopService() {
        tcpServer.stop();
    }

    public static AgentId getDefault() {
        return JndiServer.getDefault(AgentServer.getServerId());
    }

    public static AgentId getDefault(short serverId) {
        return new AgentId(serverId, serverId, AgentId.LocalJndiServiceStamp);
    }
}

