/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.plan.deploy.deployable.internal.xmlhelper;

import java.io.File;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XmlHelper {
    private SAXParser namespaceAwareParser = null;
    private SAXParser namespaceUnawareParser = null;

    public XmlHelper() throws ParserConfigurationException, SAXException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        this.namespaceUnawareParser = factory.newSAXParser();
        factory.setNamespaceAware(true);
        this.namespaceAwareParser = factory.newSAXParser();
    }

    public boolean isWellFormedXml(File file) throws IllegalArgumentException, IOException {
        try {
            this.namespaceUnawareParser.parse(file, new DefaultHandler());
            return true;
        }
        catch (SAXException e) {
            return false;
        }
    }

    public boolean isLikelyXml(File file) throws IllegalArgumentException, IOException {
        try {
            this.namespaceUnawareParser.parse(file, (DefaultHandler)new CheckFirstElementHandler());
            return false;
        }
        catch (GetOutException e) {
            return true;
        }
        catch (SAXException e) {
            return false;
        }
    }

    public String getRootElementNameSpace(File file) throws IOException, SAXException {
        try {
            this.namespaceAwareParser.parse(file, (DefaultHandler)new CheckFirstElementHandler());
            return null;
        }
        catch (GetOutException e) {
            return e.getNameSpace();
        }
    }

    static class CheckFirstElementHandler
    extends DefaultHandler {
        CheckFirstElementHandler() {
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            throw new GetOutException(uri, localName);
        }
    }

    static class GetOutException
    extends SAXException {
        private static final long serialVersionUID = 27568468415776L;
        private String nameSpace = null;
        private String elementName = null;

        public GetOutException(String nameSpace, String localName) {
            this.nameSpace = nameSpace;
            this.elementName = localName;
        }

        public void setNameSpace(String nameSpace) {
            this.nameSpace = nameSpace;
        }

        public String getNameSpace() {
            return this.nameSpace;
        }

        public void setElementName(String localName) {
            this.elementName = localName;
        }

        public String getElementName() {
            return this.elementName;
        }
    }
}

