/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.architecture;

import java.util.ArrayList;
import java.util.List;
import org.apache.felix.ipojo.ComponentFactory;
import org.apache.felix.ipojo.Factory;
import org.apache.felix.ipojo.architecture.PropertyDescription;
import org.apache.felix.ipojo.metadata.Attribute;
import org.apache.felix.ipojo.metadata.Element;
import org.osgi.framework.BundleContext;

public class ComponentDescription {
    private String[] m_providedServiceSpecification = new String[0];
    private PropertyDescription[] m_properties = new PropertyDescription[0];
    private List m_requiredProperties = new ArrayList();
    private Factory m_factory;
    static /* synthetic */ Class class$java$lang$String;

    public ComponentDescription(Factory factory) {
        this.m_factory = factory;
    }

    public List getRequiredProperties() {
        return this.m_requiredProperties;
    }

    public String toString() {
        return this.getDescription().toString();
    }

    public String getClassName() {
        return this.m_factory.getClassName();
    }

    public PropertyDescription[] getProperties() {
        return this.m_properties;
    }

    public void addProperty(String name, String value) {
        PropertyDescription pd = new PropertyDescription(name, (class$java$lang$String == null ? (class$java$lang$String = ComponentDescription.class$("java.lang.String")) : class$java$lang$String).getName(), value);
        this.addProperty(pd);
    }

    public void addProperty(PropertyDescription pd) {
        String n = pd.getName();
        if ("name".equals(n)) {
            pd = new PropertyDescription(n, pd.getType(), null);
        }
        for (int i = 0; i < this.m_properties.length; ++i) {
            PropertyDescription desc = this.m_properties[i];
            if (!desc.getName().equals(n)) continue;
            return;
        }
        PropertyDescription[] newProps = new PropertyDescription[this.m_properties.length + 1];
        System.arraycopy(this.m_properties, 0, newProps, 0, this.m_properties.length);
        newProps[this.m_properties.length] = pd;
        this.m_properties = newProps;
        if (pd.getValue() == null) {
            this.m_requiredProperties.add(n);
        }
    }

    public String[] getprovidedServiceSpecification() {
        return this.m_providedServiceSpecification;
    }

    public void addProvidedServiceSpecification(String serviceSpecification) {
        String[] newSs = new String[this.m_providedServiceSpecification.length + 1];
        System.arraycopy(this.m_providedServiceSpecification, 0, newSs, 0, this.m_providedServiceSpecification.length);
        newSs[this.m_providedServiceSpecification.length] = serviceSpecification;
        this.m_providedServiceSpecification = newSs;
    }

    public String getName() {
        return this.m_factory.getName();
    }

    public Element getDescription() {
        int i;
        Element desc = new Element("Factory", "");
        desc.addAttribute(new Attribute("name", this.m_factory.getName()));
        desc.addAttribute(new Attribute("bundle", "" + ((ComponentFactory)this.m_factory).getBundleContext().getBundle().getBundleId()));
        String cn = this.getClassName();
        if (cn == null) {
            desc.addAttribute(new Attribute("Composite", "true"));
        } else {
            desc.addAttribute(new Attribute("Implementation-Class", this.getClassName()));
        }
        String state = "valid";
        if (this.m_factory.getState() == 0) {
            state = "invalid";
        }
        desc.addAttribute(new Attribute("state", state));
        Element rh = new Element("RequiredHandlers", "");
        rh.addAttribute(new Attribute("list", this.m_factory.getRequiredHandlers().toString()));
        Element mh = new Element("MissingHandlers", "");
        mh.addAttribute(new Attribute("list", this.m_factory.getMissingHandlers().toString()));
        desc.addElement(rh);
        desc.addElement(mh);
        for (i = 0; i < this.m_providedServiceSpecification.length; ++i) {
            Element prov = new Element("provides", "");
            prov.addAttribute(new Attribute("specification", this.m_providedServiceSpecification[i]));
            desc.addElement(prov);
        }
        for (i = 0; i < this.m_properties.length; ++i) {
            Element prop = new Element("property", "");
            prop.addAttribute(new Attribute("name", this.m_properties[i].getName()));
            prop.addAttribute(new Attribute("type", this.m_properties[i].getType()));
            if (this.m_properties[i].getValue() != null) {
                prop.addAttribute(new Attribute("value", this.m_properties[i].getValue()));
            } else {
                prop.addAttribute(new Attribute("value", "REQUIRED"));
            }
            desc.addElement(prop);
        }
        return desc;
    }

    public BundleContext getBundleContext() {
        return this.m_factory.getBundleContext();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

