/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.composite.service.importer;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.List;
import java.util.Properties;
import org.apache.felix.ipojo.ServiceContext;
import org.apache.felix.ipojo.composite.service.importer.ExportHandler;
import org.apache.felix.ipojo.util.Tracker;
import org.apache.felix.ipojo.util.TrackerCustomizer;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

public class ServiceExporter
implements TrackerCustomizer {
    private BundleContext m_destination;
    private ServiceContext m_origin;
    private String m_specification;
    private Filter m_filter;
    private String m_filterStr;
    private boolean m_aggregate = false;
    private boolean m_optional = false;
    private ExportHandler m_handler;
    private boolean m_isValid;
    private Tracker m_tracker;
    private List m_records = new ArrayList();

    public ServiceExporter(String specification, String filter, boolean multiple, boolean optional, ServiceContext from, BundleContext to, ExportHandler exp) {
        this.m_destination = to;
        this.m_origin = from;
        this.m_handler = exp;
        try {
            this.m_filter = to.createFilter(filter);
        }
        catch (InvalidSyntaxException e) {
            e.printStackTrace();
            return;
        }
        this.m_aggregate = multiple;
        this.m_specification = specification;
        this.m_optional = optional;
    }

    public void start() {
        this.m_tracker = new Tracker((BundleContext)this.m_origin, this.m_filter, (TrackerCustomizer)this);
        this.m_tracker.open();
        this.m_isValid = this.isSatisfied();
    }

    private Dictionary getProps(ServiceReference ref) {
        Properties prop = new Properties();
        String[] keys = ref.getPropertyKeys();
        for (int i = 0; i < keys.length; ++i) {
            prop.put(keys[i], ref.getProperty(keys[i]));
        }
        prop.put("instance.name", this.m_handler.getCompositeManager().getInstanceName());
        prop.put("factory.name", this.m_handler.getCompositeManager().getFactory().getName());
        return prop;
    }

    public void stop() {
        this.m_tracker.close();
        for (int i = 0; i < this.m_records.size(); ++i) {
            Record rec = (Record)this.m_records.get(i);
            rec.m_svcObject = null;
            if (rec.m_reg == null) continue;
            rec.m_reg.unregister();
            rec.m_reg = null;
            this.m_tracker.ungetService(rec.m_ref);
            rec.m_ref = null;
        }
        this.m_tracker = null;
        this.m_records.clear();
    }

    public boolean isSatisfied() {
        return this.m_optional || this.m_records.size() > 0;
    }

    private List getRecordsByRef(ServiceReference ref) {
        ArrayList<Record> l = new ArrayList<Record>();
        for (int i = 0; i < this.m_records.size(); ++i) {
            Record rec = (Record)this.m_records.get(i);
            if (rec.m_ref != ref) continue;
            l.add(rec);
        }
        return l;
    }

    protected String getSpecification() {
        return this.m_specification;
    }

    public String getFilter() {
        return this.m_filterStr;
    }

    public boolean addingService(ServiceReference reference) {
        return true;
    }

    public void addedService(ServiceReference reference) {
        Record rec = new Record();
        rec.m_ref = reference;
        this.m_records.add(rec);
        if (this.m_records.size() == 1 || this.m_aggregate) {
            rec.m_svcObject = this.m_tracker.getService(rec.m_ref);
            rec.m_reg = this.m_destination.registerService(this.m_specification, rec.m_svcObject, this.getProps(rec.m_ref));
        }
        if (!this.m_isValid && this.isSatisfied()) {
            this.m_isValid = true;
            this.m_handler.validating(this);
        }
    }

    public void modifiedService(ServiceReference reference, Object service) {
        List l = this.getRecordsByRef(reference);
        for (int i = 0; i < l.size(); ++i) {
            Record rec = (Record)l.get(i);
            if (rec.m_reg == null) continue;
            rec.m_reg.setProperties(this.getProps(reference));
        }
    }

    public void removedService(ServiceReference reference, Object service) {
        List l = this.getRecordsByRef(reference);
        for (int i = 0; i < l.size(); ++i) {
            Record rec = (Record)l.get(i);
            if (rec.m_reg == null) continue;
            rec.m_svcObject = null;
            rec.m_reg.unregister();
            rec.m_reg = null;
            this.m_tracker.ungetService(rec.m_ref);
        }
        this.m_records.removeAll(l);
        if (this.m_records.size() > 0) {
            Record rec;
            if (!this.m_aggregate && (rec = (Record)this.m_records.get(0)).m_svcObject == null) {
                rec.m_svcObject = this.m_tracker.getService(rec.m_ref);
                rec.m_reg = this.m_destination.registerService(this.m_specification, rec.m_svcObject, this.getProps(rec.m_ref));
            }
        } else if (!this.m_optional) {
            this.m_isValid = false;
            this.m_handler.invalidating(this);
        }
    }

    private class Record {
        private ServiceReference m_ref;
        private ServiceRegistration m_reg;
        private Object m_svcObject;

        private Record() {
        }
    }
}

