/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.extension.loader;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.ow2.jonas.extension.loader.Bnd;
import org.ow2.jonas.extension.loader.Bundlizable;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.url.URLUtils;

public class ExtensionLoaderComponent
implements Pojo {
    private InstanceManager _cm;
    private static final Log logger = LogFactory.getLog(ExtensionLoaderComponent.class);
    private boolean _Fcontext;
    private BundleContext context;
    private boolean _Fbundles;
    private List<Bundle> bundles;
    private boolean _Fbundlizables;
    private Map<String, Bundlizable> bundlizables;
    private boolean _M$initorg_apache_felix_ipojo_InstanceManagerorg_osgi_framework_BundleContext;
    private boolean _Mstart;
    private boolean _MapplyBndWrapjava_io_Filejava_io_File;
    private boolean _Mstop;

    private BundleContext _getcontext() {
        if (!this._Fcontext) {
            return this.context;
        }
        return (BundleContext)this._cm.getterCallback("context");
    }

    private void _setcontext(BundleContext bundleContext) {
        if (!this._Fcontext) {
            this.context = bundleContext;
            return;
        }
        this._cm.setterCallback("context", (Object)bundleContext);
    }

    private List _getbundles() {
        if (!this._Fbundles) {
            return this.bundles;
        }
        return (List)this._cm.getterCallback("bundles");
    }

    private void _setbundles(List list) {
        if (!this._Fbundles) {
            this.bundles = list;
            return;
        }
        this._cm.setterCallback("bundles", (Object)list);
    }

    private Map _getbundlizables() {
        if (!this._Fbundlizables) {
            return this.bundlizables;
        }
        return (Map)this._cm.getterCallback("bundlizables");
    }

    private void _setbundlizables(Map map) {
        if (!this._Fbundlizables) {
            this.bundlizables = map;
            return;
        }
        this._cm.setterCallback("bundlizables", (Object)map);
    }

    public ExtensionLoaderComponent(InstanceManager _manager, BundleContext context) {
        this._setComponentManager(_manager);
        if (this._M$initorg_apache_felix_ipojo_InstanceManagerorg_osgi_framework_BundleContext) {
            this._cm.entryCallback("$initorg_apache_felix_ipojo_InstanceManagerorg_osgi_framework_BundleContext");
        }
        this._setcontext(context);
        this._setbundles(new ArrayList());
        this._setbundlizables(new HashMap());
        Object var4_3 = null;
        if (this._M$initorg_apache_felix_ipojo_InstanceManagerorg_osgi_framework_BundleContext) {
            this._cm.exitCallback("$initorg_apache_felix_ipojo_InstanceManagerorg_osgi_framework_BundleContext", var4_3);
        }
    }

    public void start() {
        Bundlizable bnd2;
        String name;
        if (this._Mstart) {
            this._cm.entryCallback("start");
        }
        this._getbundles().clear();
        this._getbundlizables().clear();
        File jonasRoot = new File(System.getProperty("jonas.root"));
        File jonasBase = new File(System.getProperty("jonas.base"));
        File jonasBaseWork = new File(jonasBase, "work");
        File rootLibExt = new File(new File(jonasRoot, "lib"), "ext");
        File baseLibExt = new File(new File(jonasBase, "lib"), "ext");
        File bundleWork = new File(jonasBaseWork, "ext-bundles");
        if (!bundleWork.exists()) {
            bundleWork.mkdirs();
        }
        FileFilter selectJar = new FileFilter(){

            public boolean accept(File child) {
                return child.getName().endsWith(".jar") && child.isFile();
            }
        };
        if (rootLibExt.isDirectory()) {
            for (File child : rootLibExt.listFiles(selectJar)) {
                name = child.getName();
                bnd2 = (Bundlizable)this._getbundlizables().get(name);
                if (bnd2 != null) continue;
                bnd2 = new Bundlizable();
                bnd2.setSource(child);
                this._getbundlizables().put(child.getName(), bnd2);
            }
        }
        if (baseLibExt.isDirectory() && !rootLibExt.equals(baseLibExt)) {
            for (File child : baseLibExt.listFiles(selectJar)) {
                name = child.getName();
                bnd2 = (Bundlizable)this._getbundlizables().get(name);
                if (bnd2 != null) continue;
                bnd2 = new Bundlizable();
                bnd2.setSource(child);
                this._getbundlizables().put(child.getName(), bnd2);
            }
        }
        for (File child : bundleWork.listFiles(selectJar)) {
            name = child.getName();
            bnd2 = (Bundlizable)this._getbundlizables().get(name);
            if (bnd2 != null) continue;
            bnd2 = new Bundlizable();
            bnd2.setTarget(child);
            this._getbundlizables().put(child.getName(), bnd2);
        }
        Iterator i = this._getbundlizables().entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            Bundlizable bnd3 = (Bundlizable)entry.getValue();
            if (bnd3.isSourceSuppressed()) {
                bnd3.getTarget().delete();
                i.remove();
                continue;
            }
            if (bnd3.isFirstUsage()) {
                File target = new File(bundleWork, bnd3.getSource().getName());
                bnd3.setTarget(target);
                this.applyBndWrap(bnd3.getSource(), target);
                continue;
            }
            if (!bnd3.isTargetOutdated()) continue;
            bnd3.getTarget().delete();
            this.applyBndWrap(bnd3.getSource(), bnd3.getTarget());
        }
        if (this._getbundlizables().size() != 0) {
            StringBuilder sb = new StringBuilder();
            sb.append("Some jars have been found in [");
            sb.append(rootLibExt);
            if (!rootLibExt.equals(baseLibExt)) {
                sb.append(", ");
                sb.append(baseLibExt);
            }
            sb.append("].");
            sb.append(" They have been transformed into bundles (see ");
            sb.append(bundleWork);
            sb.append(" directory).");
            sb.append("This is NOT the prefered way to extends JOnAS libraries, ");
            sb.append("prefer to use carefully created and tested bundles, ");
            sb.append("and place them in your deploy/ directory.");
            logger.info((Object)sb.toString(), new Object[0]);
        }
        for (Map.Entry entry : this._getbundlizables().entrySet()) {
            Bundlizable bnd4 = (Bundlizable)entry.getValue();
            String url = URLUtils.fileToURL((File)bnd4.getTarget()).toExternalForm();
            try {
                Bundle installed = this._getcontext().installBundle(url);
                logger.info((Object)"{0} installed as a bundle.", new Object[]{url});
                this._getbundles().add(installed);
            }
            catch (BundleException e) {
                logger.warn((Object)"Unable to install '{0}': {1}", new Object[]{url, e.getMessage()});
            }
        }
        Object var14_19 = null;
        if (this._Mstart) {
            this._cm.exitCallback("start", var14_19);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void applyBndWrap(File file, File file2) {
        List<String> messages;
        void source;
        if (this._MapplyBndWrapjava_io_Filejava_io_File) {
            this._cm.entryCallback("applyBndWrapjava_io_Filejava_io_File");
        }
        Bnd myBnd = new Bnd();
        boolean errors = false;
        try {
            void output;
            errors = myBnd.wrap((File)source, (File)output);
        }
        catch (Exception e) {
            logger.warn((Object)"Unable to bundlize '{0}'", new Object[]{source, e});
        }
        if (errors && logger.isDebugEnabled() && (messages = myBnd.getErrors()) != null) {
            for (String message : messages) {
                logger.debug((Object)"[Bnd] {0}: {1}", new Object[]{source.getName(), message});
            }
        }
        Object var8_9 = null;
        if (this._MapplyBndWrapjava_io_Filejava_io_File) {
            this._cm.exitCallback("applyBndWrapjava_io_Filejava_io_File", var8_9);
        }
    }

    public void stop() {
        if (this._Mstop) {
            this._cm.entryCallback("stop");
        }
        for (Bundle bundle : this._getbundles()) {
            try {
                bundle.uninstall();
            }
            catch (BundleException e) {
                logger.debug((Object)"Unable to uninstall bundle '{0}[{1}]': {2}", new Object[]{bundle.getSymbolicName(), bundle.getBundleId(), e.getMessage()});
            }
        }
        Object var4_4 = null;
        if (this._Mstop) {
            this._cm.exitCallback("stop", var4_4);
        }
    }

    private void _setComponentManager(InstanceManager instanceManager) {
        this._cm = instanceManager;
        Set set = this._cm.getRegistredFields();
        if (set != null) {
            if (set.contains("context")) {
                this._Fcontext = true;
            }
            if (set.contains("bundles")) {
                this._Fbundles = true;
            }
            if (set.contains("bundlizables")) {
                this._Fbundlizables = true;
            }
            if (set.contains("logger")) {
                this._Flogger = true;
            }
        }
        if ((set = this._cm.getRegistredMethods()) != null) {
            if (set.contains("$initorg_apache_felix_ipojo_InstanceManagerorg_osgi_framework_BundleContext")) {
                this._M$initorg_apache_felix_ipojo_InstanceManagerorg_osgi_framework_BundleContext = true;
            }
            if (set.contains("start")) {
                this._Mstart = true;
            }
            if (set.contains("applyBndWrapjava_io_Filejava_io_File")) {
                this._MapplyBndWrapjava_io_Filejava_io_File = true;
            }
            if (set.contains("stop")) {
                this._Mstop = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this._cm;
    }
}

