/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.ee.metadata.common.impl.xml.parsing;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import javax.xml.namespace.QName;
import org.ow2.util.ee.metadata.common.impl.xml.parsing.AbsDeploymentDescLoader;
import org.ow2.util.ee.metadata.common.impl.xml.struct.AbsEJBRef;
import org.ow2.util.ee.metadata.common.impl.xml.struct.AbsEnvironment;
import org.ow2.util.ee.metadata.common.impl.xml.struct.AbsResourceGroup;
import org.ow2.util.ee.metadata.common.impl.xml.struct.EJBLocalRef;
import org.ow2.util.ee.metadata.common.impl.xml.struct.EJBRef;
import org.ow2.util.ee.metadata.common.impl.xml.struct.EnvEntry;
import org.ow2.util.ee.metadata.common.impl.xml.struct.InjectionTarget;
import org.ow2.util.ee.metadata.common.impl.xml.struct.LifeCycleCallback;
import org.ow2.util.ee.metadata.common.impl.xml.struct.MessageDestinationRef;
import org.ow2.util.ee.metadata.common.impl.xml.struct.PortComponentRef;
import org.ow2.util.ee.metadata.common.impl.xml.struct.ResourceEnvRef;
import org.ow2.util.ee.metadata.common.impl.xml.struct.ResourceRef;
import org.ow2.util.ee.metadata.common.impl.xml.struct.ServiceRef;
import org.ow2.util.xml.XMLSerializer;
import org.ow2.util.xml.XMLUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class CommonDeploymentDescLoader
extends AbsDeploymentDescLoader {
    protected CommonDeploymentDescLoader(URL url) {
        super(url);
    }

    protected void analyzeEnvironment(Element envElement, AbsEnvironment env) {
        this.analyzeLifeCycle(envElement, env, "post-construct");
        this.analyzeLifeCycle(envElement, env, "pre-destroy");
        this.analyzeEnvEnvtry(envElement, env);
        this.analyzeEJBRef(envElement, env);
        this.analyzeEJBLocalRef(envElement, env);
        this.analyzeResourceRef(envElement, env);
        this.analyzeResourceEnvRef(envElement, env);
        this.analyzeMessageDestinationRef(envElement, env);
        this.analyzeServiceRef(envElement, env);
    }

    private void analyzeCommonEJBRef(Element refElement, AbsEJBRef ref) {
        String ejbRefName = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)refElement, (String)"ejb-ref-name");
        ref.setEjbRefName(ejbRefName);
        String ejbRefType = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)refElement, (String)"ejb-ref-type");
        ref.setEjbRefType(ejbRefType);
        String mappedName = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)refElement, (String)"mapped-name");
        ref.setMappedName(mappedName);
        String ejbLink = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)refElement, (String)"ejb-link");
        ref.setEjbLink(ejbLink);
        this.analyzeInjectionTarget(refElement, ref);
    }

    private void analyzeInjectionTarget(Element refElement, AbsResourceGroup resourceGroup) {
        NodeList injectionTargetList = refElement.getElementsByTagNameNS(this.getXMLNS(), "injection-target");
        for (int j = 0; j < injectionTargetList.getLength(); ++j) {
            Element injectionTargetElement = (Element)injectionTargetList.item(j);
            InjectionTarget injectionTarget = new InjectionTarget();
            String className = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)injectionTargetElement, (String)"injection-target-class");
            injectionTarget.setClassname(className);
            String targetName = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)injectionTargetElement, (String)"injection-target-name");
            injectionTarget.setTargetName(targetName);
            resourceGroup.addInjectionTarget(injectionTarget);
        }
    }

    private void analyzeEJBRef(Element envElement, AbsEnvironment env) {
        NodeList ejbRefList = envElement.getElementsByTagNameNS(this.getXMLNS(), "ejb-ref");
        for (int i = 0; i < ejbRefList.getLength(); ++i) {
            Element ejbRefElement = (Element)ejbRefList.item(i);
            EJBRef ejbRef = new EJBRef();
            this.analyzeCommonEJBRef(ejbRefElement, ejbRef);
            String remote = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)ejbRefElement, (String)"remote");
            ejbRef.setRemote(remote);
            String home = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)ejbRefElement, (String)"home");
            ejbRef.setHome(home);
            env.addEJBRef(ejbRef);
        }
    }

    private void analyzeResourceRef(Element envElement, AbsEnvironment env) {
        NodeList resourceRefList = envElement.getElementsByTagNameNS(this.getXMLNS(), "resource-ref");
        for (int i = 0; i < resourceRefList.getLength(); ++i) {
            Element resourceRefElement = (Element)resourceRefList.item(i);
            ResourceRef resourceRef = new ResourceRef();
            String resRefName = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)resourceRefElement, (String)"res-ref-name");
            resourceRef.setResRefName(resRefName);
            String resRefType = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)resourceRefElement, (String)"res-type");
            resourceRef.setResRefType(resRefType);
            String mappedName = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)resourceRefElement, (String)"mapped-name");
            resourceRef.setMappedName(mappedName);
            this.analyzeInjectionTarget(resourceRefElement, resourceRef);
            env.addResourceRef(resourceRef);
        }
    }

    private void analyzeMessageDestinationRef(Element envElement, AbsEnvironment env) {
        NodeList messageDestinationRefList = envElement.getElementsByTagNameNS(this.getXMLNS(), "message-destination-ref");
        for (int i = 0; i < messageDestinationRefList.getLength(); ++i) {
            Element messageDestinationRefElement = (Element)messageDestinationRefList.item(i);
            MessageDestinationRef messageDestinationRef = new MessageDestinationRef();
            String name = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)messageDestinationRefElement, (String)"message-destination-ref-name");
            messageDestinationRef.setName(name);
            String type = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)messageDestinationRefElement, (String)"message-destination-type");
            messageDestinationRef.setType(type);
            String usage = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)messageDestinationRefElement, (String)"message-destination-usage");
            messageDestinationRef.setUsage(usage);
            String link = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)messageDestinationRefElement, (String)"message-destination-link");
            messageDestinationRef.setLink(link);
            String mappedName = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)messageDestinationRefElement, (String)"mapped-name");
            messageDestinationRef.setMappedName(mappedName);
            this.analyzeInjectionTarget(messageDestinationRefElement, messageDestinationRef);
            env.addMessageDestinationRef(messageDestinationRef);
        }
    }

    private void analyzeServiceRef(Element envElement, AbsEnvironment env) {
        NodeList serviceRefList = envElement.getElementsByTagNameNS(this.getXMLNS(), "service-ref");
        for (int i = 0; i < serviceRefList.getLength(); ++i) {
            Element serviceRefElement = (Element)serviceRefList.item(i);
            ServiceRef serviceRef = new ServiceRef();
            String name = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)serviceRefElement, (String)"service-ref-name");
            serviceRef.setName(name);
            String type = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)serviceRefElement, (String)"service-interface");
            serviceRef.setServiceInterface(type);
            String usage = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)serviceRefElement, (String)"service-ref-type");
            serviceRef.setServiceRefType(usage);
            String link = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)serviceRefElement, (String)"wsdl-file");
            URI location = null;
            try {
                location = new URI(link);
            }
            catch (URISyntaxException e) {
                throw new IllegalStateException("Element 'wsdl-file' is not a valid URI", e);
            }
            serviceRef.setWsdlFile(location);
            NodeList serviceQNameList = envElement.getElementsByTagNameNS(this.getXMLNS(), "service-qname");
            if (serviceQNameList.getLength() == 1) {
                QName serviceQName = XMLUtils.getValueAsQName((Element)((Element)serviceQNameList.item(0)));
                serviceRef.setServiceQName(serviceQName);
            }
            this.analyzePortComponentRef(serviceRefElement, serviceRef);
            this.analyzeHandlerChains(serviceRefElement, serviceRef);
            this.analyzeInjectionTarget(serviceRefElement, serviceRef);
            env.addServiceRef(serviceRef);
        }
    }

    private void analyzeHandlerChains(Element serviceRefElement, ServiceRef serviceRef) {
        NodeList handlerChainsList = serviceRefElement.getElementsByTagNameNS(this.getXMLNS(), "handler-chains");
        if (handlerChainsList.getLength() == 1) {
            Element handlerChainsElement = (Element)handlerChainsList.item(0);
            this.moveNamespacesDeclaration(handlerChainsElement, "soap-header");
            this.moveNamespacesDeclaration(handlerChainsElement, "service-name-pattern");
            this.moveNamespacesDeclaration(handlerChainsElement, "port-name-pattern");
            StringWriter writer = new StringWriter();
            XMLSerializer serializer = new XMLSerializer((Node)handlerChainsElement);
            try {
                serializer.serialize((Writer)writer);
                StringBuffer sb = writer.getBuffer();
                serviceRef.setHandlerChains(sb.toString());
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Unable to serialize handlers description for service-ref '" + serviceRef.getName() + "'.", e);
            }
        }
    }

    private void moveNamespacesDeclaration(Element handlerChainsElement, String localName) {
        Element serviceRefElement = (Element)handlerChainsElement.getParentNode();
        NodeList elementList = handlerChainsElement.getElementsByTagNameNS(this.getXMLNS(), localName);
        for (int i = 0; i < elementList.getLength(); ++i) {
            Element element = (Element)elementList.item(i);
            QName name = XMLUtils.getValueAsQName((Element)element);
            Element declaringParent = null;
            Element traversed = serviceRefElement;
            Element root = serviceRefElement.getOwnerDocument().getDocumentElement();
            while (declaringParent == null && !root.isEqualNode(traversed)) {
                Attr declaration = traversed.getAttributeNodeNS("http://www.w3.org/2000/xmlns/", name.getPrefix());
                if (declaration != null) {
                    declaringParent = traversed;
                    continue;
                }
                traversed = (Element)element.getParentNode();
            }
            if (declaringParent == null) continue;
            handlerChainsElement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + name.getPrefix(), name.getNamespaceURI());
        }
    }

    private void analyzePortComponentRef(Element serviceRefElement, ServiceRef serviceRef) {
        NodeList portComponentRefList = serviceRefElement.getElementsByTagNameNS(this.getXMLNS(), "port-component-ref");
        for (int i = 0; i < portComponentRefList.getLength(); ++i) {
            Element portComponentRefElement = (Element)portComponentRefList.item(i);
            PortComponentRef portComponentRef = new PortComponentRef();
            String sei = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)portComponentRefElement, (String)"service-endpoint-interface");
            portComponentRef.setServiceEndpointInterface(sei);
            String enableMTOM = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)portComponentRefElement, (String)"enable-mtom");
            if (enableMTOM != null) {
                portComponentRef.setEnableMTOM(Boolean.parseBoolean(enableMTOM));
            }
            String link = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)portComponentRefElement, (String)"port-component-link");
            portComponentRef.setPortComponentLink(link);
            serviceRef.addPortComponentRef(portComponentRef);
        }
    }

    private void analyzeResourceEnvRef(Element envElement, AbsEnvironment env) {
        NodeList resourceEnvRefList = envElement.getElementsByTagNameNS(this.getXMLNS(), "resource-env-ref");
        for (int i = 0; i < resourceEnvRefList.getLength(); ++i) {
            Element resourceEnvRefElement = (Element)resourceEnvRefList.item(i);
            ResourceEnvRef resourceEnvRef = new ResourceEnvRef();
            String resourceEnvRefName = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)resourceEnvRefElement, (String)"resource-env-ref-name");
            resourceEnvRef.setResourceEnvRefName(resourceEnvRefName);
            String resourceEnvRefType = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)resourceEnvRefElement, (String)"resource-env-ref-type");
            resourceEnvRef.setResourceEnvRefType(resourceEnvRefType);
            String mappedName = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)resourceEnvRefElement, (String)"mapped-name");
            resourceEnvRef.setMappedName(mappedName);
            this.analyzeInjectionTarget(resourceEnvRefElement, resourceEnvRef);
            env.addResourceEnvRef(resourceEnvRef);
        }
    }

    private void analyzeEJBLocalRef(Element envElement, AbsEnvironment env) {
        NodeList ejbLocalRefList = envElement.getElementsByTagNameNS(this.getXMLNS(), "ejb-local-ref");
        for (int i = 0; i < ejbLocalRefList.getLength(); ++i) {
            Element ejbRefElement = (Element)ejbLocalRefList.item(i);
            EJBLocalRef ejbLocalRef = new EJBLocalRef();
            this.analyzeCommonEJBRef(ejbRefElement, ejbLocalRef);
            String local = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)ejbRefElement, (String)"local");
            ejbLocalRef.setLocal(local);
            String localHome = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)ejbRefElement, (String)"local-home");
            ejbLocalRef.setLocalHome(localHome);
            env.addEJBLocalRef(ejbLocalRef);
        }
    }

    private void analyzeEnvEnvtry(Element envElement, AbsEnvironment bean) {
        NodeList envEntryList = envElement.getElementsByTagNameNS(this.getXMLNS(), "env-entry");
        for (int i = 0; i < envEntryList.getLength(); ++i) {
            Element envEntryElement = (Element)envEntryList.item(i);
            EnvEntry envEntry = new EnvEntry();
            bean.addEnvEntry(envEntry);
            String envEntryName = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)envEntryElement, (String)"env-entry-name");
            envEntry.setEnvEntryName(envEntryName);
            String envEntryType = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)envEntryElement, (String)"env-entry-type");
            envEntry.setEnvEntryType(envEntryType);
            String envEntryValue = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)envEntryElement, (String)"env-entry-value");
            envEntry.setEnvEntryValue(envEntryValue);
            this.analyzeInjectionTarget(envEntryElement, envEntry);
        }
    }

    protected void analyzeLifeCycle(Element envElement, AbsEnvironment env, String lifecycleName) {
        NodeList lifecycleList = envElement.getElementsByTagNameNS(this.getXMLNS(), lifecycleName);
        for (int i = 0; i < lifecycleList.getLength(); ++i) {
            Element lifeCycleElement = (Element)lifecycleList.item(i);
            LifeCycleCallback lifecycleCallback = new LifeCycleCallback();
            if ("post-construct".equals(lifecycleName)) {
                env.addPostConstructCallback(lifecycleCallback);
            } else if ("pre-destroy".equals(lifecycleName)) {
                env.addPreDestroyCallback(lifecycleCallback);
            } else if ("pre-passivate".equals(lifecycleName)) {
                env.addPrePassivateCallback(lifecycleCallback);
            } else if ("post-activate".equals(lifecycleName)) {
                env.addPostActivateCallback(lifecycleCallback);
            } else {
                throw new IllegalArgumentException("Unknown lifecycle named '" + lifecycleName + "'.");
            }
            String className = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)lifeCycleElement, (String)"lifecycle-callback-class");
            lifecycleCallback.setLifecycleCallbackClass(className);
            String method = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)lifeCycleElement, (String)"lifecycle-callback-method");
            lifecycleCallback.setMethodName(method);
        }
    }
}

