/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.deployer;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.Policy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.security.jacc.PolicyConfiguration;
import javax.security.jacc.PolicyConfigurationFactory;
import javax.security.jacc.PolicyContextException;
import org.ow2.easybeans.api.EZBContainer;
import org.ow2.easybeans.api.EZBContainerException;
import org.ow2.easybeans.deployer.AbsDeployer;
import org.ow2.easybeans.deployment.InjectionHolder;
import org.ow2.easybeans.loader.EasyBeansClassLoader;
import org.ow2.easybeans.naming.context.ContextImpl;
import org.ow2.easybeans.persistence.PersistenceUnitManager;
import org.ow2.easybeans.persistence.api.EZBPersistenceUnitManager;
import org.ow2.easybeans.resolver.ApplicationJNDIResolver;
import org.ow2.easybeans.resolver.api.EZBApplicationJNDIResolver;
import org.ow2.easybeans.resolver.api.EZBContainerJNDIResolver;
import org.ow2.util.archive.api.ArchiveException;
import org.ow2.util.archive.api.IArchive;
import org.ow2.util.ee.deploy.api.deployable.CARDeployable;
import org.ow2.util.ee.deploy.api.deployable.EARDeployable;
import org.ow2.util.ee.deploy.api.deployable.EJB21Deployable;
import org.ow2.util.ee.deploy.api.deployable.EJB3Deployable;
import org.ow2.util.ee.deploy.api.deployable.EJBDeployable;
import org.ow2.util.ee.deploy.api.deployable.IDeployable;
import org.ow2.util.ee.deploy.api.deployable.LibDeployable;
import org.ow2.util.ee.deploy.api.deployable.RARDeployable;
import org.ow2.util.ee.deploy.api.deployable.WARDeployable;
import org.ow2.util.ee.deploy.api.deployer.DeployerException;
import org.ow2.util.ee.deploy.api.deployer.IDeployer;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JOnASDeployer
extends AbsDeployer
implements IDeployer {
    private static Log logger = LogFactory.getLog(JOnASDeployer.class);
    private static final String JCLASSLOADER_CLASS = "org.objectweb.jonas.server.JClassLoader";
    private static final String SERVICE_MANAGER_CLASS = "org.objectweb.jonas.service.ServiceManager";
    private static final String EJBMANAGERWRAPPER_CLASS = "org.objectweb.jonas_ejb.deployment.lib.wrapper.EjbManagerWrapper";
    private static final String WEBMANAGERWRAPPER_CLASS = "org.objectweb.jonas_web.deployment.lib.wrapper.WebManagerWrapper";
    private static final String CLIENTMANAGERWRAPPER_CLASS = "org.objectweb.jonas_client.deployment.lib.wrapper.ClientManagerWrapper";
    private static final String EJBMANAGERWRAPPER_SETAVAILABLE_METHODNAME = "setAvailableEjbJarsAndAltDDs";
    private static final String WEBMANAGERWRAPPER_SETALTDD_METHODNAME = "setAltDD";
    private static final String CLIENTMANAGERWRAPPER_SETALTDD_METHODNAME = "setAltDD";
    private static final String SERVICE_MANAGER_GETINSTANCE_METHODNAME = "getInstance";
    private static final String SERVICE_MANAGER_GETEJBSERVICE_METHODNAME = "getEjbService";
    private static final String SERVICE_MANAGER_GETWEBCONTAINERSERVICE_METHODNAME = "getWebContainerService";
    private static final String SERVICE_MANAGER_GETRARSERVICE_METHODNAME = "getRarService";
    private static final String CHECK_GENIC_METHODNAME = "checkGenIC";
    private static final String EJBSERVICE_DEPLOY_METHODNAME = "deployJars";
    private static final String EJBSERVICE_UNDEPLOY_METHODNAME = "unDeployJars";
    private static final String RARSERVICE_DEPLOY_METHODNAME = "deployRars";
    private static final String RARSERVICE_UNDEPLOY_METHODNAME = "unDeployRars";
    private static final String WARSERVICE_DEPLOY_METHODNAME = "deployWars";
    private static final String WARSERVICE_UNDEPLOY_METHODNAME = "unDeployWars";
    private Object serviceManager = null;
    private Object ejb21Service = null;
    private Object warService = null;
    private Method deployMethodwarService = null;
    private Method undeployMethodwarService = null;
    private Method deployMethodejb21Service = null;
    private Method undeployMethodejb21Service = null;
    private Method checkGenICMethod = null;
    private Object rarService = null;
    private Method deployMethodRarService = null;
    private Method undeployMethodRarService = null;
    private Constructor jClassLoaderConstructor = null;
    private Method ejbSetAltDD = null;
    private Method webSetAltDD = null;
    private Method clientSetAltDD = null;

    public JOnASDeployer() throws DeployerException {
        Class serviceManagerClazz = JOnASDeployer.loadClass(SERVICE_MANAGER_CLASS);
        Method getInstanceMethod = JOnASDeployer.getMethod(serviceManagerClazz, SERVICE_MANAGER_GETINSTANCE_METHODNAME, new Class[0]);
        this.serviceManager = JOnASDeployer.invoke(getInstanceMethod, null, new Object[0]);
        Method getEJBServiceMethod = JOnASDeployer.getMethod(serviceManagerClazz, SERVICE_MANAGER_GETEJBSERVICE_METHODNAME, new Class[0]);
        this.ejb21Service = JOnASDeployer.invoke(getEJBServiceMethod, this.serviceManager, new Object[0]);
        Method getWarServiceMethod = JOnASDeployer.getMethod(serviceManagerClazz, SERVICE_MANAGER_GETWEBCONTAINERSERVICE_METHODNAME, new Class[0]);
        this.warService = JOnASDeployer.invoke(getWarServiceMethod, this.serviceManager, new Object[0]);
        Method getRarServiceMethod = JOnASDeployer.getMethod(serviceManagerClazz, SERVICE_MANAGER_GETRARSERVICE_METHODNAME, new Class[0]);
        this.rarService = JOnASDeployer.invoke(getRarServiceMethod, this.serviceManager, new Object[0]);
        this.deployMethodRarService = JOnASDeployer.getMethod(this.rarService.getClass(), RARSERVICE_DEPLOY_METHODNAME, Context.class);
        this.undeployMethodRarService = JOnASDeployer.getMethod(this.rarService.getClass(), RARSERVICE_UNDEPLOY_METHODNAME, URL[].class, URL.class);
        this.deployMethodwarService = JOnASDeployer.getMethod(this.warService.getClass(), WARSERVICE_DEPLOY_METHODNAME, Context.class);
        this.undeployMethodwarService = JOnASDeployer.getMethod(this.warService.getClass(), WARSERVICE_UNDEPLOY_METHODNAME, URL[].class);
        this.deployMethodejb21Service = JOnASDeployer.getMethod(this.ejb21Service.getClass(), EJBSERVICE_DEPLOY_METHODNAME, Context.class);
        this.undeployMethodejb21Service = JOnASDeployer.getMethod(this.ejb21Service.getClass(), EJBSERVICE_UNDEPLOY_METHODNAME, URL[].class);
        try {
            this.checkGenICMethod = JOnASDeployer.getMethod(this.ejb21Service.getClass(), CHECK_GENIC_METHODNAME, String.class, URL[].class);
        }
        catch (DeployerException e) {
            logger.warn((Object)"A method was not present in this JOnAS version, auto-GenIC will be disabled", new Object[0]);
        }
        Class jclassLoaderClass = JOnASDeployer.loadClass(JCLASSLOADER_CLASS);
        try {
            this.jClassLoaderConstructor = jclassLoaderClass.getConstructor(String.class, URL[].class, ClassLoader.class);
        }
        catch (SecurityException e) {
            throw new DeployerException("Cannot get the constructor on the 'org.objectweb.jonas.server.JClassLoader' class", (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            throw new DeployerException("Cannot get the constructor on the 'org.objectweb.jonas.server.JClassLoader' class", (Throwable)e);
        }
        Class ejbManagerClass = JOnASDeployer.loadClass(EJBMANAGERWRAPPER_CLASS);
        Class webManagerClass = JOnASDeployer.loadClass(WEBMANAGERWRAPPER_CLASS);
        Class clientManagerClass = JOnASDeployer.loadClass(CLIENTMANAGERWRAPPER_CLASS);
        this.ejbSetAltDD = JOnASDeployer.getMethod(ejbManagerClass, EJBMANAGERWRAPPER_SETAVAILABLE_METHODNAME, URLClassLoader.class, URL[].class, URL[].class);
        this.webSetAltDD = JOnASDeployer.getMethod(webManagerClass, "setAltDD", URLClassLoader.class, URL[].class, URL[].class);
        this.clientSetAltDD = JOnASDeployer.getMethod(clientManagerClass, "setAltDD", URLClassLoader.class, URL[].class, URL[].class);
    }

    public void deploy(IDeployable deployable) throws DeployerException {
        this.checkSupportedDeployable(deployable);
        if (deployable instanceof EJBDeployable) {
            this.deployEJB((EJBDeployable)deployable);
        } else if (deployable instanceof EARDeployable) {
            EARDeployable earDeployable = this.unpackEARDeployable((EARDeployable)deployable);
            this.deployEAR(earDeployable);
        }
    }

    public void undeploy(IDeployable deployable) throws DeployerException {
        if (!(deployable instanceof EARDeployable)) {
            throw new UnsupportedOperationException("Undeploy only .ear files");
        }
        this.undeployEAR((EARDeployable)deployable);
    }

    protected void undeployEAR(EARDeployable tmpEARDeployable) throws DeployerException {
        List ejb21Deployables;
        URL earURL;
        logger.info((Object)"Undeploying {0}", new Object[]{tmpEARDeployable});
        EARDeployable earDeployable = tmpEARDeployable;
        EARDeployable unpackedDeployable = (EARDeployable)earDeployable.getUnpackedDeployable();
        if (unpackedDeployable != null) {
            earDeployable = unpackedDeployable;
        }
        try {
            earURL = earDeployable.getArchive().getURL();
        }
        catch (ArchiveException e) {
            throw new DeployerException("Cannot get the URL on the EAR deployable '" + earDeployable + "'.", (Throwable)e);
        }
        List warDeployables = earDeployable.getWARDeployables();
        if (warDeployables != null && this.warService != null) {
            ArrayList<URL> urls = new ArrayList<URL>();
            for (WARDeployable warDeployable : warDeployables) {
                try {
                    urls.add(warDeployable.getArchive().getURL());
                }
                catch (ArchiveException e) {
                    logger.error((Object)"Cannot get the URL from the Deployable ''{0}''", new Object[]{warDeployable, e});
                }
            }
            URL[] warURLs = urls.toArray(new URL[urls.size()]);
            JOnASDeployer.invoke(this.undeployMethodwarService, this.warService, new Object[]{warURLs});
        }
        if ((ejb21Deployables = earDeployable.getEJB21Deployables()) != null && this.ejb21Service != null) {
            ArrayList<URL> urls = new ArrayList<URL>();
            for (EJB21Deployable ejbDeployable : ejb21Deployables) {
                try {
                    urls.add(ejbDeployable.getArchive().getURL());
                }
                catch (ArchiveException e) {
                    logger.error((Object)"Cannot get the URL from the Deployable ''{0}''", new Object[]{ejbDeployable, e});
                }
            }
            URL[] ejbJarURLs = urls.toArray(new URL[urls.size()]);
            JOnASDeployer.invoke(this.undeployMethodejb21Service, this.ejb21Service, new Object[]{ejbJarURLs});
        }
        this.undeployEJB3FromEAR(earDeployable);
        List rarDeployables = earDeployable.getRARDeployables();
        if (rarDeployables != null && this.rarService != null) {
            ArrayList<URL> urls = new ArrayList<URL>();
            for (RARDeployable rarDeployable : rarDeployables) {
                try {
                    urls.add(rarDeployable.getArchive().getURL());
                }
                catch (ArchiveException e) {
                    logger.error((Object)"Cannot get the URL from the Deployable ''{0}''", new Object[]{rarDeployable, e});
                }
            }
            URL[] rarURLs = urls.toArray(new URL[urls.size()]);
            JOnASDeployer.invoke(this.undeployMethodRarService, this.rarService, rarURLs, earURL);
        }
        logger.info((Object)"''{0}'' EAR Deployable is now undeployed", new Object[]{tmpEARDeployable});
    }

    protected void deployEAR(EARDeployable earDeployable) throws DeployerException {
        logger.info((Object)"Deploying {0}", new Object[]{earDeployable});
        URL earURL = null;
        try {
            earURL = earDeployable.getArchive().getURL();
        }
        catch (ArchiveException e) {
            throw new DeployerException("Cannot get the URL for the deployable '" + earDeployable + "'.", (Throwable)e);
        }
        URLClassLoader earClassLoader = (URLClassLoader)JOnASDeployer.newInstance(this.jClassLoaderConstructor, earURL.toExternalForm(), new URL[0], Thread.currentThread().getContextClassLoader());
        ArrayList<URL> urlsEJB = new ArrayList<URL>();
        for (EJBDeployable ejb : earDeployable.getEJBDeployables()) {
            try {
                urlsEJB.add(ejb.getArchive().getURL());
            }
            catch (ArchiveException e) {
                throw new DeployerException("Cannot get the URL for the archive '" + ejb.getArchive() + "'", (Throwable)e);
            }
        }
        ArrayList<URL> urlsWAR = new ArrayList<URL>();
        for (WARDeployable war : earDeployable.getWARDeployables()) {
            try {
                urlsWAR.add(war.getArchive().getURL());
            }
            catch (ArchiveException e) {
                throw new DeployerException("Cannot get the URL for the archive '" + war.getArchive() + "'", (Throwable)e);
            }
        }
        ArrayList<URL> urlsClient = new ArrayList<URL>();
        for (CARDeployable car : earDeployable.getCARDeployables()) {
            try {
                urlsClient.add(car.getArchive().getURL());
            }
            catch (ArchiveException e) {
                throw new DeployerException("Cannot get the URL for the archive '" + car.getArchive() + "'", (Throwable)e);
            }
        }
        JOnASDeployer.invoke(this.ejbSetAltDD, null, earClassLoader, urlsEJB.toArray(new URL[urlsEJB.size()]), new URL[urlsEJB.size()]);
        JOnASDeployer.invoke(this.webSetAltDD, null, earClassLoader, urlsWAR.toArray(new URL[urlsWAR.size()]), new URL[urlsWAR.size()]);
        JOnASDeployer.invoke(this.clientSetAltDD, null, earClassLoader, urlsClient.toArray(new URL[urlsClient.size()]), new URL[urlsClient.size()]);
        this.deployRARs(earDeployable, earURL, earClassLoader);
        List ejb3s = earDeployable.getEJB3Deployables();
        List ejbs = earDeployable.getEJBDeployables();
        List libs = earDeployable.getLibDeployables();
        ArrayList<URL> urls = new ArrayList<URL>();
        for (EJBDeployable ejb : ejbs) {
            try {
                urls.add(ejb.getArchive().getURL());
            }
            catch (ArchiveException e) {
                throw new DeployerException("Cannot get the URL for the Archive '" + ejb.getArchive() + "'.", (Throwable)e);
            }
        }
        for (LibDeployable lib : libs) {
            try {
                urls.add(lib.getArchive().getURL());
            }
            catch (ArchiveException e) {
                throw new DeployerException("Cannot get the URL for the Archive '" + lib.getArchive() + "'.", (Throwable)e);
            }
        }
        URL[] arrayURLs = urls.toArray(new URL[urls.size()]);
        EasyBeansClassLoader ejbClassLoader = new EasyBeansClassLoader(arrayURLs, (ClassLoader)earClassLoader);
        PersistenceUnitManager persistenceUnitManager = this.getPersistenceUnitManager(earDeployable, ejbClassLoader);
        List<IArchive> libArchives = this.getLibArchives(earDeployable);
        this.addEjbContextIdToList(earDeployable, new ArrayList<String>(), true);
        ArrayList<EZBContainer> containers = new ArrayList<EZBContainer>();
        for (EJB3Deployable ejb : ejb3s) {
            containers.add(this.getEmbedded().createContainer(ejb.getArchive()));
        }
        ApplicationJNDIResolver applicationJNDIResolver = new ApplicationJNDIResolver();
        InjectionHolder ejbInjectionHolder = new InjectionHolder();
        ejbInjectionHolder.setPersistenceUnitManager(persistenceUnitManager);
        ejbInjectionHolder.setJNDIResolver(applicationJNDIResolver);
        for (EZBContainer container : containers) {
            container.setClassLoader((ClassLoader)ejbClassLoader);
            container.setApplicationName(earDeployable.getModuleName());
            container.setPersistenceUnitManager((EZBPersistenceUnitManager)persistenceUnitManager);
            container.setExtraArchives(libArchives);
            EZBContainerJNDIResolver containerJNDIResolver = container.getConfiguration().getContainerJNDIResolver();
            containerJNDIResolver.setApplicationJNDIResolver((EZBApplicationJNDIResolver)applicationJNDIResolver);
            applicationJNDIResolver.addContainerJNDIResolver(containerJNDIResolver);
            try {
                container.resolve();
            }
            catch (EZBContainerException e) {
                throw new DeployerException("Cannot resolve the container '" + container.getArchive() + "'.", (Throwable)e);
            }
        }
        for (EZBContainer container : containers) {
            try {
                container.start();
            }
            catch (Exception e) {
                logger.error((Object)"Cannot start container {0}", new Object[]{container.getName(), e});
                try {
                    container.stop();
                    this.getEmbedded().removeContainer(container);
                }
                catch (Exception se) {
                    logger.error((Object)"Cannot stop failing container {0}", new Object[]{container.getName(), se});
                }
                throw new DeployerException("Container '" + container.getName() + "' has failed", (Throwable)e);
            }
        }
        this.deployEJB21s(earDeployable, earURL, earClassLoader, ejbClassLoader);
        this.linkPolicyObjects(earDeployable);
        this.commitEJBPolicyObjects(earDeployable);
        this.deployWARs(earDeployable, earURL, earClassLoader, ejbClassLoader);
        this.commitWebBPolicyObjects(earDeployable);
        logger.info((Object)"''{0}'' EAR Deployable is now deployed", new Object[]{earDeployable});
    }

    protected void deployWARs(EARDeployable earDeployable, URL earURL, ClassLoader earClassLoader, ClassLoader parentClassLoader) throws DeployerException {
        List wars = earDeployable.getWARDeployables();
        if (wars.size() > 0) {
            if (this.warService == null) {
                logger.warn((Object)"There are WAR files in the EAR ''{0}'' but the 'web' service is not available", new Object[]{earDeployable});
            } else {
                ContextImpl ctx = new ContextImpl(earURL.toExternalForm());
                try {
                    ctx.rebind("earURL", (Object)earURL);
                }
                catch (NamingException e) {
                    throw new DeployerException("Cannot add the EAR URL parameter '" + earURL + "'", (Throwable)e);
                }
                LinkedList<URL> urls = new LinkedList<URL>();
                LinkedList<String> ctxRoots = new LinkedList<String>();
                for (WARDeployable warDeployable : wars) {
                    URL url = null;
                    try {
                        url = warDeployable.getArchive().getURL();
                    }
                    catch (ArchiveException e) {
                        throw new DeployerException("Cannot get the URL for the archive '" + warDeployable.getArchive() + "'", (Throwable)e);
                    }
                    urls.add(url);
                    ctxRoots.add(warDeployable.getContextRoot());
                }
                try {
                    ctx.rebind("urls", (Object)urls.toArray(new URL[urls.size()]));
                }
                catch (NamingException e) {
                    throw new DeployerException("Cannot add the urls parameter '" + urls + "'", (Throwable)e);
                }
                try {
                    ctx.rebind("parentClassLoader", (Object)parentClassLoader);
                }
                catch (NamingException e) {
                    throw new DeployerException("Cannot add the parentClassLoader parameter '" + parentClassLoader + "'", (Throwable)e);
                }
                try {
                    ctx.rebind("earClassLoader", (Object)earClassLoader);
                }
                catch (NamingException e) {
                    throw new DeployerException("Cannot add the earClassLoader parameter '" + earClassLoader + "'", (Throwable)e);
                }
                try {
                    ctx.rebind("altDDs", (Object)new URL[urls.size()]);
                }
                catch (NamingException e) {
                    throw new DeployerException("Cannot add the altDDs parameter.'", (Throwable)e);
                }
                try {
                    ctx.rebind("contextRoots", (Object)ctxRoots.toArray(new String[ctxRoots.size()]));
                }
                catch (NamingException e) {
                    throw new DeployerException("Cannot add the contextRoots parameter '" + urls + "'", (Throwable)e);
                }
                try {
                    this.deployMethodwarService.invoke(this.warService, ctx);
                }
                catch (IllegalArgumentException e) {
                    throw new DeployerException("Cannot deploy the WARs.'", (Throwable)e);
                }
                catch (IllegalAccessException e) {
                    throw new DeployerException("Cannot deploy the WARs.'", (Throwable)e);
                }
                catch (InvocationTargetException e) {
                    throw new DeployerException("Cannot deploy the WARs.'", e.getTargetException());
                }
            }
        }
    }

    protected void deployRARs(EARDeployable earDeployable, URL earURL, ClassLoader earClassLoader) throws DeployerException {
        List rars = earDeployable.getRARDeployables();
        if (rars.size() > 0) {
            if (this.rarService == null) {
                logger.warn((Object)"There are RAR files in the EAR ''{0}'' but the resource service is not available", new Object[]{earDeployable});
            } else {
                ContextImpl ctx = new ContextImpl(earURL.toExternalForm());
                try {
                    ctx.rebind("earUrl", (Object)earURL);
                }
                catch (NamingException e) {
                    throw new DeployerException("Cannot add the EAR URL parameter '" + earURL + "'", (Throwable)e);
                }
                ArrayList<URL> urls = new ArrayList<URL>();
                for (RARDeployable rarDeployable : rars) {
                    try {
                        urls.add(rarDeployable.getArchive().getURL());
                    }
                    catch (ArchiveException e) {
                        throw new DeployerException("Cannot get the URL for the archive '" + rarDeployable.getArchive() + "'", (Throwable)e);
                    }
                }
                try {
                    ctx.rebind("urls", (Object)urls.toArray(new URL[urls.size()]));
                }
                catch (NamingException e) {
                    throw new DeployerException("Cannot add the urls parameter '" + urls + "'", (Throwable)e);
                }
                try {
                    ctx.rebind("earClassLoader", (Object)earClassLoader);
                }
                catch (NamingException e) {
                    throw new DeployerException("Cannot add the earClassLoader parameter '" + earClassLoader + "'", (Throwable)e);
                }
                try {
                    ctx.rebind("altDDs", (Object)new URL[urls.size()]);
                }
                catch (NamingException e) {
                    throw new DeployerException("Cannot add the altDDs parameter.'", (Throwable)e);
                }
                try {
                    this.deployMethodRarService.invoke(this.rarService, ctx);
                }
                catch (IllegalArgumentException e) {
                    throw new DeployerException("Cannot deploy the RARs.'", (Throwable)e);
                }
                catch (IllegalAccessException e) {
                    throw new DeployerException("Cannot deploy the RARs.'", (Throwable)e);
                }
                catch (InvocationTargetException e) {
                    throw new DeployerException("Cannot deploy the RARs.'", e.getTargetException());
                }
            }
        }
    }

    protected void deployEJB21s(EARDeployable earDeployable, URL earURL, URLClassLoader earClassLoader, ClassLoader ejbClassLoader) throws DeployerException {
        List ejbs = earDeployable.getEJB21Deployables();
        if (ejbs.size() > 0) {
            if (this.ejb21Service == null) {
                logger.warn((Object)"There are EJB 2.1 files in the EAR ''{0}'' but the EJB 2.1 service is not available", new Object[]{earDeployable});
            } else {
                ArrayList<URL> urls = new ArrayList<URL>();
                for (EJB21Deployable ejb21Deployable : ejbs) {
                    try {
                        urls.add(ejb21Deployable.getArchive().getURL());
                    }
                    catch (ArchiveException e) {
                        throw new DeployerException("Cannot get the URL for the archive '" + ejb21Deployable.getArchive() + "'", (Throwable)e);
                    }
                }
                URL[] compilationURLs = null;
                URL[] myApplicationJars = earClassLoader.getURLs();
                URL[] appsJars = ((URLClassLoader)earClassLoader.getParent()).getURLs();
                compilationURLs = new URL[myApplicationJars.length + appsJars.length + urls.size()];
                System.arraycopy(urls.toArray(new URL[urls.size()]), 0, compilationURLs, 0, urls.size());
                System.arraycopy(appsJars, 0, compilationURLs, urls.size(), appsJars.length);
                System.arraycopy(myApplicationJars, 0, compilationURLs, urls.size() + appsJars.length, myApplicationJars.length);
                if (this.checkGenICMethod != null) {
                    for (EJB21Deployable ejb : ejbs) {
                        URL ejbURL = null;
                        try {
                            ejbURL = ejb.getArchive().getURL();
                        }
                        catch (ArchiveException e) {
                            throw new DeployerException("Cannot get the URL on the deployable '" + ejb + "'", (Throwable)e);
                        }
                        logger.debug((Object)"Calling GenIC on the EJB ''{0}'' with compilation URL ''{1}''.", new Object[]{ejbURL, Arrays.asList(compilationURLs)});
                        JOnASDeployer.invoke(this.checkGenICMethod, this.ejb21Service, ejbURL.getFile(), compilationURLs);
                    }
                }
                ContextImpl ctx = new ContextImpl(earURL.toExternalForm());
                try {
                    ctx.rebind("earUrl", (Object)earURL);
                    ctx.rebind("earRootUrl", (Object)earURL);
                }
                catch (NamingException e) {
                    throw new DeployerException("Cannot add the EAR URL parameter '" + earURL + "'", (Throwable)e);
                }
                try {
                    ctx.rebind("jarURLs", (Object)urls.toArray(new URL[urls.size()]));
                }
                catch (NamingException e) {
                    throw new DeployerException("Cannot add the urls parameter '" + urls + "'", (Throwable)e);
                }
                try {
                    ctx.rebind("earClassLoader", (Object)earClassLoader);
                }
                catch (NamingException e) {
                    throw new DeployerException("Cannot add the earClassLoader parameter '" + earClassLoader + "'", (Throwable)e);
                }
                try {
                    ctx.rebind("ejbClassLoader", (Object)ejbClassLoader);
                }
                catch (NamingException e) {
                    throw new DeployerException("Cannot add the ejbClassLoader parameter '" + ejbClassLoader + "'", (Throwable)e);
                }
                try {
                    ctx.rebind("roleNames", (Object)new String[0]);
                }
                catch (NamingException e) {
                    throw new DeployerException("Cannot add the altDDs parameter.'", (Throwable)e);
                }
                try {
                    this.deployMethodejb21Service.invoke(this.ejb21Service, ctx);
                }
                catch (IllegalArgumentException e) {
                    throw new DeployerException("Cannot deploy the EJB 2.1'", (Throwable)e);
                }
                catch (IllegalAccessException e) {
                    throw new DeployerException("Cannot deploy the EJB 2.1'", (Throwable)e);
                }
                catch (InvocationTargetException e) {
                    throw new DeployerException("Cannot deploy the EJB 2.1'", e.getTargetException());
                }
            }
        }
    }

    private void checkSupportedDeployable(IDeployable deployable) throws DeployerException {
        if (!(deployable instanceof EARDeployable) && !(deployable instanceof EJBDeployable)) {
            throw new DeployerException("The deployable '" + deployable + "' is not supported by this deployer");
        }
    }

    private void linkPolicyObjects(EARDeployable earDeployable) throws DeployerException {
        LinkedList<String> ctxIDs = new LinkedList<String>();
        this.addEjbContextIdToList(earDeployable, ctxIDs, false);
        this.addWebBContextIdToList(earDeployable, ctxIDs, true);
        try {
            for (String toBeLinkedCtxId : ctxIDs) {
                PolicyConfiguration toBeLinkedPC = this.getPolicyConfigurationFactory().getPolicyConfiguration(toBeLinkedCtxId, false);
                for (String linkedCtxId : ctxIDs) {
                    if (toBeLinkedCtxId.equals(linkedCtxId)) continue;
                    PolicyConfiguration linkedPC = this.getPolicyConfigurationFactory().getPolicyConfiguration(linkedCtxId, false);
                    toBeLinkedPC.linkConfiguration(linkedPC);
                }
            }
        }
        catch (PolicyContextException pce) {
            throw new DeployerException("Cannot retrieve a policy configuration", (Throwable)pce);
        }
    }

    private void addEjbContextIdToList(EARDeployable earDeployable, List<String> contextIDs, boolean resetPolicyConfiguration) throws DeployerException {
        List ejbDeployables = earDeployable.getEJBDeployables();
        ArrayList<URL> urls = new ArrayList<URL>();
        if (ejbDeployables != null) {
            for (EJBDeployable ejbDeployable : ejbDeployables) {
                try {
                    urls.add(ejbDeployable.getArchive().getURL());
                }
                catch (ArchiveException e) {
                    throw new DeployerException("Cannot get URL on the deployable '" + ejbDeployable + "'.", (Throwable)e);
                }
            }
        }
        URL[] jarUrls = urls.toArray(new URL[urls.size()]);
        for (int u = 0; u < jarUrls.length; ++u) {
            String ctxId = jarUrls[u].getPath();
            if (resetPolicyConfiguration) {
                try {
                    this.getPolicyConfigurationFactory().getPolicyConfiguration(ctxId, true);
                }
                catch (PolicyContextException pce) {
                    throw new DeployerException("Cannot retrieve a policy configuration", (Throwable)pce);
                }
            }
            contextIDs.add(ctxId);
        }
    }

    private void addWebBContextIdToList(EARDeployable earDeployable, List<String> contextIDs, boolean resetPolicyConfiguration) throws DeployerException {
        List warDeployables = earDeployable.getWARDeployables();
        if (warDeployables != null) {
            for (WARDeployable warDeployable : warDeployables) {
                URL warURL = null;
                try {
                    warURL = warDeployable.getArchive().getURL();
                }
                catch (ArchiveException e) {
                    throw new DeployerException("Cannot get URL on the deployable '" + warDeployable + "'.", (Throwable)e);
                }
                String ctxId = warURL.getFile() + warDeployable.getContextRoot();
                if (resetPolicyConfiguration) {
                    try {
                        this.getPolicyConfigurationFactory().getPolicyConfiguration(ctxId, true);
                    }
                    catch (PolicyContextException pce) {
                        throw new DeployerException("Cannot retrieve a policy configuration", (Throwable)pce);
                    }
                }
                contextIDs.add(ctxId);
            }
        }
    }

    private void commitEJBPolicyObjects(EARDeployable earDeployable) throws DeployerException {
        LinkedList<String> ctxIDs = new LinkedList<String>();
        this.addEjbContextIdToList(earDeployable, ctxIDs, false);
        this.commitPolicyObjects(ctxIDs);
    }

    private void commitWebBPolicyObjects(EARDeployable earDeployable) throws DeployerException {
        LinkedList<String> ctxIDs = new LinkedList<String>();
        this.addWebBContextIdToList(earDeployable, ctxIDs, false);
        this.commitPolicyObjects(ctxIDs);
    }

    private PolicyConfigurationFactory getPolicyConfigurationFactory() throws DeployerException {
        PolicyConfigurationFactory pcFactory = null;
        try {
            pcFactory = PolicyConfigurationFactory.getPolicyConfigurationFactory();
        }
        catch (Exception cnfe) {
            throw new DeployerException("Cannot retrieve current policy configuration factory", (Throwable)cnfe);
        }
        return pcFactory;
    }

    private void commitPolicyObjects(List ctxIDs) throws DeployerException {
        String ctxId2 = null;
        try {
            for (String ctxId2 : ctxIDs) {
                PolicyConfiguration pc = this.getPolicyConfigurationFactory().getPolicyConfiguration(ctxId2, false);
                pc.commit();
            }
        }
        catch (PolicyContextException pce) {
            throw new DeployerException("Cannot commit policy configuration with Id '" + ctxId2 + "'", (Throwable)pce);
        }
        Policy.getPolicy().refresh();
    }
}

