/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.deployment.resolver;

import java.net.URL;
import org.ow2.easybeans.api.EZBContainer;
import org.ow2.easybeans.api.bean.info.EZBBeanNamingInfo;
import org.ow2.easybeans.api.naming.EZBNamingStrategy;
import org.ow2.easybeans.deployment.Deployment;
import org.ow2.easybeans.deployment.metadata.ejbjar.EjbJarArchiveMetadata;
import org.ow2.easybeans.deployment.metadata.ejbjar.EjbJarClassMetadata;
import org.ow2.easybeans.naming.BeanNamingInfo;
import org.ow2.easybeans.naming.BeanNamingInfoHelper;
import org.ow2.easybeans.naming.strategy.DefaultNamingStrategy;
import org.ow2.easybeans.resolver.JNDIData;
import org.ow2.easybeans.resolver.api.EZBContainerJNDIResolver;
import org.ow2.easybeans.resolver.api.EZBJNDIData;
import org.ow2.util.archive.api.ArchiveException;
import org.ow2.util.archive.api.IArchive;
import org.ow2.util.ee.metadata.ejbjar.api.struct.IJLocal;
import org.ow2.util.ee.metadata.ejbjar.api.struct.IJRemote;

public class JNDIResolverHelper {
    private EZBContainerJNDIResolver containerJNDIResolver = null;
    private String applicationName = null;

    public JNDIResolverHelper(EZBContainer container) {
        this.containerJNDIResolver = container.getConfiguration().getContainerJNDIResolver();
        this.applicationName = container.getApplicationName();
    }

    public void addDeployment(Deployment deployment) {
        URL url;
        EjbJarArchiveMetadata ejbJarAnnotationMetadata = deployment.getEjbJarArchiveMetadata();
        IArchive archive = deployment.getArchive();
        try {
            url = archive.getURL();
        }
        catch (ArchiveException e) {
            throw new IllegalStateException("Cannot get the URL on the archive '" + archive + "'.", e);
        }
        Object namingStrategy = null;
        namingStrategy = deployment.getConfiguration() != null ? deployment.getConfiguration().getNamingStrategy() : new DefaultNamingStrategy();
        this.analyzeMetadata(ejbJarAnnotationMetadata, (EZBNamingStrategy)namingStrategy, url);
    }

    private void analyzeMetadata(EjbJarArchiveMetadata ejbJarAnnotationMetadata, EZBNamingStrategy namingStrategy, URL url) {
        for (EjbJarClassMetadata classAnnotationMetadata : ejbJarAnnotationMetadata.getEjbJarClassMetadataCollection()) {
            String localHome;
            String remoteHome;
            BeanNamingInfo namingInfo;
            if (!classAnnotationMetadata.isBean()) continue;
            IJLocal localItfs = classAnnotationMetadata.getLocalInterfaces();
            IJRemote remoteItfs = classAnnotationMetadata.getRemoteInterfaces();
            if (localItfs != null) {
                for (String itf : localItfs.getInterfaces()) {
                    namingInfo = BeanNamingInfoHelper.buildInfo(classAnnotationMetadata, itf, "Local", this.applicationName);
                    this.addInterface(namingInfo, namingStrategy, url);
                }
            }
            if (remoteItfs != null) {
                for (String itf : remoteItfs.getInterfaces()) {
                    namingInfo = BeanNamingInfoHelper.buildInfo(classAnnotationMetadata, itf, "Remote", this.applicationName);
                    this.addInterface(namingInfo, namingStrategy, url);
                }
            }
            if ((remoteHome = classAnnotationMetadata.getRemoteHome()) != null) {
                BeanNamingInfo namingInfo2 = BeanNamingInfoHelper.buildInfo(classAnnotationMetadata, remoteHome, "RemoteHome", this.applicationName);
                this.addInterface(namingInfo2, namingStrategy, url);
            }
            if ((localHome = classAnnotationMetadata.getLocalHome()) == null) continue;
            namingInfo = BeanNamingInfoHelper.buildInfo(classAnnotationMetadata, localHome, "LocalHome", this.applicationName);
            this.addInterface(namingInfo, namingStrategy, url);
        }
    }

    private void addInterface(EZBBeanNamingInfo beanNamingInfo, EZBNamingStrategy namingStrategy, URL containerURL) {
        String jndiName = namingStrategy.getJNDIName(beanNamingInfo);
        String interfaceName = beanNamingInfo.getInterfaceName();
        String beanName = beanNamingInfo.getName();
        this.containerJNDIResolver.addJNDIName(interfaceName, (EZBJNDIData)new JNDIData(jndiName, beanName));
    }
}

