/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.enhancer.interceptors;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.ow2.easybeans.api.bean.lifecycle.EasyBeansMDBLifeCycle;
import org.ow2.easybeans.api.bean.lifecycle.EasyBeansSFSBLifeCycle;
import org.ow2.easybeans.api.bean.lifecycle.EasyBeansSLSBLifeCycle;
import org.ow2.easybeans.asm.ClassAdapter;
import org.ow2.easybeans.asm.ClassVisitor;
import org.ow2.easybeans.asm.Label;
import org.ow2.easybeans.asm.MethodAdapter;
import org.ow2.easybeans.asm.MethodVisitor;
import org.ow2.easybeans.asm.Opcodes;
import org.ow2.easybeans.asm.Type;
import org.ow2.easybeans.deployment.metadata.ejbjar.EjbJarClassMetadata;
import org.ow2.easybeans.deployment.metadata.ejbjar.EjbJarMethodMetadata;
import org.ow2.easybeans.enhancer.CommonClassGenerator;
import org.ow2.easybeans.enhancer.DefinedClass;
import org.ow2.easybeans.enhancer.bean.BeanClassAdapter;
import org.ow2.easybeans.enhancer.injection.InjectionClassAdapter;
import org.ow2.easybeans.enhancer.interceptors.EasyBeansInvocationContextGenerator;
import org.ow2.easybeans.enhancer.interceptors.InterceptorManagerGenerator;
import org.ow2.easybeans.enhancer.lib.MethodRenamer;
import org.ow2.util.ee.metadata.ejbjar.api.IJClassInterceptor;
import org.ow2.util.ee.metadata.ejbjar.api.InterceptorType;
import org.ow2.util.scan.api.metadata.specific.ISpecificMethodMetadata;
import org.ow2.util.scan.api.metadata.structures.JMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InterceptorClassAdapter
extends ClassAdapter
implements Opcodes {
    private EjbJarClassMetadata classAnnotationMetadata;
    private List<JMethod> renamedMethods = null;
    private List<DefinedClass> definedClasses = null;
    private List<InterceptorType> generatedTypes = null;
    private List<String> beanInterceptors = null;
    private boolean addInterface = true;

    public InterceptorClassAdapter(EjbJarClassMetadata classAnnotationMetadata, ClassVisitor cv) {
        this(classAnnotationMetadata, cv, false);
        this.beanInterceptors = new ArrayList<String>();
    }

    public InterceptorClassAdapter(EjbJarClassMetadata classAnnotationMetadata, ClassVisitor cv, boolean addInterface) {
        super(cv);
        this.classAnnotationMetadata = classAnnotationMetadata;
        this.renamedMethods = new ArrayList<JMethod>();
        this.definedClasses = new ArrayList<DefinedClass>();
        this.addInterface = addInterface;
        this.generatedTypes = new ArrayList<InterceptorType>();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        String[] newInterfaces = null;
        if (this.classAnnotationMetadata.isBean() && this.addInterface) {
            newInterfaces = new String[interfaces.length + 1];
            System.arraycopy(interfaces, 0, newInterfaces, 0, interfaces.length);
            int indexElement = newInterfaces.length - 1;
            if (this.classAnnotationMetadata.isStateless()) {
                newInterfaces[indexElement] = Type.getInternalName(EasyBeansSLSBLifeCycle.class);
            } else if (this.classAnnotationMetadata.isStateful()) {
                newInterfaces[indexElement] = Type.getInternalName(EasyBeansSFSBLifeCycle.class);
            } else {
                if (!this.classAnnotationMetadata.isMdb()) throw new IllegalStateException("Bean '" + this.classAnnotationMetadata.getClassName() + "' not SLSB, SFSB or MDB");
                newInterfaces[indexElement] = Type.getInternalName(EasyBeansMDBLifeCycle.class);
            }
        } else {
            newInterfaces = interfaces;
        }
        super.visit(version, access, name, signature, superName, newInterfaces);
    }

    @Override
    public void visitInnerClass(String name, String outerName, String innerName, int access) {
        super.visitInnerClass(name, outerName, innerName, access);
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        JMethod jMethod = new JMethod(access, name, desc, signature, exceptions);
        String newName = name;
        int newAccess = access;
        if (this.isInterceptedMethod(jMethod) && this.classAnnotationMetadata.isBean()) {
            this.renamedMethods.add(jMethod);
            newName = MethodRenamer.encode(name);
        }
        if (!this.isDependencyInjectionMethod(jMethod) && !this.isInjectedMethod(jMethod) && this.isInterceptorMethod(jMethod)) {
            newAccess = 1;
        }
        return new MethodAdapter(super.visitMethod(newAccess, newName, desc, signature, exceptions));
    }

    @Override
    public void visitEnd() {
        super.visitEnd();
        if (this.classAnnotationMetadata.isBean()) {
            EjbJarMethodMetadata posConsMetaData = this.generateBeanLifeCycleMethod(this.classAnnotationMetadata, InterceptorType.POST_CONSTRUCT);
            EjbJarMethodMetadata preDesMetaData = this.generateBeanLifeCycleMethod(this.classAnnotationMetadata, InterceptorType.PRE_DESTROY);
            EjbJarMethodMetadata postActMetaData = this.generateBeanLifeCycleMethod(this.classAnnotationMetadata, InterceptorType.POST_ACTIVATE);
            EjbJarMethodMetadata prePassMetaData = this.generateBeanLifeCycleMethod(this.classAnnotationMetadata, InterceptorType.PRE_PASSIVATE);
            this.generateClass(new EjbJarMethodMetadata(InjectionClassAdapter.INJECTED_JMETHOD, this.classAnnotationMetadata), InterceptorType.DEP_INJECT);
            EjbJarMethodMetadata timerMethodAnnotationMetadata = null;
            for (EjbJarMethodMetadata m : this.classAnnotationMetadata.getSpecificMethodMetadataCollection()) {
                if (!m.isTimeout()) continue;
                timerMethodAnnotationMetadata = (EjbJarMethodMetadata)m.clone();
                timerMethodAnnotationMetadata.setJMethod(BeanClassAdapter.TIMER_JMETHOD);
                timerMethodAnnotationMetadata.setSpecificClassMetadata(this.classAnnotationMetadata);
                timerMethodAnnotationMetadata.setInherited(false, null);
                break;
            }
            if (timerMethodAnnotationMetadata == null) {
                timerMethodAnnotationMetadata = new EjbJarMethodMetadata(BeanClassAdapter.TIMER_JMETHOD, this.classAnnotationMetadata);
            }
            this.generateClass(timerMethodAnnotationMetadata, InterceptorType.TIMED_OBJECT);
            for (EjbJarMethodMetadata method : this.classAnnotationMetadata.getSpecificMethodMetadataCollection()) {
                if (!method.isBusinessMethod()) continue;
                this.generateClass(method, InterceptorType.AROUND_INVOKE);
                if (this.renamedMethods.contains(method.getJMethod())) continue;
                this.generateCallSuperEncodedMethod(method);
            }
            this.generateClass(posConsMetaData, InterceptorType.POST_CONSTRUCT);
            this.generateClass(preDesMetaData, InterceptorType.PRE_DESTROY);
            this.generateClass(prePassMetaData, InterceptorType.PRE_PASSIVATE);
            this.generateClass(postActMetaData, InterceptorType.POST_ACTIVATE);
            String generatedClName = this.classAnnotationMetadata.getClassName() + "InterceptorManager";
            InterceptorManagerGenerator interceptorManagerGenerator = new InterceptorManagerGenerator(this.classAnnotationMetadata.getEjbJarArchiveMetadata(), generatedClName, this.beanInterceptors);
            interceptorManagerGenerator.generate();
            DefinedClass dc = new DefinedClass(generatedClName.replace("/", "."), interceptorManagerGenerator.getBytes());
            this.definedClasses.add(dc);
        }
    }

    private void generateCallToInvocationContext(EjbJarMethodMetadata method, EasyBeansInvocationContextGenerator genInvCtx, InterceptorType interceptorType) {
        int block;
        String generatedMethodName = null;
        switch (interceptorType) {
            case AROUND_INVOKE: {
                generatedMethodName = method.getMethodName();
                break;
            }
            case DEP_INJECT: 
            case TIMED_OBJECT: {
                generatedMethodName = MethodRenamer.decode(method.getMethodName());
                break;
            }
            case POST_CONSTRUCT: {
                generatedMethodName = "postConstructEasyBeansLifeCycle";
                break;
            }
            case PRE_DESTROY: {
                generatedMethodName = "preDestroyEasyBeansLifeCycle";
                break;
            }
            case PRE_PASSIVATE: {
                generatedMethodName = "prePassivateEasyBeansLifeCycle";
                break;
            }
            case POST_ACTIVATE: {
                generatedMethodName = "postActivateEasyBeansLifeCycle";
                break;
            }
            default: {
                throw new RuntimeException("No generated method name found for method '" + method.getMethodName() + "'");
            }
        }
        if (generatedMethodName == null) {
            throw new RuntimeException("No generated method name found for method '" + method.getMethodName() + "'");
        }
        MethodVisitor mv = this.cv.visitMethod(1, generatedMethodName, method.getJMethod().getDescriptor(), null, method.getJMethod().getExceptions());
        mv.visitCode();
        Label tryLabel = new Label();
        mv.visitLabel(tryLabel);
        mv.visitTypeInsn(187, genInvCtx.getGeneratedClassName());
        mv.visitInsn(89);
        mv.visitVarInsn(25, 0);
        Type[] args = Type.getArgumentTypes(method.getJMethod().getDescriptor());
        int methodArg = 1;
        for (Type type : args) {
            int opCode = CommonClassGenerator.putFieldLoadOpCode(type.getSort());
            mv.visitVarInsn(opCode, methodArg);
            if (opCode == 22 || opCode == 24) {
                ++methodArg;
            }
            ++methodArg;
        }
        Type returnType = Type.getReturnType(method.getJMethod().getDescriptor());
        String constructorDesc = genInvCtx.getConstructorDesc();
        mv.visitMethodInsn(183, genInvCtx.getGeneratedClassName(), "<init>", constructorDesc);
        mv.visitMethodInsn(182, genInvCtx.getGeneratedClassName(), "proceed", "()Ljava/lang/Object;");
        CommonClassGenerator.transformObjectIntoPrimitive(returnType, mv);
        CommonClassGenerator.addReturnType(returnType, mv);
        boolean methodAlreadyThrowJavaLangException = false;
        String[] methodExceptions = method.getJMethod().getExceptions();
        Label[] catchsLabel = null;
        if (methodExceptions != null) {
            if (Arrays.asList(methodExceptions).contains("java/lang/Exception")) {
                methodAlreadyThrowJavaLangException = true;
                catchsLabel = new Label[methodExceptions.length];
            } else {
                catchsLabel = new Label[methodExceptions.length + 1];
            }
        } else {
            catchsLabel = new Label[1];
        }
        for (int i = 0; i < catchsLabel.length; ++i) {
            catchsLabel[i] = new Label();
        }
        int lastCatchBlockLabel = 0;
        lastCatchBlockLabel = methodAlreadyThrowJavaLangException ? catchsLabel.length : catchsLabel.length - 1;
        for (block = 0; block < lastCatchBlockLabel; ++block) {
            mv.visitLabel(catchsLabel[block]);
            mv.visitVarInsn(58, methodArg);
            mv.visitVarInsn(25, methodArg);
            mv.visitInsn(191);
        }
        if (!methodAlreadyThrowJavaLangException) {
            mv.visitLabel(catchsLabel[lastCatchBlockLabel]);
            mv.visitVarInsn(58, methodArg);
            mv.visitVarInsn(25, methodArg);
            mv.visitTypeInsn(193, "java/lang/RuntimeException");
            Label notInstanceOfRuntimeExceptionLabel = new Label();
            mv.visitJumpInsn(153, notInstanceOfRuntimeExceptionLabel);
            mv.visitVarInsn(25, methodArg);
            mv.visitTypeInsn(192, "java/lang/RuntimeException");
            mv.visitInsn(191);
            mv.visitLabel(notInstanceOfRuntimeExceptionLabel);
            mv.visitTypeInsn(187, "java/lang/RuntimeException");
            mv.visitInsn(89);
            mv.visitVarInsn(25, methodArg);
            mv.visitMethodInsn(183, "java/lang/RuntimeException", "<init>", "(Ljava/lang/Throwable;)V");
            mv.visitInsn(191);
        }
        block = 0;
        if (methodExceptions != null) {
            for (String exception : methodExceptions) {
                mv.visitTryCatchBlock(tryLabel, catchsLabel[0], catchsLabel[block], exception);
                ++block;
            }
        }
        if (!methodAlreadyThrowJavaLangException) {
            mv.visitTryCatchBlock(tryLabel, catchsLabel[0], catchsLabel[lastCatchBlockLabel], "java/lang/Exception");
        }
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private void generateClass(EjbJarMethodMetadata method, InterceptorType interceptorType) {
        EasyBeansInvocationContextGenerator genInvCtx = new EasyBeansInvocationContextGenerator(method, interceptorType);
        genInvCtx.generate();
        for (IJClassInterceptor interceptor : genInvCtx.getAllInterceptors()) {
            String interceptorClassName = interceptor.getClassName();
            if (interceptorClassName.equals(this.classAnnotationMetadata.getClassName()) || this.beanInterceptors.contains(interceptorClassName)) continue;
            this.beanInterceptors.add(interceptorClassName);
        }
        DefinedClass dc = new DefinedClass(genInvCtx.getGeneratedClassName().replace("/", "."), genInvCtx.getBytes());
        this.definedClasses.add(dc);
        this.generatedTypes.add(interceptorType);
        this.generateCallToInvocationContext(method, genInvCtx, interceptorType);
    }

    private void generateCallSuperEncodedMethod(EjbJarMethodMetadata method) {
        String generatedMethodName = MethodRenamer.encode(method.getMethodName());
        JMethod jMethod = method.getJMethod();
        MethodVisitor mv = this.cv.visitMethod(jMethod.getAccess(), generatedMethodName, jMethod.getDescriptor(), jMethod.getSignature(), jMethod.getExceptions());
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        Type[] args = Type.getArgumentTypes(jMethod.getDescriptor());
        int methodArg = 1;
        for (Type type : args) {
            int opCode = CommonClassGenerator.putFieldLoadOpCode(type.getSort());
            mv.visitVarInsn(opCode, methodArg);
            if (opCode == 22 || opCode == 24) {
                ++methodArg;
            }
            ++methodArg;
        }
        mv.visitMethodInsn(183, method.getClassMetadata().getSuperName(), jMethod.getName(), jMethod.getDescriptor());
        Type returnType = Type.getReturnType(jMethod.getDescriptor());
        CommonClassGenerator.addReturnType(returnType, mv);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private EjbJarMethodMetadata generateBeanLifeCycleMethod(EjbJarClassMetadata classMetaData, InterceptorType interceptorType) {
        String generatedMethodName = null;
        LinkedList<EjbJarMethodMetadata> existingLifecycleMethods = null;
        switch (interceptorType) {
            case AROUND_INVOKE: 
            case DEP_INJECT: 
            case TIMED_OBJECT: {
                return null;
            }
            case POST_CONSTRUCT: {
                generatedMethodName = "beanPostConstruct$generated";
                existingLifecycleMethods = classMetaData.getPostConstructMethodsMetadata();
                break;
            }
            case PRE_DESTROY: {
                generatedMethodName = "beanPreDestroy$generated";
                existingLifecycleMethods = classMetaData.getPreDestroyMethodsMetadata();
                break;
            }
            case PRE_PASSIVATE: {
                generatedMethodName = "beanPrePassivate$generated";
                existingLifecycleMethods = classMetaData.getPrePassivateMethodsMetadata();
                break;
            }
            case POST_ACTIVATE: {
                generatedMethodName = "beanPostActivate$generated";
                existingLifecycleMethods = classMetaData.getPostActivateMethodsMetadata();
                break;
            }
            default: {
                throw new RuntimeException("No generated method name found for interceptorType '" + interceptorType + "'");
            }
        }
        MethodVisitor mv = this.cv.visitMethod(1, generatedMethodName, "()V", null, null);
        mv.visitCode();
        if (existingLifecycleMethods != null) {
            for (EjbJarMethodMetadata method : existingLifecycleMethods) {
                String clName = method.getClassMetadata().getClassName();
                mv.visitVarInsn(25, 0);
                int opcode = 182;
                if (method.isInherited()) {
                    clName = method.getOriginalClassMetadata().getClassName();
                    opcode = 183;
                }
                mv.visitMethodInsn(opcode, clName, method.getMethodName(), method.getJMethod().getDescriptor());
            }
        }
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        JMethod method = new JMethod(1, generatedMethodName, "()V", null, null);
        EjbJarMethodMetadata generatedMetadata = new EjbJarMethodMetadata(method, classMetaData);
        switch (interceptorType) {
            case POST_CONSTRUCT: {
                generatedMetadata.setPostConstruct(true);
                break;
            }
            case PRE_DESTROY: {
                generatedMetadata.setPreDestroy(true);
                break;
            }
            case PRE_PASSIVATE: {
                generatedMetadata.setPrePassivate(true);
                break;
            }
            case POST_ACTIVATE: {
                generatedMetadata.setPostActivate(true);
                break;
            }
            default: {
                throw new RuntimeException("No generated method name found for interceptorType '" + interceptorType + "'");
            }
        }
        classMetaData.addSpecificMethodMetadata((ISpecificMethodMetadata)generatedMetadata);
        return generatedMetadata;
    }

    private boolean isDependencyInjectionMethod(JMethod jMethod) {
        return "injectedByEasyBeans".equals(jMethod.getName());
    }

    private boolean isInjectedMethod(JMethod jMethod) {
        for (String method : InjectionClassAdapter.INJECTED_METHODS) {
            if (!method.equals(jMethod.getName())) continue;
            return true;
        }
        return false;
    }

    private boolean isInterceptedMethod(JMethod jMethod) {
        if (this.isDependencyInjectionMethod(jMethod)) {
            return this.classAnnotationMetadata.isBean();
        }
        if (this.isInjectedMethod(jMethod)) {
            return false;
        }
        EjbJarMethodMetadata method = (EjbJarMethodMetadata)this.classAnnotationMetadata.getSpecificMethodMetadata(jMethod);
        if (method == null) {
            throw new IllegalStateException("Cannot find a method " + jMethod + " in class " + this.classAnnotationMetadata.getClassName());
        }
        return method.isBusinessMethod();
    }

    private boolean isInterceptorMethod(JMethod jMethod) {
        EjbJarMethodMetadata method = (EjbJarMethodMetadata)this.classAnnotationMetadata.getSpecificMethodMetadata(jMethod);
        if (method == null) {
            throw new IllegalStateException("Cannot find a method " + jMethod + " in class " + this.classAnnotationMetadata.getClassName());
        }
        return method.isAroundInvoke() || method.isLifeCycleMethod();
    }

    public List<DefinedClass> getDefinedClasses() {
        return this.definedClasses;
    }
}

