/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.naming;

import java.lang.reflect.Method;
import java.util.LinkedList;
import java.util.List;
import org.ow2.easybeans.api.EZBContainer;
import org.ow2.easybeans.api.EZBServer;
import org.ow2.easybeans.api.Factory;
import org.ow2.easybeans.container.session.stateful.StatefulSessionFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class J2EEManagedObjectNamingHelper {
    private static final String EASYBEANS_ROOT = "/easybeans";

    private J2EEManagedObjectNamingHelper() {
    }

    public static String getJ2EEManagedObjectId(Object instance) throws IllegalArgumentException {
        Class<?> clazz = instance.getClass();
        if (EZBServer.class.isAssignableFrom(clazz)) {
            return EASYBEANS_ROOT;
        }
        if (EZBContainer.class.isAssignableFrom(clazz)) {
            EZBContainer container = (EZBContainer)instance;
            String archiveName = container.getArchive().getName().replaceAll("(.*[/\\\\])", "");
            return "/easybeans/" + container.getApplicationName() + "/" + archiveName;
        }
        if (Factory.class.isAssignableFrom(clazz)) {
            Factory factory = (Factory)instance;
            EZBContainer container = factory.getContainer();
            String archiveName = container.getArchive().getName().replaceAll("(.*[/\\\\])", "");
            String factoryName = factory.getClassName().replaceAll("(.*\\.)", "");
            return "/easybeans/" + container.getApplicationName() + "/" + archiveName + "/" + factoryName;
        }
        throw new IllegalArgumentException("Name is not define for argument of type " + instance.getClass());
    }

    public static String getMethodSignature(Method method) {
        String signature = method.getName();
        for (Class<?> clazz : method.getParameterTypes()) {
            signature = signature + "_" + clazz.getName();
        }
        return signature;
    }

    public static List<String> getBeanMethodsManagedObjectIds(Factory<?, ?> factory) {
        LinkedList<String> result = new LinkedList<String>();
        LinkedList<Method> methods = new LinkedList<Method>();
        methods.addAll(factory.getLocalInterfaceMethods());
        methods.addAll(factory.getRemoteInterfaceMethods());
        if (StatefulSessionFactory.class.isAssignableFrom(factory.getClass())) {
            try {
                methods.add(StatefulSessionFactory.class.getMethod("toString", new Class[0]));
            }
            catch (Throwable e) {
                // empty catch block
            }
        }
        String factoryId = J2EEManagedObjectNamingHelper.getJ2EEManagedObjectId(factory);
        for (Method method : methods) {
            result.add(factoryId + "/" + J2EEManagedObjectNamingHelper.getMethodSignature(method));
        }
        return result;
    }

    public static String getEasybeansRootFilter() {
        return J2EEManagedObjectNamingHelper.encodeJ2EEManagedObjectFilter(EASYBEANS_ROOT);
    }

    public static String getAllJ2EEManagedObjectsFilter() {
        return J2EEManagedObjectNamingHelper.getEasybeansRootFilter() + "(/[^/]+){0,4}";
    }

    public static String getAllApplicationsFilter() {
        return J2EEManagedObjectNamingHelper.getEasybeansRootFilter() + "/[^/]+";
    }

    public static String getAllJarsFilter() {
        return J2EEManagedObjectNamingHelper.getAllApplicationsFilter() + "/[^/]+";
    }

    public static String getAllBeansFilter() {
        return J2EEManagedObjectNamingHelper.getAllJarsFilter() + "/[^/]+";
    }

    public static String getAllMethodsFilter() {
        return J2EEManagedObjectNamingHelper.getAllBeansFilter() + "/[^/]+";
    }

    public static String getAllRelativeApplicationsFilter(String j2eeManagedObjectId) {
        if (j2eeManagedObjectId.matches(J2EEManagedObjectNamingHelper.getEasybeansRootFilter())) {
            return J2EEManagedObjectNamingHelper.encodeJ2EEManagedObjectFilter(j2eeManagedObjectId) + "/[^/]+";
        }
        if (j2eeManagedObjectId.matches(J2EEManagedObjectNamingHelper.getAllApplicationsFilter())) {
            return J2EEManagedObjectNamingHelper.encodeJ2EEManagedObjectFilter(j2eeManagedObjectId);
        }
        throw new IllegalArgumentException("Cannot proccess RelativeApplicationsFilter from id " + j2eeManagedObjectId);
    }

    public static String getAllRelativeJarsFilter(String j2eeManagedObjectId) {
        if (j2eeManagedObjectId.matches(J2EEManagedObjectNamingHelper.getEasybeansRootFilter())) {
            return J2EEManagedObjectNamingHelper.encodeJ2EEManagedObjectFilter(j2eeManagedObjectId) + "/[^/]+/[^/]+";
        }
        if (j2eeManagedObjectId.matches(J2EEManagedObjectNamingHelper.getAllApplicationsFilter())) {
            return J2EEManagedObjectNamingHelper.encodeJ2EEManagedObjectFilter(j2eeManagedObjectId) + "/[^/]+";
        }
        if (j2eeManagedObjectId.matches(J2EEManagedObjectNamingHelper.getAllJarsFilter())) {
            return J2EEManagedObjectNamingHelper.encodeJ2EEManagedObjectFilter(j2eeManagedObjectId);
        }
        throw new IllegalArgumentException("Cannot proccess RelativeApplicationsFilter from id " + j2eeManagedObjectId);
    }

    public static String getAllRelativeBeansFilter(String j2eeManagedObjectId) {
        if (j2eeManagedObjectId.matches(J2EEManagedObjectNamingHelper.getEasybeansRootFilter())) {
            return J2EEManagedObjectNamingHelper.encodeJ2EEManagedObjectFilter(j2eeManagedObjectId) + "/[^/]+/[^/]+/[^/]+";
        }
        if (j2eeManagedObjectId.matches(J2EEManagedObjectNamingHelper.getAllApplicationsFilter())) {
            return J2EEManagedObjectNamingHelper.encodeJ2EEManagedObjectFilter(j2eeManagedObjectId) + "/[^/]+/[^/]+";
        }
        if (j2eeManagedObjectId.matches(J2EEManagedObjectNamingHelper.getAllJarsFilter())) {
            return J2EEManagedObjectNamingHelper.encodeJ2EEManagedObjectFilter(j2eeManagedObjectId) + "/[^/]+";
        }
        if (j2eeManagedObjectId.matches(J2EEManagedObjectNamingHelper.getAllBeansFilter())) {
            return J2EEManagedObjectNamingHelper.encodeJ2EEManagedObjectFilter(j2eeManagedObjectId);
        }
        throw new IllegalArgumentException("Cannot proccess RelativeBeansFilter from id " + j2eeManagedObjectId);
    }

    public static String getAllRelativeMethodsFilter(String j2eeManagedObjectId) {
        if (j2eeManagedObjectId.matches(J2EEManagedObjectNamingHelper.getEasybeansRootFilter())) {
            return J2EEManagedObjectNamingHelper.encodeJ2EEManagedObjectFilter(j2eeManagedObjectId) + "/[^/]+/[^/]+/[^/]+/[^/]+";
        }
        if (j2eeManagedObjectId.matches(J2EEManagedObjectNamingHelper.getAllApplicationsFilter())) {
            return J2EEManagedObjectNamingHelper.encodeJ2EEManagedObjectFilter(j2eeManagedObjectId) + "/[^/]+/[^/]+/[^/]+";
        }
        if (j2eeManagedObjectId.matches(J2EEManagedObjectNamingHelper.getAllJarsFilter())) {
            return J2EEManagedObjectNamingHelper.encodeJ2EEManagedObjectFilter(j2eeManagedObjectId) + "/[^/]+/[^/]+";
        }
        if (j2eeManagedObjectId.matches(J2EEManagedObjectNamingHelper.getAllBeansFilter())) {
            return J2EEManagedObjectNamingHelper.encodeJ2EEManagedObjectFilter(j2eeManagedObjectId) + "/[^/]+";
        }
        if (j2eeManagedObjectId.matches(J2EEManagedObjectNamingHelper.getAllMethodsFilter())) {
            return J2EEManagedObjectNamingHelper.encodeJ2EEManagedObjectFilter(j2eeManagedObjectId);
        }
        throw new IllegalArgumentException("Cannot proccess RelativeMethodsFilter from id " + j2eeManagedObjectId);
    }

    public static String encodeJ2EEManagedObjectFilter(String j2eeManagedObjectId) {
        String result = j2eeManagedObjectId.replaceAll("\\\\", "\\\\\\\\");
        result = result.replaceAll("\\.", "\\\\.");
        result = result.replaceAll("\\*", "\\\\*");
        result = result.replaceAll("\\^", "\\\\^");
        result = result.replaceAll("\\$", "\\\\$");
        result = result.replaceAll("\\+", "\\\\+");
        result = result.replaceAll("\\|", "\\\\|");
        result = result.replaceAll("\\?", "\\\\?");
        result = result.replaceAll("\\(", "\\\\(");
        result = result.replaceAll("\\)", "\\\\)");
        result = result.replaceAll("\\[", "\\\\[");
        result = result.replaceAll("\\]", "\\\\]");
        result = result.replaceAll("\\{", "\\\\{");
        result = result.replaceAll("\\}", "\\\\}");
        return result;
    }
}

