/**
 * JOnAS: Java(TM) Open Application Server
 * Copyright (C) 2005-2006 Bull S.A.S
 * Contact: jonas-team@objectweb.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * Initial developer(s):
 * --------------------------------------------------------------------------
 * $Id: ClientLBLookup.java 15428 2008-10-07 11:20:29Z sauthieg $
 * --------------------------------------------------------------------------
 */

package org.ow2.jonas.examples.cluster.client;

import java.util.Properties;

import org.ow2.jonas.examples.cluster.beans.samplecluster2.MyEjb1Home;


/**
 * Fat client :
 * - access to a SSB
 * - LB at the lookup, home, remote
 */
public class ClientLBLookup {

    /**
     * Iteration number
     */
    private static final int ITERATION_NB = 20;

    /**
     * Main method
     * @param args arguments of the client
     */
    public static int main(final String[] args) {

        String jonasEJBServer = null;
        String ejbTotalCallsCount = null;
        String ejbEntityCreated = null;
        Properties prop = null;

        for (int i = 1; i < ITERATION_NB + 1; i++) {
            try {

                MyEjb1Home home = ClientUtility.getMyEjb1Home();
                System.out.println("Home retrieved -> " + home);
                //MyEjb1 bean = ClientUtility.getMyEjb1Bean(home);
                //System.out.println("Bean created -> " + bean);

                //prop = bean.getInfoProps();
                //System.out.println("Bean invoked");

                //jonasEJBServer = prop.getProperty("EJB server");
                //ejbTotalCallsCount = prop.getProperty("EJB total calls");
                //ejbEntityCreated = prop.getProperty("EJB server entity created");

                // Comments the remove() call to avoid confusing in the LB algo
                // Indeed, the remove is equilibrated too
                //bean.remove();

            } catch (Exception e) {
                e.printStackTrace();
                return -1;
            }
            System.out.println("\n");
            System.out.println("Iteration=" + i + " - EJB served by jonas=" + jonasEJBServer + " - EJB total calls=" + ejbTotalCallsCount + " - ejbEntityCreated=" + ejbEntityCreated);
        }

        System.out.println("Client OK. Exiting.");
        return 0;
    }
}

