/**
 * JOnAS: Java(TM) Open Application Server
 * Copyright (C) 2006 Bull S.A.S
 * Contact: jonas-team@objectweb.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * Initial developer(s):
 * --------------------------------------------------------------------------
 * $Id: ClientException.java 15428 2008-10-07 11:20:29Z sauthieg $
 * --------------------------------------------------------------------------
 */

package org.ow2.jonas.examples.cluster.client;

import java.util.Properties;

import org.ow2.jonas.examples.cluster.beans.samplecluster2.MyEjb1;
import org.ow2.jonas.examples.cluster.beans.samplecluster2.MyEjb1Home;
import org.ow2.jonas.examples.cluster.beans.samplecluster2.MyException;


/**
 * Fat client :
 * - get an exception
 */
public class ClientException {

    /**
     * Private constructor for utility class
     *
     */
    private ClientException() {
    }

    /**
     * Main method
     * @param args arguments of the client
     */
    public static int main(final String[] args) {

        String jonasEJBServer = null;
        String ejbTotalCallsCount = null;
        String ejbEntityCreated = null;
        Properties prop = null;

        MyEjb1Home home = ClientUtility.getMyEjb1Home();
        System.out.println("Home retrieved -> " + home);
        MyEjb1 bean = ClientUtility.getMyEjb1Bean(home);
        System.out.println("Bean created -> " + bean);


        try {
            System.out.println("Throw an exception at the server side");
            bean.throwMyException();
        } catch (MyException e) {
            System.out.println("MyException caught : " + e);
        } catch (Exception e) {
            System.out.println("Exception caught : " + e);
        }

        System.out.println("Client OK. Exiting.");
        return 0;
    }
}

