/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.ws.cxf;

import java.util.ArrayList;
import org.apache.cxf.Bus;
import org.apache.cxf.BusException;
import org.apache.cxf.BusFactory;
import org.apache.cxf.transport.DestinationFactory;
import org.apache.cxf.transport.DestinationFactoryManager;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Level;
import org.ow2.jonas.ws.cxf.http.JOnASHTTPTransportFactory;
import org.ow2.util.execution.ExecutionResult;
import org.ow2.util.execution.IExecution;
import org.ow2.util.execution.helper.RunnableHelper;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public class BusCreator {
    private static Log logger = LogFactory.getLog(BusCreator.class);

    public Bus initBus() {
        IExecution<Bus> createBusJob = new IExecution<Bus>(){

            public Bus execute() throws Exception {
                Level old = org.ow2.jonas.lib.util.Log.setComponentLogLevel((String)"org.apache.cxf", (Level)BasicLevel.LEVEL_ERROR);
                Level old2 = org.ow2.jonas.lib.util.Log.setComponentLogLevel((String)"org.springframework", (Level)BasicLevel.LEVEL_ERROR);
                Bus newBus = BusFactory.newInstance().createBus();
                org.ow2.jonas.lib.util.Log.setComponentLogLevel((String)"org.apache.cxf", (Level)old);
                org.ow2.jonas.lib.util.Log.setComponentLogLevel((String)"org.springframework", (Level)old2);
                return newBus;
            }
        };
        ExecutionResult res = new RunnableHelper().execute(Bus.class.getClassLoader(), (IExecution)createBusJob);
        if (res.hasException()) {
            logger.error((Object)"Cannot create Bus", new Object[]{res.getException()});
        }
        Bus bus = (Bus)res.getResult();
        try {
            this.createDestinationFactory(bus);
        }
        catch (BusException e) {
            logger.error((Object)"Cannot create destination factory", new Object[]{e});
        }
        return bus;
    }

    private void createDestinationFactory(Bus bus) throws BusException {
        JOnASHTTPTransportFactory factory = new JOnASHTTPTransportFactory(bus);
        ArrayList<String> namespaces = new ArrayList<String>();
        namespaces.add("http://schemas.xmlsoap.org/wsdl/soap/http");
        namespaces.add("http://schemas.xmlsoap.org/soap/http");
        namespaces.add("http://www.w3.org/2003/05/soap/bindings/HTTP/");
        namespaces.add("http://schemas.xmlsoap.org/wsdl/http/");
        namespaces.add("http://cxf.apache.org/transports/http/configuration");
        namespaces.add("http://cxf.apache.org/bindings/xformat");
        factory.setTransportIds(namespaces);
        for (String ns : namespaces) {
            this.registerTransport(bus, factory, ns);
        }
    }

    private void registerTransport(Bus bus, DestinationFactory factory, String namespace) throws BusException {
        DestinationFactoryManager manager = (DestinationFactoryManager)bus.getExtension(DestinationFactoryManager.class);
        manager.registerDestinationFactory(namespace, factory);
    }
}

