/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.ws.cxf.easybeans.ext;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.jws.WebService;
import org.apache.cxf.Bus;
import org.apache.cxf.jaxws.support.JaxWsImplementorInfo;
import org.apache.cxf.jaxws.support.JaxWsServiceFactoryBean;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Level;
import org.ow2.easybeans.api.EZBContainerCallbackInfo;
import org.ow2.easybeans.api.Factory;
import org.ow2.easybeans.container.EmptyLifeCycleCallBack;
import org.ow2.easybeans.container.session.stateless.StatelessSessionFactory;
import org.ow2.jonas.lib.util.Log;
import org.ow2.jonas.ws.cxf.BusCreator;
import org.ow2.jonas.ws.cxf.PortComponent;
import org.ow2.jonas.ws.cxf.easybeans.EasyBeansEndpoint;
import org.ow2.jonas.ws.cxf.easybeans.EasyBeansJaxWsServerFactoryBean;
import org.ow2.jonas.ws.cxf.jaxws.CXFWSEndpoint;
import org.ow2.jonas.ws.jaxws.IJAXWSService;
import org.ow2.jonas.ws.jaxws.IWebServiceDeploymentManager;
import org.ow2.jonas.ws.jaxws.IWebServiceEndpoint;
import org.ow2.jonas.ws.jaxws.PortMetaData;
import org.ow2.jonas.ws.jaxws.WSException;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LifeCycleCallback
extends EmptyLifeCycleCallBack {
    private static org.ow2.util.log.Log logger = LogFactory.getLog(LifeCycleCallback.class);
    private Bus bus = null;
    private IWebServiceDeploymentManager manager;
    private List<IWebServiceEndpoint> endpoints = new ArrayList<IWebServiceEndpoint>();
    private IJAXWSService jaxwsService;

    public void setManager(IWebServiceDeploymentManager manager) {
        this.manager = manager;
    }

    public void start(EZBContainerCallbackInfo info) {
        Map factories = info.getFactories();
        for (Factory f : factories.values()) {
            StatelessSessionFactory factory;
            Class klass;
            WebService ws;
            if (!(f instanceof StatelessSessionFactory) || (ws = (klass = (factory = (StatelessSessionFactory)f).getBeanClass()).getAnnotation(WebService.class)) == null) continue;
            BusCreator creator = new BusCreator();
            this.bus = creator.initBus();
            String wsdlName = ws.wsdlLocation();
            URL url = null;
            if (wsdlName != null && (url = klass.getClassLoader().getResource(wsdlName)) == null) {
                try {
                    url = new URL(wsdlName);
                }
                catch (MalformedURLException ex2) {
                    url = klass.getClassLoader().getResource("/" + wsdlName);
                }
            }
            EasyBeansEndpoint easybeansEndpoint = this.createEasyBeansEndpoint(factory, klass, url);
            String pattern = null;
            PortComponent pc = klass.getAnnotation(PortComponent.class);
            String serviceName = ws.serviceName();
            String portName = ws.portName();
            String name = ws.name();
            pattern = pc != null ? pc.urlPattern() : (!"".equals(serviceName) ? "/" + serviceName : "/" + klass.getSimpleName() + "Service");
            PortMetaData pmd = new PortMetaData();
            String contextRoot = LifeCycleCallback.extractContextRoot(info.getArchive().getName());
            pmd.setContextRoot(contextRoot);
            pmd.setUrlPattern(pattern);
            logger.info((Object)"PortMetaData [context:{0}, pattern:{1}]", new Object[]{pmd.getContextRoot(), pmd.getUrlPattern()});
            CXFWSEndpoint endpoint = new CXFWSEndpoint(easybeansEndpoint, IWebServiceEndpoint.EndpointType.EJB, pmd);
            try {
                this.manager.registerWSEndpoint((IWebServiceEndpoint)endpoint);
            }
            catch (WSException e) {
                logger.error((Object)"Unable to register endpoint {0}", new Object[]{endpoint, e});
                throw new RuntimeException("Endpoint not deployed completely", e);
            }
            endpoint.start();
            this.endpoints.add(endpoint);
            logger.info((Object)"Endpoint {0} inited", new Object[]{klass.getName()});
        }
    }

    private static String extractContextRoot(String filename) {
        String context = filename.substring(filename.lastIndexOf(File.separator) + 1);
        context = context.substring(0, context.lastIndexOf(46));
        return context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EasyBeansEndpoint createEasyBeansEndpoint(StatelessSessionFactory factory, Class<?> klass, URL wsdlUrl) {
        JaxWsImplementorInfo jaxWsImplementorInfo = new JaxWsImplementorInfo(klass);
        JaxWsServiceFactoryBean jaxWsServiceFactoryBean = new JaxWsServiceFactoryBean(jaxWsImplementorInfo);
        jaxWsServiceFactoryBean.setBus(this.bus);
        if (wsdlUrl != null) {
            jaxWsServiceFactoryBean.setWsdlURL(wsdlUrl);
        }
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(klass.getClassLoader());
            jaxWsServiceFactoryBean.create();
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
        EasyBeansJaxWsServerFactoryBean factoryBean = new EasyBeansJaxWsServerFactoryBean(jaxWsServiceFactoryBean, factory);
        return new EasyBeansEndpoint(factory, this.bus, factoryBean);
    }

    public void stop(EZBContainerCallbackInfo info) {
        this.stop();
        logger.info((Object)("Bus stopped for " + info.getArchive()), new Object[0]);
    }

    public void stop() {
        ArrayList<WSException> exceptions = new ArrayList<WSException>();
        for (IWebServiceEndpoint endpoint : this.endpoints) {
            try {
                endpoint.stop();
                this.manager.unregisterWSEndpoint(endpoint);
            }
            catch (WSException e) {
                exceptions.add(e);
            }
        }
        this.endpoints.clear();
        if (this.bus != null) {
            Level old = Log.setComponentLogLevel((String)"org.apache.cxf", (Level)BasicLevel.LEVEL_ERROR);
            Level old2 = Log.setComponentLogLevel((String)"org.springframework", (Level)BasicLevel.LEVEL_ERROR);
            this.bus.shutdown(true);
            this.bus = null;
            Log.setComponentLogLevel((String)"org.apache.cxf", (Level)old);
            Log.setComponentLogLevel((String)"org.springframework", (Level)old2);
        }
        for (WSException exception : exceptions) {
            logger.warn((Object)"Unable to stop/unregister endpoint", new Object[]{exception});
        }
    }

    public void setJaxwsService(IJAXWSService jaxwsService) {
        this.jaxwsService = jaxwsService;
    }
}

