/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.ws.cxf.jaxws;

import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.ServletContext;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.jaxws.EndpointImpl;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.http.WSDLQueryHandler;
import org.apache.cxf.transports.http.QueryHandlerRegistry;
import org.ow2.jonas.ws.cxf.http.JOnASDestination;
import org.ow2.jonas.ws.cxf.http.JOnASWSDLQueryHandler;
import org.ow2.jonas.ws.jaxws.IWSRequest;
import org.ow2.jonas.ws.jaxws.IWSResponse;
import org.ow2.jonas.ws.jaxws.IWebServiceEndpoint;
import org.ow2.jonas.ws.jaxws.PortMetaData;
import org.ow2.jonas.ws.jaxws.WSException;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public class CXFWSEndpoint
implements IWebServiceEndpoint {
    private static Log logger = LogFactory.getLog(CXFWSEndpoint.class);
    private EndpointImpl endpoint = null;
    private JOnASDestination destination = null;
    private PortMetaData portMetaData;
    private IWebServiceEndpoint.EndpointType type;

    public CXFWSEndpoint(EndpointImpl endpoint, IWebServiceEndpoint.EndpointType type, PortMetaData pmd) {
        this.endpoint = endpoint;
        this.type = type;
        this.portMetaData = pmd;
        this.destination = (JOnASDestination)endpoint.getServer().getDestination();
    }

    public IWebServiceEndpoint.EndpointType getType() {
        return this.type;
    }

    public void invoke(IWSRequest request, IWSResponse response) throws WSException {
        logger.debug((Object)"Receiving request on the thread ''{0}''", new Object[]{Thread.currentThread()});
        Bus old = BusFactory.getThreadDefaultBus();
        try {
            Bus bus = this.destination.getBus();
            BusFactory.setThreadDefaultBus((Bus)bus);
            HttpServletRequest httpRequest = (HttpServletRequest)request.getAttribute(HttpServletRequest.class);
            HttpServletResponse httpResponse = (HttpServletResponse)request.getAttribute(HttpServletResponse.class);
            ServletContext servletContext = (ServletContext)request.getAttribute(ServletContext.class);
            if ("GET".equals(httpRequest.getMethod())) {
                this.processGetMethod(bus, httpRequest, httpResponse);
            } else {
                this.destination.invoke(servletContext, httpRequest, httpResponse);
            }
        }
        catch (IOException ioe) {
            throw new WSException((Throwable)ioe);
        }
        finally {
            BusFactory.setThreadDefaultBus((Bus)old);
        }
    }

    private void processGetMethod(Bus bus, HttpServletRequest request, HttpServletResponse response) throws WSException {
        EndpointInfo ei = this.destination.getEndpointInfo();
        if (null != request.getQueryString() && request.getQueryString().length() > 0 && bus.getExtension(QueryHandlerRegistry.class) != null) {
            String ctxUri = request.getPathInfo();
            String address = request.getRequestURL().toString();
            String baseUri = address + "?" + request.getQueryString();
            ei.setAddress(address);
            for (Object qh : ((QueryHandlerRegistry)bus.getExtension(QueryHandlerRegistry.class)).getHandlers()) {
                if (!qh.isRecognizedQuery(baseUri, ctxUri, ei)) continue;
                if (qh instanceof WSDLQueryHandler) {
                    qh = new JOnASWSDLQueryHandler(bus, request.getRequestURL().toString());
                }
                response.setContentType(qh.getResponseContentType(baseUri, ctxUri));
                try {
                    ServletOutputStream out = response.getOutputStream();
                    qh.writeResponse(baseUri, ctxUri, ei, (OutputStream)out);
                    out.flush();
                    return;
                }
                catch (Exception e) {
                    throw new WSException((Throwable)e);
                }
            }
        }
    }

    public void start() {
        this.endpoint.publish();
    }

    public void stop() {
        this.endpoint.stop();
    }

    public PortMetaData getPortMetaData() {
        return this.portMetaData;
    }
}

