/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.services.bootstrap;

import java.io.File;
import java.io.FilenameFilter;
import java.util.List;
import java.util.Set;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.ow2.jonas.configuration.ConfigurationManager;
import org.ow2.jonas.configuration.DeploymentPlanDeployer;
import org.ow2.jonas.lib.bootstrap.JProp;
import org.ow2.jonas.properties.ServerProperties;
import org.ow2.util.archive.api.IArchive;
import org.ow2.util.archive.impl.ArchiveManager;
import org.ow2.util.ee.deploy.api.deployable.IDeployable;
import org.ow2.util.ee.deploy.api.deployer.IDeployerManager;
import org.ow2.util.ee.deploy.impl.helper.DeployableHelper;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public class JOnASDeploymentPlanDeployer
extends Thread
implements DeploymentPlanDeployer,
Pojo {
    private InstanceManager __IM;
    private boolean __FconfigurationManager;
    private ConfigurationManager configurationManager;
    private boolean __FdeployerManager;
    private IDeployerManager deployerManager;
    private boolean __FserverProperties;
    private ServerProperties serverProperties;
    private boolean __Flogger;
    private Log logger;
    private static final String JONAS_BOOTSTRAP = "jonas.bootstrap";
    private static final String JONAS_SERVICE = "jonas.service";
    private static final String DEPLOYMENT_CONFIG_DIR = JProp.getConfDir() + File.separator + "deployment";
    private boolean __Minit;
    private boolean __Mrun;
    private boolean __Mdeploy$java_lang_String;
    private boolean __MundeployDeploymentPlan$java_lang_String;
    private boolean __MdeployDeploymentPlan$java_io_File;
    private boolean __MundeployDeploymentPlan$java_io_File;
    private boolean __MsetConfigurationManager$org_ow2_jonas_configuration_ConfigurationManager;
    private boolean __MsetDeployerManager$org_ow2_util_ee_deploy_api_deployer_IDeployerManager;
    private boolean __MsetServerProperties$org_ow2_jonas_properties_ServerProperties;

    ConfigurationManager __getconfigurationManager() {
        if (!this.__FconfigurationManager) {
            return this.configurationManager;
        }
        return (ConfigurationManager)this.__IM.onGet((Object)this, "configurationManager");
    }

    void __setconfigurationManager(ConfigurationManager configurationManager) {
        if (!this.__FconfigurationManager) {
            this.configurationManager = configurationManager;
            return;
        }
        this.__IM.onSet((Object)this, "configurationManager", (Object)configurationManager);
    }

    IDeployerManager __getdeployerManager() {
        if (!this.__FdeployerManager) {
            return this.deployerManager;
        }
        return (IDeployerManager)this.__IM.onGet((Object)this, "deployerManager");
    }

    void __setdeployerManager(IDeployerManager iDeployerManager) {
        if (!this.__FdeployerManager) {
            this.deployerManager = iDeployerManager;
            return;
        }
        this.__IM.onSet((Object)this, "deployerManager", (Object)iDeployerManager);
    }

    ServerProperties __getserverProperties() {
        if (!this.__FserverProperties) {
            return this.serverProperties;
        }
        return (ServerProperties)this.__IM.onGet((Object)this, "serverProperties");
    }

    void __setserverProperties(ServerProperties serverProperties) {
        if (!this.__FserverProperties) {
            this.serverProperties = serverProperties;
            return;
        }
        this.__IM.onSet((Object)this, "serverProperties", (Object)serverProperties);
    }

    Log __getlogger() {
        if (!this.__Flogger) {
            return this.logger;
        }
        return (Log)this.__IM.onGet((Object)this, "logger");
    }

    void __setlogger(Log log) {
        if (!this.__Flogger) {
            this.logger = log;
            return;
        }
        this.__IM.onSet((Object)this, "logger", (Object)log);
    }

    public JOnASDeploymentPlanDeployer() {
        this((InstanceManager)null);
    }

    private JOnASDeploymentPlanDeployer(InstanceManager _manager) {
        this._setInstanceManager(_manager);
        this.__setconfigurationManager(null);
        this.__setdeployerManager(null);
        this.__setserverProperties(null);
        this.__setlogger(LogFactory.getLog(JOnASDeploymentPlanDeployer.class));
    }

    public void init() {
        if (!this.__Minit) {
            this.__init();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "init", new Object[0]);
            this.__init();
            this.__IM.onExit((Object)this, "init", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "init", throwable);
            throw throwable;
        }
    }

    private void __init() {
        new Thread(this).start();
    }

    public void run() {
        if (!this.__Mrun) {
            this.__run();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "run", new Object[0]);
            this.__run();
            this.__IM.onExit((Object)this, "run", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "run", throwable);
            throw throwable;
        }
    }

    private void __run() {
        boolean boostrapMode = Boolean.getBoolean(JONAS_BOOTSTRAP);
        if (!boostrapMode) {
            List services = this.__getconfigurationManager().getOptionalServices();
            for (String service : services) {
                try {
                    this.deploy(service);
                }
                catch (Exception e) {
                    this.__getlogger().error((Object)"Cannot deploy the service ''{0}''", new Object[]{service});
                }
            }
        }
    }

    public void deploy(String string) throws Exception {
        if (!this.__Mdeploy$java_lang_String) {
            this.__deploy(string);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "deploy$java_lang_String", new Object[]{string});
            this.__deploy(string);
            this.__IM.onExit((Object)this, "deploy$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "deploy$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __deploy(String name) throws Exception {
        File file;
        String service = name;
        File configDir = new File(DEPLOYMENT_CONFIG_DIR);
        final String baseName = name + "-base";
        File[] base = configDir.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.equalsIgnoreCase(baseName.concat(".xml"));
            }
        });
        if (base.length == 1) {
            this.deploy(baseName);
            String serviceClass = this.__getserverProperties().getValue("jonas.service." + service + ".class");
            String implementationName = serviceClass.split("\\.")[4];
            service = service + "-" + implementationName;
        }
        if (!(file = new File(DEPLOYMENT_CONFIG_DIR, service + ".xml")).exists()) {
            throw new Exception("Cannot deploy the deployment plan '" + name + "', file '" + file + "' not found");
        }
        this.deployDeploymentPlan(file);
    }

    public void undeployDeploymentPlan(String string) throws Exception {
        if (!this.__MundeployDeploymentPlan$java_lang_String) {
            this.__undeployDeploymentPlan(string);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "undeployDeploymentPlan$java_lang_String", new Object[]{string});
            this.__undeployDeploymentPlan(string);
            this.__IM.onExit((Object)this, "undeployDeploymentPlan$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "undeployDeploymentPlan$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __undeployDeploymentPlan(String name) throws Exception {
        File file = new File(DEPLOYMENT_CONFIG_DIR, name + ".xml");
        if (!file.exists()) {
            throw new Exception("Cannot undeploy the deployment plan '" + name + "', file '" + file + "' not found");
        }
        this.undeployDeploymentPlan(file);
    }

    private void deployDeploymentPlan(File file) throws Exception {
        if (!this.__MdeployDeploymentPlan$java_io_File) {
            this.__deployDeploymentPlan(file);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "deployDeploymentPlan$java_io_File", new Object[]{file});
            this.__deployDeploymentPlan(file);
            this.__IM.onExit((Object)this, "deployDeploymentPlan$java_io_File", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "deployDeploymentPlan$java_io_File", throwable);
            throw throwable;
        }
    }

    private void __deployDeploymentPlan(File file) throws Exception {
        this.__getlogger().debug((Object)"Deploying the deployment plan for ''{0}''", new Object[]{file});
        IArchive archive = ArchiveManager.getInstance().getArchive((Object)file);
        if (archive == null) {
            throw new Exception("Ignoring invalid file '" + file + "'");
        }
        IDeployable deployable = null;
        try {
            deployable = DeployableHelper.getDeployable((IArchive)archive);
            this.__getdeployerManager().deploy(deployable);
        }
        catch (Exception e) {
            throw new Exception("Cannot deploy the deployment plan for '" + file + "'");
        }
    }

    private void undeployDeploymentPlan(File file) throws Exception {
        if (!this.__MundeployDeploymentPlan$java_io_File) {
            this.__undeployDeploymentPlan(file);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "undeployDeploymentPlan$java_io_File", new Object[]{file});
            this.__undeployDeploymentPlan(file);
            this.__IM.onExit((Object)this, "undeployDeploymentPlan$java_io_File", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "undeployDeploymentPlan$java_io_File", throwable);
            throw throwable;
        }
    }

    private void __undeployDeploymentPlan(File file) throws Exception {
        this.__getlogger().debug((Object)"Undeploying the deployment plan for ''{0}''", new Object[]{file});
        IArchive archive = ArchiveManager.getInstance().getArchive((Object)file);
        if (archive == null) {
            throw new Exception("Ignoring invalid file '" + file + "'");
        }
        IDeployable deployable = null;
        try {
            deployable = DeployableHelper.getDeployable((IArchive)archive);
            this.__getdeployerManager().undeploy(deployable);
        }
        catch (Exception e) {
            throw new Exception("Cannot undeploy the deployment plan for '" + file + "'");
        }
    }

    public void setConfigurationManager(ConfigurationManager configurationManager) {
        if (!this.__MsetConfigurationManager$org_ow2_jonas_configuration_ConfigurationManager) {
            this.__setConfigurationManager(configurationManager);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setConfigurationManager$org_ow2_jonas_configuration_ConfigurationManager", new Object[]{configurationManager});
            this.__setConfigurationManager(configurationManager);
            this.__IM.onExit((Object)this, "setConfigurationManager$org_ow2_jonas_configuration_ConfigurationManager", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setConfigurationManager$org_ow2_jonas_configuration_ConfigurationManager", throwable);
            throw throwable;
        }
    }

    private void __setConfigurationManager(ConfigurationManager configurationManager) {
        this.__setconfigurationManager(configurationManager);
    }

    public void setDeployerManager(IDeployerManager iDeployerManager) {
        if (!this.__MsetDeployerManager$org_ow2_util_ee_deploy_api_deployer_IDeployerManager) {
            this.__setDeployerManager(iDeployerManager);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setDeployerManager$org_ow2_util_ee_deploy_api_deployer_IDeployerManager", new Object[]{iDeployerManager});
            this.__setDeployerManager(iDeployerManager);
            this.__IM.onExit((Object)this, "setDeployerManager$org_ow2_util_ee_deploy_api_deployer_IDeployerManager", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setDeployerManager$org_ow2_util_ee_deploy_api_deployer_IDeployerManager", throwable);
            throw throwable;
        }
    }

    private void __setDeployerManager(IDeployerManager deployerManager) {
        this.__setdeployerManager(deployerManager);
    }

    public void setServerProperties(ServerProperties serverProperties) {
        if (!this.__MsetServerProperties$org_ow2_jonas_properties_ServerProperties) {
            this.__setServerProperties(serverProperties);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setServerProperties$org_ow2_jonas_properties_ServerProperties", new Object[]{serverProperties});
            this.__setServerProperties(serverProperties);
            this.__IM.onExit((Object)this, "setServerProperties$org_ow2_jonas_properties_ServerProperties", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setServerProperties$org_ow2_jonas_properties_ServerProperties", throwable);
            throw throwable;
        }
    }

    private void __setServerProperties(ServerProperties serverProperties) {
        this.__setserverProperties(serverProperties);
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            if (set.contains("serverProperties")) {
                this.__FserverProperties = true;
            }
            if (set.contains("deployerManager")) {
                this.__FdeployerManager = true;
            }
            if (set.contains("logger")) {
                this.__Flogger = true;
            }
            if (set.contains("configurationManager")) {
                this.__FconfigurationManager = true;
            }
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("init")) {
                this.__Minit = true;
            }
            if (set.contains("run")) {
                this.__Mrun = true;
            }
            if (set.contains("deploy$java_lang_String")) {
                this.__Mdeploy$java_lang_String = true;
            }
            if (set.contains("undeployDeploymentPlan$java_lang_String")) {
                this.__MundeployDeploymentPlan$java_lang_String = true;
            }
            if (set.contains("deployDeploymentPlan$java_io_File")) {
                this.__MdeployDeploymentPlan$java_io_File = true;
            }
            if (set.contains("undeployDeploymentPlan$java_io_File")) {
                this.__MundeployDeploymentPlan$java_io_File = true;
            }
            if (set.contains("setConfigurationManager$org_ow2_jonas_configuration_ConfigurationManager")) {
                this.__MsetConfigurationManager$org_ow2_jonas_configuration_ConfigurationManager = true;
            }
            if (set.contains("setDeployerManager$org_ow2_util_ee_deploy_api_deployer_IDeployerManager")) {
                this.__MsetDeployerManager$org_ow2_util_ee_deploy_api_deployer_IDeployerManager = true;
            }
            if (set.contains("setServerProperties$org_ow2_jonas_properties_ServerProperties")) {
                this.__MsetServerProperties$org_ow2_jonas_properties_ServerProperties = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

