/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.web.tomcat6.ws;

import org.apache.catalina.InstanceEvent;
import org.apache.catalina.InstanceListener;
import org.ow2.jonas.ws.jaxws.IJAXWSService;
import org.ow2.jonas.ws.jaxws.IWebServiceEndpoint;
import org.ow2.jonas.ws.jaxws.WSException;
import org.ow2.jonas.ws.jaxws.http.servlet.JAXWSServlet;
import org.ow2.util.ee.metadata.war.api.IWarClassMetadata;

public class EndpointInstanceListener
implements InstanceListener {
    private IWarClassMetadata endpointMetadata;
    private IJAXWSService service;
    private IWebServiceEndpoint endpoint;

    public EndpointInstanceListener(IWarClassMetadata endpointMetadata, IJAXWSService service) {
        this.endpointMetadata = endpointMetadata;
        this.service = service;
    }

    public void instanceEvent(InstanceEvent event) {
        if ("beforeInit".equals(event.getType())) {
            JAXWSServlet servlet = (JAXWSServlet)event.getServlet();
            if (this.endpoint == null) {
                ClassLoader loader = event.getWrapper().getLoader().getClassLoader();
                try {
                    this.endpoint = this.service.createPOJOWebServiceEndpoint(this.endpointMetadata, loader);
                }
                catch (WSException e) {
                    throw new RuntimeException("WebServiceEndpoint creation failed", e);
                }
                this.endpoint.start();
                this.endpointMetadata = null;
                this.service = null;
            }
            servlet.setWebServiceEndpoint(this.endpoint);
        }
    }
}

