/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.extension.loader;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.ow2.jonas.extension.loader.Bnd;
import org.ow2.jonas.extension.loader.Bundlizable;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.url.URLUtils;

public class ExtensionLoaderComponent
implements Pojo {
    private InstanceManager __IM;
    private static final Log logger = LogFactory.getLog(ExtensionLoaderComponent.class);
    private boolean __Fcontext;
    private BundleContext context;
    private boolean __Fbundles;
    private List<Bundle> bundles;
    private boolean __Fbundlizables;
    private Map<String, Bundlizable> bundlizables;
    private boolean __Mstart;
    private boolean __MapplyBndWrap$java_io_File$java_io_File;
    private boolean __Mstop;

    BundleContext __getcontext() {
        if (!this.__Fcontext) {
            return this.context;
        }
        return (BundleContext)this.__IM.onGet((Object)this, "context");
    }

    void __setcontext(BundleContext bundleContext) {
        if (!this.__Fcontext) {
            this.context = bundleContext;
            return;
        }
        this.__IM.onSet((Object)this, "context", (Object)bundleContext);
    }

    List __getbundles() {
        if (!this.__Fbundles) {
            return this.bundles;
        }
        return (List)this.__IM.onGet((Object)this, "bundles");
    }

    void __setbundles(List list) {
        if (!this.__Fbundles) {
            this.bundles = list;
            return;
        }
        this.__IM.onSet((Object)this, "bundles", (Object)list);
    }

    Map __getbundlizables() {
        if (!this.__Fbundlizables) {
            return this.bundlizables;
        }
        return (Map)this.__IM.onGet((Object)this, "bundlizables");
    }

    void __setbundlizables(Map map) {
        if (!this.__Fbundlizables) {
            this.bundlizables = map;
            return;
        }
        this.__IM.onSet((Object)this, "bundlizables", (Object)map);
    }

    public ExtensionLoaderComponent(BundleContext bundleContext) {
        this(null, bundleContext);
    }

    private ExtensionLoaderComponent(InstanceManager _manager, BundleContext context) {
        this._setInstanceManager(_manager);
        this.__setcontext(context);
        this.__setbundles(new ArrayList());
        this.__setbundlizables(new HashMap());
    }

    public void start() {
        if (!this.__Mstart) {
            this.__start();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "start", new Object[0]);
            this.__start();
            this.__IM.onExit((Object)this, "start", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "start", throwable);
            throw throwable;
        }
    }

    private void __start() {
        Bundlizable bnd2;
        String name;
        this.__getbundles().clear();
        this.__getbundlizables().clear();
        File jonasRoot = new File(System.getProperty("jonas.root"));
        File jonasBase = new File(System.getProperty("jonas.base"));
        File jonasBaseWork = new File(jonasBase, "work");
        File rootLibExt = new File(new File(jonasRoot, "lib"), "ext");
        File baseLibExt = new File(new File(jonasBase, "lib"), "ext");
        File bundleWork = new File(jonasBaseWork, "ext-bundles");
        if (!bundleWork.exists()) {
            bundleWork.mkdirs();
        }
        FileFilter selectJar = new FileFilter(){

            public boolean accept(File child) {
                return child.getName().endsWith(".jar") && child.isFile();
            }
        };
        if (rootLibExt.isDirectory()) {
            for (File child : rootLibExt.listFiles(selectJar)) {
                name = child.getName();
                bnd2 = (Bundlizable)this.__getbundlizables().get(name);
                if (bnd2 != null) continue;
                bnd2 = new Bundlizable();
                bnd2.setSource(child);
                this.__getbundlizables().put(child.getName(), bnd2);
            }
        }
        if (baseLibExt.isDirectory() && !rootLibExt.equals(baseLibExt)) {
            for (File child : baseLibExt.listFiles(selectJar)) {
                name = child.getName();
                bnd2 = (Bundlizable)this.__getbundlizables().get(name);
                if (bnd2 != null) continue;
                bnd2 = new Bundlizable();
                bnd2.setSource(child);
                this.__getbundlizables().put(child.getName(), bnd2);
            }
        }
        for (File child : bundleWork.listFiles(selectJar)) {
            name = child.getName();
            bnd2 = (Bundlizable)this.__getbundlizables().get(name);
            if (bnd2 != null) continue;
            bnd2 = new Bundlizable();
            bnd2.setTarget(child);
            this.__getbundlizables().put(child.getName(), bnd2);
        }
        Iterator i = this.__getbundlizables().entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            Bundlizable bnd3 = (Bundlizable)entry.getValue();
            if (bnd3.isSourceSuppressed()) {
                bnd3.getTarget().delete();
                i.remove();
                continue;
            }
            if (bnd3.isFirstUsage()) {
                File target = new File(bundleWork, bnd3.getSource().getName());
                bnd3.setTarget(target);
                this.applyBndWrap(bnd3.getSource(), target);
                continue;
            }
            if (!bnd3.isTargetOutdated()) continue;
            bnd3.getTarget().delete();
            this.applyBndWrap(bnd3.getSource(), bnd3.getTarget());
        }
        if (this.__getbundlizables().size() != 0) {
            StringBuilder sb = new StringBuilder();
            sb.append("Some jars have been found in [");
            sb.append(rootLibExt);
            if (!rootLibExt.equals(baseLibExt)) {
                sb.append(", ");
                sb.append(baseLibExt);
            }
            sb.append("].");
            sb.append(" They have been transformed into bundles (see ");
            sb.append(bundleWork);
            sb.append(" directory).");
            sb.append("This is NOT the prefered way to extends JOnAS libraries, ");
            sb.append("prefer to use carefully created and tested bundles, ");
            sb.append("and place them in your deploy/ directory.");
            logger.info((Object)sb.toString(), new Object[0]);
        }
        for (Map.Entry entry : this.__getbundlizables().entrySet()) {
            Bundlizable bnd4 = (Bundlizable)entry.getValue();
            String url = URLUtils.fileToURL((File)bnd4.getTarget()).toExternalForm();
            try {
                Bundle installed = this.__getcontext().installBundle(url);
                logger.info((Object)"{0} installed as a bundle.", new Object[]{url});
                this.__getbundles().add(installed);
            }
            catch (BundleException e) {
                logger.warn((Object)"Unable to install '{0}': {1}", new Object[]{url, e.getMessage()});
            }
        }
    }

    private void applyBndWrap(File file, File file2) {
        if (!this.__MapplyBndWrap$java_io_File$java_io_File) {
            this.__applyBndWrap(file, file2);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "applyBndWrap$java_io_File$java_io_File", new Object[]{file, file2});
            this.__applyBndWrap(file, file2);
            this.__IM.onExit((Object)this, "applyBndWrap$java_io_File$java_io_File", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "applyBndWrap$java_io_File$java_io_File", throwable);
            throw throwable;
        }
    }

    private void __applyBndWrap(File source, File output) {
        List<String> messages;
        Bnd myBnd = new Bnd();
        boolean errors = false;
        try {
            errors = myBnd.wrap(source, output);
        }
        catch (Exception e) {
            logger.warn((Object)"Unable to bundlize '{0}'", new Object[]{source, e});
        }
        if (errors && logger.isDebugEnabled() && (messages = myBnd.getErrors()) != null) {
            for (String message : messages) {
                logger.debug((Object)"[Bnd] {0}: {1}", new Object[]{source.getName(), message});
            }
        }
    }

    public void stop() {
        if (!this.__Mstop) {
            this.__stop();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "stop", new Object[0]);
            this.__stop();
            this.__IM.onExit((Object)this, "stop", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "stop", throwable);
            throw throwable;
        }
    }

    private void __stop() {
        for (Bundle bundle : this.__getbundles()) {
            try {
                bundle.uninstall();
            }
            catch (BundleException e) {
                logger.debug((Object)"Unable to uninstall bundle '{0}[{1}]': {2}", new Object[]{bundle.getSymbolicName(), bundle.getBundleId(), e.getMessage()});
            }
        }
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            if (set.contains("context")) {
                this.__Fcontext = true;
            }
            if (set.contains("bundles")) {
                this.__Fbundles = true;
            }
            if (set.contains("bundlizables")) {
                this.__Fbundlizables = true;
            }
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("start")) {
                this.__Mstart = true;
            }
            if (set.contains("applyBndWrap$java_io_File$java_io_File")) {
                this.__MapplyBndWrap$java_io_File$java_io_File = true;
            }
            if (set.contains("stop")) {
                this.__Mstop = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

