/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.ws.jaxws.client.naming.factory;

import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import javax.xml.namespace.QName;
import javax.xml.ws.Service;
import org.ow2.jonas.lib.util.JNDIUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ServiceObjectFactory
implements ObjectFactory {
    @Override
    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable<?, ?> environment) throws Exception {
        Constructor<Service> constructor;
        if (!(obj instanceof Reference)) {
            return null;
        }
        Reference ref = (Reference)obj;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        String serviceClassname = JNDIUtils.extractStringFrom((Reference)ref, (String)"service-class");
        String seiClassname = JNDIUtils.extractStringFrom((Reference)ref, (String)"service-endpoint-interface");
        String wsdlLocation = JNDIUtils.extractStringFrom((Reference)ref, (String)"wsdl-location");
        QName serviceName = (QName)JNDIUtils.extractObjectFrom((Reference)ref, (String)"service-qname", QName.class);
        Class<Service> serviceClass = null;
        serviceClass = Class.forName(serviceClassname, true, loader).asSubclass(Service.class);
        boolean haveWSDL = true;
        URL location = null;
        if (wsdlLocation != null) {
            try {
                location = new URL(wsdlLocation);
            }
            catch (MalformedURLException mue) {
                ClassLoader serviceLoader = serviceClass.getClassLoader();
                location = serviceLoader.getResource(wsdlLocation);
                if (location == null) {
                    location = loader.getResource(wsdlLocation);
                }
                if (location == null) {
                    haveWSDL = false;
                }
            }
        } else {
            haveWSDL = false;
        }
        Service service = null;
        if (haveWSDL) {
            constructor = serviceClass.getConstructor(URL.class, QName.class);
            service = constructor.newInstance(location, null);
        } else {
            constructor = serviceClass.getConstructor(new Class[0]);
            service = constructor.newInstance(new Object[0]);
        }
        this.prepareService(service, ref);
        Object returnedObject = service;
        if (seiClassname != null) {
            ClassLoader serviceClassLoader = service.getClass().getClassLoader();
            Class<?> sei = serviceClassLoader.loadClass(seiClassname);
            returnedObject = service.getPort(sei);
        }
        return returnedObject;
    }

    protected abstract void prepareService(Service var1, Reference var2) throws Exception;
}

