/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework.searchpolicy;

import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.felix.framework.BundleProtectionDomain;
import org.apache.felix.framework.Logger;
import org.apache.felix.framework.searchpolicy.ModuleDefinition;
import org.apache.felix.framework.searchpolicy.R4Wire;
import org.apache.felix.framework.searchpolicy.R4WireModule;
import org.apache.felix.framework.searchpolicy.ResolveException;
import org.apache.felix.framework.searchpolicy.ResolveListener;
import org.apache.felix.framework.util.CompoundEnumeration;
import org.apache.felix.framework.util.SecurityManagerEx;
import org.apache.felix.framework.util.Util;
import org.apache.felix.framework.util.manifestparser.Capability;
import org.apache.felix.framework.util.manifestparser.R4Attribute;
import org.apache.felix.framework.util.manifestparser.R4Directive;
import org.apache.felix.framework.util.manifestparser.R4Library;
import org.apache.felix.framework.util.manifestparser.Requirement;
import org.apache.felix.moduleloader.ICapability;
import org.apache.felix.moduleloader.IModule;
import org.apache.felix.moduleloader.IModuleFactory;
import org.apache.felix.moduleloader.IRequirement;
import org.apache.felix.moduleloader.IWire;
import org.apache.felix.moduleloader.ModuleEvent;
import org.apache.felix.moduleloader.ModuleImpl;
import org.apache.felix.moduleloader.ModuleListener;
import org.apache.felix.moduleloader.ResourceNotFoundException;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.PackagePermission;
import org.osgi.framework.Version;

public class R4SearchPolicyCore
implements ModuleListener {
    private Logger m_logger = null;
    private Map m_configMap = null;
    private IModuleFactory m_factory = null;
    private Map m_unresolvedPkgIndexMap = new HashMap();
    private Map m_resolvedPkgIndexMap = new HashMap();
    private Map m_resolvedCapMap = new HashMap();
    private Map m_moduleDataMap = new HashMap();
    private String[] m_bootPkgs = null;
    private boolean[] m_bootPkgWildcards = null;
    private static final ResolveListener[] m_emptyListeners = new ResolveListener[0];
    private ResolveListener[] m_listeners = m_emptyListeners;
    public static final IModule[] m_emptyModules = new IModule[0];
    public static final ICapability[] m_emptyCapabilities = new ICapability[0];
    public static final PackageSource[] m_emptySources = new PackageSource[0];
    private static SecurityManagerEx m_sm = new SecurityManagerEx();
    static /* synthetic */ Class class$java$lang$Thread;
    static /* synthetic */ Class class$java$lang$ClassLoader;
    static /* synthetic */ Class class$java$lang$Class;
    static /* synthetic */ Class class$java$lang$reflect$Proxy;
    static /* synthetic */ Class class$org$apache$felix$framework$searchpolicy$ContentClassLoader;
    static /* synthetic */ Class class$org$osgi$framework$Bundle;

    public R4SearchPolicyCore(Logger logger, Map configMap) {
        this.m_logger = logger;
        this.m_configMap = configMap;
        String s = (String)this.m_configMap.get("org.osgi.framework.bootdelegation");
        s = s == null ? "java.*" : s + ",java.*";
        StringTokenizer st = new StringTokenizer(s, " ,");
        this.m_bootPkgs = new String[st.countTokens()];
        this.m_bootPkgWildcards = new boolean[this.m_bootPkgs.length];
        for (int i = 0; i < this.m_bootPkgs.length; ++i) {
            s = st.nextToken();
            if (s.endsWith("*")) {
                this.m_bootPkgWildcards[i] = true;
                s = s.substring(0, s.length() - 1);
            }
            this.m_bootPkgs[i] = s;
        }
    }

    public IModuleFactory getModuleFactory() {
        return this.m_factory;
    }

    public void setModuleFactory(IModuleFactory factory) throws IllegalStateException {
        if (this.m_factory != null) {
            throw new IllegalStateException("Module manager is already initialized");
        }
        this.m_factory = factory;
        this.m_factory.addModuleListener(this);
    }

    private boolean isResolved(IModule module) {
        ModuleData data = (ModuleData)this.m_moduleDataMap.get(module);
        return data == null ? false : data.m_resolved;
    }

    private void setResolved(IModule module, boolean resolved) {
        ModuleData data = (ModuleData)this.m_moduleDataMap.get(module);
        if (data == null) {
            data = new ModuleData(module);
            this.m_moduleDataMap.put(module, data);
        }
        data.m_resolved = resolved;
    }

    public Object[] definePackage(IModule module, String pkgName) {
        Map headerMap = ((ModuleDefinition)module.getDefinition()).getHeaders();
        String spectitle = (String)headerMap.get("Specification-Title");
        String specversion = (String)headerMap.get("Specification-Version");
        String specvendor = (String)headerMap.get("Specification-Vendor");
        String impltitle = (String)headerMap.get("Implementation-Title");
        String implversion = (String)headerMap.get("Implementation-Version");
        String implvendor = (String)headerMap.get("Implementation-Vendor");
        if (spectitle != null || specversion != null || specvendor != null || impltitle != null || implversion != null || implvendor != null) {
            return new Object[]{spectitle, specversion, specvendor, impltitle, implversion, implvendor};
        }
        return null;
    }

    public Class findClass(IModule module, String name) throws ClassNotFoundException {
        try {
            return (Class)this.findClassOrResource(module, name, true);
        }
        catch (ResourceNotFoundException ex) {
        }
        catch (ClassNotFoundException ex) {
            String msg = name;
            if (this.m_logger.getLogLevel() >= 4) {
                msg = this.diagnoseClassLoadError(module, name);
            }
            throw new ClassNotFoundException(msg, ex);
        }
        return null;
    }

    public URL findResource(IModule module, String name) throws ResourceNotFoundException {
        try {
            return (URL)this.findClassOrResource(module, name, false);
        }
        catch (ClassNotFoundException ex) {
        }
        catch (ResourceNotFoundException ex) {
            throw ex;
        }
        return null;
    }

    public Enumeration findResources(IModule module, String name) throws ResourceNotFoundException {
        int i;
        Enumeration urls = null;
        ArrayList<Enumeration> enums = new ArrayList<Enumeration>();
        try {
            this.resolve(module);
        }
        catch (ResolveException ex) {
            urls = module.getContentLoader().getResources(name);
            if (urls != null) {
                return urls;
            }
            throw new ResourceNotFoundException(name + ": cannot resolve requirement " + ex.getRequirement());
        }
        String pkgName = Util.getResourcePackage(name);
        if (pkgName.length() > 0) {
            for (int i2 = 0; i2 < this.m_bootPkgs.length; ++i2) {
                if ((!this.m_bootPkgWildcards[i2] || !pkgName.startsWith(this.m_bootPkgs[i2]) && !this.m_bootPkgs[i2].regionMatches(0, pkgName, 0, pkgName.length())) && (this.m_bootPkgWildcards[i2] || !this.m_bootPkgs[i2].equals(pkgName))) continue;
                try {
                    urls = this.getClass().getClassLoader().getResources(name);
                }
                catch (IOException ex) {
                    // empty catch block
                }
                if (this.m_bootPkgs[i2].startsWith("java.")) {
                    return urls;
                }
                enums.add(urls);
                break;
            }
        }
        IWire[] wires = module.getWires();
        for (i = 0; wires != null && i < wires.length; ++i) {
            if (!(wires[i] instanceof R4Wire) || (urls = wires[i].getResources(name)) == null) continue;
            enums.add(urls);
            return new CompoundEnumeration(enums.toArray(new Enumeration[enums.size()]));
        }
        for (i = 0; wires != null && i < wires.length; ++i) {
            if (!(wires[i] instanceof R4WireModule) || (urls = wires[i].getResources(name)) == null) continue;
            enums.add(urls);
        }
        urls = module.getContentLoader().getResources(name);
        if (urls != null) {
            enums.add(urls);
        } else {
            IWire wire = this.attemptDynamicImport(module, pkgName);
            if (wire != null && (urls = wire.getResources(name)) != null) {
                enums.add(urls);
            }
        }
        return new CompoundEnumeration(enums.toArray(new Enumeration[enums.size()]));
    }

    private Object findClassOrResource(IModule module, String name, boolean isClass) throws ClassNotFoundException, ResourceNotFoundException {
        try {
            this.resolve(module);
        }
        catch (ResolveException ex) {
            if (isClass) {
                throw new ClassNotFoundException(name + ": cannot resolve package " + ex.getRequirement());
            }
            URL url = module.getContentLoader().getResource(name);
            if (url != null) {
                return url;
            }
            throw new ResourceNotFoundException(name + ": cannot resolve package " + ex.getRequirement());
        }
        String pkgName = isClass ? Util.getClassPackage(name) : Util.getResourcePackage(name);
        Object result = null;
        for (int i = 0; i < this.m_bootPkgs.length; ++i) {
            if (pkgName.length() <= 0 || (!this.m_bootPkgWildcards[i] || !pkgName.startsWith(this.m_bootPkgs[i]) && !this.m_bootPkgs[i].regionMatches(0, pkgName, 0, pkgName.length())) && (this.m_bootPkgWildcards[i] || !this.m_bootPkgs[i].equals(pkgName))) continue;
            try {
                Object object = result = isClass ? this.getClass().getClassLoader().loadClass(name) : this.getClass().getClassLoader().getResource(name);
                if (!this.m_bootPkgs[i].startsWith("java.") && result == null) continue;
                return result;
            }
            catch (ClassNotFoundException ex) {
                if (!this.m_bootPkgs[i].startsWith("java.")) break;
                throw ex;
            }
        }
        if ((result = this.searchImports(module, name, isClass)) == null) {
            Object object = result = isClass ? module.getContentLoader().getClass(name) : module.getContentLoader().getResource(name);
            if (result == null) {
                result = this.searchDynamicImports(module, name, pkgName, isClass);
            }
        }
        if (result == null) {
            if (isClass) {
                throw new ClassNotFoundException(name);
            }
            throw new ResourceNotFoundException(name);
        }
        return result;
    }

    private Object searchImports(IModule module, String name, boolean isClass) throws ClassNotFoundException, ResourceNotFoundException {
        IWire[] wires = module.getWires();
        for (int i = 0; wires != null && i < wires.length; ++i) {
            Serializable result;
            Serializable serializable = result = isClass ? wires[i].getClass(name) : wires[i].getResource(name);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private Object searchDynamicImports(IModule module, String name, String pkgName, boolean isClass) throws ClassNotFoundException, ResourceNotFoundException {
        IWire wire = this.attemptDynamicImport(module, pkgName);
        if (wire != null) {
            return isClass ? wire.getClass(name) : wire.getResource(name);
        }
        Class[] classes = m_sm.getClassContext();
        for (int i = 1; i < classes.length && !(class$java$lang$Thread == null ? R4SearchPolicyCore.class$("java.lang.Thread") : class$java$lang$Thread).equals(classes[i]); ++i) {
            if (this.getClass().getClassLoader() == classes[i].getClassLoader() || (class$java$lang$ClassLoader == null ? R4SearchPolicyCore.class$("java.lang.ClassLoader") : class$java$lang$ClassLoader).isAssignableFrom(classes[i]) || (class$java$lang$Class == null ? R4SearchPolicyCore.class$("java.lang.Class") : class$java$lang$Class).equals(classes[i]) || (class$java$lang$reflect$Proxy == null ? R4SearchPolicyCore.class$("java.lang.reflect.Proxy") : class$java$lang$reflect$Proxy).equals(classes[i])) continue;
            boolean delegate = true;
            ClassLoader cl = classes[i].getClassLoader();
            while (cl != null) {
                if ((class$org$apache$felix$framework$searchpolicy$ContentClassLoader == null ? R4SearchPolicyCore.class$("org.apache.felix.framework.searchpolicy.ContentClassLoader") : class$org$apache$felix$framework$searchpolicy$ContentClassLoader).isInstance(cl)) {
                    delegate = false;
                    break;
                }
                cl = cl.getClass().getClassLoader();
            }
            if (!delegate || (class$org$osgi$framework$Bundle == null ? (class$org$osgi$framework$Bundle = R4SearchPolicyCore.class$("org.osgi.framework.Bundle")) : class$org$osgi$framework$Bundle).isInstance(classes[i - 1])) break;
            try {
                return this.getClass().getClassLoader().loadClass(name);
            }
            catch (NoClassDefFoundError ex) {
                break;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IWire attemptDynamicImport(IModule importer, String pkgName) {
        R4Wire wire = null;
        PackageSource candidate = null;
        if (this.isDynamicImportAllowed(importer, pkgName)) {
            IRequirement[] dynamics = importer.getDefinition().getDynamicRequirements();
            for (int dynIdx = 0; dynamics != null && dynIdx < dynamics.length; ++dynIdx) {
                IRequirement target = this.createDynamicRequirement(dynamics[dynIdx], pkgName);
                if (target == null) continue;
                try {
                    IModuleFactory iModuleFactory = this.m_factory;
                    synchronized (iModuleFactory) {
                        PackageSource[] resolved = this.getResolvedCandidates(target);
                        PackageSource[] unresolved = this.getUnresolvedCandidates(target);
                        PackageSource[] candidates = new PackageSource[resolved.length + unresolved.length];
                        System.arraycopy(resolved, 0, candidates, 0, resolved.length);
                        System.arraycopy(unresolved, 0, candidates, resolved.length, unresolved.length);
                        for (int candIdx = 0; candidate == null && candIdx < candidates.length; ++candIdx) {
                            try {
                                if (!this.resolveDynamicImportCandidate(candidates[candIdx].m_module, importer)) continue;
                                candidate = candidates[candIdx];
                                continue;
                            }
                            catch (ResolveException ex) {
                                // empty catch block
                            }
                        }
                        if (candidate != null) {
                            IWire[] wires = importer.getWires();
                            IWire[] newWires = null;
                            if (wires == null) {
                                newWires = new IWire[1];
                            } else {
                                newWires = new IWire[wires.length + 1];
                                System.arraycopy(wires, 0, newWires, 0, wires.length);
                            }
                            wire = new R4Wire(importer, dynamics[dynIdx], candidate.m_module, candidate.m_capability);
                            newWires[newWires.length - 1] = wire;
                            ((ModuleImpl)importer).setWires(newWires);
                            this.m_logger.log(4, "WIRE: " + newWires[newWires.length - 1]);
                            return wire;
                        }
                        continue;
                    }
                }
                catch (Exception ex) {
                    this.m_logger.log(1, "Unable to dynamically import package.", ex);
                }
            }
        }
        return null;
    }

    private boolean isDynamicImportAllowed(IModule importer, String pkgName) {
        ICapability[] caps = importer.getDefinition().getCapabilities();
        for (int i = 0; caps != null && i < caps.length; ++i) {
            if (!caps[i].getNamespace().equals("package") || !caps[i].getProperties().get("package").equals(pkgName)) continue;
            return false;
        }
        IWire[] wires = importer.getWires();
        for (int i = 0; wires != null && i < wires.length; ++i) {
            if (!wires[i].hasPackage(pkgName)) continue;
            return false;
        }
        return true;
    }

    private IRequirement createDynamicRequirement(IRequirement dynReq, String pkgName) {
        Requirement req = null;
        String dynPkgName = ((Requirement)dynReq).getPackageName();
        boolean wildcard = dynPkgName.lastIndexOf(".*") >= 0;
        String string = dynPkgName = wildcard ? dynPkgName.substring(0, dynPkgName.length() - 2) : dynPkgName;
        if (dynPkgName.equals("*") || pkgName.equals(dynPkgName) || wildcard && pkgName.startsWith(dynPkgName + ".")) {
            R4Directive[] dirs = ((Requirement)dynReq).getDirectives();
            R4Attribute[] attrs = ((Requirement)dynReq).getAttributes();
            R4Attribute[] newAttrs = new R4Attribute[attrs.length];
            System.arraycopy(attrs, 0, newAttrs, 0, attrs.length);
            for (int attrIdx = 0; attrIdx < newAttrs.length; ++attrIdx) {
                if (!newAttrs[attrIdx].getName().equals("package")) continue;
                newAttrs[attrIdx] = new R4Attribute("package", pkgName, false);
                break;
            }
            req = new Requirement("package", dirs, newAttrs);
        }
        return req;
    }

    private boolean resolveDynamicImportCandidate(IModule provider, IModule importer) throws ResolveException {
        HashMap candidatesMap = new HashMap();
        if (!this.isResolved(provider)) {
            this.populateCandidatesMap(candidatesMap, provider);
            this.findConsistentClassSpace(candidatesMap, provider);
        }
        HashMap moduleMap = new HashMap();
        Map importerPkgMap = this.getModulePackages(moduleMap, importer, candidatesMap);
        Map usesMap = this.calculateUsesConstraints(provider, moduleMap, candidatesMap);
        Iterator iter = usesMap.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            ResolvedPackage rp = (ResolvedPackage)importerPkgMap.get(entry.getKey());
            if (rp == null) continue;
            rp = (ResolvedPackage)rp.clone();
            List constraintList = (List)entry.getValue();
            for (int constIdx = 0; constIdx < constraintList.size(); ++constIdx) {
                ResolvedPackage rpUses = (ResolvedPackage)constraintList.get(constIdx);
                if (rpUses.isSubset(rp)) continue;
                if (rp.isSubset(rpUses)) {
                    rp.m_sourceList.clear();
                    rp.m_sourceList.addAll(rpUses.m_sourceList);
                    continue;
                }
                this.m_logger.log(4, "Constraint violation for " + importer + " detected; module can see " + rp + " and " + rpUses);
                return false;
            }
        }
        Map resolvedModuleWireMap = this.createWires(candidatesMap, provider);
        if (resolvedModuleWireMap != null) {
            Iterator iter2 = resolvedModuleWireMap.entrySet().iterator();
            while (iter2.hasNext()) {
                this.fireModuleResolved((IModule)iter2.next().getKey());
            }
        }
        return true;
    }

    public String findLibrary(IModule module, String name) {
        if (name.startsWith("/")) {
            name = name.substring(1);
        }
        R4Library[] libs = module.getDefinition().getLibraries();
        for (int i = 0; libs != null && i < libs.length; ++i) {
            if (!libs[i].match(name)) continue;
            return module.getContentLoader().getContent().getEntryAsNativeLibrary(libs[i].getEntryName());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PackageSource[] getResolvedCandidates(IRequirement req) {
        IModuleFactory iModuleFactory = this.m_factory;
        synchronized (iModuleFactory) {
            Object[] candidates = m_emptySources;
            if (req.getNamespace().equals("package") && ((Requirement)req).getPackageName() != null) {
                String pkgName = ((Requirement)req).getPackageName();
                IModule[] modules = (IModule[])this.m_resolvedPkgIndexMap.get(pkgName);
                for (int modIdx = 0; modules != null && modIdx < modules.length; ++modIdx) {
                    ICapability resolvedCap = Util.getSatisfyingCapability(modules[modIdx], req);
                    if (resolvedCap == null) continue;
                    if (System.getSecurityManager() != null && !((BundleProtectionDomain)modules[modIdx].getContentLoader().getSecurityContext()).impliesDirect(new PackagePermission(pkgName, "export"))) {
                        this.m_logger.log(4, "PackagePermission.EXPORT denied for " + pkgName + "from " + modules[modIdx].getId());
                        continue;
                    }
                    PackageSource[] tmp = new PackageSource[candidates.length + 1];
                    System.arraycopy(candidates, 0, tmp, 0, candidates.length);
                    tmp[candidates.length] = new PackageSource(modules[modIdx], resolvedCap);
                    candidates = tmp;
                }
            } else {
                Iterator i = this.m_resolvedCapMap.entrySet().iterator();
                while (i.hasNext()) {
                    Map.Entry entry = i.next();
                    IModule module = (IModule)entry.getKey();
                    ICapability[] resolvedCaps = (ICapability[])entry.getValue();
                    for (int capIdx = 0; capIdx < resolvedCaps.length; ++capIdx) {
                        if (!req.isSatisfied(resolvedCaps[capIdx])) continue;
                        if (resolvedCaps[capIdx].getNamespace().equals("package") && System.getSecurityManager() != null && !((BundleProtectionDomain)module.getContentLoader().getSecurityContext()).impliesDirect(new PackagePermission((String)resolvedCaps[capIdx].getProperties().get("package"), "export"))) {
                            this.m_logger.log(4, "PackagePermission.EXPORT denied for " + resolvedCaps[capIdx].getProperties().get("package") + "from " + module.getId());
                            continue;
                        }
                        PackageSource[] tmp = new PackageSource[candidates.length + 1];
                        System.arraycopy(candidates, 0, tmp, 0, candidates.length);
                        tmp[candidates.length] = new PackageSource(module, resolvedCaps[capIdx]);
                        candidates = tmp;
                    }
                }
            }
            Arrays.sort(candidates);
            return candidates;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PackageSource[] getUnresolvedCandidates(IRequirement req) {
        IModuleFactory iModuleFactory = this.m_factory;
        synchronized (iModuleFactory) {
            IModule[] modules = null;
            modules = req.getNamespace().equals("package") && ((Requirement)req).getPackageName() != null ? (IModule[])this.m_unresolvedPkgIndexMap.get(((Requirement)req).getPackageName()) : this.m_factory.getModules();
            Object[] candidates = m_emptySources;
            for (int modIdx = 0; modules != null && modIdx < modules.length; ++modIdx) {
                ICapability cap = Util.getSatisfyingCapability(modules[modIdx], req);
                if (cap == null || this.isResolved(modules[modIdx])) continue;
                PackageSource[] tmp = new PackageSource[candidates.length + 1];
                System.arraycopy(candidates, 0, tmp, 0, candidates.length);
                tmp[candidates.length] = new PackageSource(modules[modIdx], cap);
                candidates = tmp;
            }
            Arrays.sort(candidates);
            return candidates;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resolve(IModule rootModule) throws ResolveException {
        Map resolvedModuleWireMap = null;
        Map fragmentMap = null;
        IModuleFactory iModuleFactory = this.m_factory;
        synchronized (iModuleFactory) {
            if (this.isResolved(rootModule)) {
                return;
            }
            IModule targetFragment = null;
            if (this.isFragment(rootModule)) {
                targetFragment = rootModule;
                List hostList = this.getPotentialHosts(targetFragment);
                rootModule = (IModule)hostList.get(0);
            }
            fragmentMap = this.getPotentialFragments(rootModule);
            if (targetFragment != null) {
                fragmentMap.put(R4SearchPolicyCore.getBundleSymbolicName(targetFragment), new IModule[]{targetFragment});
            }
            HashMap candidatesMap = new HashMap();
            this.populateCandidatesMap(candidatesMap, rootModule);
            this.findConsistentClassSpace(candidatesMap, rootModule);
            resolvedModuleWireMap = this.createWires(candidatesMap, rootModule);
            if (fragmentMap != null && fragmentMap.size() > 0) {
                ArrayList<IModule> list = new ArrayList<IModule>();
                Iterator iter = fragmentMap.entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry entry = iter.next();
                    String symName = (String)entry.getKey();
                    IModule[] fragments = (IModule[])entry.getValue();
                    list.add(fragments[0]);
                    this.setResolved(fragments[0], true);
                    this.m_logger.log(4, "(FRAGMENT) WIRE: " + rootModule + " -> " + symName + " -> " + fragments[0]);
                }
                try {
                    ((ModuleImpl)rootModule).attachFragments(list.toArray(new IModule[list.size()]));
                }
                catch (Exception ex) {
                    this.m_logger.log(1, "Unable to attach fragments", ex);
                }
            }
        }
        if (resolvedModuleWireMap != null) {
            Iterator iter = resolvedModuleWireMap.entrySet().iterator();
            while (iter.hasNext()) {
                this.fireModuleResolved((IModule)iter.next().getKey());
            }
            iter = fragmentMap.entrySet().iterator();
            while (iter.hasNext()) {
                this.fireModuleResolved(((IModule[])iter.next().getValue())[0]);
            }
        }
    }

    private boolean isFragment(IModule module) {
        Map headerMap;
        return module.getDefinition() instanceof ModuleDefinition && (headerMap = ((ModuleDefinition)module.getDefinition()).getHeaders()).containsKey("Fragment-Host");
    }

    private List getPotentialHosts(IModule fragment) throws ResolveException {
        ArrayList<IModule> hostList = new ArrayList<IModule>();
        IRequirement[] reqs = fragment.getDefinition().getRequirements();
        IRequirement hostReq = null;
        for (int reqIdx = 0; reqIdx < reqs.length; ++reqIdx) {
            if (!reqs[reqIdx].getNamespace().equals("host")) continue;
            hostReq = reqs[reqIdx];
            break;
        }
        IModule[] modules = this.m_factory.getModules();
        block1: for (int modIdx = 0; hostReq != null && modIdx < modules.length; ++modIdx) {
            if (fragment.equals(modules[modIdx]) || this.isResolved(modules[modIdx])) continue;
            ICapability[] caps = modules[modIdx].getDefinition().getCapabilities();
            for (int capIdx = 0; caps != null && capIdx < caps.length; ++capIdx) {
                if (!caps[capIdx].getNamespace().equals("host") || !hostReq.isSatisfied(caps[capIdx]) || modules[modIdx].isStale()) continue;
                hostList.add(modules[modIdx]);
                continue block1;
            }
        }
        if (hostList.size() == 0) {
            throw new ResolveException("Unable to resolve.", fragment, hostReq);
        }
        return hostList;
    }

    private Map getPotentialFragments(IModule host) {
        HashMap fragmentMap = new HashMap();
        ICapability[] caps = host.getDefinition().getCapabilities();
        ICapability bundleCap = null;
        for (int capIdx = 0; capIdx < caps.length; ++capIdx) {
            if (!caps[capIdx].getNamespace().equals("host")) continue;
            bundleCap = caps[capIdx];
            break;
        }
        IModule[] modules = this.m_factory.getModules();
        block1: for (int modIdx = 0; bundleCap != null && modIdx < modules.length; ++modIdx) {
            if (host.equals(modules[modIdx])) continue;
            IRequirement[] reqs = modules[modIdx].getDefinition().getRequirements();
            for (int reqIdx = 0; reqs != null && reqIdx < reqs.length; ++reqIdx) {
                if (!reqs[reqIdx].getNamespace().equals("host") || !reqs[reqIdx].isSatisfied(bundleCap) || modules[modIdx].isStale()) continue;
                this.indexFragment(fragmentMap, modules[modIdx]);
                continue block1;
            }
        }
        return fragmentMap;
    }

    private static String getBundleSymbolicName(IModule module) {
        ICapability[] caps = module.getDefinition().getCapabilities();
        for (int capIdx = 0; caps != null && capIdx < caps.length; ++capIdx) {
            if (!caps[capIdx].getNamespace().equals("module")) continue;
            return (String)caps[capIdx].getProperties().get("bundle-symbolic-name");
        }
        return null;
    }

    private static Version getBundleVersion(IModule module) {
        ICapability[] caps = module.getDefinition().getCapabilities();
        for (int capIdx = 0; caps != null && capIdx < caps.length; ++capIdx) {
            if (!caps[capIdx].getNamespace().equals("module")) continue;
            return (Version)caps[capIdx].getProperties().get("bundle-version");
        }
        return Version.emptyVersion;
    }

    private void indexFragment(Map map, IModule module) {
        String symName = R4SearchPolicyCore.getBundleSymbolicName(module);
        IModule[] modules = (IModule[])map.get(symName);
        if (modules == null) {
            modules = new IModule[]{module};
        } else {
            Version version = R4SearchPolicyCore.getBundleVersion(module);
            Version middleVersion = null;
            int top = 0;
            int bottom = modules.length - 1;
            int middle = 0;
            while (top <= bottom) {
                middle = (bottom - top) / 2 + top;
                middleVersion = R4SearchPolicyCore.getBundleVersion(modules[middle]);
                int cmp = middleVersion.compareTo(version);
                if (cmp < 0) {
                    bottom = middle - 1;
                    continue;
                }
                if (cmp == 0) {
                    long exportId;
                    long middleId = Util.getBundleIdFromModuleId(modules[middle].getId());
                    if (middleId < (exportId = Util.getBundleIdFromModuleId(module.getId()))) {
                        top = middle + 1;
                        continue;
                    }
                    bottom = middle - 1;
                    continue;
                }
                top = middle + 1;
            }
            if (top >= modules.length || modules[top] != module) {
                IModule[] newMods = new IModule[modules.length + 1];
                System.arraycopy(modules, 0, newMods, 0, top);
                System.arraycopy(modules, top, newMods, top + 1, modules.length - top);
                newMods[top] = module;
                modules = newMods;
            }
        }
        map.put(symName, modules);
    }

    private void populateCandidatesMap(Map candidatesMap, IModule module) throws ResolveException {
        if (candidatesMap.get(module) != null) {
            return;
        }
        ArrayList<CandidateSet> candSetList = new ArrayList<CandidateSet>();
        candidatesMap.put(module, candSetList);
        IRequirement[] reqs = module.getDefinition().getRequirements();
        for (int reqIdx = 0; reqs != null && reqIdx < reqs.length; ++reqIdx) {
            PackageSource[] resolved = this.getResolvedCandidates(reqs[reqIdx]);
            PackageSource[] unresolved = this.getUnresolvedCandidates(reqs[reqIdx]);
            PackageSource[] candidates = new PackageSource[resolved.length + unresolved.length];
            System.arraycopy(resolved, 0, candidates, 0, resolved.length);
            System.arraycopy(unresolved, 0, candidates, resolved.length, unresolved.length);
            ResolveException rethrow = null;
            if (candidates.length > 0) {
                for (int candIdx = 0; candIdx < candidates.length; ++candIdx) {
                    try {
                        if (this.isResolved(candidates[candIdx].m_module)) continue;
                        this.populateCandidatesMap(candidatesMap, candidates[candIdx].m_module);
                        continue;
                    }
                    catch (ResolveException ex) {
                        candidates[candIdx] = null;
                        rethrow = ex;
                    }
                }
                candidates = R4SearchPolicyCore.shrinkCandidateArray(candidates);
            }
            if (candidates.length == 0 && !reqs[reqIdx].isOptional()) {
                if (rethrow != null) {
                    throw rethrow;
                }
                throw new ResolveException("Unable to resolve.", module, reqs[reqIdx]);
            }
            if (candidates.length <= 0) continue;
            candSetList.add(new CandidateSet(module, reqs[reqIdx], candidates));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpPackageIndexMap(Map pkgIndexMap) {
        R4SearchPolicyCore r4SearchPolicyCore = this;
        synchronized (r4SearchPolicyCore) {
            Iterator i = pkgIndexMap.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                IModule[] modules = (IModule[])entry.getValue();
                if (modules == null || modules.length <= 0 || modules.length == 1 && modules[0].getId().equals("0")) continue;
                System.out.println("  " + entry.getKey());
                for (int j = 0; j < modules.length; ++j) {
                    System.out.println("    " + modules[j]);
                }
            }
        }
    }

    private void dumpPackageSources(Map pkgMap) {
        Iterator i = pkgMap.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            ResolvedPackage rp = (ResolvedPackage)entry.getValue();
            System.out.println(rp);
        }
    }

    private void findConsistentClassSpace(Map candidatesMap, IModule rootModule) throws ResolveException {
        ArrayList candidatesList = null;
        HashMap moduleMap = new HashMap();
        HashMap cycleMap = new HashMap();
        while (!this.isSingletonConsistent(rootModule, moduleMap, candidatesMap) || !this.isClassSpaceConsistent(rootModule, moduleMap, cycleMap, candidatesMap)) {
            if (candidatesList == null) {
                candidatesList = new ArrayList();
                Iterator iter = candidatesMap.entrySet().iterator();
                while (iter.hasNext()) {
                    candidatesList.add(iter.next().getValue());
                }
            }
            this.incrementCandidateConfiguration(candidatesList);
            moduleMap.clear();
            cycleMap.clear();
        }
    }

    private boolean isSingletonConsistent(IModule targetModule, Map moduleMap, Map candidatesMap) {
        HashMap<String, String> singletonMap = new HashMap<String, String>();
        IModule[] modules = this.m_factory.getModules();
        for (int i = 0; modules != null && i < modules.length; ++i) {
            if (!this.isResolved(modules[i]) || !this.isSingleton(modules[i])) continue;
            String symName = R4SearchPolicyCore.getBundleSymbolicName(modules[i]);
            singletonMap.put(symName, symName);
        }
        return this.areCandidatesSingletonConsistent(targetModule, singletonMap, moduleMap, new HashMap(), candidatesMap);
    }

    private boolean areCandidatesSingletonConsistent(IModule targetModule, Map singletonMap, Map moduleMap, Map cycleMap, Map candidatesMap) {
        if (cycleMap.get(targetModule) != null) {
            return true;
        }
        cycleMap.put(targetModule, targetModule);
        String symName = R4SearchPolicyCore.getBundleSymbolicName(targetModule);
        boolean isSingleton = this.isSingleton(targetModule);
        if (isSingleton && singletonMap.containsKey(symName)) {
            return false;
        }
        if (isSingleton) {
            singletonMap.put(symName, symName);
        }
        Map pkgMap = null;
        try {
            pkgMap = this.getModulePackages(moduleMap, targetModule, candidatesMap);
        }
        catch (ResolveException ex) {
            this.m_logger.log(4, "Constraint violation for " + targetModule + " detected.", ex);
            return false;
        }
        Iterator iter = pkgMap.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            ResolvedPackage rp = (ResolvedPackage)entry.getValue();
            for (int srcIdx = 0; srcIdx < rp.m_sourceList.size(); ++srcIdx) {
                PackageSource ps = (PackageSource)rp.m_sourceList.get(srcIdx);
                if (this.isResolved(ps.m_module)) continue;
                return this.areCandidatesSingletonConsistent(ps.m_module, singletonMap, moduleMap, cycleMap, candidatesMap);
            }
        }
        return true;
    }

    private boolean isSingleton(IModule module) {
        ICapability[] modCaps = Util.getCapabilityByNamespace(module, "module");
        if (modCaps == null || modCaps.length == 0) {
            return false;
        }
        R4Directive[] dirs = ((Capability)modCaps[0]).getDirectives();
        for (int dirIdx = 0; dirs != null && dirIdx < dirs.length; ++dirIdx) {
            if (!dirs[dirIdx].getName().equalsIgnoreCase("singleton") || !Boolean.valueOf(dirs[dirIdx].getValue()).booleanValue()) continue;
            return true;
        }
        return false;
    }

    private boolean isClassSpaceConsistent(IModule targetModule, Map moduleMap, Map cycleMap, Map candidatesMap) {
        if (cycleMap.get(targetModule) != null) {
            return true;
        }
        cycleMap.put(targetModule, targetModule);
        Map pkgMap = null;
        try {
            pkgMap = this.getModulePackages(moduleMap, targetModule, candidatesMap);
        }
        catch (ResolveException ex) {
            this.m_logger.log(4, "Constraint violation for " + targetModule + " detected.", ex);
            return false;
        }
        Iterator iter = pkgMap.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            ResolvedPackage rp = (ResolvedPackage)entry.getValue();
            for (int srcIdx = 0; srcIdx < rp.m_sourceList.size(); ++srcIdx) {
                PackageSource ps = (PackageSource)rp.m_sourceList.get(srcIdx);
                if (this.isClassSpaceConsistent(ps.m_module, moduleMap, cycleMap, candidatesMap)) continue;
                return false;
            }
        }
        Map usesMap = null;
        try {
            usesMap = this.calculateUsesConstraints(targetModule, moduleMap, candidatesMap);
        }
        catch (ResolveException ex) {
            this.m_logger.log(4, "Constraint violation for " + targetModule + " detected.", ex);
            return false;
        }
        Iterator iter2 = usesMap.entrySet().iterator();
        while (iter2.hasNext()) {
            Map.Entry entry = iter2.next();
            ResolvedPackage rp = (ResolvedPackage)pkgMap.get(entry.getKey());
            if (rp == null) continue;
            rp = (ResolvedPackage)rp.clone();
            List constraintList = (List)entry.getValue();
            for (int constIdx = 0; constIdx < constraintList.size(); ++constIdx) {
                ResolvedPackage rpUses = (ResolvedPackage)constraintList.get(constIdx);
                if (rpUses.isSubset(rp)) continue;
                if (rp.isSubset(rpUses)) {
                    rp.m_sourceList.clear();
                    rp.m_sourceList.addAll(rpUses.m_sourceList);
                    continue;
                }
                this.m_logger.log(4, "Constraint violation for " + targetModule + " detected; module can see " + rp + " and " + rpUses);
                return false;
            }
        }
        return true;
    }

    private Map calculateUsesConstraints(IModule targetModule, Map moduleMap, Map candidatesMap) throws ResolveException {
        Map usesMap = new HashMap();
        HashMap cycleMap = new HashMap();
        Map pkgMap = this.getModulePackages(moduleMap, targetModule, candidatesMap);
        Iterator iter = pkgMap.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            ResolvedPackage rp = (ResolvedPackage)entry.getValue();
            for (int srcIdx = 0; srcIdx < rp.m_sourceList.size(); ++srcIdx) {
                usesMap = this.calculateUsesConstraints((PackageSource)rp.m_sourceList.get(srcIdx), moduleMap, usesMap, cycleMap, candidatesMap);
            }
        }
        return usesMap;
    }

    private Map calculateUsesConstraints(PackageSource psTarget, Map moduleMap, Map usesMap, Map cycleMap, Map candidatesMap) throws ResolveException {
        if (cycleMap.get(psTarget) != null) {
            return usesMap;
        }
        cycleMap.put(psTarget, psTarget);
        Map pkgMap = this.getModulePackages(moduleMap, psTarget.m_module, candidatesMap);
        Capability cap = (Capability)psTarget.m_capability;
        for (int i = 0; i < cap.getUses().length; ++i) {
            ResolvedPackage rp = (ResolvedPackage)pkgMap.get(cap.getUses()[i]);
            if (rp == null) continue;
            for (int srcIdx = 0; srcIdx < rp.m_sourceList.size(); ++srcIdx) {
                usesMap = this.calculateUsesConstraints((PackageSource)rp.m_sourceList.get(srcIdx), moduleMap, usesMap, cycleMap, candidatesMap);
            }
            ArrayList<ResolvedPackage> constraintList = (ArrayList<ResolvedPackage>)usesMap.get(cap.getUses()[i]);
            if (constraintList == null) {
                constraintList = new ArrayList<ResolvedPackage>();
            }
            constraintList.add(rp);
            usesMap.put(cap.getUses()[i], constraintList);
        }
        return usesMap;
    }

    private Map getModulePackages(Map moduleMap, IModule module, Map candidatesMap) throws ResolveException {
        Map map = (Map)moduleMap.get(module);
        if (map == null) {
            map = this.calculateModulePackages(module, candidatesMap);
            moduleMap.put(module, map);
        }
        return map;
    }

    private Map calculateModulePackages(IModule module, Map candidatesMap) throws ResolveException {
        Map.Entry entry;
        Map importedPackages = this.calculateImportedPackages(module, candidatesMap);
        Map exportedPackages = this.calculateExportedPackages(module);
        Map requiredPackages = this.calculateRequiredPackages(module, candidatesMap);
        Iterator i = exportedPackages.entrySet().iterator();
        while (i.hasNext()) {
            entry = i.next();
            ResolvedPackage rpReq = (ResolvedPackage)requiredPackages.get(entry.getKey());
            if (rpReq != null) {
                ResolvedPackage rpExport = (ResolvedPackage)entry.getValue();
                rpReq.merge(rpExport);
                continue;
            }
            requiredPackages.put(entry.getKey(), entry.getValue());
        }
        i = importedPackages.entrySet().iterator();
        while (i.hasNext()) {
            entry = i.next();
            requiredPackages.put(entry.getKey(), entry.getValue());
        }
        return requiredPackages;
    }

    private Map calculateImportedPackages(IModule targetModule, Map candidatesMap) throws ResolveException {
        return candidatesMap.get(targetModule) == null ? this.calculateImportedPackagesResolved(targetModule) : this.calculateImportedPackagesUnresolved(targetModule, candidatesMap);
    }

    private Map calculateImportedPackagesUnresolved(IModule targetModule, Map candidatesMap) throws ResolveException {
        HashMap<String, ResolvedPackage> pkgMap = new HashMap<String, ResolvedPackage>();
        List candSetList = (List)candidatesMap.get(targetModule);
        for (int candSetIdx = 0; candSetList != null && candSetIdx < candSetList.size(); ++candSetIdx) {
            CandidateSet cs = (CandidateSet)candSetList.get(candSetIdx);
            PackageSource ps = cs.m_candidates[cs.m_idx];
            if (!ps.m_capability.getNamespace().equals("package")) continue;
            String pkgName = (String)ps.m_capability.getProperties().get("package");
            ResolvedPackage rp = new ResolvedPackage(pkgName);
            rp.m_sourceList.add(ps);
            pkgMap.put(rp.m_name, rp);
        }
        return pkgMap;
    }

    private Map calculateImportedPackagesResolved(IModule targetModule) throws ResolveException {
        HashMap<String, ResolvedPackage> pkgMap = new HashMap<String, ResolvedPackage>();
        IWire[] wires = targetModule.getWires();
        for (int wireIdx = 0; wires != null && wireIdx < wires.length; ++wireIdx) {
            if (!wires[wireIdx].getCapability().getNamespace().equals("package")) continue;
            String pkgName = (String)wires[wireIdx].getCapability().getProperties().get("package");
            ResolvedPackage rp = (ResolvedPackage)pkgMap.get(pkgName);
            rp = rp == null ? new ResolvedPackage(pkgName) : rp;
            rp.m_sourceList.add(new PackageSource(wires[wireIdx].getExporter(), wires[wireIdx].getCapability()));
            pkgMap.put(rp.m_name, rp);
        }
        return pkgMap;
    }

    private Map calculateExportedPackages(IModule targetModule) {
        HashMap<String, ResolvedPackage> pkgMap = new HashMap<String, ResolvedPackage>();
        ICapability[] caps = targetModule.getDefinition().getCapabilities();
        for (int capIdx = 0; caps != null && capIdx < caps.length; ++capIdx) {
            if (!caps[capIdx].getNamespace().equals("package")) continue;
            String pkgName = (String)caps[capIdx].getProperties().get("package");
            ResolvedPackage rp = (ResolvedPackage)pkgMap.get(pkgName);
            rp = rp == null ? new ResolvedPackage(pkgName) : rp;
            rp.m_sourceList.add(new PackageSource(targetModule, caps[capIdx]));
            pkgMap.put(rp.m_name, rp);
        }
        return pkgMap;
    }

    private Map calculateRequiredPackages(IModule targetModule, Map candidatesMap) {
        return candidatesMap.get(targetModule) == null ? this.calculateRequiredPackagesResolved(targetModule) : this.calculateRequiredPackagesUnresolved(targetModule, candidatesMap);
    }

    private Map calculateRequiredPackagesUnresolved(IModule targetModule, Map candidatesMap) {
        HashMap pkgMap = new HashMap();
        List candSetList = (List)candidatesMap.get(targetModule);
        for (int candSetIdx = 0; candSetList != null && candSetIdx < candSetList.size(); ++candSetIdx) {
            CandidateSet cs = (CandidateSet)candSetList.get(candSetIdx);
            PackageSource ps = cs.m_candidates[cs.m_idx];
            if (!ps.m_capability.getNamespace().equals("module")) continue;
            HashMap<IModule, IModule> cycleMap = new HashMap<IModule, IModule>();
            cycleMap.put(targetModule, targetModule);
            Map requireMap = this.calculateExportedAndReexportedPackages(ps, candidatesMap, cycleMap);
            Iterator reqIter = requireMap.entrySet().iterator();
            while (reqIter.hasNext()) {
                Map.Entry entry = reqIter.next();
                ResolvedPackage rp = (ResolvedPackage)pkgMap.get(entry.getKey());
                if (rp != null) {
                    ResolvedPackage rpReq = (ResolvedPackage)entry.getValue();
                    rp.merge(rpReq);
                    continue;
                }
                pkgMap.put(entry.getKey(), entry.getValue());
            }
        }
        return pkgMap;
    }

    private Map calculateRequiredPackagesResolved(IModule targetModule) {
        HashMap pkgMap = new HashMap();
        IWire[] wires = targetModule.getWires();
        for (int i = 0; wires != null && i < wires.length; ++i) {
            if (!wires[i].getCapability().getNamespace().equals("module")) continue;
            HashMap<IModule, IModule> cycleMap = new HashMap<IModule, IModule>();
            cycleMap.put(targetModule, targetModule);
            Map requireMap = this.calculateExportedAndReexportedPackagesResolved(wires[i].getExporter(), cycleMap);
            Iterator reqIter = requireMap.entrySet().iterator();
            while (reqIter.hasNext()) {
                Map.Entry entry = reqIter.next();
                ResolvedPackage rp = (ResolvedPackage)pkgMap.get(entry.getKey());
                if (rp != null) {
                    ResolvedPackage rpReq = (ResolvedPackage)entry.getValue();
                    rp.merge(rpReq);
                    continue;
                }
                pkgMap.put(entry.getKey(), entry.getValue());
            }
        }
        return pkgMap;
    }

    private Map calculateExportedAndReexportedPackages(PackageSource psTarget, Map candidatesMap, Map cycleMap) {
        return candidatesMap.get(psTarget.m_module) == null ? this.calculateExportedAndReexportedPackagesResolved(psTarget.m_module, cycleMap) : this.calculateExportedAndReexportedPackagesUnresolved(psTarget, candidatesMap, cycleMap);
    }

    private Map calculateExportedAndReexportedPackagesUnresolved(PackageSource psTarget, Map candidatesMap, Map cycleMap) {
        HashMap pkgMap = new HashMap();
        if (cycleMap.get(psTarget.m_module) != null) {
            return pkgMap;
        }
        cycleMap.put(psTarget.m_module, psTarget.m_module);
        HashMap allRequiredMap = new HashMap();
        HashMap<String, String> reexportedPkgMap = new HashMap<String, String>();
        List candSetList = (List)candidatesMap.get(psTarget.m_module);
        for (int candSetIdx = 0; candSetIdx < candSetList.size(); ++candSetIdx) {
            CandidateSet cs = (CandidateSet)candSetList.get(candSetIdx);
            PackageSource ps = cs.m_candidates[cs.m_idx];
            if (!ps.m_capability.getNamespace().equals("module")) continue;
            boolean reexport = false;
            R4Directive[] dirs = ((Requirement)cs.m_requirement).getDirectives();
            for (int dirIdx = 0; !reexport && dirs != null && dirIdx < dirs.length; ++dirIdx) {
                if (!dirs[dirIdx].getName().equals("visibility") || !dirs[dirIdx].getValue().equals("reexport")) continue;
                reexport = true;
            }
            Map requiredMap = this.calculateExportedAndReexportedPackages(ps, candidatesMap, cycleMap);
            Iterator reqIter = requiredMap.entrySet().iterator();
            while (reqIter.hasNext()) {
                Map.Entry entry = reqIter.next();
                String pkgName = (String)entry.getKey();
                ResolvedPackage rp = (ResolvedPackage)allRequiredMap.get(pkgName);
                if (rp != null) {
                    ResolvedPackage rpReq = (ResolvedPackage)entry.getValue();
                    rp.merge(rpReq);
                } else {
                    allRequiredMap.put(pkgName, entry.getValue());
                }
                if (!reexport) continue;
                reexportedPkgMap.put(pkgName, pkgName);
            }
        }
        Iterator iter = reexportedPkgMap.entrySet().iterator();
        while (iter.hasNext()) {
            String pkgName = (String)iter.next().getKey();
            pkgMap.put(pkgName, allRequiredMap.get(pkgName));
        }
        ICapability[] candCaps = psTarget.m_module.getDefinition().getCapabilities();
        for (int capIdx = 0; candCaps != null && capIdx < candCaps.length; ++capIdx) {
            if (!candCaps[capIdx].getNamespace().equals("package")) continue;
            String pkgName = (String)candCaps[capIdx].getProperties().get("package");
            ResolvedPackage rp = (ResolvedPackage)pkgMap.get(pkgName);
            rp = rp == null ? new ResolvedPackage(pkgName) : rp;
            rp.m_sourceList.add(new PackageSource(psTarget.m_module, candCaps[capIdx]));
            pkgMap.put(rp.m_name, rp);
        }
        return pkgMap;
    }

    private Map calculateExportedAndReexportedPackagesResolved(IModule targetModule, Map cycleMap) {
        HashMap pkgMap = new HashMap();
        if (cycleMap.get(targetModule) != null) {
            return pkgMap;
        }
        cycleMap.put(targetModule, targetModule);
        HashMap allRequiredMap = new HashMap();
        HashMap<String, String> reexportedPkgMap = new HashMap<String, String>();
        IWire[] wires = targetModule.getWires();
        for (int i = 0; wires != null && i < wires.length; ++i) {
            if (!wires[i].getCapability().getNamespace().equals("module")) continue;
            boolean reexport = false;
            R4Directive[] dirs = ((Requirement)wires[i].getRequirement()).getDirectives();
            for (int dirIdx = 0; !reexport && dirs != null && dirIdx < dirs.length; ++dirIdx) {
                if (!dirs[dirIdx].getName().equals("visibility") || !dirs[dirIdx].getValue().equals("reexport")) continue;
                reexport = true;
            }
            Map requiredMap = this.calculateExportedAndReexportedPackagesResolved(wires[i].getExporter(), cycleMap);
            Iterator reqIter = requiredMap.entrySet().iterator();
            while (reqIter.hasNext()) {
                Map.Entry entry = reqIter.next();
                String pkgName = (String)entry.getKey();
                ResolvedPackage rp = (ResolvedPackage)allRequiredMap.get(pkgName);
                if (rp != null) {
                    ResolvedPackage rpReq = (ResolvedPackage)entry.getValue();
                    rp.merge(rpReq);
                } else {
                    allRequiredMap.put(pkgName, entry.getValue());
                }
                if (!reexport) continue;
                reexportedPkgMap.put(pkgName, pkgName);
            }
        }
        Iterator iter = reexportedPkgMap.entrySet().iterator();
        while (iter.hasNext()) {
            String pkgName = (String)iter.next().getKey();
            pkgMap.put(pkgName, allRequiredMap.get(pkgName));
        }
        ICapability[] caps = targetModule.getDefinition().getCapabilities();
        for (int i = 0; caps != null && i < caps.length; ++i) {
            if (!caps[i].getNamespace().equals("package")) continue;
            String pkgName = (String)caps[i].getProperties().get("package");
            ResolvedPackage rp = (ResolvedPackage)pkgMap.get(pkgName);
            rp = rp == null ? new ResolvedPackage(pkgName) : rp;
            rp.m_sourceList.add(new PackageSource(targetModule, caps[i]));
            pkgMap.put(rp.m_name, rp);
        }
        return pkgMap;
    }

    private Map calculateCandidateRequiredPackages(IModule module, PackageSource psTarget, Map candidatesMap) {
        HashMap<IModule, IModule> cycleMap = new HashMap<IModule, IModule>();
        cycleMap.put(module, module);
        return this.calculateExportedAndReexportedPackages(psTarget, candidatesMap, cycleMap);
    }

    private void incrementCandidateConfiguration(List resolverList) throws ResolveException {
        for (int i = 0; i < resolverList.size(); ++i) {
            List candSetList = (List)resolverList.get(i);
            for (int j = 0; j < candSetList.size(); ++j) {
                CandidateSet cs = (CandidateSet)candSetList.get(j);
                if (cs.m_idx + 1 < cs.m_candidates.length) {
                    ++cs.m_idx;
                    return;
                }
                cs.m_idx = 0;
            }
        }
        throw new ResolveException("Unable to resolve due to constraint violation.", null, null);
    }

    private Map createWires(Map candidatesMap, IModule rootModule) {
        Map resolvedModuleWireMap = this.populateWireMap(candidatesMap, rootModule, new HashMap());
        Iterator iter = resolvedModuleWireMap.entrySet().iterator();
        while (iter.hasNext()) {
            int capIdx;
            ICapability[] capsCopy;
            Map.Entry entry = iter.next();
            IModule module = (IModule)entry.getKey();
            IWire[] wires = (IWire[])entry.getValue();
            this.setResolved(module, true);
            if (wires.length > 0) {
                ((ModuleImpl)module).setWires(wires);
                for (int wireIdx = 0; wires != null && wireIdx < wires.length; ++wireIdx) {
                    this.m_logger.log(4, "WIRE: " + wires[wireIdx]);
                }
            }
            ICapability[] caps = module.getDefinition().getCapabilities();
            for (int capIdx2 = 0; caps != null && capIdx2 < caps.length; ++capIdx2) {
                if (!caps[capIdx2].getNamespace().equals("package")) continue;
                String pkgName = (String)caps[capIdx2].getProperties().get("package");
                this.m_unresolvedPkgIndexMap.put(pkgName, R4SearchPolicyCore.removeModuleFromArray((IModule[])this.m_unresolvedPkgIndexMap.get(pkgName), module));
            }
            ICapability[] iCapabilityArray = capsCopy = caps == null ? null : new ICapability[caps.length];
            if (capsCopy != null) {
                System.arraycopy(caps, 0, capsCopy, 0, caps.length);
            }
            block3: for (capIdx = 0; capsCopy != null && capIdx < capsCopy.length; ++capIdx) {
                for (int wireIdx = 0; wires != null && wireIdx < wires.length; ++wireIdx) {
                    if (!wires[wireIdx].getRequirement().isSatisfied(capsCopy[capIdx])) continue;
                    if (wires[wireIdx].getExporter().equals(module)) continue block3;
                    capsCopy[capIdx] = null;
                    continue block3;
                }
            }
            for (capIdx = 0; capsCopy != null && capIdx < capsCopy.length; ++capIdx) {
                if (capsCopy[capIdx] == null) continue;
                ICapability[] resolvedCaps = (ICapability[])this.m_resolvedCapMap.get(module);
                resolvedCaps = R4SearchPolicyCore.addCapabilityToArray(resolvedCaps, capsCopy[capIdx]);
                this.m_resolvedCapMap.put(module, resolvedCaps);
                if (!capsCopy[capIdx].getNamespace().equals("package")) continue;
                this.indexPackageCapability(this.m_resolvedPkgIndexMap, module, capsCopy[capIdx]);
            }
        }
        return resolvedModuleWireMap;
    }

    private Map populateWireMap(Map candidatesMap, IModule importer, Map wireMap) {
        if (this.isResolved(importer) || wireMap.get(importer) != null) {
            return wireMap;
        }
        List candSetList = (List)candidatesMap.get(importer);
        ArrayList<R4WireModule> moduleWires = new ArrayList<R4WireModule>();
        ArrayList<IWire> packageWires = new ArrayList<IWire>();
        IWire[] wires = new IWire[candSetList.size()];
        wireMap.put(importer, wires);
        for (int candSetIdx = 0; candSetIdx < candSetList.size(); ++candSetIdx) {
            CandidateSet cs = (CandidateSet)candSetList.get(candSetIdx);
            if (cs.m_requirement.getNamespace().equals("module")) {
                moduleWires.add(new R4WireModule(importer, cs.m_requirement, cs.m_candidates[cs.m_idx].m_module, cs.m_candidates[cs.m_idx].m_capability, this.calculateCandidateRequiredPackages(importer, cs.m_candidates[cs.m_idx], candidatesMap)));
            } else {
                packageWires.add(new R4Wire(importer, cs.m_requirement, cs.m_candidates[cs.m_idx].m_module, cs.m_candidates[cs.m_idx].m_capability));
            }
            wireMap = this.populateWireMap(candidatesMap, cs.m_candidates[cs.m_idx].m_module, wireMap);
        }
        packageWires.addAll(moduleWires);
        wireMap.put(importer, packageWires.toArray(wires));
        return wireMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addResolverListener(ResolveListener l) {
        if (l == null) {
            throw new IllegalArgumentException("Listener is null");
        }
        ResolveListener[] resolveListenerArray = m_emptyListeners;
        synchronized (m_emptyListeners) {
            if (this.m_listeners == m_emptyListeners) {
                this.m_listeners = new ResolveListener[]{l};
            } else {
                ResolveListener[] newList = new ResolveListener[this.m_listeners.length + 1];
                System.arraycopy(this.m_listeners, 0, newList, 0, this.m_listeners.length);
                newList[this.m_listeners.length] = l;
                this.m_listeners = newList;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeResolverListener(ResolveListener l) {
        if (l == null) {
            throw new IllegalArgumentException("Listener is null");
        }
        ResolveListener[] resolveListenerArray = m_emptyListeners;
        synchronized (m_emptyListeners) {
            int idx = -1;
            for (int i = 0; i < this.m_listeners.length; ++i) {
                if (!this.m_listeners[i].equals(l)) continue;
                idx = i;
                break;
            }
            if (idx >= 0) {
                if (this.m_listeners.length == 1) {
                    this.m_listeners = m_emptyListeners;
                } else {
                    ResolveListener[] newList = new ResolveListener[this.m_listeners.length - 1];
                    System.arraycopy(this.m_listeners, 0, newList, 0, idx);
                    if (idx < newList.length) {
                        System.arraycopy(this.m_listeners, idx + 1, newList, idx, newList.length - idx);
                    }
                    this.m_listeners = newList;
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    private void fireModuleResolved(IModule module) {
        ModuleEvent event = null;
        ResolveListener[] listeners = this.m_listeners;
        for (int i = 0; i < listeners.length; ++i) {
            if (event == null) {
                event = new ModuleEvent(this.m_factory, module);
            }
            listeners[i].moduleResolved(event);
        }
    }

    private void fireModuleUnresolved(IModule module) {
        ModuleEvent event = null;
        ResolveListener[] listeners = this.m_listeners;
        for (int i = 0; i < listeners.length; ++i) {
            if (event == null) {
                event = new ModuleEvent(this.m_factory, module);
            }
            listeners[i].moduleUnresolved(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moduleAdded(ModuleEvent event) {
        IModuleFactory iModuleFactory = this.m_factory;
        synchronized (iModuleFactory) {
            IModule module = event.getModule();
            ICapability[] caps = module.getDefinition().getCapabilities();
            for (int i = 0; caps != null && i < caps.length; ++i) {
                if (!caps[i].getNamespace().equals("package")) continue;
                this.indexPackageCapability(this.m_unresolvedPkgIndexMap, module, caps[i]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moduleRemoved(ModuleEvent event) {
        IModuleFactory iModuleFactory = this.m_factory;
        synchronized (iModuleFactory) {
            ICapability[] caps = event.getModule().getDefinition().getCapabilities();
            for (int i = 0; caps != null && i < caps.length; ++i) {
                if (!caps[i].getNamespace().equals("package")) continue;
                String pkgName = (String)caps[i].getProperties().get("package");
                IModule[] modules = (IModule[])this.m_unresolvedPkgIndexMap.get(pkgName);
                if (modules != null) {
                    modules = R4SearchPolicyCore.removeModuleFromArray(modules, event.getModule());
                    this.m_unresolvedPkgIndexMap.put(pkgName, modules);
                }
                if ((modules = (IModule[])this.m_resolvedPkgIndexMap.get(pkgName)) == null) continue;
                modules = R4SearchPolicyCore.removeModuleFromArray(modules, event.getModule());
                this.m_resolvedPkgIndexMap.put(pkgName, modules);
            }
            try {
                ((ModuleImpl)event.getModule()).attachFragments(null);
            }
            catch (Exception ex) {
                this.m_logger.log(1, "Error detaching fragments.", ex);
            }
            ((ModuleImpl)event.getModule()).setWires(null);
            this.m_resolvedCapMap.remove(event.getModule());
            this.m_moduleDataMap.remove(event.getModule());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moduleRefreshed(ModuleEvent event) {
        IModuleFactory iModuleFactory = this.m_factory;
        synchronized (iModuleFactory) {
            IModule module = event.getModule();
            ICapability[] caps = event.getModule().getDefinition().getCapabilities();
            for (int i = 0; caps != null && i < caps.length; ++i) {
                ICapability[] resolvedCaps = (ICapability[])this.m_resolvedCapMap.get(module);
                resolvedCaps = R4SearchPolicyCore.addCapabilityToArray(resolvedCaps, caps[i]);
                this.m_resolvedCapMap.put(module, resolvedCaps);
                if (!caps[i].getNamespace().equals("package")) continue;
                String pkgName = (String)caps[i].getProperties().get("package");
                this.indexPackageCapability(this.m_resolvedPkgIndexMap, module, caps[i]);
            }
        }
    }

    private void indexPackageCapability(Map map, IModule module, ICapability capability) {
        if (capability.getNamespace().equals("package")) {
            String pkgName = (String)capability.getProperties().get("package");
            IModule[] modules = (IModule[])map.get(pkgName);
            if (modules == null) {
                modules = new IModule[]{module};
            } else {
                Version version = (Version)capability.getProperties().get("version");
                Version middleVersion = null;
                int top = 0;
                int bottom = modules.length - 1;
                int middle = 0;
                while (top <= bottom) {
                    middle = (bottom - top) / 2 + top;
                    middleVersion = (Version)R4SearchPolicyCore.getExportPackageCapability(modules[middle], pkgName).getProperties().get("version");
                    int cmp = middleVersion.compareTo(version);
                    if (cmp < 0) {
                        bottom = middle - 1;
                        continue;
                    }
                    if (cmp == 0) {
                        long exportId;
                        long middleId = Util.getBundleIdFromModuleId(modules[middle].getId());
                        if (middleId < (exportId = Util.getBundleIdFromModuleId(module.getId()))) {
                            top = middle + 1;
                            continue;
                        }
                        bottom = middle - 1;
                        continue;
                    }
                    top = middle + 1;
                }
                if (top >= modules.length || modules[top] != module) {
                    IModule[] newMods = new IModule[modules.length + 1];
                    System.arraycopy(modules, 0, newMods, 0, top);
                    System.arraycopy(modules, top, newMods, top + 1, modules.length - top);
                    newMods[top] = module;
                    modules = newMods;
                }
            }
            map.put(pkgName, modules);
        }
    }

    public static ICapability getExportPackageCapability(IModule m, String pkgName) {
        ICapability[] caps = m.getDefinition().getCapabilities();
        for (int i = 0; caps != null && i < caps.length; ++i) {
            if (!caps[i].getNamespace().equals("package") || !caps[i].getProperties().get("package").equals(pkgName)) continue;
            return caps[i];
        }
        return null;
    }

    private static IModule[] removeModuleFromArray(IModule[] modules, IModule m) {
        if (modules == null) {
            return m_emptyModules;
        }
        int idx = -1;
        do {
            idx = -1;
            for (int i = 0; i < modules.length; ++i) {
                if (modules[i] != m) continue;
                idx = i;
                break;
            }
            if (idx < 0) continue;
            if (modules.length - 1 == 0) {
                modules = m_emptyModules;
                continue;
            }
            IModule[] newModules = new IModule[modules.length - 1];
            System.arraycopy(modules, 0, newModules, 0, idx);
            if (idx < newModules.length) {
                System.arraycopy(modules, idx + 1, newModules, idx, newModules.length - idx);
            }
            modules = newModules;
        } while (idx >= 0);
        return modules;
    }

    private static PackageSource[] shrinkCandidateArray(PackageSource[] candidates) {
        if (candidates == null) {
            return m_emptySources;
        }
        int lower = 0;
        for (int i = 0; i < candidates.length; ++i) {
            if (candidates[i] == null) continue;
            candidates[lower++] = candidates[i];
        }
        if (lower == 0) {
            return m_emptySources;
        }
        PackageSource[] newCandidates = new PackageSource[lower];
        System.arraycopy(candidates, 0, newCandidates, 0, lower);
        return newCandidates;
    }

    private static ICapability[] addCapabilityToArray(ICapability[] caps, ICapability cap) {
        for (int i = 0; caps != null && i < caps.length; ++i) {
            if (!caps[i].equals(cap)) continue;
            return caps;
        }
        if (caps != null) {
            ICapability[] newCaps = new ICapability[caps.length + 1];
            System.arraycopy(caps, 0, newCaps, 0, caps.length);
            newCaps[caps.length] = cap;
            caps = newCaps;
        } else {
            caps = new ICapability[]{cap};
        }
        return caps;
    }

    private String diagnoseClassLoadError(IModule module, String name) {
        String pkgName = Util.getClassPackage(name);
        long impId = Util.getBundleIdFromModuleId(module.getId());
        IWire[] wires = module.getWires();
        for (int i = 0; wires != null && i < wires.length; ++i) {
            if (!wires[i].getCapability().getNamespace().equals("package") || !wires[i].getCapability().getProperties().get("package").equals(pkgName)) continue;
            long expId = Util.getBundleIdFromModuleId(wires[i].getExporter().getId());
            StringBuffer sb = new StringBuffer("*** Package '");
            sb.append(pkgName);
            sb.append("' is imported by bundle ");
            sb.append(impId);
            sb.append(" from bundle ");
            sb.append(expId);
            sb.append(", but the exported package from bundle ");
            sb.append(expId);
            sb.append(" does not contain the requested class '");
            sb.append(name);
            sb.append("'. Please verify that the class name is correct in the importing bundle ");
            sb.append(impId);
            sb.append(" and/or that the exported package is correctly bundled in ");
            sb.append(expId);
            sb.append(". ***");
            return sb.toString();
        }
        IRequirement[] reqs = module.getDefinition().getRequirements();
        IRequirement[] dynamics = module.getDefinition().getDynamicRequirements();
        for (int dynIdx = 0; dynIdx < dynamics.length; ++dynIdx) {
            IRequirement target = this.createDynamicRequirement(dynamics[dynIdx], pkgName);
            if (target == null) continue;
            PackageSource[] exporters = this.getResolvedCandidates(target);
            PackageSource[] packageSourceArray = exporters = exporters.length == 0 ? this.getUnresolvedCandidates(target) : exporters;
            if (exporters.length == 0) {
                try {
                    Requirement pkgReq = new Requirement("package", "(package=" + pkgName + ")");
                    exporters = this.getResolvedCandidates(pkgReq);
                    exporters = exporters.length == 0 ? this.getUnresolvedCandidates(pkgReq) : exporters;
                }
                catch (InvalidSyntaxException ex) {
                    // empty catch block
                }
            }
            long expId = exporters.length == 0 ? -1L : Util.getBundleIdFromModuleId(exporters[0].m_module.getId());
            StringBuffer sb = new StringBuffer("*** Class '");
            sb.append(name);
            sb.append("' was not found, but this is likely normal since package '");
            sb.append(pkgName);
            sb.append("' is dynamically imported by bundle ");
            sb.append(impId);
            sb.append(".");
            if (exporters.length > 0) {
                try {
                    if (!target.isSatisfied(Util.getSatisfyingCapability(exporters[0].m_module, new Requirement("package", "(package=" + pkgName + ")")))) {
                        sb.append(" However, bundle ");
                        sb.append(expId);
                        sb.append(" does export this package with attributes that do not match.");
                    }
                }
                catch (InvalidSyntaxException ex) {
                    // empty catch block
                }
            }
            sb.append(" ***");
            return sb.toString();
        }
        Requirement pkgReq = null;
        try {
            pkgReq = new Requirement("package", "(package=" + pkgName + ")");
        }
        catch (InvalidSyntaxException ex) {
            // empty catch block
        }
        PackageSource[] exporters = this.getResolvedCandidates(pkgReq);
        PackageSource[] packageSourceArray = exporters = exporters.length == 0 ? this.getUnresolvedCandidates(pkgReq) : exporters;
        if (exporters.length > 0) {
            boolean classpath = false;
            try {
                this.getClass().getClassLoader().loadClass(name);
                classpath = true;
            }
            catch (NoClassDefFoundError err) {
            }
            catch (Exception ex) {
                // empty catch block
            }
            long expId = Util.getBundleIdFromModuleId(exporters[0].m_module.getId());
            StringBuffer sb = new StringBuffer("*** Class '");
            sb.append(name);
            sb.append("' was not found because bundle ");
            sb.append(impId);
            sb.append(" does not import '");
            sb.append(pkgName);
            sb.append("' even though bundle ");
            sb.append(expId);
            sb.append(" does export it.");
            if (classpath) {
                sb.append(" Additionally, the class is also available from the system class loader. There are two fixes: 1) Add an import for '");
                sb.append(pkgName);
                sb.append("' to bundle ");
                sb.append(impId);
                sb.append("; imports are necessary for each class directly touched by bundle code or indirectly touched, such as super classes if their methods are used. ");
                sb.append("2) Add package '");
                sb.append(pkgName);
                sb.append("' to the '");
                sb.append("org.osgi.framework.bootdelegation");
                sb.append("' property; a library or VM bug can cause classes to be loaded by the wrong class loader. The first approach is preferable for preserving modularity.");
            } else {
                sb.append(" To resolve this issue, add an import for '");
                sb.append(pkgName);
                sb.append("' to bundle ");
                sb.append(impId);
                sb.append(".");
            }
            sb.append(" ***");
            return sb.toString();
        }
        try {
            this.getClass().getClassLoader().loadClass(name);
            StringBuffer sb = new StringBuffer("*** Package '");
            sb.append(pkgName);
            sb.append("' is not imported by bundle ");
            sb.append(impId);
            sb.append(", nor is there any bundle that exports package '");
            sb.append(pkgName);
            sb.append("'. However, the class '");
            sb.append(name);
            sb.append("' is available from the system class loader. There are two fixes: 1) Add package '");
            sb.append(pkgName);
            sb.append("' to the '");
            sb.append("org.osgi.framework.system.packages.extra");
            sb.append("' property and modify bundle ");
            sb.append(impId);
            sb.append(" to import this package; this causes the system bundle to export class path packages. 2) Add package '");
            sb.append(pkgName);
            sb.append("' to the '");
            sb.append("org.osgi.framework.bootdelegation");
            sb.append("' property; a library or VM bug can cause classes to be loaded by the wrong class loader. The first approach is preferable for preserving modularity.");
            sb.append(" ***");
            return sb.toString();
        }
        catch (Exception ex2) {
            StringBuffer sb = new StringBuffer("*** Class '");
            sb.append(name);
            sb.append("' was not found. Bundle ");
            sb.append(impId);
            sb.append(" does not import package '");
            sb.append(pkgName);
            sb.append("', nor is the package exported by any other bundle or available from the system class loader.");
            sb.append(" ***");
            return sb.toString();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected class ResolvedPackage {
        public String m_name = null;
        public List m_sourceList = new ArrayList();

        public ResolvedPackage(String name) {
            this.m_name = name;
        }

        public boolean isSubset(ResolvedPackage rp) {
            if (this.m_sourceList.size() > rp.m_sourceList.size()) {
                return false;
            }
            if (!this.m_name.equals(rp.m_name)) {
                return false;
            }
            return rp.m_sourceList.containsAll(this.m_sourceList);
        }

        public Object clone() {
            ResolvedPackage rp = new ResolvedPackage(this.m_name);
            rp.m_sourceList.addAll(this.m_sourceList);
            return rp;
        }

        public void merge(ResolvedPackage rp) {
            for (int srcIdx = 0; srcIdx < rp.m_sourceList.size(); ++srcIdx) {
                if (this.m_sourceList.contains(rp.m_sourceList.get(srcIdx))) continue;
                this.m_sourceList.add(rp.m_sourceList.get(srcIdx));
            }
        }

        public String toString() {
            return this.toString("", new StringBuffer()).toString();
        }

        public StringBuffer toString(String padding, StringBuffer sb) {
            sb.append(padding);
            sb.append(this.m_name);
            sb.append(" from [");
            for (int i = 0; i < this.m_sourceList.size(); ++i) {
                PackageSource ps = (PackageSource)this.m_sourceList.get(i);
                sb.append(ps.m_module);
                if (i + 1 >= this.m_sourceList.size()) continue;
                sb.append(", ");
            }
            sb.append("]");
            return sb;
        }
    }

    public class PackageSource
    implements Comparable {
        public IModule m_module = null;
        public ICapability m_capability = null;

        public PackageSource(IModule module, ICapability capability) {
            this.m_module = module;
            this.m_capability = capability;
        }

        public int compareTo(Object o) {
            PackageSource ps = (PackageSource)o;
            Version thisVersion = null;
            Version version = null;
            if (this.m_capability.getNamespace().equals("package")) {
                thisVersion = ((Capability)this.m_capability).getPackageVersion();
                version = ((Capability)ps.m_capability).getPackageVersion();
            } else if (this.m_capability.getNamespace().equals("module")) {
                thisVersion = (Version)this.m_capability.getProperties().get("bundle-version");
                version = (Version)ps.m_capability.getProperties().get("bundle-version");
            }
            if (thisVersion != null && version != null) {
                long id;
                int cmp = thisVersion.compareTo(version);
                if (cmp < 0) {
                    return 1;
                }
                if (cmp > 0) {
                    return -1;
                }
                long thisId = Util.getBundleIdFromModuleId(this.m_module.getId());
                if (thisId < (id = Util.getBundleIdFromModuleId(ps.m_module.getId()))) {
                    return -1;
                }
                if (thisId > id) {
                    return 1;
                }
                return 0;
            }
            return -1;
        }

        public int hashCode() {
            int PRIME = 31;
            int result = 1;
            result = 31 * result + (this.m_capability == null ? 0 : this.m_capability.hashCode());
            result = 31 * result + (this.m_module == null ? 0 : this.m_module.hashCode());
            return result;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null) {
                return false;
            }
            if (this.getClass() != o.getClass()) {
                return false;
            }
            PackageSource ps = (PackageSource)o;
            return this.m_module.equals(ps.m_module) && this.m_capability == ps.m_capability;
        }
    }

    private class CandidateSet {
        public IModule m_module = null;
        public IRequirement m_requirement = null;
        public PackageSource[] m_candidates = null;
        public int m_idx = 0;

        public CandidateSet(IModule module, IRequirement requirement, PackageSource[] candidates) {
            this.m_module = module;
            this.m_requirement = requirement;
            this.m_candidates = candidates;
        }
    }

    private static class ModuleData {
        public IModule m_module = null;
        public boolean m_resolved = false;

        public ModuleData(IModule module) {
            this.m_module = module;
        }
    }
}

