/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.launcher.felix;

import java.rmi.RMISecurityManager;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Policy;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Map;
import org.apache.felix.framework.Felix;
import org.apache.felix.main.AutoActivator;
import org.ow2.jonas.launcher.felix.DefaultConfigurationProvider;
import org.ow2.jonas.launcher.felix.IConfigurationProvider;
import org.ow2.jonas.launcher.felix.util.IOUtils;
import org.ow2.jonas.launcher.felix.util.JOnASUtils;

public class JOnAS {
    private Felix felix;
    private static final String SECURITY_MANAGER = "jonas.security.manager";

    public JOnAS(boolean forceCleanUp) throws Exception {
        System.out.println("\nWelcome to OW2 JOnAS (Running on Felix).");
        System.out.println("-----------------------------------------------\n");
        boolean useSecurityManager = new Boolean(JOnASUtils.getServerProperty(SECURITY_MANAGER, "true").trim());
        if (useSecurityManager) {
            Policy.setPolicy(new Policy(){

                public void refresh() {
                }

                public PermissionCollection getPermissions(CodeSource source) {
                    return new PermissionCollection(){

                        public void add(Permission perm) {
                        }

                        public boolean implies(Permission perm) {
                            return true;
                        }

                        public Enumeration elements() {
                            return new Enumeration(){
                                private volatile boolean more = true;

                                public Object nextElement() {
                                    this.more = false;
                                    return new AllPermission();
                                }

                                public boolean hasMoreElements() {
                                    return this.more;
                                }
                            };
                        }
                    };
                }
            });
            if (System.getSecurityManager() == null) {
                System.setSecurityManager(new RMISecurityManager());
            }
        }
        this.initializeSystemProperties();
        IConfigurationProvider provider = this.getConfigurationProvider();
        Map configProps = provider.getConfiguration();
        if (forceCleanUp) {
            configProps.put("org.osgi.framework.storage.clean", "onFirstInit");
        }
        ArrayList<AutoActivator> list = new ArrayList<AutoActivator>();
        list.add(new AutoActivator(configProps));
        configProps.put("felix.systembundle.activators", list);
        this.felix = new Felix(configProps);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                try {
                    if (JOnAS.this.felix.getState() == 32) {
                        JOnAS.this.felix.stop();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace(System.err);
                }
            }
        });
    }

    public void start() throws Exception {
        this.felix.start();
        this.felix.waitForStop(0L);
        System.exit(0);
    }

    public void stop() throws Exception {
        if (this.felix.getState() == 32) {
            this.felix.stop();
        }
    }

    protected IConfigurationProvider getConfigurationProvider() {
        return new DefaultConfigurationProvider();
    }

    public static void main(String[] args) throws Exception {
        JOnAS jonas = new JOnAS(Boolean.getBoolean("jonas.cache.clean"));
        jonas.start();
    }

    protected void initializeSystemProperties() {
        System.setProperty("jonas.start.date", Long.toString(System.currentTimeMillis()));
        System.setProperty("monolog.wrappers", "mx4j.log.CommonsLogger,mx4j.log.Logger,java.util.logging.Logger,org.ow2.util.log.JDKLogger, org.apache.juli.logging.DirectJDKLog,org.ow2.carol.util.configuration.TraceCarol");
        System.setProperty("org.omg.CORBA.ORBClass", "org.jacorb.orb.ORB");
        System.setProperty("org.omg.CORBA.ORBSingletonClass", "org.jacorb.orb.ORBSingleton");
        System.setProperty("org.omg.PortableInterceptor.ORBInitializerClass.standard_init", "org.jacorb.orb.standardInterceptors.IORInterceptorInitializer");
        System.setProperty("javax.rmi.CORBA.PortableRemoteObjectClass", "org.ow2.carol.rmi.multi.MultiPRODelegate");
        System.setProperty("javax.rmi.CORBA.UtilClass", "org.ow2.carol.util.delegate.UtilDelegateImpl");
        System.setProperty("java.naming.factory.initial", "org.ow2.carol.jndi.spi.MultiOrbInitialContextFactory");
        this.setDefaultPropertyIfNotSet("java.security.policy", IOUtils.getSystemPath(JOnASUtils.getJOnASBase(), "conf/java.policy"));
        this.setDefaultPropertyIfNotSet("java.security.auth.login.config", IOUtils.getSystemPath(JOnASUtils.getJOnASBase(), "conf/jaas.config"));
        this.setDefaultPropertyIfNotSet("jonas.name", "jonas");
    }

    protected void setDefaultPropertyIfNotSet(String key, String def) {
        System.setProperty(key, System.getProperty(key, def));
    }
}

