/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.lib.service.manager;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.ow2.jonas.configuration.ConfigurationManager;
import org.ow2.jonas.configuration.DeploymentPlanDeployer;
import org.ow2.jonas.depmonitor.MonitoringService;
import org.ow2.jonas.lib.management.javaee.J2EEServiceState;
import org.ow2.jonas.lib.service.manager.ServiceItem;
import org.ow2.jonas.lib.service.manager.ServiceTracker;
import org.ow2.jonas.lib.service.manager.ServiceUtil;
import org.ow2.jonas.management.J2EEServerService;
import org.ow2.jonas.management.ServiceManager;
import org.ow2.util.archive.api.IArchiveMetadata;
import org.ow2.util.ee.deploy.api.deployable.IDeployable;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceManagerImpl
implements ServiceManager,
Pojo {
    private InstanceManager __IM;
    private boolean __Flogger;
    private Log logger;
    private boolean __FserviceStates;
    private Map<String, ServiceItem> serviceStates;
    private boolean __Fbc;
    private BundleContext bc;
    private boolean __FconfigurationManager;
    private ConfigurationManager configurationManager;
    private boolean __Fj2eeServer;
    private J2EEServerService j2eeServer;
    private boolean __FdeploymentPlanDeployer;
    private DeploymentPlanDeployer deploymentPlanDeployer;
    private static final String REQUIRE_JONAS_SERVICES = "Require-JOnAS-Services";
    private boolean __Mstart;
    private boolean __MaddService$org_ow2_jonas_lib_service_manager_ServiceItem;
    private boolean __MsetMandatoryService$java_lang_String;
    private boolean __MdeleteAllServices;
    private boolean __MgetServices;
    private boolean __MsetServiceState$java_lang_String$org_ow2_jonas_lib_management_javaee_J2EEServiceState;
    private boolean __MgetServiceState$java_lang_String;
    private boolean __MgetServiceDescription$java_lang_String;
    private boolean __MallServicesRunning;
    private boolean __MallOptionalServicesStopped;
    private boolean __McheckServerState$java_lang_String;
    private boolean __MstartMonitoring;
    private boolean __MdepMonitorRunning;
    private boolean __MdepMonitorReference;
    private boolean __Mupdate;
    private boolean __MstartService$java_lang_String;
    private boolean __MstartRequiredServices$org_ow2_util_ee_deploy_api_deployable_IDeployable;
    private boolean __MstopService$java_lang_String;
    private boolean __McreateServiceItem$java_lang_String$boolean;
    private boolean __MbindJ2EEServer$org_ow2_jonas_management_J2EEServerService;
    private boolean __MunbindJ2EEServer$org_ow2_jonas_management_J2EEServerService;
    private boolean __MsetConfigurationManager$org_ow2_jonas_configuration_ConfigurationManager;
    private boolean __MsetDeploymentPlanDeployer$org_ow2_jonas_configuration_DeploymentPlanDeployer;
    private boolean __MconvertToList$java_lang_String;

    Log __getlogger() {
        if (!this.__Flogger) {
            return this.logger;
        }
        return (Log)this.__IM.onGet((Object)this, "logger");
    }

    void __setlogger(Log log) {
        if (!this.__Flogger) {
            this.logger = log;
            return;
        }
        this.__IM.onSet((Object)this, "logger", (Object)log);
    }

    Map __getserviceStates() {
        if (!this.__FserviceStates) {
            return this.serviceStates;
        }
        return (Map)this.__IM.onGet((Object)this, "serviceStates");
    }

    void __setserviceStates(Map map) {
        if (!this.__FserviceStates) {
            this.serviceStates = map;
            return;
        }
        this.__IM.onSet((Object)this, "serviceStates", (Object)map);
    }

    BundleContext __getbc() {
        if (!this.__Fbc) {
            return this.bc;
        }
        return (BundleContext)this.__IM.onGet((Object)this, "bc");
    }

    void __setbc(BundleContext bundleContext) {
        if (!this.__Fbc) {
            this.bc = bundleContext;
            return;
        }
        this.__IM.onSet((Object)this, "bc", (Object)bundleContext);
    }

    ConfigurationManager __getconfigurationManager() {
        if (!this.__FconfigurationManager) {
            return this.configurationManager;
        }
        return (ConfigurationManager)this.__IM.onGet((Object)this, "configurationManager");
    }

    void __setconfigurationManager(ConfigurationManager configurationManager) {
        if (!this.__FconfigurationManager) {
            this.configurationManager = configurationManager;
            return;
        }
        this.__IM.onSet((Object)this, "configurationManager", (Object)configurationManager);
    }

    J2EEServerService __getj2eeServer() {
        if (!this.__Fj2eeServer) {
            return this.j2eeServer;
        }
        return (J2EEServerService)this.__IM.onGet((Object)this, "j2eeServer");
    }

    void __setj2eeServer(J2EEServerService j2EEServerService) {
        if (!this.__Fj2eeServer) {
            this.j2eeServer = j2EEServerService;
            return;
        }
        this.__IM.onSet((Object)this, "j2eeServer", (Object)j2EEServerService);
    }

    DeploymentPlanDeployer __getdeploymentPlanDeployer() {
        if (!this.__FdeploymentPlanDeployer) {
            return this.deploymentPlanDeployer;
        }
        return (DeploymentPlanDeployer)this.__IM.onGet((Object)this, "deploymentPlanDeployer");
    }

    void __setdeploymentPlanDeployer(DeploymentPlanDeployer deploymentPlanDeployer) {
        if (!this.__FdeploymentPlanDeployer) {
            this.deploymentPlanDeployer = deploymentPlanDeployer;
            return;
        }
        this.__IM.onSet((Object)this, "deploymentPlanDeployer", (Object)deploymentPlanDeployer);
    }

    public ServiceManagerImpl(BundleContext bundleContext) {
        this(null, bundleContext);
    }

    private ServiceManagerImpl(InstanceManager _manager, BundleContext bc) {
        this._setInstanceManager(_manager);
        this.__setlogger(LogFactory.getLog(J2EEServerService.class));
        this.__setserviceStates(null);
        this.__setconfigurationManager(null);
        this.__setj2eeServer(null);
        this.__setdeploymentPlanDeployer(null);
        this.__setbc(bc);
        this.__setserviceStates(new Hashtable());
    }

    public void start() {
        if (!this.__Mstart) {
            this.__start();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "start", new Object[0]);
            this.__start();
            this.__IM.onExit((Object)this, "start", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "start", throwable);
            throw throwable;
        }
    }

    private void __start() {
        try {
            this.update();
        }
        catch (Exception e) {
            this.__getlogger().error((Object)"Cannot initialize the service states", new Object[0]);
        }
        ServiceTracker listener = new ServiceTracker(this);
        this.__getbc().addServiceListener((ServiceListener)listener);
    }

    public void addService(ServiceItem serviceItem) {
        if (!this.__MaddService$org_ow2_jonas_lib_service_manager_ServiceItem) {
            this.__addService(serviceItem);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "addService$org_ow2_jonas_lib_service_manager_ServiceItem", new Object[]{serviceItem});
            this.__addService(serviceItem);
            this.__IM.onExit((Object)this, "addService$org_ow2_jonas_lib_service_manager_ServiceItem", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "addService$org_ow2_jonas_lib_service_manager_ServiceItem", throwable);
            throw throwable;
        }
    }

    private void __addService(ServiceItem serviceItem) {
        this.__getserviceStates().put(serviceItem.getName(), serviceItem);
    }

    public void setMandatoryService(String string) {
        if (!this.__MsetMandatoryService$java_lang_String) {
            this.__setMandatoryService(string);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setMandatoryService$java_lang_String", new Object[]{string});
            this.__setMandatoryService(string);
            this.__IM.onExit((Object)this, "setMandatoryService$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setMandatoryService$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __setMandatoryService(String serviceName) {
        ServiceItem serviceItem = (ServiceItem)this.__getserviceStates().get(serviceName);
        if (serviceItem != null) {
            serviceItem.setMandatory(true);
        }
    }

    public void deleteAllServices() {
        if (!this.__MdeleteAllServices) {
            this.__deleteAllServices();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "deleteAllServices", new Object[0]);
            this.__deleteAllServices();
            this.__IM.onExit((Object)this, "deleteAllServices", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "deleteAllServices", throwable);
            throw throwable;
        }
    }

    private void __deleteAllServices() {
        this.__getserviceStates().clear();
    }

    public List<String> getServices() {
        List<String> list;
        if (!this.__MgetServices) {
            return this.__getServices();
        }
        try {
            this.__IM.onEntry((Object)this, "getServices", new Object[0]);
            list = this.__getServices();
            this.__IM.onExit((Object)this, "getServices", list);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getServices", throwable);
            throw throwable;
        }
        return list;
    }

    private List<String> __getServices() {
        ArrayList<String> sl = new ArrayList<String>();
        for (ServiceItem serviceItem : this.__getserviceStates().values()) {
            sl.add(serviceItem.getName());
        }
        return sl;
    }

    public J2EEServiceState setServiceState(String string, J2EEServiceState j2EEServiceState) {
        J2EEServiceState j2EEServiceState2;
        if (!this.__MsetServiceState$java_lang_String$org_ow2_jonas_lib_management_javaee_J2EEServiceState) {
            return this.__setServiceState(string, j2EEServiceState);
        }
        try {
            this.__IM.onEntry((Object)this, "setServiceState$java_lang_String$org_ow2_jonas_lib_management_javaee_J2EEServiceState", new Object[]{string, j2EEServiceState});
            j2EEServiceState2 = this.__setServiceState(string, j2EEServiceState);
            this.__IM.onExit((Object)this, "setServiceState$java_lang_String$org_ow2_jonas_lib_management_javaee_J2EEServiceState", (Object)j2EEServiceState2);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setServiceState$java_lang_String$org_ow2_jonas_lib_management_javaee_J2EEServiceState", throwable);
            throw throwable;
        }
        return j2EEServiceState2;
    }

    private J2EEServiceState __setServiceState(String serviceName, J2EEServiceState state) {
        if (this.__getserviceStates() == null) {
            this.__getlogger().error((Object)"setServiceState called but servicesState table null", new Object[0]);
            return null;
        }
        ServiceItem serviceItem = (ServiceItem)this.__getserviceStates().get(serviceName);
        if (serviceItem == null) {
            this.__getlogger().error((Object)("setServiceState called but service " + serviceName + " not known"), new Object[0]);
            return null;
        }
        serviceItem.setState(state);
        if (!serviceItem.isMandatory()) {
            this.checkServerState(serviceName);
        }
        return state;
    }

    public String getServiceState(String string) {
        String string2;
        if (!this.__MgetServiceState$java_lang_String) {
            return this.__getServiceState(string);
        }
        try {
            this.__IM.onEntry((Object)this, "getServiceState$java_lang_String", new Object[]{string});
            string2 = this.__getServiceState(string);
            this.__IM.onExit((Object)this, "getServiceState$java_lang_String", (Object)string2);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getServiceState$java_lang_String", throwable);
            throw throwable;
        }
        return string2;
    }

    private String __getServiceState(String serviceName) {
        ServiceItem serviceItem = (ServiceItem)this.__getserviceStates().get(serviceName);
        if (serviceItem != null) {
            return serviceItem.getState().toString();
        }
        this.__getlogger().error((Object)("getServiceState called but service " + serviceName + " not known"), new Object[0]);
        return null;
    }

    public String getServiceDescription(String string) {
        String string2;
        if (!this.__MgetServiceDescription$java_lang_String) {
            return this.__getServiceDescription(string);
        }
        try {
            this.__IM.onEntry((Object)this, "getServiceDescription$java_lang_String", new Object[]{string});
            string2 = this.__getServiceDescription(string);
            this.__IM.onExit((Object)this, "getServiceDescription$java_lang_String", (Object)string2);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getServiceDescription$java_lang_String", throwable);
            throw throwable;
        }
        return string2;
    }

    private String __getServiceDescription(String serviceName) {
        ServiceItem serviceItem = (ServiceItem)this.__getserviceStates().get(serviceName);
        if (serviceItem != null) {
            return serviceItem.getDescription();
        }
        this.__getlogger().error((Object)("getServiceDescription called but service " + serviceName + " not known"), new Object[0]);
        return null;
    }

    private boolean allServicesRunning() {
        boolean bl;
        if (!this.__MallServicesRunning) {
            return this.__allServicesRunning();
        }
        try {
            this.__IM.onEntry((Object)this, "allServicesRunning", new Object[0]);
            bl = this.__allServicesRunning();
            this.__IM.onExit((Object)this, "allServicesRunning", (Object)new Boolean(bl));
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "allServicesRunning", throwable);
            throw throwable;
        }
        return bl;
    }

    private boolean __allServicesRunning() {
        for (ServiceItem serviceItem : this.__getserviceStates().values()) {
            J2EEServiceState state = serviceItem.getState();
            if (state.equals((Object)J2EEServiceState.RUNNING)) continue;
            return false;
        }
        return true;
    }

    private boolean allOptionalServicesStopped() {
        boolean bl;
        if (!this.__MallOptionalServicesStopped) {
            return this.__allOptionalServicesStopped();
        }
        try {
            this.__IM.onEntry((Object)this, "allOptionalServicesStopped", new Object[0]);
            bl = this.__allOptionalServicesStopped();
            this.__IM.onExit((Object)this, "allOptionalServicesStopped", (Object)new Boolean(bl));
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "allOptionalServicesStopped", throwable);
            throw throwable;
        }
        return bl;
    }

    private boolean __allOptionalServicesStopped() {
        for (ServiceItem serviceItem : this.__getserviceStates().values()) {
            J2EEServiceState state = serviceItem.getState();
            if (serviceItem.isMandatory() || state.equals((Object)J2EEServiceState.STOPPED)) continue;
            return false;
        }
        return true;
    }

    protected void checkServerState(String string) {
        if (!this.__McheckServerState$java_lang_String) {
            this.__checkServerState(string);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "checkServerState$java_lang_String", new Object[]{string});
            this.__checkServerState(string);
            this.__IM.onExit((Object)this, "checkServerState$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "checkServerState$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __checkServerState(String serviceName) {
        if (this.__getj2eeServer() != null) {
            if (this.__getj2eeServer().isStarting() && this.allServicesRunning() && !this.startMonitoring()) {
                this.__getj2eeServer().setRunning();
            }
            if (this.__getj2eeServer().isRunning() && "depmonitor".equals(serviceName) && this.depMonitorRunning()) {
                this.startMonitoring();
            }
            if ((this.__getj2eeServer().isRunning() || this.__getj2eeServer().isStopping()) && this.allOptionalServicesStopped()) {
                this.__getj2eeServer().setStopped();
            }
        }
    }

    private boolean startMonitoring() {
        boolean bl;
        if (!this.__MstartMonitoring) {
            return this.__startMonitoring();
        }
        try {
            this.__IM.onEntry((Object)this, "startMonitoring", new Object[0]);
            bl = this.__startMonitoring();
            this.__IM.onExit((Object)this, "startMonitoring", (Object)new Boolean(bl));
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "startMonitoring", throwable);
            throw throwable;
        }
        return bl;
    }

    private boolean __startMonitoring() {
        ServiceReference reference = this.depMonitorReference();
        if (reference != null) {
            MonitoringService monitoringService = (MonitoringService)this.__getbc().getService(reference);
            monitoringService.startMonitoring();
            return true;
        }
        return false;
    }

    private boolean depMonitorRunning() {
        boolean bl;
        if (!this.__MdepMonitorRunning) {
            return this.__depMonitorRunning();
        }
        try {
            this.__IM.onEntry((Object)this, "depMonitorRunning", new Object[0]);
            bl = this.__depMonitorRunning();
            this.__IM.onExit((Object)this, "depMonitorRunning", (Object)new Boolean(bl));
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "depMonitorRunning", throwable);
            throw throwable;
        }
        return bl;
    }

    private boolean __depMonitorRunning() {
        return this.depMonitorReference() != null;
    }

    private ServiceReference depMonitorReference() {
        ServiceReference serviceReference;
        if (!this.__MdepMonitorReference) {
            return this.__depMonitorReference();
        }
        try {
            this.__IM.onEntry((Object)this, "depMonitorReference", new Object[0]);
            serviceReference = this.__depMonitorReference();
            this.__IM.onExit((Object)this, "depMonitorReference", (Object)serviceReference);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "depMonitorReference", throwable);
            throw throwable;
        }
        return serviceReference;
    }

    private ServiceReference __depMonitorReference() {
        return this.__getbc().getServiceReference(MonitoringService.class.getName());
    }

    public synchronized void update() throws Exception {
        if (!this.__Mupdate) {
            this.__update();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "update", new Object[0]);
            this.__update();
            this.__IM.onExit((Object)this, "update", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "update", throwable);
            throw throwable;
        }
    }

    private void __update() throws Exception {
        this.deleteAllServices();
        for (String service : this.__getconfigurationManager().getMandatoryServices()) {
            this.addService(this.createServiceItem(service, Boolean.TRUE));
        }
        for (String service : this.__getconfigurationManager().getOptionalServices()) {
            this.addService(this.createServiceItem(service, Boolean.FALSE));
        }
        List<String> runningServices = ServiceUtil.runningServices(this.__getbc());
        for (String service : runningServices) {
            this.setServiceState(service, J2EEServiceState.RUNNING);
        }
    }

    public void startService(String string) throws Exception {
        if (!this.__MstartService$java_lang_String) {
            this.__startService(string);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "startService$java_lang_String", new Object[]{string});
            this.__startService(string);
            this.__IM.onExit((Object)this, "startService$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "startService$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __startService(String service) throws Exception {
        if (this.__getserviceStates().get(service) == null || ((ServiceItem)this.__getserviceStates().get(service)).getState() != J2EEServiceState.RUNNING) {
            this.__getdeploymentPlanDeployer().deploy(service);
            if (this.__getconfigurationManager().matchService(service)) {
                this.addService(this.createServiceItem(service, false));
                this.__getconfigurationManager().updateServiceConfiguration(service);
            }
        } else {
            this.__getlogger().debug((Object)"Service ''{0 }}' is already running", new Object[]{service});
        }
    }

    public void startRequiredServices(IDeployable<?> iDeployable) {
        if (!this.__MstartRequiredServices$org_ow2_util_ee_deploy_api_deployable_IDeployable) {
            this.__startRequiredServices(iDeployable);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "startRequiredServices$org_ow2_util_ee_deploy_api_deployable_IDeployable", new Object[]{iDeployable});
            this.__startRequiredServices(iDeployable);
            this.__IM.onExit((Object)this, "startRequiredServices$org_ow2_util_ee_deploy_api_deployable_IDeployable", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "startRequiredServices$org_ow2_util_ee_deploy_api_deployable_IDeployable", throwable);
            throw throwable;
        }
    }

    private void __startRequiredServices(IDeployable<?> deployable) {
        IArchiveMetadata metadata = deployable.getArchive().getMetadata();
        if (metadata != null) {
            String services = metadata.get(REQUIRE_JONAS_SERVICES);
            for (String service : this.convertToList(services)) {
                try {
                    this.startService(service);
                }
                catch (Exception e) {
                    this.__getlogger().error((Object)"Cannot start required service ''{0}''", new Object[]{service, e});
                }
            }
        }
    }

    public void stopService(String string) throws Exception {
        if (!this.__MstopService$java_lang_String) {
            this.__stopService(string);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "stopService$java_lang_String", new Object[]{string});
            this.__stopService(string);
            this.__IM.onExit((Object)this, "stopService$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "stopService$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __stopService(String service) throws Exception {
        if (this.__getserviceStates().get(service) != null && ((ServiceItem)this.__getserviceStates().get(service)).getState() == J2EEServiceState.RUNNING) {
            try {
                this.__getconfigurationManager().deleteServiceConfiguration(service);
            }
            catch (Exception e) {
                this.__getlogger().error((Object)"Cannot delete configuration for the ''{0 }}' service", new Object[]{service});
            }
        } else {
            this.__getlogger().debug((Object)"Service ''0}'' is not running", new Object[]{service});
        }
    }

    private ServiceItem createServiceItem(String string, boolean bl) {
        ServiceItem serviceItem;
        if (!this.__McreateServiceItem$java_lang_String$boolean) {
            return this.__createServiceItem(string, bl);
        }
        try {
            this.__IM.onEntry((Object)this, "createServiceItem$java_lang_String$boolean", new Object[]{string, new Boolean(bl)});
            serviceItem = this.__createServiceItem(string, bl);
            this.__IM.onExit((Object)this, "createServiceItem$java_lang_String$boolean", (Object)serviceItem);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "createServiceItem$java_lang_String$boolean", throwable);
            throw throwable;
        }
        return serviceItem;
    }

    private ServiceItem __createServiceItem(String service, boolean mandatory) {
        ServiceItem serviceItem = new ServiceItem();
        serviceItem.setName(service);
        serviceItem.setDescription(service + " description ...");
        serviceItem.setState(J2EEServiceState.STOPPED);
        serviceItem.setMandatory(mandatory);
        return serviceItem;
    }

    public void bindJ2EEServer(J2EEServerService j2EEServerService) {
        if (!this.__MbindJ2EEServer$org_ow2_jonas_management_J2EEServerService) {
            this.__bindJ2EEServer(j2EEServerService);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "bindJ2EEServer$org_ow2_jonas_management_J2EEServerService", new Object[]{j2EEServerService});
            this.__bindJ2EEServer(j2EEServerService);
            this.__IM.onExit((Object)this, "bindJ2EEServer$org_ow2_jonas_management_J2EEServerService", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "bindJ2EEServer$org_ow2_jonas_management_J2EEServerService", throwable);
            throw throwable;
        }
    }

    private void __bindJ2EEServer(J2EEServerService j2eeServer) {
        this.__setj2eeServer(j2eeServer);
    }

    public void unbindJ2EEServer(J2EEServerService j2EEServerService) {
        if (!this.__MunbindJ2EEServer$org_ow2_jonas_management_J2EEServerService) {
            this.__unbindJ2EEServer(j2EEServerService);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "unbindJ2EEServer$org_ow2_jonas_management_J2EEServerService", new Object[]{j2EEServerService});
            this.__unbindJ2EEServer(j2EEServerService);
            this.__IM.onExit((Object)this, "unbindJ2EEServer$org_ow2_jonas_management_J2EEServerService", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "unbindJ2EEServer$org_ow2_jonas_management_J2EEServerService", throwable);
            throw throwable;
        }
    }

    private void __unbindJ2EEServer(J2EEServerService j2eeServer) {
        this.__setj2eeServer(null);
    }

    public void setConfigurationManager(ConfigurationManager configurationManager) {
        if (!this.__MsetConfigurationManager$org_ow2_jonas_configuration_ConfigurationManager) {
            this.__setConfigurationManager(configurationManager);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setConfigurationManager$org_ow2_jonas_configuration_ConfigurationManager", new Object[]{configurationManager});
            this.__setConfigurationManager(configurationManager);
            this.__IM.onExit((Object)this, "setConfigurationManager$org_ow2_jonas_configuration_ConfigurationManager", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setConfigurationManager$org_ow2_jonas_configuration_ConfigurationManager", throwable);
            throw throwable;
        }
    }

    private void __setConfigurationManager(ConfigurationManager configurationManager) {
        this.__setconfigurationManager(configurationManager);
    }

    public void setDeploymentPlanDeployer(DeploymentPlanDeployer deploymentPlanDeployer) {
        if (!this.__MsetDeploymentPlanDeployer$org_ow2_jonas_configuration_DeploymentPlanDeployer) {
            this.__setDeploymentPlanDeployer(deploymentPlanDeployer);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setDeploymentPlanDeployer$org_ow2_jonas_configuration_DeploymentPlanDeployer", new Object[]{deploymentPlanDeployer});
            this.__setDeploymentPlanDeployer(deploymentPlanDeployer);
            this.__IM.onExit((Object)this, "setDeploymentPlanDeployer$org_ow2_jonas_configuration_DeploymentPlanDeployer", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setDeploymentPlanDeployer$org_ow2_jonas_configuration_DeploymentPlanDeployer", throwable);
            throw throwable;
        }
    }

    private void __setDeploymentPlanDeployer(DeploymentPlanDeployer deploymentPlanDeployer) {
        this.__setdeploymentPlanDeployer(deploymentPlanDeployer);
    }

    private List<String> convertToList(String string) {
        List<String> list;
        if (!this.__MconvertToList$java_lang_String) {
            return this.__convertToList(string);
        }
        try {
            this.__IM.onEntry((Object)this, "convertToList$java_lang_String", new Object[]{string});
            list = this.__convertToList(string);
            this.__IM.onExit((Object)this, "convertToList$java_lang_String", list);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "convertToList$java_lang_String", throwable);
            throw throwable;
        }
        return list;
    }

    private List<String> __convertToList(String param) {
        ArrayList<String> result = new ArrayList<String>();
        if (param != null && !param.equals("")) {
            for (String element : param.split(",")) {
                result.add(element);
            }
        }
        return result;
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            if (set.contains("deploymentPlanDeployer")) {
                this.__FdeploymentPlanDeployer = true;
            }
            if (set.contains("bc")) {
                this.__Fbc = true;
            }
            if (set.contains("j2eeServer")) {
                this.__Fj2eeServer = true;
            }
            if (set.contains("logger")) {
                this.__Flogger = true;
            }
            if (set.contains("configurationManager")) {
                this.__FconfigurationManager = true;
            }
            if (set.contains("serviceStates")) {
                this.__FserviceStates = true;
            }
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("start")) {
                this.__Mstart = true;
            }
            if (set.contains("addService$org_ow2_jonas_lib_service_manager_ServiceItem")) {
                this.__MaddService$org_ow2_jonas_lib_service_manager_ServiceItem = true;
            }
            if (set.contains("setMandatoryService$java_lang_String")) {
                this.__MsetMandatoryService$java_lang_String = true;
            }
            if (set.contains("deleteAllServices")) {
                this.__MdeleteAllServices = true;
            }
            if (set.contains("getServices")) {
                this.__MgetServices = true;
            }
            if (set.contains("setServiceState$java_lang_String$org_ow2_jonas_lib_management_javaee_J2EEServiceState")) {
                this.__MsetServiceState$java_lang_String$org_ow2_jonas_lib_management_javaee_J2EEServiceState = true;
            }
            if (set.contains("getServiceState$java_lang_String")) {
                this.__MgetServiceState$java_lang_String = true;
            }
            if (set.contains("getServiceDescription$java_lang_String")) {
                this.__MgetServiceDescription$java_lang_String = true;
            }
            if (set.contains("allServicesRunning")) {
                this.__MallServicesRunning = true;
            }
            if (set.contains("allOptionalServicesStopped")) {
                this.__MallOptionalServicesStopped = true;
            }
            if (set.contains("checkServerState$java_lang_String")) {
                this.__McheckServerState$java_lang_String = true;
            }
            if (set.contains("startMonitoring")) {
                this.__MstartMonitoring = true;
            }
            if (set.contains("depMonitorRunning")) {
                this.__MdepMonitorRunning = true;
            }
            if (set.contains("depMonitorReference")) {
                this.__MdepMonitorReference = true;
            }
            if (set.contains("update")) {
                this.__Mupdate = true;
            }
            if (set.contains("startService$java_lang_String")) {
                this.__MstartService$java_lang_String = true;
            }
            if (set.contains("startRequiredServices$org_ow2_util_ee_deploy_api_deployable_IDeployable")) {
                this.__MstartRequiredServices$org_ow2_util_ee_deploy_api_deployable_IDeployable = true;
            }
            if (set.contains("stopService$java_lang_String")) {
                this.__MstopService$java_lang_String = true;
            }
            if (set.contains("createServiceItem$java_lang_String$boolean")) {
                this.__McreateServiceItem$java_lang_String$boolean = true;
            }
            if (set.contains("bindJ2EEServer$org_ow2_jonas_management_J2EEServerService")) {
                this.__MbindJ2EEServer$org_ow2_jonas_management_J2EEServerService = true;
            }
            if (set.contains("unbindJ2EEServer$org_ow2_jonas_management_J2EEServerService")) {
                this.__MunbindJ2EEServer$org_ow2_jonas_management_J2EEServerService = true;
            }
            if (set.contains("setConfigurationManager$org_ow2_jonas_configuration_ConfigurationManager")) {
                this.__MsetConfigurationManager$org_ow2_jonas_configuration_ConfigurationManager = true;
            }
            if (set.contains("setDeploymentPlanDeployer$org_ow2_jonas_configuration_DeploymentPlanDeployer")) {
                this.__MsetDeploymentPlanDeployer$org_ow2_jonas_configuration_DeploymentPlanDeployer = true;
            }
            if (set.contains("convertToList$java_lang_String")) {
                this.__MconvertToList$java_lang_String = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

