/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.ws.axis2.easybeans.ext;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.jws.HandlerChain;
import javax.jws.WebService;
import org.ow2.easybeans.api.EZBContainerCallbackInfo;
import org.ow2.easybeans.api.Factory;
import org.ow2.easybeans.container.EmptyLifeCycleCallBack;
import org.ow2.easybeans.container.session.stateless.StatelessSessionFactory;
import org.ow2.jonas.ws.axis2.jaxws.Axis2WSEndpoint;
import org.ow2.jonas.ws.jaxws.IWebServiceDeploymentManager;
import org.ow2.jonas.ws.jaxws.IWebServiceEndpoint;
import org.ow2.jonas.ws.jaxws.PortMetaData;
import org.ow2.jonas.ws.jaxws.WSException;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public class LifeCycleCallback
extends EmptyLifeCycleCallBack {
    private static Log logger = LogFactory.getLog(LifeCycleCallback.class);
    private IWebServiceDeploymentManager manager;
    private List<IWebServiceEndpoint> endpoints = new ArrayList<IWebServiceEndpoint>();

    public void setManager(IWebServiceDeploymentManager manager) {
        this.manager = manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(EZBContainerCallbackInfo info) {
        Map factories = info.getFactories();
        for (Factory f : factories.values()) {
            StatelessSessionFactory factory;
            Class klass;
            WebService ws;
            if (!(f instanceof StatelessSessionFactory) || (ws = (klass = (factory = (StatelessSessionFactory)f).getBeanClass()).getAnnotation(WebService.class)) == null) continue;
            String wsdlName = ws.wsdlLocation();
            URL url = null;
            if (wsdlName != null && (url = klass.getClassLoader().getResource(wsdlName)) == null) {
                try {
                    url = new URL(wsdlName);
                }
                catch (MalformedURLException ex2) {
                    url = klass.getClassLoader().getResource("/" + wsdlName);
                }
            }
            String pattern = null;
            String serviceName = ws.serviceName();
            String portName = ws.portName();
            String name = ws.name();
            pattern = !"".equals(portName) ? "/" + serviceName + "/" + portName : "/" + serviceName + "/" + name;
            PortMetaData pmd = new PortMetaData();
            String contextRoot = LifeCycleCallback.extractContextRoot(info.getArchive().getName());
            StringBuffer handlerXML = new StringBuffer();
            try {
                HandlerChain hc = klass.getAnnotation(HandlerChain.class);
                if (hc != null) {
                    URL handlerURL = klass.getClassLoader().getResource(hc.file());
                    BufferedReader br = new BufferedReader(new InputStreamReader(handlerURL.openStream()));
                    String temp = null;
                    temp = br.readLine();
                    while (temp != null) {
                        handlerXML.append(temp);
                        temp = br.readLine();
                    }
                    pmd.setHandlerXML(handlerXML.toString());
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to Get the handler description file!", e);
            }
            finally {
                if (pmd.getHandlerXML() != null) {
                    logger.debug((Object)"Found handlers in this package!", new Object[0]);
                }
            }
            pmd.setContextRoot(contextRoot);
            pmd.setUrlPattern(pattern);
            logger.info((Object)"PortMetaData [context:{0}, pattern:{1}]", new Object[]{pmd.getContextRoot(), pmd.getUrlPattern()});
            ClassLoader old = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(klass.getClassLoader());
            Axis2WSEndpoint endpoint = new Axis2WSEndpoint(klass, IWebServiceEndpoint.EndpointType.EJB, pmd, factory);
            try {
                endpoint.init();
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
            finally {
                Thread.currentThread().setContextClassLoader(old);
            }
            try {
                this.manager.registerWSEndpoint((IWebServiceEndpoint)endpoint);
            }
            catch (WSException e) {
                logger.error((Object)"Unable to register endpoint {0}", new Object[]{endpoint, e});
                throw new RuntimeException("Endpoint not deployed completely", e);
            }
            endpoint.start();
            this.endpoints.add(endpoint);
            logger.info((Object)"Endpoint {0} inited", new Object[]{klass.getName()});
            logger.info((Object)("Axis2 ready for " + info.getArchive()), new Object[0]);
        }
    }

    private static String extractContextRoot(String filename) {
        String context = filename.substring(filename.lastIndexOf(File.separator) + 1);
        context = context.substring(0, context.lastIndexOf(95));
        return context;
    }

    public void stop(EZBContainerCallbackInfo info) {
        this.stop();
        logger.info((Object)("axis2 stopped for " + info.getArchive()), new Object[0]);
    }

    public void stop() {
        ArrayList<WSException> exceptions = new ArrayList<WSException>();
        for (IWebServiceEndpoint endpoint : this.endpoints) {
            try {
                endpoint.stop();
                this.manager.unregisterWSEndpoint(endpoint);
            }
            catch (WSException e) {
                exceptions.add(e);
            }
        }
        this.endpoints.clear();
        for (WSException exception : exceptions) {
            logger.warn((Object)"Unable to stop/unregister endpoint", new Object[]{exception});
        }
    }
}

