/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.generators.wsgen.generator.ews.wsdltoj2ee.writer;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.wsdl.Binding;
import javax.wsdl.Definition;
import javax.wsdl.Message;
import javax.wsdl.OperationType;
import javax.xml.namespace.QName;
import org.apache.axis.constants.Use;
import org.apache.axis.utils.Messages;
import org.apache.axis.wsdl.symbolTable.FaultInfo;
import org.apache.axis.wsdl.symbolTable.Parameter;
import org.apache.axis.wsdl.symbolTable.Parameters;
import org.apache.axis.wsdl.symbolTable.SchemaUtils;
import org.apache.axis.wsdl.symbolTable.SymbolTable;
import org.apache.axis.wsdl.symbolTable.TypeEntry;
import org.apache.axis.wsdl.toJava.Emitter;
import org.apache.axis.wsdl.toJava.JavaWriter;
import org.apache.axis.wsdl.toJava.Utils;
import org.ow2.jonas.generators.wsgen.generator.ews.wsdltoj2ee.JOnASJ2EEWebServicesContext;
import org.ow2.jonas.generators.wsgen.generator.ews.wsdltoj2ee.emitter.JOnASWSEmitter;
import org.w3c.dom.Node;

public abstract class JOnASDeployWriter
extends JavaWriter {
    private JOnASJ2EEWebServicesContext jonasWSContext;
    protected static final String WSDD_SUFFIX = ".wsdd";
    private static int count = 0;
    private Definition definition = null;
    private SymbolTable symbolTable = null;
    protected Use use = Use.DEFAULT;
    private static Map mepStrings = new HashMap();

    public JOnASDeployWriter(Emitter emitter, Definition definition, SymbolTable symbolTable) {
        super(emitter, "deploy");
        this.definition = definition;
        this.symbolTable = symbolTable;
        if (emitter instanceof JOnASWSEmitter) {
            this.jonasWSContext = ((JOnASWSEmitter)emitter).getJOnASWsContext();
        }
        if (this.jonasWSContext == null) {
            throw new RuntimeException("jonasWSContext can not be null");
        }
    }

    protected String getFileName() {
        String dir = this.emitter.getNamespaces().getAsDir("");
        return dir + this.getPrefix() + JOnASDeployWriter.getCount() + WSDD_SUFFIX;
    }

    protected void writeFileHeader(PrintWriter pw) throws IOException {
        pw.println(Messages.getMessage((String)"deploy00"));
        pw.println(Messages.getMessage((String)"deploy02"));
        pw.println(Messages.getMessage((String)"deploy03"));
        pw.println(Messages.getMessage((String)"deploy05"));
        pw.println(Messages.getMessage((String)"deploy06"));
        pw.println(Messages.getMessage((String)"deploy07"));
        pw.println(Messages.getMessage((String)"deploy09"));
        pw.println();
        pw.println("<deployment");
        pw.println("    xmlns=\"http://xml.apache.org/axis/wsdd/\"");
        pw.println("    xmlns:java=\"http://xml.apache.org/axis/wsdd/providers/java\">");
    }

    protected void writeFileBody(PrintWriter pw) throws IOException {
        this.writeDeployServices(pw);
        pw.println("</deployment>");
    }

    protected abstract String getPrefix();

    protected abstract void writeDeployServices(PrintWriter var1) throws IOException;

    protected void writeTypeMapping(PrintWriter pw, String namespaceURI, String localPart, String javaType, String serializerFactory, String deserializerFactory, String encodingStyle) {
        pw.println("      <typeMapping");
        pw.println("        xmlns:ns=\"" + namespaceURI + "\"");
        pw.println("        qname=\"ns:" + localPart + '\"');
        pw.println("        type=\"java:" + javaType + '\"');
        pw.println("        serializer=\"" + serializerFactory + "\"");
        pw.println("        deserializer=\"" + deserializerFactory + "\"");
        pw.println("        encodingStyle=\"" + encodingStyle + "\"");
        pw.println("      />");
    }

    protected void writeOperation(PrintWriter pw, String javaOperName, QName elementQName, QName returnQName, QName returnType, Parameters params, ArrayList faults, String soapAction) {
        String mepString;
        Parameter retParam;
        pw.print("      <operation name=\"" + javaOperName + "\"");
        if (elementQName != null) {
            pw.print(" qname=\"" + Utils.genQNameAttributeString((QName)elementQName, (String)"operNS") + "\"");
        }
        if (returnQName != null) {
            pw.print(" returnQName=\"" + Utils.genQNameAttributeStringWithLastLocalPart((QName)returnQName, (String)"retNS") + "\"");
        }
        if (returnType != null) {
            pw.print(" returnType=\"" + Utils.genQNameAttributeString((QName)returnType, (String)"rtns") + "\"");
        }
        if ((retParam = params.returnParam) != null) {
            QName returnItemType;
            TypeEntry type = retParam.getType();
            QName returnItemQName = Utils.getItemQName((TypeEntry)type);
            if (returnItemQName != null) {
                pw.print(" returnItemQName=\"");
                pw.print(Utils.genQNameAttributeString((QName)returnItemQName, (String)"tns3"));
                pw.print("\"");
            }
            if ((returnItemType = Utils.getItemType((TypeEntry)type)) != null && this.use == Use.ENCODED) {
                pw.print(" returnItemType=\"");
                pw.print(Utils.genQNameAttributeString((QName)returnItemType, (String)"tns2"));
                pw.print("\"");
            }
        }
        if (soapAction != null) {
            pw.print(" soapAction=\"" + soapAction + "\"");
        }
        if (!OperationType.REQUEST_RESPONSE.equals(params.mep) && (mepString = this.getMepString(params.mep)) != null) {
            pw.print(" mep=\"" + mepString + "\"");
        }
        if (params.returnParam != null && params.returnParam.isOutHeader()) {
            pw.print(" returnHeader=\"true\"");
        }
        pw.println(" >");
        Vector paramList = params.list;
        for (int i = 0; i < paramList.size(); ++i) {
            QName itemQName;
            Parameter param = (Parameter)paramList.elementAt(i);
            QName paramQName = param.getQName();
            QName paramType = Utils.getXSIType((Parameter)param);
            pw.print("        <parameter");
            if (paramQName == null) {
                pw.print(" name=\"" + param.getName() + "\"");
            } else {
                pw.print(" qname=\"" + Utils.genQNameAttributeStringWithLastLocalPart((QName)paramQName, (String)"pns") + "\"");
            }
            pw.print(" type=\"" + Utils.genQNameAttributeString((QName)paramType, (String)"ptns") + "\"");
            if (param.getMode() != 1) {
                pw.print(" mode=\"" + this.getModeString(param.getMode()) + "\"");
            }
            if (param.isInHeader()) {
                pw.print(" inHeader=\"true\"");
            }
            if (param.isOutHeader()) {
                pw.print(" outHeader=\"true\"");
            }
            if ((itemQName = Utils.getItemQName((TypeEntry)param.getType())) != null) {
                pw.print(" itemQName=\"");
                pw.print(Utils.genQNameAttributeString((QName)itemQName, (String)"pitns"));
                pw.print("\"");
            }
            pw.println("/>");
        }
        if (faults != null) {
            for (FaultInfo faultInfo : faults) {
                QName faultQName = faultInfo.getQName();
                if (faultQName == null) continue;
                String className = Utils.getFullExceptionName((Message)faultInfo.getMessage(), (SymbolTable)this.symbolTable);
                pw.print("        <fault");
                pw.print(" name=\"" + faultInfo.getName() + "\"");
                pw.print(" qname=\"" + Utils.genQNameAttributeString((QName)faultQName, (String)"fns") + "\"");
                pw.print(" class=\"" + className + "\"");
                pw.print(" type=\"" + Utils.genQNameAttributeString((QName)faultInfo.getXMLType(), (String)"ftns") + "\"");
                pw.println("/>");
            }
        }
        pw.println("      </operation>");
    }

    protected void writeDeployTypes(PrintWriter pw, Binding binding, boolean hasLiteral, boolean hasMIME, Use use) {
        pw.println();
        if (hasMIME) {
            QName bQName = binding.getQName();
            this.writeTypeMapping(pw, bQName.getNamespaceURI(), "DataHandler", "javax.activation.DataHandler", "org.apache.axis.encoding.ser.JAFDataHandlerSerializerFactory", "org.apache.axis.encoding.ser.JAFDataHandlerDeserializerFactory", use.getEncoding());
        }
        boolean useJAF = false;
        Map types = this.getSymbolTable().getTypeIndex();
        Collection typeCollection = types.values();
        for (TypeEntry type : typeCollection) {
            String deserializerFactory;
            String serializerFactory;
            boolean process = true;
            if (!Utils.shouldEmit((TypeEntry)type)) {
                process = false;
            }
            if (!process) continue;
            String namespaceURI = type.getQName().getNamespaceURI();
            String localPart = type.getQName().getLocalPart();
            String javaType = type.getName();
            String encodingStyle = "";
            QName innerType = null;
            if (!hasLiteral) {
                encodingStyle = use.getEncoding();
            }
            if (javaType.endsWith("[]")) {
                if (SchemaUtils.isListWithItemType((Node)type.getNode())) {
                    serializerFactory = "org.apache.axis.encoding.ser.SimpleListSerializerFactory";
                    deserializerFactory = "org.apache.axis.encoding.ser.SimpleListDeserializerFactory";
                } else {
                    serializerFactory = "org.apache.axis.encoding.ser.ArraySerializerFactory";
                    deserializerFactory = "org.apache.axis.encoding.ser.ArrayDeserializerFactory";
                    innerType = type.getComponentType();
                }
            } else if (type.getNode() != null && Utils.getEnumerationBaseAndValues((Node)type.getNode(), (SymbolTable)this.getSymbolTable()) != null) {
                serializerFactory = "org.apache.axis.encoding.ser.EnumSerializerFactory";
                deserializerFactory = "org.apache.axis.encoding.ser.EnumDeserializerFactory";
            } else if (type.isSimpleType()) {
                serializerFactory = "org.apache.axis.encoding.ser.SimpleSerializerFactory";
                deserializerFactory = "org.apache.axis.encoding.ser.SimpleDeserializerFactory";
            } else if (type.getBaseType() != null) {
                serializerFactory = "org.apache.axis.encoding.ser.SimpleSerializerFactory";
                deserializerFactory = "org.apache.axis.encoding.ser.SimpleDeserializerFactory";
            } else {
                serializerFactory = "org.apache.axis.encoding.ser.BeanSerializerFactory";
                deserializerFactory = "org.apache.axis.encoding.ser.BeanDeserializerFactory";
            }
            Vector<String> jafType = new Vector<String>();
            jafType.add("java.awt.Image");
            jafType.add("javax.xml.transform.Source");
            jafType.add("javax.mail.internet.MimeMultipart");
            if (jafType.contains(javaType)) {
                serializerFactory = "org.apache.axis.encoding.ser.JAFDataHandlerSerializerFactory";
                deserializerFactory = "org.apache.axis.encoding.ser.JAFDataHandlerDeserializerFactory";
                useJAF = true;
            }
            if (innerType == null) {
                this.writeTypeMapping(pw, namespaceURI, localPart, javaType, serializerFactory, deserializerFactory, encodingStyle);
                continue;
            }
            this.writeArrayTypeMapping(pw, namespaceURI, localPart, javaType, encodingStyle, innerType);
        }
        if (useJAF) {
            pw.println("      <parameter name=\"sendMultiRefs\" value=\"false\"/>");
        }
    }

    protected void writeArrayTypeMapping(PrintWriter pw, String namespaceURI, String localPart, String javaType, String encodingStyle, QName innerType) {
        pw.println("      <arrayMapping");
        pw.println("        xmlns:ns=\"" + namespaceURI + "\"");
        pw.println("        qname=\"ns:" + localPart + '\"');
        pw.println("        type=\"java:" + javaType + '\"');
        pw.println("        innerType=\"" + Utils.genQNameAttributeString((QName)innerType, (String)"cmp-ns") + '\"');
        pw.println("        encodingStyle=\"" + encodingStyle + "\"");
        pw.println("      />");
    }

    public String getModeString(byte mode) {
        if (mode == 1) {
            return "IN";
        }
        if (mode == 3) {
            return "INOUT";
        }
        return "OUT";
    }

    protected PrintWriter getPrintWriter(String filename) throws IOException {
        File file = new File(filename);
        File parent = new File(file.getParent());
        parent.mkdirs();
        FileOutputStream out = new FileOutputStream(file);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)out, "UTF-8");
        return new PrintWriter(writer);
    }

    public static int getCount() {
        return count++;
    }

    public Definition getDefinition() {
        return this.definition;
    }

    public JOnASJ2EEWebServicesContext getJonasWSContext() {
        return this.jonasWSContext;
    }

    public SymbolTable getSymbolTable() {
        return this.symbolTable;
    }

    private String getMepString(OperationType mep) {
        return (String)mepStrings.get(mep);
    }

    static {
        mepStrings.put(OperationType.REQUEST_RESPONSE, "request-response");
        mepStrings.put(OperationType.ONE_WAY, "oneway");
    }
}

