/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.ws.axis;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.util.List;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import javax.wsdl.xml.WSDLWriter;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.axis.AxisFault;
import org.apache.axis.Constants;
import org.apache.axis.MessageContext;
import org.apache.axis.i18n.Messages;
import org.apache.axis.server.AxisServer;
import org.apache.axis.transport.http.AbstractQueryStringHandler;
import org.apache.axis.transport.http.HTTPConstants;
import org.apache.axis.utils.XMLUtils;
import org.ow2.jonas.deployment.ws.PortComponentDesc;
import org.ow2.jonas.deployment.ws.ServiceDesc;
import org.ow2.jonas.ws.WSServiceException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class QSUpdateServiceWSDLHandler
extends AbstractQueryStringHandler {
    private static final String NS_URI_SOAP = "http://schemas.xmlsoap.org/wsdl/soap/";
    private static final QName QNAME_SOAP_ADDRESS = new QName("http://schemas.xmlsoap.org/wsdl/soap/", "address");
    private static final String NS_URI_WSDL = "http://schemas.xmlsoap.org/wsdl/";
    private static final String NS_URI_XSD = "http://www.w3.org/2001/XMLSchema";
    private static final String PARAM_FILENAME = "filename";
    private static final String PARAM_CONTEXT = "context";
    private static final String PARAM_JWSDL = "JWSDL";
    private static final QName WSDL_DEFINITIONS_QNAME = new QName("http://schemas.xmlsoap.org/wsdl/", "definitions");
    private ServiceDesc sd = null;

    public void invoke(MessageContext msgContext) throws AxisFault {
        this.configureFromContext(msgContext);
        AxisServer engine = (AxisServer)msgContext.getProperty("transport.http.plugin.engine");
        PrintWriter writer = (PrintWriter)msgContext.getProperty("transport.http.plugin.writer");
        HttpServletResponse response = (HttpServletResponse)msgContext.getProperty(HTTPConstants.MC_HTTP_SERVLETRESPONSE);
        HttpServletRequest request = (HttpServletRequest)msgContext.getProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST);
        try {
            InitialContext ctx = new InitialContext();
            this.sd = (ServiceDesc)ctx.lookup("java:comp/jonas/" + engine.getName() + "/dd");
        }
        catch (NamingException e) {
            throw new AxisFault("Servlet name not found : " + engine.getName(), e);
        }
        String wsdlFilename = request.getParameter(PARAM_FILENAME);
        String context = request.getParameter(PARAM_CONTEXT);
        try {
            Document doc = null;
            if (wsdlFilename == null) {
                doc = this.getDefinitionAsDocument(this.sd.getWSDL().getDefinition());
                wsdlFilename = this.sd.getWSDL().getName();
                String[] pathElements = wsdlFilename.split("/");
                if (pathElements.length <= 2) {
                    throw new WSServiceException("invalid filename");
                }
                StringBuffer buf = new StringBuffer();
                for (int i = 2; i < pathElements.length; ++i) {
                    buf.append(pathElements[i]);
                    if (i == pathElements.length - 1) continue;
                    buf.append("/");
                }
                wsdlFilename = buf.toString();
                context = ".";
                msgContext.setProperty("WSDL", doc);
            } else {
                doc = (Document)msgContext.getProperty("WSDL_" + wsdlFilename);
                if (doc == null) {
                    doc = this.getDocument(wsdlFilename, context);
                }
                msgContext.setProperty("WSDL_" + wsdlFilename, doc);
            }
            if (doc != null) {
                this.modifyImports(doc, request, new File(context, wsdlFilename).getParent());
                Document up2date = this.updateWSDLPortLocations(doc);
                response.setContentType("text/xml; charset=" + XMLUtils.getEncoding().toLowerCase());
                this.reportWSDL(up2date, writer);
            } else {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)"processWsdlRequest: failed to create WSDL");
                }
                this.reportNoWSDL(response, writer, "noWSDL02", null);
            }
        }
        catch (AxisFault axisFault) {
            if (axisFault.getFaultCode().equals(Constants.QNAME_NO_SERVICE_FAULT_CODE)) {
                this.processAxisFault(axisFault);
                response.setStatus(404);
                this.reportNoWSDL(response, writer, "noWSDL01", axisFault);
            }
            throw axisFault;
        }
    }

    private Document getDefinitionAsDocument(Definition definition) throws AxisFault {
        try {
            WSDLWriter writer = this.getWSDLWriter();
            return writer.getDocument(definition);
        }
        catch (WSDLException e) {
            throw new AxisFault(e.getMessage(), e);
        }
    }

    private void modifyImports(Document doc, HttpServletRequest request, String context) {
        Element de = doc.getDocumentElement();
        NodeList imports = de.getElementsByTagNameNS(NS_URI_WSDL, "import");
        for (int i = 0; i < imports.getLength(); ++i) {
            Element imp = (Element)imports.item(i);
            Attr location = imp.getAttributeNode("location");
            if (location.getValue().startsWith("http://")) continue;
            String req = this.computeUpdatedURL(request, context, location);
            this.log.debug((Object)("Replacing wsdl:location '" + location.getValue() + "' with '" + req.toString() + "'"));
            location.setValue(req.toString());
        }
        this.updateSchema(de, "include", request, context);
        this.updateSchema(de, "import", request, context);
        NodeList types = de.getElementsByTagNameNS(NS_URI_WSDL, "types");
        if (types.getLength() != 0) {
            Element typesElement = (Element)types.item(0);
            NodeList schemasList = typesElement.getElementsByTagNameNS(NS_URI_XSD, "schema");
            for (int i = 0; i < schemasList.getLength(); ++i) {
                Element schema = (Element)schemasList.item(i);
                this.updateSchema(schema, "include", request, context);
                this.updateSchema(schema, "import", request, context);
            }
        }
    }

    private String computeUpdatedURL(HttpServletRequest request, String context, Attr location) {
        StringBuffer req = request.getRequestURL();
        req.append("?JWSDL");
        req.append("&filename=" + location.getValue());
        req.append("&context=" + context);
        return req.toString();
    }

    private void updateSchema(Element schema, String elementName, HttpServletRequest request, String context) {
        NodeList elements = schema.getElementsByTagNameNS(NS_URI_XSD, elementName);
        for (int i = 0; i < elements.getLength(); ++i) {
            Element e = (Element)elements.item(i);
            Attr location = e.getAttributeNode("schemaLocation");
            if (location == null || location.getValue().startsWith("http://")) continue;
            String req = this.computeUpdatedURL(request, context, location);
            this.log.debug((Object)("Replacing xsd:schemaLocation '" + location.getValue() + "' with '" + req.toString() + "'"));
            location.setValue(req.toString());
        }
    }

    private Document getDocument(String wsdlFilename, String context) throws AxisFault {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        URL res = cl.getResource(context + "/" + wsdlFilename);
        Document doc = null;
        if (res != null) {
            try {
                doc = this.createDocument(res.openStream());
            }
            catch (IOException ioe) {
                throw new AxisFault("Cannot open requested URL : " + res);
            }
        } else {
            throw new AxisFault("Cannot find requested document : " + wsdlFilename);
        }
        return doc;
    }

    private Document createDocument(InputStream stream) throws AxisFault {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.setValidating(false);
            DocumentBuilder builder = factory.newDocumentBuilder();
            return builder.parse(stream);
        }
        catch (ParserConfigurationException pce) {
            throw new AxisFault(pce.getMessage(), pce);
        }
        catch (SAXException se) {
            throw new AxisFault(se.getMessage(), se);
        }
        catch (IOException ioe) {
            throw new AxisFault(ioe.getMessage(), ioe);
        }
    }

    private Document updateWSDLPortLocations(Document doc) throws AxisFault {
        this.log.debug((Object)"Entering updateWSDL");
        QName docQname = new QName(doc.getDocumentElement().getNamespaceURI(), doc.getDocumentElement().getLocalName());
        if (WSDL_DEFINITIONS_QNAME.equals(docQname)) {
            try {
                WSDLReader reader = this.getWSDLReader();
                Definition def = reader.readWSDL(null, doc);
                QName sQName = this.sd.getWSDL().getServiceQname();
                Service s = def.getService(sQName);
                if (s != null) {
                    List portsComp = this.sd.getPortComponents();
                    for (PortComponentDesc pcd : portsComp) {
                        URL endpoint = pcd.getEndpointURL();
                        QName portQName = pcd.getQName();
                        Port port = s.getPort(portQName.getLocalPart());
                        if (port != null) {
                            List ext = port.getExtensibilityElements();
                            for (ExtensibilityElement element : ext) {
                                if (!element.getElementType().equals(QNAME_SOAP_ADDRESS)) continue;
                                SOAPAddress sa = (SOAPAddress)element;
                                sa.setLocationURI(endpoint.toExternalForm());
                                this.log.debug((Object)("Update port soap:location with " + endpoint));
                            }
                            continue;
                        }
                        this.log.warn((Object)("Cannot find wsdl:port '" + portQName.getLocalPart() + "' in wsdl:service " + s.getQName()));
                    }
                }
                return WSDLFactory.newInstance().newWSDLWriter().getDocument(def);
            }
            catch (WSDLException wsdle) {
                throw new AxisFault("Cannot read WSDL Document", wsdle);
            }
        }
        return doc;
    }

    private WSDLReader getWSDLReader() throws WSDLException {
        WSDLFactory factory = WSDLFactory.newInstance();
        WSDLReader reader = factory.newWSDLReader();
        reader.setFeature("javax.wsdl.importDocuments", false);
        return reader;
    }

    private WSDLWriter getWSDLWriter() throws WSDLException {
        WSDLFactory factory = WSDLFactory.newInstance();
        return factory.newWSDLWriter();
    }

    public void reportWSDL(Document doc, PrintWriter writer) {
        XMLUtils.PrettyDocumentToWriter(doc, writer);
    }

    public void reportNoWSDL(HttpServletResponse res, PrintWriter writer, String moreDetailCode, AxisFault axisFault) {
        res.setStatus(404);
        res.setContentType("text/html");
        writer.println("<h2>" + Messages.getMessage("error00") + "</h2>");
        writer.println("<p>" + Messages.getMessage("noWSDL00") + "</p>");
        if (moreDetailCode != null) {
            writer.println("<p>" + Messages.getMessage(moreDetailCode) + "</p>");
        }
        if (axisFault != null && this.isDevelopment()) {
            this.writeFault(writer, axisFault);
        }
    }
}

