/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jorm.lib;

import org.objectweb.jorm.api.PClassMapping;
import org.objectweb.jorm.api.PMapper;
import org.objectweb.jorm.genclass.lib.GenClassMapping;
import org.objectweb.jorm.metainfo.api.Class;
import org.objectweb.jorm.metainfo.api.ClassRef;
import org.objectweb.jorm.metainfo.api.GenClassRef;
import org.objectweb.jorm.metainfo.api.MetaObject;
import org.objectweb.jorm.naming.api.PNameCoder;

public class JormPathHelper {
    public static final char SEP = '/';
    public static final String ELEMENT = "/element";

    public static String getPath(GenClassRef gcr, boolean element) {
        MetaObject parent = gcr.getParent();
        if (parent instanceof Class) {
            return JormPathHelper.getPath((Class)parent) + '/' + gcr.getName() + (element ? ELEMENT : "");
        }
        if (parent instanceof GenClassRef) {
            GenClassRef p = (GenClassRef)parent;
            return JormPathHelper.getPath(p, false) + '/' + p.getGenClassName() + (element ? ELEMENT : "");
        }
        return null;
    }

    public static String getPath(ClassRef cr) {
        MetaObject parent = cr.getParent();
        if (parent instanceof Class) {
            return JormPathHelper.getPath((Class)parent) + '/' + cr.getName();
        }
        if (parent instanceof GenClassRef) {
            GenClassRef p = (GenClassRef)parent;
            return JormPathHelper.getPath(p, false) + '/' + p.getGenClassName() + ELEMENT;
        }
        return null;
    }

    public static String replaceFieldOwner(String path, String newOwner) {
        if (path == null) {
            return null;
        }
        int idx = path.indexOf(47);
        if (idx == -1) {
            return path;
        }
        if (idx == 0) {
            idx = path.indexOf(47, 1);
        }
        if (idx == -1) {
            return path;
        }
        return JormPathHelper.getPath(newOwner) + path.substring(idx);
    }

    public static String getPath(Class clazz) {
        return JormPathHelper.getPath(clazz.getFQName());
    }

    public static String getPath(String fqclassname) {
        return '/' + fqclassname;
    }

    public static String getPath(String sourceclassName, String refFieldName, String[] genClassNames) {
        StringBuffer cn = new StringBuffer();
        cn.append(JormPathHelper.getPath(sourceclassName));
        cn.append('/');
        cn.append(refFieldName);
        for (int i = 1; i < genClassNames.length; ++i) {
            cn.append('/');
            cn.append(genClassNames[i - 1]);
        }
        return cn.toString();
    }

    public static PNameCoder getPNameCoder(String path, PMapper mapper) {
        if (path == null || path.length() == 0 || mapper == null) {
            return null;
        }
        int idx = path.indexOf(47);
        if (idx == -1) {
            PClassMapping pcm = mapper.lookup(path);
            if (pcm == null) {
                return null;
            }
            PNameCoder pnc = pcm.getClassPNameCoder();
            if (pnc == null) {
                pnc = pcm.getPBinder();
            }
            return pnc;
        }
        if (idx == 0) {
            return JormPathHelper.getPNameCoder(path.substring(1), mapper);
        }
        return JormPathHelper.getPNameCoder(path.substring(idx + 1), mapper.lookup(path.substring(0, idx)));
    }

    private static PNameCoder getPNameCoder(String path, PClassMapping pcm) {
        if (pcm == null) {
            return null;
        }
        int idx = path.indexOf(47);
        if (pcm instanceof GenClassMapping) {
            if (idx == -1) {
                return pcm.getPBinder();
            }
            String subpath = path.substring(idx + 1);
            if (('/' + subpath).startsWith(ELEMENT)) {
                return pcm.getPNameCoder();
            }
            return JormPathHelper.getPNameCoder(subpath, pcm.getGenClassMapping());
        }
        if (idx == -1) {
            return pcm.getPNameCoder(path);
        }
        return JormPathHelper.getPNameCoder(path.substring(idx + 1), pcm.getGenClassMapping(path.substring(0, idx)));
    }

    public static PClassMapping getPClassMapping(String path, PMapper mapper) {
        if (path == null || path.length() == 0 || mapper == null) {
            return null;
        }
        int idx = path.indexOf(47);
        if (idx == -1) {
            return mapper.lookup(path);
        }
        if (idx == 0) {
            return JormPathHelper.getPClassMapping(path.substring(1), mapper);
        }
        return JormPathHelper.getPClassMapping(path.substring(idx + 1), mapper.lookup(path.substring(0, idx)));
    }

    private static PClassMapping getPClassMapping(String path, PClassMapping pcm) {
        if (pcm == null) {
            return null;
        }
        int idx = path.indexOf(47);
        if (pcm instanceof GenClassMapping) {
            if (idx == -1) {
                return pcm.getGenClassMapping();
            }
            String subpath = path.substring(idx + 1);
            if (('/' + subpath).startsWith(ELEMENT)) {
                return null;
            }
            return JormPathHelper.getPClassMapping(subpath, pcm.getGenClassMapping());
        }
        if (idx == -1) {
            return pcm.getGenClassMapping(path);
        }
        return JormPathHelper.getPClassMapping(path.substring(idx + 1), pcm.getGenClassMapping(path.substring(0, idx)));
    }

    public static String getOriginClass(String path) {
        if (path == null || path.length() == 0) {
            return null;
        }
        int idx = path.indexOf(47);
        if (idx == 0) {
            idx = path.indexOf(47, idx);
        }
        if (idx == -1) {
            return path;
        }
        int idx2 = path.indexOf(47, idx + 1);
        if (idx2 == -1) {
            return path.substring(idx + 1);
        }
        return path.substring(idx + 1, idx2);
    }
}

