/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jorm.mapper.rdb.util;

import java.io.PrintStream;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class DriverConformTest {
    private static String drvCN;
    private static String user;
    private static String url;
    private static String passwd;
    private static PrintStream out;
    private Connection conn = null;
    private boolean debug;

    public static void main(String[] args) {
        boolean interac = false;
        boolean debug = false;
        out = System.out;
        String sql = null;
        String javaType = null;
        String value = null;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-driver") && i + 1 < args.length) {
                drvCN = args[++i];
                continue;
            }
            if (args[i].equals("-url") && i + 1 < args.length) {
                url = args[++i];
                continue;
            }
            if (args[i].equals("-user") && i + 1 < args.length) {
                user = args[++i];
                continue;
            }
            if (args[i].equals("-passwd") && i + 1 < args.length) {
                passwd = args[++i];
                continue;
            }
            if (args[i].equals("-sql") && i + 1 < args.length) {
                sql = args[++i];
                continue;
            }
            if (args[i].equals("-java") && i + 1 < args.length) {
                javaType = args[++i];
                continue;
            }
            if (args[i].equals("-value") && i + 1 < args.length) {
                value = args[++i];
                continue;
            }
            if (args[i].equals("-debug")) {
                debug = true;
                continue;
            }
            System.out.println("Unknown argument: " + args[i]);
            DriverConformTest.usage();
            System.exit(1);
        }
        DriverConformTest d = new DriverConformTest(debug);
        if (interac) {
            String getter = null;
            String setter = null;
            try {
                sql = DriverConformTest.readString("Enter a SQL TYPE: ");
                javaType = DriverConformTest.readString("Enter the java type (ex: java.lang.Integer): ");
                value = DriverConformTest.readString("Enter a value(ex: 0): ");
                String answer = DriverConformTest.readString("Do you wan to use standard sql accessors [Y|n]:");
                getter = null;
                setter = null;
                if ("n".equalsIgnoreCase(answer.trim())) {
                    getter = DriverConformTest.readString("Enter the sql getter (ex: getBoolean): ");
                    setter = DriverConformTest.readString("Enter the sql setter (ex: setBoolean): ");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            d.specif(sql, javaType, value, getter, setter);
        } else if (sql != null && javaType != null && value != null) {
            d.specif(sql, javaType, value, null, null);
        } else {
            d.standard();
        }
        d.close();
    }

    private static void usage() {
        System.out.println("\nUsage: DriverConformTest -driver <driver class name>  -url <database url> \n [-user <user name> -passwd <password of the user>] -debug\n -sql <SQL type>  -java <java type>  -value <a value> ");
        System.out.println("* debug: The debug option prints all test results.");
    }

    public DriverConformTest(boolean debug) {
        this.debug = debug;
        if (drvCN == null || drvCN.length() == 0) {
            System.out.println("No driver specified !");
            DriverConformTest.usage();
            System.exit(1);
        }
        try {
            Class.forName(drvCN);
        }
        catch (Exception e) {
            out.println("Impossible to load the driver: " + drvCN);
            out.println(e.getMessage());
            System.exit(1);
        }
        if (url == null || url.length() == 0) {
            out.println("No url specified !");
            DriverConformTest.usage();
            System.exit(1);
        }
        try {
            this.conn = user == null || user.length() == 0 ? DriverManager.getConnection(url) : DriverManager.getConnection(url, user, passwd);
        }
        catch (SQLException e) {
            out.println("Impossible to fetch a connection:");
            out.println(e.getMessage());
            System.exit(1);
        }
    }

    public void specif(String sqlType, String stype, String sval, String getter, String setter) {
        try {
            Object val = null;
            Class<?> type = null;
            try {
                type = Class.forName(stype);
                val = type.getDeclaredMethod("valueOf", String.class).invoke(null, sval);
            }
            catch (Exception e) {
                try {
                    val = type.getDeclaredMethod("valueOf", Object.class).invoke(null, sval);
                }
                catch (Exception e2) {
                    System.err.println("Impossible to build a " + sval);
                    System.exit(1);
                }
            }
            String tableName = "table_" + sqlType;
            this._testCreateTable(tableName, sqlType);
            this._testInsertSelect(sqlType, tableName, val, type, getter, setter);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void standard() {
        this.testBoolean();
        this.testByte();
        this.testShort();
        this.testInt();
        this.testLong();
        this.testFloat();
        this.testDouble();
        this.testDate();
        this.testString();
        this.testBigDecimal();
    }

    public void close() {
        if (this.conn != null) {
            try {
                this.conn.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean _testCreateTable(String tableName, String colType) {
        Statement s = null;
        try {
            s = this.conn.createStatement();
            s.execute("DROP TABLE " + tableName);
        }
        catch (SQLException e) {
        }
        finally {
            try {
                s.close();
            }
            catch (SQLException e) {}
        }
        try {
            s = this.conn.createStatement();
            s.execute("CREATE TABLE " + tableName + "(col1 " + colType + ")");
            this.ok("create table", colType);
            boolean e = true;
            return e;
        }
        catch (SQLException e) {
            this.fail("create table: ", e, colType);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                s.close();
            }
            catch (SQLException e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void _testInsertSelect(String colType, String tableName, Object val, Class type, String getter, String setter) {
        block26: {
            ResultSet rs;
            Statement ps;
            block24: {
                String sval = "" + val;
                ps = null;
                rs = null;
                ps = this.conn.prepareStatement("INSERT INTO " + tableName + " VALUES (?)");
                this.assignValue((PreparedStatement)ps, 1, val, type, setter);
                ps.execute();
                this.ok("insert value " + sval, colType);
                ps = this.conn.prepareStatement("SELECT * from " + tableName + " WHERE col1 = ?");
                this.assignValue((PreparedStatement)ps, 1, val, type, setter);
                rs = ps.executeQuery();
                if (rs.next()) {
                    if (val.equals(this.retrieveValue(rs, 1, type, getter))) {
                        this.ok("select value " + sval, colType);
                    } else {
                        this.fail("select value " + sval + ": bad value", colType);
                    }
                    Object o = rs.getObject(1);
                    if (type.equals(o.getClass()) && (val == null && o == null || val != null && val.equals(o))) {
                        this.ok("select value " + sval + " with getObject", colType);
                    } else {
                        this.fail("select value " + sval + " with getObject", colType);
                    }
                    if (rs.next()) {
                        this.fail("select value " + sval + ": more than one result", colType);
                    }
                    break block24;
                }
                this.fail("select value " + sval + ": no result", colType);
            }
            Object var12_12 = null;
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException e2) {
                // empty catch block
            }
            try {
                if (ps != null) {
                    ps.close();
                }
                break block26;
            }
            catch (SQLException e2) {}
            break block26;
            {
                catch (Exception e) {
                    this.fail("insert & select: ", e, colType);
                    Object var12_13 = null;
                    try {
                        if (rs != null) {
                            rs.close();
                        }
                    }
                    catch (SQLException e2) {
                        // empty catch block
                    }
                    try {
                        if (ps != null) {
                            ps.close();
                        }
                        break block26;
                    }
                    catch (SQLException e2) {}
                }
            }
            catch (Throwable throwable) {
                Object var12_14 = null;
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException e2) {
                    // empty catch block
                }
                try {
                    if (ps != null) {
                        ps.close();
                    }
                }
                catch (SQLException e2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    private void assignValue(PreparedStatement ps, int index, Object value, Class type, String setter) throws Exception {
        if (value == null) {
            ps.setNull(index, this.class2sqlType(type));
        } else if (setter != null && setter.length() > 0) {
            try {
                PreparedStatement.class.getMethod(setter, Integer.TYPE, type).invoke((Object)ps, new Integer(1), value);
            }
            catch (NoSuchMethodException e) {
                this.fail("Method " + setter + " not found");
                throw e;
            }
        } else if (Boolean.class.equals(type)) {
            ps.setBoolean(index, (Boolean)value);
        } else if (Byte.class.equals(type)) {
            ps.setByte(index, (Byte)value);
        } else if (Short.class.equals(type)) {
            ps.setShort(index, (Short)value);
        } else if (Integer.class.equals(type)) {
            ps.setInt(index, (Integer)value);
        } else if (Long.class.equals(type)) {
            ps.setLong(index, (Long)value);
        } else if (Float.class.equals(type)) {
            ps.setFloat(index, ((Float)value).floatValue());
        } else if (Double.class.equals(type)) {
            ps.setDouble(index, (Double)value);
        } else if (String.class.equals(type)) {
            ps.setString(index, (String)value);
        } else if (Date.class.equals(type)) {
            ps.setDate(index, (Date)value);
        } else if (BigDecimal.class.equals(type)) {
            ps.setBigDecimal(index, (BigDecimal)value);
        } else {
            throw new Exception("Unmanaged type: " + type);
        }
    }

    private int class2sqlType(Class type) throws Exception {
        if (Boolean.class.equals(type)) {
            return -7;
        }
        if (Byte.class.equals(type)) {
            return -6;
        }
        if (Short.class.equals(type)) {
            return 5;
        }
        if (Integer.class.equals(type)) {
            return 4;
        }
        if (Long.class.equals(type)) {
            return -5;
        }
        if (Float.class.equals(type)) {
            return 7;
        }
        if (Double.class.equals(type)) {
            return 8;
        }
        if (String.class.equals(type)) {
            return 12;
        }
        if (Date.class.equals(type)) {
            return 91;
        }
        if (BigDecimal.class.equals(type)) {
            return 3;
        }
        throw new Exception("Unmanaged type: " + type);
    }

    private Object retrieveValue(ResultSet rs, int index, Class type, String getter) throws Exception {
        Object o = null;
        if (getter != null && getter.length() > 0) {
            try {
                o = ResultSet.class.getMethod(getter, Integer.TYPE).invoke((Object)rs, new Integer(1));
            }
            catch (NoSuchMethodException e) {
                this.fail("Method " + getter + " not found");
                throw e;
            }
        } else if (Boolean.class.equals(type)) {
            o = new Boolean(rs.getBoolean(index));
        } else if (Byte.class.equals(type)) {
            o = new Byte(rs.getByte(index));
        } else if (Short.class.equals(type)) {
            o = new Short(rs.getShort(index));
        } else if (Integer.class.equals(type)) {
            o = new Integer(rs.getInt(index));
        } else if (Long.class.equals(type)) {
            o = new Long(rs.getLong(index));
        } else if (Float.class.equals(type)) {
            o = new Float(rs.getFloat(index));
        } else if (Double.class.equals(type)) {
            o = new Double(rs.getDouble(index));
        } else if (String.class.equals(type)) {
            o = rs.getString(index);
        } else if (Date.class.equals(type)) {
            o = rs.getDate(index);
        } else if (BigDecimal.class.equals(type)) {
            o = rs.getBigDecimal(index);
        } else {
            throw new Exception("Unknown type: " + type);
        }
        return rs.wasNull() ? null : o;
    }

    public void testBoolean() {
        String tableName = "JormBoolean";
        String colType = "BIT";
        if (this._testCreateTable(tableName, colType)) {
            this._testInsertSelect(colType, tableName, Boolean.TRUE, Boolean.class, null, null);
            this._testInsertSelect(colType, tableName, Boolean.FALSE, Boolean.class, null, null);
        }
    }

    public void testByte() {
        String tableName = "JormByte";
        String colType = "TINYINT";
        if (this._testCreateTable(tableName, colType)) {
            this._testInsertSelect(colType, tableName, new Byte(0), Byte.class, null, null);
            this._testInsertSelect(colType, tableName, new Byte(1), Byte.class, null, null);
            this._testInsertSelect(colType, tableName, new Byte(-2), Byte.class, null, null);
        }
    }

    public void testShort() {
        String tableName = "JormShort";
        String colType = "SMALLINT";
        if (this._testCreateTable(tableName, colType)) {
            this._testInsertSelect(colType, tableName, new Short(0), Short.class, null, null);
            this._testInsertSelect(colType, tableName, new Short(1), Short.class, null, null);
            this._testInsertSelect(colType, tableName, new Short(254), Short.class, null, null);
        }
    }

    public void testInt() {
        String tableName = "JormInt";
        String colType = "INTEGER";
        if (this._testCreateTable(tableName, colType)) {
            this._testInsertSelect(colType, tableName, new Integer(0), Integer.class, null, null);
            this._testInsertSelect(colType, tableName, new Integer(1), Integer.class, null, null);
            this._testInsertSelect(colType, tableName, new Integer(254), Integer.class, null, null);
        }
    }

    public void testLong() {
        String tableName = "JormLong";
        String colType = "BIGINT";
        if (this._testCreateTable(tableName, colType)) {
            this._testInsertSelect(colType, tableName, new Long(0L), Long.class, null, null);
            this._testInsertSelect(colType, tableName, new Long(1L), Long.class, null, null);
            this._testInsertSelect(colType, tableName, new Long(254L), Long.class, null, null);
        }
    }

    public void testFloat() {
        String tableName = "JormFloat";
        String colType = "REAL";
        if (this._testCreateTable(tableName, colType)) {
            this._testInsertSelect(colType, tableName, new Float(0.0), Float.class, null, null);
            this._testInsertSelect(colType, tableName, new Float(1.0f), Float.class, null, null);
            this._testInsertSelect(colType, tableName, new Float(254.0f), Float.class, null, null);
        }
    }

    public void testDouble() {
        String tableName = "JormDouble";
        String colType = "DOUBLE";
        if (this._testCreateTable(tableName, colType)) {
            this._testInsertSelect(colType, tableName, new Double(0.0), Double.class, null, null);
            this._testInsertSelect(colType, tableName, new Double(1.0), Double.class, null, null);
            this._testInsertSelect(colType, tableName, new Double(254.0), Double.class, null, null);
        }
    }

    public void testDate() {
        String tableName = "JormDate";
        String colType = "DATE";
        if (this._testCreateTable(tableName, colType)) {
            // empty if block
        }
    }

    public void testString() {
        this._testCreateTable("JormString", "VARCHAR");
        String tableName = "JormString";
        String colType = "VARCHAR";
        if (this._testCreateTable(tableName, colType)) {
            this._testInsertSelect(colType, tableName, "", String.class, null, null);
            this._testInsertSelect(colType, tableName, "abcd", String.class, null, null);
        }
    }

    public void testBigDecimal() {
        this._testCreateTable("JormBigDecimal", "DECIMAL");
        String tableName = "JormBigDecimal";
        String colType = "DECIMAL";
        if (this._testCreateTable(tableName, colType)) {
            this._testInsertSelect(colType, tableName, new BigDecimal(0.0), BigDecimal.class, null, null);
            this._testInsertSelect(colType, tableName, new BigDecimal("8764236557855635636.78966564"), BigDecimal.class, null, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void testTableExistence() {
        ResultSet rs;
        block10: {
            String tableName = "TableExist";
            this._testCreateTable(tableName, "INTEGER");
            rs = null;
            boolean existtable = false;
            rs = this.conn.getMetaData().getTables(null, null, tableName, new String[]{"TABLE"});
            while (rs.next() && !existtable) {
                existtable = tableName.equalsIgnoreCase(rs.getString(3));
            }
            if (existtable) {
                this.ok("Able to find an existing table");
                break block10;
            }
            this.fail("Unable to found a table");
        }
        Object var6_4 = null;
        if (rs == null) return;
        try {
            rs.close();
            return;
        }
        catch (SQLException e2) {
            this.fail(e2.getMessage());
        }
        return;
        {
            catch (Exception e) {
                Object var6_5 = null;
                if (rs == null) return;
                try {
                    rs.close();
                    return;
                }
                catch (SQLException e2) {
                    this.fail(e2.getMessage());
                }
                return;
            }
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (rs == null) throw throwable;
            try {
                rs.close();
                throw throwable;
            }
            catch (SQLException e2) {
                this.fail(e2.getMessage());
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void testSequence() {
        ResultSet rs;
        block34: {
            String seqName = "TotoSeq";
            Statement s = null;
            try {
                s = this.conn.createStatement();
                s.execute("DROP SEQUENCE " + seqName);
            }
            catch (SQLException e) {
            }
            finally {
                try {
                    s.close();
                }
                catch (SQLException e) {}
            }
            try {
                s = this.conn.createStatement();
                s.execute("CREATE SEQUENCE " + seqName);
                this.ok("create sequence");
            }
            catch (SQLException e) {
                this.fail("create sequence: " + e.getMessage(), e);
                return;
            }
            finally {
                try {
                    s.close();
                }
                catch (SQLException e) {}
            }
            rs = null;
            boolean existtable = false;
            rs = this.conn.getMetaData().getTables(null, null, seqName, null);
            while (rs.next() && !existtable) {
                existtable = seqName.equalsIgnoreCase(rs.getString(3));
            }
            if (existtable) {
                this.ok("Able to find an existing sequence");
                break block34;
            }
            this.fail("Unable to found an existing sequence");
        }
        Object var9_16 = null;
        if (rs == null) return;
        try {
            rs.close();
            return;
        }
        catch (SQLException e2) {
            this.fail(e2.getMessage());
        }
        return;
        {
            catch (Exception e) {
                Object var9_17 = null;
                if (rs == null) return;
                try {
                    rs.close();
                    return;
                }
                catch (SQLException e2) {
                    this.fail(e2.getMessage());
                }
                return;
            }
        }
        catch (Throwable throwable) {
            Object var9_18 = null;
            if (rs == null) throw throwable;
            try {
                rs.close();
                throw throwable;
            }
            catch (SQLException e2) {
                this.fail(e2.getMessage());
            }
            throw throwable;
        }
    }

    public static String readString(String invitation) throws Exception {
        System.out.print(invitation);
        System.out.flush();
        StringBuffer reply_buffer = null;
        char b = (char)System.in.read();
        while (b > '\u0000' && b != '\n' && Character.isWhitespace(b)) {
            b = (char)System.in.read();
        }
        while (b > '\u0000' && b != '\n' && b != '\r') {
            if (reply_buffer == null) {
                reply_buffer = new StringBuffer();
            }
            reply_buffer.append(b);
            b = (char)System.in.read();
        }
        if (System.in.available() == 1) {
            System.in.read();
        }
        if (reply_buffer != null) {
            return reply_buffer.toString();
        }
        return "";
    }

    public void fail(String msg, Throwable t, String colType) {
        this.fail(colType + ": " + msg, t);
    }

    public void fail(String msg, Throwable t) {
        if (this.debug) {
            this.fail(msg);
            t.printStackTrace(out);
        } else {
            this.fail(msg + t.getMessage());
        }
    }

    public void fail(String msg, String colType) {
        this.fail(colType + ": " + msg);
    }

    public void fail(String msg) {
        out.println("**FAIL: " + msg);
    }

    public void ok(String msg, String colType) {
        this.ok(colType + ": " + msg);
    }

    public void ok(String msg) {
        if (this.debug) {
            out.println("OK: " + msg);
        }
    }

    public void debug(String msg) {
        if (this.debug) {
            out.println("DEBUG: " + msg);
        }
    }
}

