/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.plan.fetcher.impl.url;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import org.ow2.util.file.FileUtils;
import org.ow2.util.file.FileUtilsException;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.plan.bindings.deploymentplan.Deployment;
import org.ow2.util.plan.bindings.deploymentplan.DeploymentHelper;
import org.ow2.util.plan.bindings.deploymentplan.url.UrlDeployment;
import org.ow2.util.plan.bindings.exceptions.InvalidDeploymentException;
import org.ow2.util.plan.bindings.exceptions.InvalidRepositoryException;
import org.ow2.util.plan.bindings.repository.Repository;
import org.ow2.util.plan.bindings.repository.RepositoryKind;
import org.ow2.util.plan.fetcher.api.IResourceFetcher;
import org.ow2.util.plan.fetcher.api.exceptions.FetcherException;
import org.ow2.util.plan.fetcher.api.exceptions.ResourceFetcherNotResolvedException;
import org.ow2.util.plan.fetcher.api.exceptions.ResourceNotFoundException;
import org.ow2.util.plan.fetcher.impl.AbsResourceFetcherImpl;
import org.ow2.util.url.URLUtils;

public class UrlResourceFetcher
extends AbsResourceFetcherImpl
implements IResourceFetcher {
    private Log logger = LogFactory.getLog(UrlResourceFetcher.class);
    private Repository foundRepository = null;
    private URL foundURL = null;
    private File localFile = null;

    public void resolve() throws FetcherException {
        if (!(this.deployment instanceof UrlDeployment)) {
            throw new FetcherException((Throwable)new InvalidDeploymentException("Incompatible class " + this.deployment.getClass()));
        }
        UrlDeployment urlDeployment = (UrlDeployment)this.deployment;
        this.logger.debug((Object)"trying to resolve resource {0}", new Object[]{urlDeployment.getResource()});
        String repositoryRef = null;
        try {
            repositoryRef = DeploymentHelper.getRepositoryRef((Deployment)urlDeployment);
        }
        catch (InvalidDeploymentException e) {
            this.logger.error((Object)e.getMessage(), new Object[0]);
        }
        this.localFile = null;
        if (repositoryRef != null) {
            this.searchRepository(this.getRepositoryManager().getRepositoryById(repositoryRef));
        } else {
            for (Repository repository : this.getRepositoryManager()) {
                try {
                    this.searchRepository(repository);
                }
                catch (FetcherException e) {
                    this.logger.debug((Object)"resource {0} was not found on repository {1}", new Object[]{this.deployment, repository});
                }
                if (this.localFile == null || !this.localFile.exists()) continue;
                break;
            }
        }
        if (this.localFile == null || !this.localFile.exists()) {
            throw new FetcherException((Throwable)new ResourceNotFoundException(urlDeployment.toString()));
        }
    }

    private void searchRepository(Repository repository) throws FetcherException {
        URL repositoryURL = null;
        try {
            repositoryURL = new URL(repository.getUrl());
        }
        catch (MalformedURLException e) {
            throw new FetcherException((Throwable)new InvalidRepositoryException("Invalid URL", (Throwable)e));
        }
        try {
            this.foundURL = new URL(repositoryURL + "/" + ((UrlDeployment)this.deployment).getResource());
        }
        catch (MalformedURLException e) {
            this.logger.error((Object)"Bad URL syntax in {0}", new Object[]{this.foundURL});
            throw new FetcherException((Throwable)new InvalidDeploymentException("invalid path to resource", (Throwable)e));
        }
        this.foundRepository = repository;
        if (repositoryURL != null && "file".equals(repositoryURL.getProtocol())) {
            this.localFile = URLUtils.urlToFile((URL)this.foundURL);
        } else {
            this.localFile = UrlResourceFetcher.makeLocalFilePath((File)this.localRepositoriesBaseDir, (String)this.foundRepository.getId(), (String)((UrlDeployment)this.deployment).getResource());
            if (!this.localFile.exists() || this.hasChanged()) {
                if (!this.localFile.getParentFile().exists()) {
                    this.localFile.getParentFile().mkdirs();
                }
                InputStream is = null;
                try {
                    URLConnection connection = this.foundURL.openConnection();
                    is = connection.getInputStream();
                    FileUtils.dump((InputStream)is, (File)this.localFile);
                    this.localFile.setLastModified(connection.getLastModified());
                }
                catch (IOException ioe) {
                    this.logger.error((Object)"Exception while opening connection to resource {0}", new Object[]{this.foundURL});
                    throw new FetcherException("Exception while opening connection", (Throwable)ioe);
                }
                catch (FileUtilsException e) {
                    this.logger.error((Object)"Exception while copying data from resource {0};exception: {1}", new Object[]{this.foundURL, e});
                    throw new FetcherException("Exception while copying resource data", (Throwable)e);
                }
                finally {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException e) {}
                    }
                }
            }
        }
    }

    public RepositoryKind getSupportedRepositoryType() {
        return RepositoryKind.URL;
    }

    public File getResource() throws ResourceFetcherNotResolvedException {
        if (this.localFile == null) {
            throw new ResourceFetcherNotResolvedException();
        }
        return this.localFile;
    }

    public boolean hasChanged() throws FetcherException {
        try {
            URLConnection connection = this.foundURL.openConnection();
            if (connection.getLastModified() > this.localFile.lastModified()) {
                return true;
            }
        }
        catch (IOException e) {
            this.logger.debug((Object)"Cannot retrieve the last modification date for the URL {0} : {1}", new Object[]{this.foundURL, e.getMessage()});
        }
        return false;
    }

    public void update() throws FetcherException {
        this.searchRepository(this.foundRepository);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append(":useRepository=");
        if (this.foundRepository != null) {
            sb.append(this.foundRepository);
        } else {
            sb.append("null");
        }
        sb.append(":resolved=");
        sb.append(this.localFile != null);
        sb.append(":lastCheck=");
        sb.append(this.localFile.lastModified());
        return sb.toString();
    }
}

